/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.io.IOException;
import java.lang.reflect.Array;
import java.text.FieldPosition;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.measure.Unit;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.util.X364;
import org.apache.sis.io.wkt.Colors;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.RangeFormat;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Deprecable;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

final class ParameterTableRow {
    private final Map<String, Set<Object>> identifiers;
    int codespaceWidth;
    String valueDomain;
    int valueDomainAlignment;
    final List<Object> values = new ArrayList<Object>(2);
    final List<Object> units = new ArrayList<Object>(2);
    private int remarks;

    ParameterTableRow(IdentifiedObject object, Locale locale, Set<String> preferredCodespaces, Map<String, Integer> remarks, boolean isBrief) {
        InternationalString r;
        Set ids;
        String codespace;
        Collection aliases;
        this.identifiers = new LinkedHashMap<String, Set<Object>>();
        Identifier name = object.getName();
        if (name != null) {
            String codespace2 = name.getCodeSpace();
            if (preferredCodespaces == null || preferredCodespaces.contains(codespace2)) {
                this.addIdentifier(codespace2, name.getCode());
                name = null;
            }
        }
        if ((!isBrief || this.identifiers.isEmpty()) && (aliases = object.getAlias()) != null) {
            for (GenericName alias : aliases) {
                if (ParameterTableRow.isDeprecated(alias)) continue;
                codespace = NameToIdentifier.getCodeSpace(alias, locale);
                if (codespace != null) {
                    alias = alias.tip();
                }
                if (preferredCodespaces != null && !preferredCodespaces.contains(codespace)) continue;
                this.addIdentifier(codespace, NameToIdentifier.toString(alias, locale));
                name = null;
                if (!isBrief) continue;
                break;
            }
        }
        if (name != null) {
            this.addIdentifier(name.getCodeSpace(), name.getCode());
        }
        if (!isBrief && (ids = object.getIdentifiers()) != null) {
            for (Identifier id : ids) {
                if (ParameterTableRow.isDeprecated(id)) continue;
                codespace = id.getCodeSpace();
                if (preferredCodespaces != null && !preferredCodespaces.contains(codespace)) continue;
                this.addIdentifier(codespace, id);
            }
        }
        if ((r = object.getRemarks()) != null) {
            int n = remarks.size() + 1;
            Integer p = remarks.putIfAbsent(r.toString(locale), n);
            this.remarks = p != null ? p : n;
        }
    }

    private static boolean isDeprecated(Object object) {
        return object instanceof Deprecable && ((Deprecable)object).isDeprecated();
    }

    private void addIdentifier(String codespace, Object identifier) {
        Set<Object> ids;
        int width;
        if (codespace != null && (width = codespace.codePointCount(0, codespace.length())) > this.codespaceWidth) {
            this.codespaceWidth = width;
        }
        if ((ids = this.identifiers.get(codespace)) == null) {
            ids = new LinkedHashSet<Object>(8);
            this.identifiers.put(codespace, ids);
        }
        ids.add(identifier);
    }

    final String getCodeSpace() {
        Iterator<Map.Entry<String, Set<Object>>> it = this.identifiers.entrySet().iterator();
        if (it.hasNext()) {
            Map.Entry<String, Set<Object>> entry = it.next();
            if (!it.hasNext()) {
                return entry.getKey();
            }
        }
        return null;
    }

    final int setValueDomain(Range<?> range, Format format, StringBuffer buffer) {
        FieldPosition fieldPosition = new FieldPosition(RangeFormat.Field.MAX_VALUE);
        this.valueDomain = format.format(range, buffer, fieldPosition).toString();
        buffer.setLength(0);
        this.valueDomainAlignment = fieldPosition.getBeginIndex();
        return this.valueDomainAlignment;
    }

    final void addValue(Object value, Unit<?> unit) {
        this.values.add(value);
        this.units.add(unit);
    }

    final void expandSingleton() {
        Object[] value;
        assert (this.values.size() == this.units.size());
        if (this.values.size() == 1 && (value = this.values.get(0)) != null) {
            if (value instanceof Collection) {
                value = ((Collection)value).toArray();
            }
            if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                Object unit = this.units.get(0);
                this.values.clear();
                this.units.clear();
                for (int i = 0; i < length; ++i) {
                    this.values.add(Array.get(value, i));
                    this.units.add(unit);
                }
            }
        }
    }

    private static void writeColor(Appendable out, Colors colors, ElementKind type) throws IOException {
        String name;
        if (colors != null && (name = colors.getName(type)) != null) {
            out.append(X364.forColorName(name).sequence());
        }
    }

    private static void writeColor(Appendable out, X364 color, boolean colorEnabled) throws IOException {
        if (colorEnabled) {
            out.append(color.sequence());
        }
    }

    final void writeIdentifiers(Appendable out, boolean writeCodespaces, Colors colors, boolean colorsForRows, String lineSeparator) throws IOException {
        if (this.codespaceWidth != 0) {
            this.codespaceWidth += 2;
        }
        boolean isNewLine = false;
        for (Map.Entry<String, Set<Object>> entry : this.identifiers.entrySet()) {
            String codespace = entry.getKey();
            Set<Object> identifiers = entry.getValue();
            Iterator<Object> it = identifiers.iterator();
            while (it.hasNext()) {
                if (isNewLine) {
                    out.append(lineSeparator);
                }
                isNewLine = true;
                ParameterTableRow.writeColor(out, colors, ElementKind.NAME);
                if (writeCodespaces) {
                    int pad = this.codespaceWidth;
                    if (codespace != null) {
                        ParameterTableRow.writeColor(out, X364.FAINT, colorsForRows);
                        out.append(codespace).append(':');
                        ParameterTableRow.writeColor(out, X364.NORMAL, colorsForRows);
                        pad -= codespace.length() + 1;
                    }
                    out.append(CharSequences.spaces(pad));
                }
                ParameterTableRow.writeColor(out, X364.BOLD, colors != null);
                out.append(ParameterTableRow.toString(it.next()));
                ParameterTableRow.writeColor(out, X364.RESET, colors != null);
                it.remove();
                if (this.remarks != 0) {
                    ParameterTableRow.writeFootnoteNumber(out, this.remarks);
                    this.remarks = 0;
                }
                boolean hasAliases = false;
                boolean hasIdentifiers = false;
                while (it.hasNext()) {
                    Object id = it.next();
                    if (id instanceof Identifier) {
                        out.append(hasIdentifiers ? ", " : " (");
                        ParameterTableRow.writeColor(out, colors, ElementKind.IDENTIFIER);
                        out.append(ParameterTableRow.toString(id));
                        ParameterTableRow.writeColor(out, X364.FOREGROUND_DEFAULT, colors != null);
                        hasIdentifiers = true;
                        it.remove();
                        continue;
                    }
                    hasAliases = true;
                }
                if (hasIdentifiers) {
                    out.append(')');
                }
                if (!hasAliases) continue;
                it = identifiers.iterator();
            }
        }
    }

    static void writeFootnoteNumber(Appendable out, int n) throws IOException {
        if (n >= 0 && n < 10) {
            out.append(Characters.toSuperScript((char)(48 + n)));
        } else {
            out.append('(').append(Integer.toString(n)).append(')');
        }
    }

    private static String toString(Object parameter) {
        if (parameter instanceof Identifier) {
            parameter = ((Identifier)parameter).getCode();
        }
        return parameter.toString();
    }
}

