/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.Arrays;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import org.apache.sis.internal.referencing.provider.FranceGeocentricInterpolation;
import org.apache.sis.internal.referencing.provider.Molodensky;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.datum.DatumShiftGrid;
import org.apache.sis.referencing.operation.transform.InterpolatedGeocentricTransform;
import org.apache.sis.referencing.operation.transform.InterpolatedMolodenskyTransform2D;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.MolodenskyFormula;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

@Deprecated(since="1.4", forRemoval=true)
public class InterpolatedMolodenskyTransform
extends MolodenskyFormula {
    private static final long serialVersionUID = -5691721806681489940L;
    private static final ParameterDescriptorGroup DESCRIPTOR;
    private static final ParameterDescriptorGroup INVERSE;
    private final InterpolatedMolodenskyTransform inverse;

    InterpolatedMolodenskyTransform(InterpolatedMolodenskyTransform inverse, Ellipsoid source, Ellipsoid target) {
        super(inverse, source, target, INVERSE);
        this.inverse = inverse;
    }

    protected InterpolatedMolodenskyTransform(Ellipsoid source, boolean isSource3D, Ellipsoid target, boolean isTarget3D, DatumShiftGrid<Angle, Length> grid) {
        super(source, isSource3D, target, isTarget3D, grid.getCellMean(0), grid.getCellMean(1), grid.getCellMean(2), grid, false, DESCRIPTOR);
        InterpolatedMolodenskyTransform.ensureGeocentricTranslation(grid, (Unit<Length>)source.getAxisUnit());
        this.inverse = isSource3D || isTarget3D ? new Inverse(this, source, target) : new InterpolatedMolodenskyTransform2D.Inverse(this, source, target);
    }

    public static MathTransform createGeodeticTransformation(MathTransformFactory factory, Ellipsoid source, boolean isSource3D, Ellipsoid target, boolean isTarget3D, DatumShiftGrid<Angle, Length> grid) throws FactoryException {
        ArgumentChecks.ensureNonNull("grid", grid);
        InterpolatedMolodenskyTransform tr = isSource3D || isTarget3D ? new InterpolatedMolodenskyTransform(source, isSource3D, target, isTarget3D, grid) : new InterpolatedMolodenskyTransform2D(source, target, grid);
        tr.inverse.context.completeTransform(factory, null);
        return tr.context.completeTransform(factory, tr);
    }

    @Override
    final void completeParameters(Parameters pg, double semiMinor, Unit<?> unit, double \u0394f) {
        super.completeParameters(pg, semiMinor, unit, \u0394f);
        if (pg != this.context) {
            \u0394f = this.\u0394fmod / semiMinor;
            pg.getOrCreate(Molodensky.AXIS_LENGTH_DIFFERENCE).setValue(this.\u0394a, unit);
            pg.getOrCreate(Molodensky.FLATTENING_DIFFERENCE).setValue(\u0394f, Units.UNITY);
        }
        this.grid.getParameterValues(pg);
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        double[] vector = new double[3];
        double \u03bb = srcPts[srcOff];
        double \u03c6 = srcPts[srcOff + 1];
        this.grid.interpolateInCell(this.normalizedToGridX(\u03bb), this.normalizedToGridY(\u03c6), vector);
        return this.transform(\u03bb, \u03c6, this.isSource3D ? srcPts[srcOff + 2] : 0.0, dstPts, dstOff, vector[0], vector[1], vector[2], null, derivate);
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int srcInc = this.isSource3D ? 3 : 2;
        int dstInc = this.isTarget3D ? 3 : 2;
        int offFinal = 0;
        double[] dstFinal = null;
        if (srcPts == dstPts) {
            switch (IterationStrategy.suggest(srcOff, srcInc, dstOff, dstInc, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    srcOff += (numPts - 1) * srcInc;
                    srcInc = -srcInc;
                    dstOff += (numPts - 1) * dstInc;
                    dstInc = -dstInc;
                    break;
                }
                default: {
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * srcInc);
                    srcOff = 0;
                    break;
                }
                case BUFFER_TARGET: {
                    dstFinal = dstPts;
                    offFinal = dstOff;
                    dstPts = new double[numPts * dstInc];
                    dstOff = 0;
                }
            }
        }
        double[] offset = new double[3];
        while (--numPts >= 0) {
            double \u03bb = srcPts[srcOff];
            double \u03c6 = srcPts[srcOff + 1];
            this.grid.interpolateInCell(this.normalizedToGridX(\u03bb), this.normalizedToGridY(\u03c6), offset);
            this.transform(\u03bb, \u03c6, this.isSource3D ? srcPts[srcOff + 2] : 0.0, dstPts, dstOff, offset[0], offset[1], offset[2], null, false);
            srcOff += srcInc;
            dstOff += dstInc;
        }
        if (dstFinal != null) {
            System.arraycopy(dstPts, 0, dstFinal, offFinal, dstPts.length);
        }
    }

    @Override
    public MathTransform inverse() {
        return this.inverse;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        ParameterDescriptor[] param = new ParameterDescriptor[]{Molodensky.DIMENSION, Molodensky.SRC_SEMI_MAJOR, Molodensky.SRC_SEMI_MINOR, Molodensky.AXIS_LENGTH_DIFFERENCE, Molodensky.FLATTENING_DIFFERENCE, FranceGeocentricInterpolation.FILE};
        return ((ParameterBuilder)((ParameterBuilder)new ParameterBuilder().setRequired(true).setCodeSpace(Citations.SIS, "SIS")).addName(this.context.getDescriptor().getName().getCode() + " (radians domain)")).createGroup((GeneralParameterDescriptor[])param);
    }

    static {
        ParameterBuilder builder = (ParameterBuilder)new ParameterBuilder().setRequired(true).setCodeSpace(Citations.SIS, "SIS");
        DESCRIPTOR = ((ParameterBuilder)builder.addName("Molodensky interpolation")).createGroupWithSameParameters(InterpolatedGeocentricTransform.DESCRIPTOR);
        INVERSE = ((ParameterBuilder)builder.addName("Molodensky inverse interpolation")).createGroupWithSameParameters(InterpolatedGeocentricTransform.DESCRIPTOR);
    }

    static class Inverse
    extends InterpolatedMolodenskyTransform {
        private static final long serialVersionUID = -3520896803296425651L;

        Inverse(InterpolatedMolodenskyTransform inverse, Ellipsoid source, Ellipsoid target) {
            super(inverse, source, target);
        }

        @Override
        public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
            return this.transform(srcPts[srcOff], srcPts[srcOff + 1], this.isSource3D ? srcPts[srcOff + 2] : 0.0, dstPts, dstOff, this.tX, this.tY, this.tZ, new double[3], derivate);
        }

        @Override
        public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
            int srcInc = this.isSource3D ? 3 : 2;
            int dstInc = this.isTarget3D ? 3 : 2;
            int offFinal = 0;
            double[] dstFinal = null;
            if (srcPts == dstPts) {
                switch (IterationStrategy.suggest(srcOff, srcInc, dstOff, dstInc, numPts)) {
                    case ASCENDING: {
                        break;
                    }
                    case DESCENDING: {
                        srcOff += (numPts - 1) * srcInc;
                        srcInc = -srcInc;
                        dstOff += (numPts - 1) * dstInc;
                        dstInc = -dstInc;
                        break;
                    }
                    default: {
                        srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * srcInc);
                        srcOff = 0;
                        break;
                    }
                    case BUFFER_TARGET: {
                        dstFinal = dstPts;
                        offFinal = dstOff;
                        dstPts = new double[numPts * dstInc];
                        dstOff = 0;
                    }
                }
            }
            double[] offset = new double[3];
            while (--numPts >= 0) {
                this.transform(srcPts[srcOff], srcPts[srcOff + 1], this.isSource3D ? srcPts[srcOff + 2] : 0.0, dstPts, dstOff, this.tX, this.tY, this.tZ, offset, false);
                srcOff += srcInc;
                dstOff += dstInc;
            }
            if (dstFinal != null) {
                System.arraycopy(dstPts, 0, dstFinal, offFinal, dstPts.length);
            }
        }
    }
}

