/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.temporal.object;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import org.apache.sis.util.NullArgumentException;
import org.geotoolkit.temporal.object.DefaultTemporalTopologicalPrimitive;
import org.opengis.temporal.Instant;
import org.opengis.temporal.TemporalEdge;
import org.opengis.temporal.TemporalNode;
import org.opengis.temporal.TemporalTopologicalPrimitive;

@XmlType(name="TimeNode_Type", propOrder={"previousEdge", "nextEdge", "realization"})
@XmlRootElement(name="TimeNode")
public class DefaultTemporalNode
extends DefaultTemporalTopologicalPrimitive
implements TemporalNode {
    private Instant realization;
    private TemporalEdge previousEdge;
    private TemporalEdge nextEdge;

    public DefaultTemporalNode(Map<String, ?> properties, Instant realization, TemporalEdge previousEdge, TemporalEdge nextEdge) throws NullArgumentException {
        super(properties);
        this.realization = realization;
        this.previousEdge = previousEdge;
        this.nextEdge = nextEdge;
    }

    private DefaultTemporalNode(TemporalNode object) {
        super((TemporalTopologicalPrimitive)object);
        if (object != null) {
            this.realization = object.getRealization();
            this.previousEdge = object.getPreviousEdge();
            this.nextEdge = object.getNextEdge();
        }
    }

    public static DefaultTemporalNode castOrCopy(TemporalNode object) {
        if (object == null || object instanceof DefaultTemporalNode) {
            return (DefaultTemporalNode)object;
        }
        return new DefaultTemporalNode(object);
    }

    private DefaultTemporalNode() {
        this.realization = null;
        this.previousEdge = null;
        this.nextEdge = null;
    }

    @XmlElement(name="position")
    public Instant getRealization() {
        return this.realization;
    }

    @XmlElement(name="previousEdge")
    public TemporalEdge getPreviousEdge() {
        return this.previousEdge;
    }

    @XmlElement(name="nextEdge")
    public TemporalEdge getNextEdge() {
        return this.nextEdge;
    }
}

