/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.temporal.object;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.temporal.object.DefaultTemporalEdge;
import org.geotoolkit.temporal.object.DefaultTemporalNode;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.temporal.TemporalEdge;
import org.opengis.temporal.TemporalNode;
import org.opengis.temporal.TemporalTopologicalComplex;
import org.opengis.temporal.TemporalTopologicalPrimitive;

@XmlType(name="TimeTopologyComplex_Type", propOrder={"composition"})
@XmlRootElement(name="TimeTopologyComplex")
public class DefaultTemporalTopologicalComplex
extends AbstractIdentifiedObject
implements TemporalTopologicalComplex {
    final Collection<TemporalTopologicalPrimitive> composition;

    public DefaultTemporalTopologicalComplex(Map<String, ?> properties, Collection<TemporalTopologicalPrimitive> primitives) throws IllegalArgumentException {
        super(properties);
        ArgumentChecks.ensureNonNull((String)"primitives", primitives);
        this.composition = primitives;
    }

    private DefaultTemporalTopologicalComplex() {
        super((IdentifiedObject)NilReferencingObject.INSTANCE);
        this.composition = null;
    }

    private DefaultTemporalTopologicalComplex(TemporalTopologicalComplex object) {
        super((IdentifiedObject)NilReferencingObject.INSTANCE);
        this.composition = object != null ? object.getTemporalTopologicalPrimitives() : null;
    }

    public static DefaultTemporalTopologicalComplex castOrCopy(TemporalTopologicalComplex object) {
        if (object == null || object instanceof DefaultTemporalTopologicalComplex) {
            return (DefaultTemporalTopologicalComplex)object;
        }
        return new DefaultTemporalTopologicalComplex(object);
    }

    public Collection<TemporalTopologicalPrimitive> getTemporalTopologicalPrimitives() {
        return this.composition;
    }

    @XmlElement(name="primitive", required=true)
    private Collection<TemporalTopologicalPrimitive> getComposition() {
        if (this.composition.isEmpty()) {
            return null;
        }
        Object[] prim = this.composition.toArray();
        ArrayList<TemporalTopologicalPrimitive> lst = new ArrayList<TemporalTopologicalPrimitive>();
        int s = prim.length;
        for (int i = 0; i < s; ++i) {
            if (prim[i] instanceof TemporalEdge) {
                lst.add(DefaultTemporalEdge.castOrCopy((TemporalEdge)prim[i]));
                continue;
            }
            if (prim[i] instanceof TemporalNode) {
                lst.add(DefaultTemporalNode.castOrCopy((TemporalNode)prim[i]));
                continue;
            }
            return null;
        }
        return lst;
    }
}

