/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.metadata.iso.identification.AbstractIdentification;
import org.apache.sis.metadata.iso.identification.OperationName;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.distribution.StandardOrderProcess;
import org.opengis.metadata.identification.CoupledResource;
import org.opengis.metadata.identification.CouplingType;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.identification.OperationChainMetadata;
import org.opengis.metadata.identification.OperationMetadata;
import org.opengis.metadata.identification.ServiceIdentification;
import org.opengis.util.GenericName;

@XmlType(name="SV_ServiceIdentification_Type", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0", propOrder={"serviceType", "serviceTypeVersions", "accessProperties", "couplingType", "coupledResources", "operatedDataset", "profile", "serviceStandard", "containsOperations", "operatesOn", "operationChain"})
@XmlRootElement(name="SV_ServiceIdentification", namespace="http://standards.iso.org/iso/19115/-3/srv/2.0")
public class DefaultServiceIdentification
extends AbstractIdentification
implements ServiceIdentification {
    private static final long serialVersionUID = 7700836694236616300L;
    private GenericName serviceType;
    private Collection<String> serviceTypeVersions;
    private StandardOrderProcess accessProperties;
    private CouplingType couplingType;
    private Collection<CoupledResource> coupledResources;
    private Collection<Citation> operatedDatasets;
    private Collection<Citation> profiles;
    private Collection<Citation> serviceStandards;
    private Collection<OperationMetadata> containsOperations;
    private Collection<DataIdentification> operatesOn;
    private Collection<OperationChainMetadata> containsChain;

    public DefaultServiceIdentification() {
    }

    public DefaultServiceIdentification(GenericName serviceType, Citation citation, CharSequence abstracts) {
        super(citation, abstracts);
        this.serviceType = serviceType;
    }

    public DefaultServiceIdentification(ServiceIdentification object) {
        super((Identification)object);
        if (object != null) {
            this.serviceType = object.getServiceType();
            this.serviceTypeVersions = this.copyCollection(object.getServiceTypeVersions(), String.class);
            this.accessProperties = object.getAccessProperties();
            this.couplingType = object.getCouplingType();
            this.coupledResources = this.copyCollection(object.getCoupledResources(), CoupledResource.class);
            this.operatedDatasets = this.copyCollection(object.getOperatedDatasets(), Citation.class);
            this.profiles = this.copyCollection(object.getProfiles(), Citation.class);
            this.serviceStandards = this.copyCollection(object.getServiceStandards(), Citation.class);
            this.containsOperations = this.copyCollection(object.getContainsOperations(), OperationMetadata.class);
            this.operatesOn = this.copyCollection(object.getOperatesOn(), DataIdentification.class);
            this.containsChain = this.copyCollection(object.getContainsChain(), OperationChainMetadata.class);
        }
    }

    public static DefaultServiceIdentification castOrCopy(ServiceIdentification object) {
        if (object == null || object instanceof DefaultServiceIdentification) {
            return (DefaultServiceIdentification)object;
        }
        return new DefaultServiceIdentification(object);
    }

    @XmlElement(name="serviceType", required=true)
    public GenericName getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(GenericName newValue) {
        this.checkWritePermission(this.serviceType);
        this.serviceType = newValue;
    }

    @XmlElement(name="serviceTypeVersion")
    public Collection<String> getServiceTypeVersions() {
        this.serviceTypeVersions = this.nonNullCollection(this.serviceTypeVersions, String.class);
        return this.serviceTypeVersions;
    }

    public void setServiceTypeVersions(Collection<? extends String> newValues) {
        this.serviceTypeVersions = this.writeCollection(newValues, this.serviceTypeVersions, String.class);
    }

    @XmlElement(name="accessProperties")
    public StandardOrderProcess getAccessProperties() {
        return this.accessProperties;
    }

    public void setAccessProperties(StandardOrderProcess newValue) {
        this.checkWritePermission(this.accessProperties);
        this.accessProperties = newValue;
    }

    @XmlElement(name="couplingType")
    public CouplingType getCouplingType() {
        return this.couplingType;
    }

    public void setCouplingType(CouplingType newValue) {
        this.checkWritePermission(this.couplingType);
        this.couplingType = newValue;
    }

    @XmlElement(name="coupledResource")
    public Collection<CoupledResource> getCoupledResources() {
        this.coupledResources = this.nonNullCollection(this.coupledResources, CoupledResource.class);
        return this.coupledResources;
    }

    public void setCoupledResources(Collection<? extends CoupledResource> newValues) {
        this.coupledResources = this.writeCollection(newValues, this.coupledResources, CoupledResource.class);
    }

    public Collection<Citation> getOperatedDatasets() {
        this.operatedDatasets = this.nonNullCollection(this.operatedDatasets, Citation.class);
        return this.operatedDatasets;
    }

    public void setOperatedDatasets(Collection<? extends Citation> newValues) {
        this.operatedDatasets = this.writeCollection(newValues, this.operatedDatasets, Citation.class);
    }

    public Collection<Citation> getProfiles() {
        this.profiles = this.nonNullCollection(this.profiles, Citation.class);
        return this.profiles;
    }

    public void setProfiles(Collection<? extends Citation> newValues) {
        this.profiles = this.writeCollection(newValues, this.profiles, Citation.class);
    }

    public Collection<Citation> getServiceStandards() {
        this.serviceStandards = this.nonNullCollection(this.serviceStandards, Citation.class);
        return this.serviceStandards;
    }

    public void setServiceStandards(Collection<? extends Citation> newValues) {
        this.serviceStandards = this.writeCollection(newValues, this.serviceStandards, Citation.class);
    }

    @XmlElement(name="containsOperations")
    public Collection<OperationMetadata> getContainsOperations() {
        this.containsOperations = this.nonNullCollection(this.containsOperations, OperationMetadata.class);
        return this.containsOperations;
    }

    public void setContainsOperations(Collection<? extends OperationMetadata> newValues) {
        this.containsOperations = this.writeCollection(newValues, this.containsOperations, OperationMetadata.class);
    }

    @XmlElement(name="operatesOn")
    public Collection<DataIdentification> getOperatesOn() {
        this.operatesOn = this.nonNullCollection(this.operatesOn, DataIdentification.class);
        return this.operatesOn;
    }

    public void setOperatesOn(Collection<? extends DataIdentification> newValues) {
        this.operatesOn = this.writeCollection(newValues, this.operatesOn, DataIdentification.class);
    }

    public Collection<OperationChainMetadata> getContainsChain() {
        this.containsChain = this.nonNullCollection(this.containsChain, OperationChainMetadata.class);
        return this.containsChain;
    }

    public void setContainsChain(Collection<? extends OperationChainMetadata> newValues) {
        this.containsChain = this.writeCollection(newValues, this.containsChain, OperationChainMetadata.class);
    }

    @XmlElement(name="operatedDataset")
    private Collection<Citation> getOperatedDataset() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getOperatedDatasets() : null;
    }

    @XmlElement(name="profile")
    private Collection<Citation> getProfile() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getProfiles() : null;
    }

    @XmlElement(name="serviceStandard")
    private Collection<Citation> getServiceStandard() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getServiceStandards() : null;
    }

    @XmlElement(name="containsChain")
    private Collection<OperationChainMetadata> getOperationChain() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getContainsChain() : null;
    }

    private void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        if (this.containsOperations != null && this.coupledResources != null) {
            OperationName.resolve(this.containsOperations, this.coupledResources);
        }
    }
}

