/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.isoonjts.spatialschema;

import java.util.List;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.referencing.CommonCRS;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry.JTSPointArray;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.PositionFactory;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class JTSPositionFactory
implements PositionFactory {
    private final CoordinateReferenceSystem crs;

    public JTSPositionFactory() {
        this((CoordinateReferenceSystem)CommonCRS.WGS84.normalizedGeographic());
    }

    public JTSPositionFactory(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public DirectPosition createDirectPosition(double[] coordinates) throws MismatchedDimensionException {
        GeneralDirectPosition position = new GeneralDirectPosition(coordinates);
        position.setCoordinateReferenceSystem(this.crs);
        return position;
    }

    public Position createPosition(Position position) {
        return new GeneralDirectPosition(position.getDirectPosition());
    }

    public List createPositionList() {
        return new JTSPointArray(this.crs);
    }

    public List createPositionList(double[] coordinates, int start, int end) {
        JTSPointArray array = new JTSPointArray(this.crs);
        int N = this.crs.getCoordinateSystem().getDimension();
        for (int i = start; i < end; i += N) {
            double[] ords = new double[N];
            System.arraycopy(coordinates, i, ords, 0, N);
            array.add(this.createDirectPosition(ords));
        }
        return array;
    }

    public List createPositionList(float[] coordinates, int start, int end) {
        JTSPointArray array = new JTSPointArray(this.crs);
        int N = this.crs.getCoordinateSystem().getDimension();
        for (int i = start; i < end; i += N) {
            double[] ords = new double[N];
            System.arraycopy(coordinates, i, ords, 0, N);
            array.add(this.createDirectPosition(ords));
        }
        return array;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public PointArray createPointArray(float[] array, int start, int end) {
        PointArray pointArray = this.createPointArray();
        int D = this.crs.getCoordinateSystem().getDimension();
        if (D == 2) {
            for (int i = start; i < end; i += D) {
                double[] coordinates = new double[]{array[i], array[i + 1]};
                GeneralDirectPosition pos = new GeneralDirectPosition(coordinates);
                pos.setCoordinateReferenceSystem(this.crs);
                pointArray.add((Object)pos);
            }
        } else if (D == 3) {
            for (int i = start; i < end; i += D) {
                double[] coordinates = new double[]{array[i], array[i + 1], array[i + 2]};
                GeneralDirectPosition pos = new GeneralDirectPosition(coordinates);
                pos.setCoordinateReferenceSystem(this.crs);
                pointArray.add((Object)pos);
            }
        } else {
            for (int i = start; i < end; i += D) {
                double[] coordinates = new double[D];
                int o = 0;
                while (i < D) {
                    coordinates[o] = array[i + o];
                    ++i;
                }
                GeneralDirectPosition pos = new GeneralDirectPosition(coordinates);
                pos.setCoordinateReferenceSystem(this.crs);
                pointArray.add((Object)pos);
            }
        }
        return pointArray;
    }

    public PointArray createPointArray(double[] array, int start, int end) {
        PointArray pointArray = this.createPointArray();
        int n = this.crs.getCoordinateSystem().getDimension();
        double[] coordinates = new double[n];
        for (int i = start; i < array.length && i <= end; i += n) {
            for (int j = i; j < i + n; ++j) {
                coordinates[j - i] = array[j];
            }
            pointArray.add((Object)this.createDirectPosition(coordinates));
        }
        return pointArray;
    }

    public PointArray createPointArray() {
        return new JTSPointArray(this.crs);
    }
}

