/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.isoonjts.spatialschema.geometry;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.referencing.CRS;
import org.geotoolkit.geometry.isoonjts.JTSUtils;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.JTSEnvelope;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.JTSGeometry;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSCurveBoundary;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSPoint;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSSurfaceBoundary;
import org.geotoolkit.internal.jaxb.CoordinateReferenceSystemAdapter;
import org.geotoolkit.util.Cloneable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.opengis.geometry.Boundary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.TransfiniteSet;
import org.opengis.geometry.complex.Complex;
import org.opengis.geometry.primitive.Ring;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class AbstractJTSGeometry
implements Geometry,
Serializable,
Cloneable,
JTSGeometry {
    private boolean mutable;
    @XmlAttribute(name="srsName")
    @XmlJavaTypeAdapter(value=CoordinateReferenceSystemAdapter.class)
    private CoordinateReferenceSystem coordinateReferenceSystem;
    private org.locationtech.jts.geom.Geometry jtsPeer;
    private JTSGeometry parent;

    public AbstractJTSGeometry() {
        this(null);
    }

    public AbstractJTSGeometry(CoordinateReferenceSystem coordinateReferenceSystem) {
        this(coordinateReferenceSystem, true);
    }

    public AbstractJTSGeometry(CoordinateReferenceSystem coordinateReferenceSystem, boolean mutable) {
        this.coordinateReferenceSystem = coordinateReferenceSystem;
        this.mutable = mutable;
    }

    public void setParent(JTSGeometry parent) {
        this.parent = parent;
    }

    protected abstract org.locationtech.jts.geom.Geometry computeJTSPeer();

    @Override
    public final void invalidateCachedJTSPeer() {
        this.jtsPeer = null;
        if (this.parent != null) {
            this.parent.invalidateCachedJTSPeer();
        }
    }

    protected final void setJTSPeer(org.locationtech.jts.geom.Geometry g) {
        this.jtsPeer = g;
    }

    @Override
    public final org.locationtech.jts.geom.Geometry getJTSGeometry() {
        if (this.jtsPeer == null) {
            this.jtsPeer = this.computeJTSPeer();
        }
        return this.jtsPeer;
    }

    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.coordinateReferenceSystem;
    }

    public final void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        this.coordinateReferenceSystem = crs;
    }

    public final Geometry getMbRegion() {
        org.locationtech.jts.geom.Geometry jtsGeom = this.getJTSGeometry();
        return JTSUtils.toISO(jtsGeom.getEnvelope(), this.getCoordinateReferenceSystem());
    }

    public final DirectPosition getRepresentativePoint() {
        org.locationtech.jts.geom.Geometry jtsGeom = this.getJTSGeometry();
        Point p = jtsGeom.getInteriorPoint();
        return JTSUtils.pointToDirectPosition(p, this.getCoordinateReferenceSystem());
    }

    public Boundary getBoundary() {
        org.locationtech.jts.geom.Geometry jtsGeom = this.getJTSGeometry();
        if (jtsGeom instanceof GeometryCollection) {
            throw new UnsupportedOperationException("Boundary cannot be computed for multi-primitives.");
        }
        org.locationtech.jts.geom.Geometry jtsBoundary = jtsGeom.getBoundary();
        int d = jtsGeom.getDimension();
        if (d == 0) {
            return null;
        }
        if (d == 1) {
            Coordinate[] coords = jtsBoundary.getCoordinates();
            if (coords == null || coords.length == 0) {
                JTSCurveBoundary result = new JTSCurveBoundary(this.getCoordinateReferenceSystem(), null, null);
                return result;
            }
            if (coords.length != 2) {
                throw new RuntimeException("ERROR: One dimensional primitive had wrong number of boundary points (" + coords.length + ")");
            }
            CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
            JTSCurveBoundary result = new JTSCurveBoundary(crs, new JTSPoint(JTSUtils.coordinateToDirectPosition(coords[0], crs)), new JTSPoint(JTSUtils.coordinateToDirectPosition(coords[1], crs)));
            return result;
        }
        if (d == 2) {
            MultiLineString mls = (MultiLineString)jtsBoundary;
            int n = mls.getNumGeometries();
            CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
            Ring exteriorRing = JTSUtils.linearRingToRing((LineString)mls.getGeometryN(0), crs);
            Ring[] interiorRings = new Ring[n - 1];
            for (int i = 1; i < n; ++i) {
                interiorRings[n - 1] = JTSUtils.linearRingToRing((LineString)mls.getGeometryN(i), crs);
            }
            JTSSurfaceBoundary result = new JTSSurfaceBoundary(crs, exteriorRing, interiorRings);
            return result;
        }
        throw new UnsupportedOperationException("Computing the boundary for geometries of dimension larger than 2 is not supported.");
    }

    public final Complex getClosure() {
        throw new UnsupportedOperationException("Closure not supported");
    }

    public final boolean isSimple() {
        org.locationtech.jts.geom.Geometry jtsGeom = this.getJTSGeometry();
        return jtsGeom.isSimple();
    }

    public final boolean isCycle() {
        org.locationtech.jts.geom.Geometry jtsGeom = this.getJTSGeometry();
        org.locationtech.jts.geom.Geometry jtsBoundary = jtsGeom.getBoundary();
        return jtsBoundary.isEmpty();
    }

    public final double getDistance(Geometry geometry) {
        org.locationtech.jts.geom.Geometry jtsGeom1 = this.getJTSGeometry();
        org.locationtech.jts.geom.Geometry jtsGeom2 = ((JTSGeometry)geometry).getJTSGeometry();
        return JTSUtils.distance(jtsGeom1, jtsGeom2);
    }

    public final int getDimension(DirectPosition point) {
        org.locationtech.jts.geom.Geometry jtsGeom = this.getJTSGeometry();
        if (jtsGeom instanceof GeometryCollection) {
            Point p = JTSUtils.directPositionToPoint(point);
            return AbstractJTSGeometry.getDimension(p, (GeometryCollection)jtsGeom);
        }
        return jtsGeom.getDimension();
    }

    private static final int getDimension(Point p, GeometryCollection gc) {
        int min = Integer.MAX_VALUE;
        int n = gc.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            int d = Integer.MAX_VALUE;
            org.locationtech.jts.geom.Geometry g = gc.getGeometryN(i);
            if (g instanceof GeometryCollection) {
                d = AbstractJTSGeometry.getDimension(p, (GeometryCollection)g);
            } else if (g.intersects(p)) {
                d = g.getDimension();
            }
            if (d >= min) continue;
            min = d;
        }
        return min;
    }

    public final int getCoordinateDimension() {
        return this.getCoordinateReferenceSystem().getCoordinateSystem().getDimension();
    }

    public final Set getMaximalComplex() {
        return null;
    }

    public final Geometry transform(CoordinateReferenceSystem newCRS) throws TransformException {
        try {
            MathTransform mt = CRS.findOperation((CoordinateReferenceSystem)this.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)newCRS, null).getMathTransform();
            return this.transform(newCRS, mt);
        }
        catch (OperationNotFoundException e) {
            throw new TransformException("Unable to find an operation", (Throwable)e);
        }
        catch (FactoryException e) {
            throw new TransformException("Factory exception", (Throwable)e);
        }
    }

    public final Geometry transform(CoordinateReferenceSystem newCRS, MathTransform transform) throws TransformException {
        org.locationtech.jts.geom.Geometry jtsGeom = this.getJTSGeometry();
        jtsGeom = (org.locationtech.jts.geom.Geometry)jtsGeom.clone();
        CoordinateReferenceSystem oldCRS = this.getCoordinateReferenceSystem();
        jtsGeom.apply(new MathTransformFilter(transform, oldCRS, newCRS));
        return JTSUtils.toISO(jtsGeom, this.getCoordinateReferenceSystem());
    }

    public final org.opengis.geometry.Envelope getEnvelope() {
        org.locationtech.jts.geom.Geometry jtsGeom = this.getJTSGeometry();
        Envelope jtsEnv = jtsGeom.getEnvelopeInternal();
        CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
        DirectPosition2D lower = new DirectPosition2D(jtsEnv.getMinX(), jtsEnv.getMinY());
        lower.setCoordinateReferenceSystem(crs);
        DirectPosition2D upper = new DirectPosition2D(jtsEnv.getMaxX(), jtsEnv.getMaxY());
        upper.setCoordinateReferenceSystem(crs);
        JTSEnvelope result = new JTSEnvelope((DirectPosition)lower, (DirectPosition)upper);
        return result;
    }

    public final DirectPosition getCentroid() {
        org.locationtech.jts.geom.Geometry jtsGeom = this.getJTSGeometry();
        Point jtsCentroid = jtsGeom.getCentroid();
        return JTSUtils.pointToDirectPosition(jtsCentroid, this.getCoordinateReferenceSystem());
    }

    public final Geometry getConvexHull() {
        org.locationtech.jts.geom.Geometry jtsGeom = this.getJTSGeometry();
        org.locationtech.jts.geom.Geometry jtsHull = jtsGeom.convexHull();
        return JTSUtils.toISO(jtsHull, this.getCoordinateReferenceSystem());
    }

    public final Geometry getBuffer(double distance) {
        org.locationtech.jts.geom.Geometry jtsGeom = this.getJTSGeometry();
        org.locationtech.jts.geom.Geometry jtsBuffer = jtsGeom.buffer(distance);
        return JTSUtils.toISO(jtsBuffer, this.getCoordinateReferenceSystem());
    }

    public final boolean isMutable() {
        return this.mutable;
    }

    public final Geometry toImmutable() {
        if (this.isMutable()) {
            AbstractJTSGeometry result = this.clone();
            result.mutable = false;
            return result;
        }
        return this;
    }

    public AbstractJTSGeometry clone() {
        try {
            return (AbstractJTSGeometry)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new AssertionError((Object)cnse);
        }
    }

    public boolean contains(DirectPosition point) {
        org.locationtech.jts.geom.Geometry jtsGeom1 = this.getJTSGeometry();
        Point jtsGeom2 = JTSUtils.directPositionToPoint(point);
        return JTSUtils.contains(jtsGeom1, jtsGeom2);
    }

    public boolean contains(TransfiniteSet pointSet) {
        org.locationtech.jts.geom.Geometry jtsGeom1 = this.getJTSGeometry();
        org.locationtech.jts.geom.Geometry jtsGeom2 = ((JTSGeometry)pointSet).getJTSGeometry();
        return JTSUtils.contains(jtsGeom1, jtsGeom2);
    }

    public double distance(Geometry otherGeometry) {
        return this.getDistance(otherGeometry);
    }

    public TransfiniteSet difference(TransfiniteSet pointSet) {
        org.locationtech.jts.geom.Geometry jtsGeom1 = this.getJTSGeometry();
        org.locationtech.jts.geom.Geometry jtsGeom2 = ((JTSGeometry)pointSet).getJTSGeometry();
        return JTSUtils.toISO(JTSUtils.difference(jtsGeom1, jtsGeom2), this.getCoordinateReferenceSystem());
    }

    public boolean equals(TransfiniteSet pointSet) {
        org.locationtech.jts.geom.Geometry jtsGeom1 = this.getJTSGeometry();
        org.locationtech.jts.geom.Geometry jtsGeom2 = ((JTSGeometry)pointSet).getJTSGeometry();
        return JTSUtils.equals(jtsGeom1, jtsGeom2);
    }

    public TransfiniteSet intersection(TransfiniteSet pointSet) {
        org.locationtech.jts.geom.Geometry jtsGeom1 = this.getJTSGeometry();
        org.locationtech.jts.geom.Geometry jtsGeom2 = ((JTSGeometry)pointSet).getJTSGeometry();
        return JTSUtils.toISO(jtsGeom1.intersection(jtsGeom2), this.getCoordinateReferenceSystem());
    }

    public boolean intersects(TransfiniteSet pointSet) {
        org.locationtech.jts.geom.Geometry jtsGeom1 = this.getJTSGeometry();
        org.locationtech.jts.geom.Geometry jtsGeom2 = ((JTSGeometry)pointSet).getJTSGeometry();
        return JTSUtils.intersects(jtsGeom1, jtsGeom2);
    }

    public TransfiniteSet symmetricDifference(TransfiniteSet pointSet) {
        org.locationtech.jts.geom.Geometry jtsGeom1 = this.getJTSGeometry();
        org.locationtech.jts.geom.Geometry jtsGeom2 = ((JTSGeometry)pointSet).getJTSGeometry();
        return JTSUtils.toISO(JTSUtils.symmetricDifference(jtsGeom1, jtsGeom2), this.getCoordinateReferenceSystem());
    }

    public TransfiniteSet union(TransfiniteSet pointSet) {
        org.locationtech.jts.geom.Geometry jtsGeom1 = this.getJTSGeometry();
        org.locationtech.jts.geom.Geometry jtsGeom2 = ((JTSGeometry)pointSet).getJTSGeometry();
        return JTSUtils.toISO(JTSUtils.union(jtsGeom1, jtsGeom2), this.getCoordinateReferenceSystem());
    }

    public static Set listAsSet(final List list) {
        return new Set(){

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public void clear() {
                list.clear();
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }

            @Override
            public Object[] toArray() {
                return list.toArray();
            }

            @Override
            public boolean add(Object o) {
                return list.add(o);
            }

            @Override
            public boolean contains(Object o) {
                return list.contains(o);
            }

            @Override
            public boolean remove(Object o) {
                return list.remove(o);
            }

            @Override
            public boolean addAll(Collection c) {
                return list.addAll(c);
            }

            @Override
            public boolean containsAll(Collection c) {
                return list.containsAll(c);
            }

            @Override
            public boolean removeAll(Collection c) {
                return list.removeAll(c);
            }

            @Override
            public boolean retainAll(Collection c) {
                return list.retainAll(c);
            }

            @Override
            public Iterator iterator() {
                return list.iterator();
            }

            @Override
            public Object[] toArray(Object[] a) {
                return list.toArray(a);
            }
        };
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof AbstractJTSGeometry) {
            AbstractJTSGeometry that = (AbstractJTSGeometry)object;
            return Objects.equals(this.coordinateReferenceSystem, that.coordinateReferenceSystem) && Objects.equals(this.parent, that.parent);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + (this.coordinateReferenceSystem != null ? this.coordinateReferenceSystem.hashCode() : 0);
        hash = 41 * hash + (this.parent != null ? this.parent.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[").append(this.getClass().getName()).append(']');
        sb.append('\n');
        if (this.coordinateReferenceSystem != null) {
            sb.append("crs: ").append(this.coordinateReferenceSystem).append('\n');
        }
        if (this.jtsPeer != null) {
            sb.append("jtspeer: ").append(this.jtsPeer).append('\n');
        }
        sb.append("mutable: ").append(this.mutable).append('\n');
        if (this.parent != null) {
            sb.append("parent:").append(this.parent).append('\n');
        }
        return sb.toString();
    }

    public static class MathTransformFilter
    implements CoordinateFilter {
        private MathTransform transform;
        private DirectPosition src;
        private DirectPosition dst;

        public MathTransformFilter(MathTransform transform, CoordinateReferenceSystem oldCRS, CoordinateReferenceSystem newCRS) {
            this.transform = transform;
            this.src = new GeneralDirectPosition(oldCRS);
            this.dst = new GeneralDirectPosition(newCRS);
        }

        @Override
        public void filter(Coordinate coord) {
            JTSUtils.coordinateToDirectPosition(coord, this.src);
            try {
                this.transform.transform(this.src, this.dst);
            }
            catch (MismatchedDimensionException e) {
                throw new RuntimeException(e);
            }
            catch (TransformException e) {
                throw new RuntimeException(e);
            }
            JTSUtils.directPositionToCoordinate(this.dst, coord);
        }
    }
}

