/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.grid;

import java.util.Arrays;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.DoubleUnaryOperator;
import org.geotoolkit.util.grid.GridTraversal;

class MultiDimensionMove
implements Spliterator<double[]> {
    private final double[] startPoint;
    private final double[] endPoint;
    private final double[] segmentVector;
    private final double[] previousPoint;
    private final DoubleUnaryOperator[] moveDirs;

    MultiDimensionMove(double[] startPoint, double[] endPoint) {
        if (startPoint.length != endPoint.length) {
            throw new IllegalArgumentException(String.format("Dimension of given points does not match: start is %dD, but end is %dD", startPoint.length, endPoint.length));
        }
        this.startPoint = Arrays.copyOf(startPoint, startPoint.length);
        this.previousPoint = Arrays.copyOf(startPoint, startPoint.length);
        this.endPoint = Arrays.copyOf(endPoint, endPoint.length);
        this.moveDirs = new DoubleUnaryOperator[startPoint.length];
        this.segmentVector = new double[startPoint.length];
        for (int i = 0; i < this.segmentVector.length; ++i) {
            this.segmentVector[i] = endPoint[i] - startPoint[i];
            this.moveDirs[i] = GridTraversal.isNearZero(this.segmentVector[i]) ? null : (this.segmentVector[i] < 0.0 ? GridTraversal::floorOrDecrement : GridTraversal::ceilOrIncrement);
        }
    }

    @Override
    public boolean tryAdvance(Consumer<? super double[]> action) {
        int i;
        double minDist = Double.POSITIVE_INFINITY;
        int idxOfMinDist = -1;
        for (i = 0; i < this.moveDirs.length; ++i) {
            DoubleUnaryOperator mover = this.moveDirs[i];
            if (mover == null) continue;
            double move = mover.applyAsDouble(this.previousPoint[i]);
            if (this.segmentVector[i] >= 0.0 ? move >= this.endPoint[i] : move <= this.endPoint[i]) {
                move = this.endPoint[i];
            }
            if (GridTraversal.isNearZero(move -= this.previousPoint[i])) continue;
            double moveRatio = move / this.segmentVector[i];
            assert (moveRatio >= 0.0);
            if (!(moveRatio < minDist)) continue;
            minDist = moveRatio;
            idxOfMinDist = i;
        }
        if (idxOfMinDist < 0) {
            return false;
        }
        for (i = 0; i < this.previousPoint.length; ++i) {
            int n = i;
            this.previousPoint[n] = this.previousPoint[n] + minDist * this.segmentVector[i];
            if (!(this.segmentVector[i] >= 0.0 ? this.previousPoint[i] > this.endPoint[i] : this.previousPoint[i] < this.endPoint[i])) continue;
            this.previousPoint[i] = this.endPoint[i];
        }
        assert (GridTraversal.areColinear(this.segmentVector, GridTraversal.toVector(this.startPoint, this.previousPoint)));
        action.accept((double[])Arrays.copyOf(this.previousPoint, this.previousPoint.length));
        return true;
    }

    @Override
    public Spliterator<double[]> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 273;
    }
}

