/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat30.basic;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Validator;
import org.opengis.cite.cat30.CommonFixture;
import org.opengis.cite.cat30.ETSAssert;
import org.opengis.cite.cat30.ErrorMessage;
import org.opengis.cite.cat30.SuiteAttribute;
import org.opengis.cite.cat30.util.ClientUtils;
import org.opengis.cite.cat30.util.DatasetInfo;
import org.opengis.cite.cat30.util.ServiceMetadataUtils;
import org.opengis.cite.cat30.util.XMLUtils;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class GetRecordByIdTests
extends CommonFixture {
    private URI getURI;
    private URI postURI;
    private List<String> idList;

    void setIdList(List<String> idList) {
        this.idList = idList;
    }

    @BeforeClass
    public void findRequestEndpoints() {
        this.getURI = ServiceMetadataUtils.getOperationEndpoint(this.cswCapabilities, "GetRecordById", "GET");
        this.postURI = ServiceMetadataUtils.getOperationEndpoint(this.cswCapabilities, "GetRecordById", "POST");
    }

    @BeforeClass
    public void getRecordIdentifiers(ITestContext testContext) {
        DatasetInfo dataset = (DatasetInfo)testContext.getSuite().getAttribute(SuiteAttribute.DATASET.getName());
        if (null == dataset) {
            throw new SkipException("Dataset info not found in test context.");
        }
        List<String> identifiers = dataset.getRecordIdentifiers();
        if (identifiers.isEmpty()) {
            throw new SkipException("No dc:identifier elements found in sample data.");
        }
        this.setIdList(identifiers);
    }

    @Test(description="Requirements: 127,141")
    public void getRecordById_noMatch() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecordById");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("id", "urn:example:" + System.currentTimeMillis());
        this.response = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        Assert.assertEquals((int)this.response.getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
    }

    @Test(description="Requirements: 124,134")
    public void getSummaryRecordById() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecordById");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        int randomIndex = ThreadLocalRandom.current().nextInt(this.idList.size());
        String id = this.idList.get(randomIndex);
        qryParams.put("id", id);
        this.response = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        Assert.assertEquals((int)this.response.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Document entity = ClientUtils.getResponseEntityAsDocument(this.response, null);
        String expr = String.format("/csw:SummaryRecord/dc:identifier = '%s'", id);
        ETSAssert.assertXPath(expr, entity, null);
    }

    @Test(description="Requirements: 123")
    public void getBriefRecordById() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecordById");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("elementSetName", "brief");
        int randomIndex = ThreadLocalRandom.current().nextInt(this.idList.size());
        String id = this.idList.get(randomIndex);
        qryParams.put("id", id);
        this.response = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        Assert.assertEquals((int)this.response.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Document entity = ClientUtils.getResponseEntityAsDocument(this.response, null);
        String expr = String.format("/csw:BriefRecord/dc:identifier = '%s'", id);
        ETSAssert.assertXPath(expr, entity, null);
        Validator validator = this.cswSchema.newValidator();
        ETSAssert.assertSchemaValid(validator, new DOMSource(entity));
    }

    @Test(description="Requirements: 123")
    public void getFullRecordById() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecordById");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("elementSetName", "full");
        int randomIndex = ThreadLocalRandom.current().nextInt(this.idList.size());
        String id = this.idList.get(randomIndex);
        qryParams.put("id", id);
        this.response = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        Assert.assertEquals((int)this.response.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Document entity = ClientUtils.getResponseEntityAsDocument(this.response, null);
        String expr = String.format("/csw:Record/dc:identifier = '%s'", id);
        ETSAssert.assertXPath(expr, entity, null);
        Validator validator = this.cswSchema.newValidator();
        ETSAssert.assertSchemaValid(validator, new DOMSource(entity));
    }

    @Test(description="Requirements: 003,139,140")
    public void getRecordByIdAsAtomEntryUsingAcceptHeader() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecordById");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        int randomIndex = ThreadLocalRandom.current().nextInt(this.idList.size());
        String id = this.idList.get(randomIndex);
        qryParams.put("id", id);
        this.response = this.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_ATOM_XML_TYPE);
        Assert.assertEquals((int)this.response.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Document entity = this.getResponseEntityAsDocument(this.response, null);
        Map<String, String> nsBindings = Collections.singletonMap("http://www.w3.org/2005/Atom", "atom");
        String expr = String.format("/atom:entry/dc:identifier = '%s'", id);
        ETSAssert.assertXPath(expr, entity, nsBindings);
        Validator atomValidator = this.atomSchema.newValidator();
        ValidationErrorHandler err = new ValidationErrorHandler();
        atomValidator.setErrorHandler((ErrorHandler)err);
        try {
            StreamSource src = XMLUtils.toStreamSource(new DOMSource(entity));
            atomValidator.validate(src);
        }
        catch (IOException | SAXException ex) {
            Logger.getLogger(GetRecordByIdTests.class.getName()).log(Level.WARNING, "Error attempting to validate Atom entry.", ex);
        }
        Assert.assertFalse((boolean)err.errorsDetected(), (String)ErrorMessage.format("NotSchemaValid", err.getErrorCount(), err.toString()));
    }

    @Test(description="Requirements: 002,135,140")
    public void getRecordByIdAsAtomEntryUsingOutputFormat() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecordById");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("outputFormat", "application/atom+xml");
        int randomIndex = ThreadLocalRandom.current().nextInt(this.idList.size());
        String id = this.idList.get(randomIndex);
        qryParams.put("id", id);
        this.response = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        Assert.assertEquals((int)this.response.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Document entity = ClientUtils.getResponseEntityAsDocument(this.response, null);
        Map<String, String> nsBindings = Collections.singletonMap("http://www.w3.org/2005/Atom", "atom");
        String expr = String.format("/atom:entry/dc:identifier = '%s'", id);
        ETSAssert.assertXPath(expr, entity, nsBindings);
    }

    @Test(description="Requirements: 002,035,128")
    public void getRecordByIdWithUnsupportedFormat() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecordById");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("outputFormat", "model/vnd.collada+xml");
        int randomIndex = ThreadLocalRandom.current().nextInt(this.idList.size());
        String id = this.idList.get(randomIndex);
        qryParams.put("id", id);
        this.response = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        ETSAssert.assertExceptionReport(this.response, "InvalidParameterValue", "outputFormat");
    }

    @Test(description="Requirements: 132,136")
    public void getRecordByIdWithUnsupportedSchema() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecordById");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("outputSchema", "http://www.example.org/ns/alpha");
        int randomIndex = ThreadLocalRandom.current().nextInt(this.idList.size());
        String id = this.idList.get(randomIndex);
        qryParams.put("id", id);
        this.response = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        ETSAssert.assertExceptionReport(this.response, "InvalidParameterValue", "outputSchema");
    }

    @Test(description="Requirements: 037")
    public void getRecordByIdWithMissingId() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecordById");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        this.response = ClientUtils.buildGetRequest(this.getURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        ETSAssert.assertExceptionReport(this.response, "MissingParameterValue", "id");
    }
}

