/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat30.util;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opengis.cite.cat30.util.ClientUtils;
import org.opengis.cite.cat30.util.ServiceMetadataUtils;
import org.opengis.cite.cat30.util.XMLUtils;
import org.w3c.dom.Document;

public class CSWClient {
    private static final Logger LOGR = Logger.getLogger(CSWClient.class.getName());
    private Document cswCapabilities;

    public Document getServiceDescription() {
        return this.cswCapabilities;
    }

    public void setServiceDescription(Document capabilities) {
        if (!capabilities.getDocumentElement().getNamespaceURI().equals("http://www.opengis.net/cat/csw/3.0")) {
            throw new IllegalArgumentException("Expected a CSW v3 capabilities document.");
        }
        this.cswCapabilities = capabilities;
    }

    public File saveFullRecords(int maxRecords, MediaType mediaType) {
        Response rsp;
        URI getRecordsURI = ServiceMetadataUtils.getOperationEndpoint(this.cswCapabilities, "GetRecords", "GET");
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetRecords");
        qryParams.put("service", "CSW");
        qryParams.put("version", "3.0.0");
        qryParams.put("maxRecords", Integer.toString(maxRecords));
        qryParams.put("elementSetName", "full");
        if (mediaType.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            qryParams.put("typeNames", "Record");
        }
        if ((rsp = ClientUtils.buildGetRequest(getRecordsURI, qryParams, mediaType)).getStatus() != Response.Status.OK.getStatusCode()) {
            return null;
        }
        Document entityDoc = (Document)rsp.readEntity(Document.class);
        File outputFile = null;
        try {
            outputFile = File.createTempFile("records-", ".xml");
            FileOutputStream fos = new FileOutputStream(outputFile);
            XMLUtils.writeNode(entityDoc, fos);
            fos.close();
        }
        catch (IOException ex) {
            LOGR.log(Level.WARNING, "Failed to save GetRecords response entity to file.", ex);
        }
        return outputFile;
    }

    public Document getCapabilities(URI uri) {
        if (null == uri || !uri.isAbsolute()) {
            uri = ServiceMetadataUtils.getOperationEndpoint(this.cswCapabilities, "GetCapabilities", "GET");
        }
        Response rsp = ClientUtils.buildGetRequest(uri, null, MediaType.APPLICATION_XML_TYPE);
        Document capabilitiesDoc = null;
        if (rsp.getStatus() == Response.Status.OK.getStatusCode() && XMLUtils.isXML(rsp.getMediaType())) {
            capabilitiesDoc = (Document)rsp.readEntity(Document.class);
        }
        return capabilitiesDoc;
    }

    public Document getOpenSearchDescription(URI uri) {
        Response rsp;
        if (null == uri || !uri.isAbsolute()) {
            uri = ServiceMetadataUtils.getOperationEndpoint(this.cswCapabilities, "GetCapabilities", "GET");
        }
        if ((rsp = ClientUtils.buildGetRequest(uri, null, MediaType.valueOf((String)"application/vnd.a9.opensearchdescription+xml"), MediaType.valueOf((String)"application/opensearchdescription+xml"))).getStatus() != Response.Status.OK.getStatusCode() || !XMLUtils.isXML(rsp.getMediaType())) {
            URI endpoint;
            Set<String> values = ServiceMetadataUtils.getConstraintValues(this.cswCapabilities, "OpenSearchDescriptionDocument");
            if (null != values && !values.isEmpty() && !(endpoint = URI.create(values.iterator().next())).equals(uri)) {
                return this.getOpenSearchDescription(endpoint);
            }
            LOGR.config(rsp.toString());
            return null;
        }
        Document entityDoc = (Document)rsp.readEntity(Document.class);
        if (!entityDoc.getDocumentElement().getNamespaceURI().equals("http://a9.com/-/spec/opensearch/1.1/")) {
            LOGR.config(entityDoc.getDocumentElement().getNodeName());
            return null;
        }
        return entityDoc;
    }
}

