/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.folder;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.apache.sis.internal.storage.Capability;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.StoreMetadata;
import org.apache.sis.internal.storage.StoreUtilities;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.internal.storage.folder.Store;
import org.apache.sis.internal.storage.folder.WritableStore;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.logging.Logging;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.InternationalString;

@StoreMetadata(formatName="folder", capabilities={Capability.READ, Capability.WRITE}, resourceTypes={Aggregate.class, FeatureSet.class, GridCoverageResource.class}, yieldPriority=true)
public final class StoreProvider
extends DataStoreProvider {
    static final String NAME = "folder";
    private static final Logger LOGGER = Logger.getLogger("org.apache.sis.storage.folder");
    private static final ParameterDescriptor<Locale> LOCALE;
    private static final ParameterDescriptor<TimeZone> TIMEZONE;
    private static final ParameterDescriptor<Charset> ENCODING;
    private static final ParameterDescriptor<String> FORMAT;
    static final ParameterDescriptorGroup PARAMETERS;

    private static <T> ParameterDescriptor<T> annotate(ParameterBuilder builder, ParameterDescriptor<T> e, InternationalString remark) {
        return ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addName(e.getName())).setDescription((CharSequence)e.getDescription())).setRemarks((CharSequence)remark)).create(e.getValueClass(), null);
    }

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public ParameterDescriptorGroup getOpenParameters() {
        return PARAMETERS;
    }

    @Override
    public ProbeResult probeContent(StorageConnector connector) throws DataStoreException {
        try {
            Path path = connector.getStorageAs(Path.class);
            if (path != null && Files.isDirectory(path, new LinkOption[0])) {
                return ProbeResult.SUPPORTED;
            }
        }
        catch (FileSystemNotFoundException e) {
            Logging.recoverableException(this.getLogger(), StoreProvider.class, "probeContent", e);
        }
        return ProbeResult.UNSUPPORTED_STORAGE;
    }

    @Override
    public DataStore open(StorageConnector connector) throws DataStoreException {
        return this.open(connector, null, EnumSet.noneOf(StandardOpenOption.class));
    }

    private DataStore open(StorageConnector connector, String format, EnumSet<StandardOpenOption> options) throws DataStoreException {
        Store store;
        DataStoreProvider componentProvider;
        if (format != null) {
            componentProvider = StoreUtilities.providerByFormatName(format.trim());
            if (Boolean.FALSE.equals(StoreUtilities.canWrite(componentProvider.getClass()))) {
                options.clear();
            }
        } else {
            componentProvider = null;
            options.clear();
        }
        Path path = connector.getStorageAs(Path.class);
        try {
            boolean isNew = false;
            if (options.contains(StandardOpenOption.CREATE) && (options.contains(StandardOpenOption.CREATE_NEW) || Files.notExists(path, new LinkOption[0]))) {
                Files.createDirectory(path, new FileAttribute[0]);
                isNew = true;
            }
            store = isNew || options.contains(StandardOpenOption.WRITE) && Files.isWritable(path) ? new WritableStore(this, connector, path, componentProvider) : new Store(this, connector, path, componentProvider);
            if (!Files.isDirectory(path, new LinkOption[0])) {
                throw new DataStoreException(Resources.format((short)44, path));
            }
            if (options.contains(StandardOpenOption.TRUNCATE_EXISTING)) {
                WritableStore.deleteRecursively(path, false);
            }
        }
        catch (IOException e) {
            short errorKey;
            int isDirectory = 0;
            if (e instanceof FileAlreadyExistsException) {
                if (path != null && Files.isDirectory(path, new LinkOption[0])) {
                    isDirectory = 1;
                }
                errorKey = 45;
            } else {
                errorKey = e instanceof NoSuchFileException ? (short)46 : 43;
            }
            throw new DataStoreException(Resources.format(errorKey, path != null ? path : connector.getStorageName(), isDirectory), e);
        }
        connector.closeAllExcept(path);
        return store;
    }

    @Override
    public DataStore open(ParameterValueGroup parameters) throws DataStoreException {
        ArgumentChecks.ensureNonNull("parameter", parameters);
        StorageConnector connector = URIDataStore.Provider.connector(this, parameters);
        Parameters pg = Parameters.castOrWrap((ParameterValueGroup)parameters);
        connector.setOption(OptionKey.LOCALE, (Locale)pg.getValue(LOCALE));
        connector.setOption(OptionKey.TIMEZONE, (TimeZone)pg.getValue(TIMEZONE));
        connector.setOption(OptionKey.ENCODING, (Charset)pg.getValue(ENCODING));
        EnumSet<StandardOpenOption> options = EnumSet.of(StandardOpenOption.WRITE);
        if (Boolean.TRUE.equals(pg.getValue(URIDataStore.Provider.CREATE_PARAM))) {
            options.add(StandardOpenOption.CREATE);
        }
        return this.open(connector, (String)pg.getValue(FORMAT), options);
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    static {
        ParameterBuilder builder = new ParameterBuilder();
        InternationalString remark = Resources.formatInternational((short)33);
        ENCODING = StoreProvider.annotate(builder, URIDataStore.Provider.ENCODING, remark);
        LOCALE = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addName((CharSequence)"locale")).setDescription((CharSequence)Resources.formatInternational((short)30))).setRemarks((CharSequence)remark)).create(Locale.class, null);
        TIMEZONE = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addName((CharSequence)"timezone")).setDescription((CharSequence)Resources.formatInternational((short)32))).setRemarks((CharSequence)remark)).create(TimeZone.class, null);
        FORMAT = ((ParameterBuilder)((ParameterBuilder)builder.addName((CharSequence)"format")).setDescription((CharSequence)Resources.formatInternational((short)40))).create(String.class, null);
        ParameterDescriptor location = new ParameterBuilder(URIDataStore.Provider.LOCATION_PARAM).create(Path.class, null);
        PARAMETERS = ((ParameterBuilder)builder.addName((CharSequence)NAME)).createGroup(new GeneralParameterDescriptor[]{location, LOCALE, TIMEZONE, ENCODING, FORMAT, URIDataStore.Provider.CREATE_PARAM});
    }
}

