/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat30.basic;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.cat30.CommonFixture;
import org.opengis.cite.cat30.ETSAssert;
import org.opengis.cite.cat30.ErrorMessage;
import org.opengis.cite.cat30.util.ClientUtils;
import org.opengis.cite.cat30.util.ServiceMetadataUtils;
import org.opengis.cite.cat30.util.TestSuiteLogger;
import org.opengis.cite.cat30.util.XMLUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class GetCapabilitiesTests
extends CommonFixture {
    private static final String SCHEMATRON_CSW_CAPABILITIES = "/org/opengis/cite/cat30/sch/csw-capabilities-3.0.sch";
    private URI getCapabilitiesURI;

    @BeforeClass
    public void findServiceEndpoint() {
        this.getCapabilitiesURI = ServiceMetadataUtils.getOperationEndpoint(this.cswCapabilities, "GetCapabilities", "GET");
    }

    public void setServiceCapabilities(Document cswCapabilities) {
        this.cswCapabilities = cswCapabilities;
    }

    @Test(description="Requirements: 043,045")
    public void getFullCapabilitiesAcceptVersion3() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetCapabilities");
        qryParams.put("service", "CSW");
        qryParams.put("acceptVersions", "3.0.0");
        this.response = ClientUtils.buildGetRequest(this.getCapabilitiesURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        Assert.assertEquals((int)this.response.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Source source = ClientUtils.getResponseEntityAsSource(this.response, null);
        Validator validator = this.cswSchema.newValidator();
        ETSAssert.assertSchemaValid(validator, source);
        URL schemaUrl = this.getClass().getResource(SCHEMATRON_CSW_CAPABILITIES);
        ETSAssert.assertSchematronValid(schemaUrl, source);
    }

    @Test(description="Requirements: 006")
    public void getCapabilitiesFromBaseURL() {
        this.response = ClientUtils.buildGetRequest(this.getCapabilitiesURI, null, MediaType.WILDCARD_TYPE);
        Assert.assertEquals((int)this.response.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Source source = ClientUtils.getResponseEntityAsSource(this.response, null);
        URL schURL = this.getClass().getResource(SCHEMATRON_CSW_CAPABILITIES);
        ETSAssert.assertSchematronValid(schURL, source);
    }

    @Test(description="Requirements: 007")
    public void getCapabilitiesFromBaseURLAsXML() {
        this.response = ClientUtils.buildGetRequest(this.getCapabilitiesURI, null, MediaType.valueOf((String)"text/html; q=0.5"), MediaType.APPLICATION_XML_TYPE);
        Assert.assertEquals((int)this.response.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Source source = ClientUtils.getResponseEntityAsSource(this.response, null);
        URL schURL = this.getClass().getResource(SCHEMATRON_CSW_CAPABILITIES);
        ETSAssert.assertSchematronValid(schURL, source);
    }

    @Test(description="Requirements: 011")
    public void getCapabilitiesWithMixedCaseParamNames() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("Request", "GetCapabilities");
        qryParams.put("SERVICE", "CSW");
        qryParams.put("acceptversions", "3.0.0");
        this.response = ClientUtils.buildGetRequest(this.getCapabilitiesURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        Document doc = ClientUtils.getResponseEntityAsDocument(this.response, null);
        QName qName = new QName("http://www.opengis.net/cat/csw/3.0", "Capabilities");
        ETSAssert.assertQualifiedName(doc.getDocumentElement(), qName);
    }

    @Test(description="Requirements: 012")
    public void getCapabilitiesWithInvalidParamValue() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "getCapabilities");
        qryParams.put("service", "CSW");
        qryParams.put("acceptVersions", "3.0.0");
        this.response = ClientUtils.buildGetRequest(this.getCapabilitiesURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        ETSAssert.assertExceptionReport(this.response, "InvalidParameterValue", "request");
    }

    @Test(description="Requirements: 010")
    public void getCapabilitiesIsMissingServiceParam() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetCapabilities");
        qryParams.put("acceptVersions", "3.0.0");
        this.response = ClientUtils.buildGetRequest(this.getCapabilitiesURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        ETSAssert.assertExceptionReport(this.response, "MissingParameterValue", "service");
    }

    @Test(description="Requirements: 036,037,042")
    public void getCapabilitiesWithUnsupportedVersion() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetCapabilities");
        qryParams.put("service", "CSW");
        qryParams.put("acceptVersions", "9999.12.31");
        this.response = ClientUtils.buildGetRequest(this.getCapabilitiesURI, qryParams, MediaType.APPLICATION_XML_TYPE);
        ETSAssert.assertExceptionReport(this.response, "VersionNegotiationFailed", "acceptVersions");
    }

    @Test(description="Requirements: 036,037,042")
    public void getCapabilitiesInUnsupportedFormat() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetCapabilities");
        qryParams.put("service", "CSW");
        qryParams.put("acceptVersions", "3.0.0");
        qryParams.put("acceptFormats", "model/x3d+xml");
        this.response = ClientUtils.buildGetRequest(this.getCapabilitiesURI, qryParams, MediaType.WILDCARD_TYPE);
        ETSAssert.assertExceptionReport(this.response, "InvalidParameterValue", "acceptFormats");
    }

    @Test(description="Requirements: 036,037,042")
    public void getCapabilitiesInSupportedFormat() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetCapabilities");
        qryParams.put("service", "CSW");
        qryParams.put("acceptVersions", "3.0.0");
        Set<String> allowedFormats = ServiceMetadataUtils.getParameterValues(this.cswCapabilities, "GetCapabilities", "acceptFormats");
        allowedFormats.add("text/xml");
        for (String format : allowedFormats) {
            qryParams.put("acceptFormats", format);
            this.response = ClientUtils.buildGetRequest(this.getCapabilitiesURI, qryParams, MediaType.WILDCARD_TYPE);
            Assert.assertEquals((int)this.response.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
            MediaType mediaType = new MediaType(this.response.getMediaType().getType(), this.response.getMediaType().getSubtype());
            Assert.assertEquals((Object)mediaType, (Object)MediaType.valueOf((String)format), (String)ErrorMessage.get("UnexpectedMediaType"));
        }
    }

    @Test(description="Requirements: 044")
    public void getCapabilitiesBySection() {
        HashMap<String, String> qryParams = new HashMap<String, String>();
        qryParams.put("request", "GetCapabilities");
        qryParams.put("service", "CSW");
        qryParams.put("acceptVersions", "3.0.0");
        Set<String> sections = ServiceMetadataUtils.getParameterValues(this.cswCapabilities, "GetCapabilities", "sections");
        sections.add("All");
        for (String section : sections) {
            qryParams.put("sections", section);
            this.response = ClientUtils.buildGetRequest(this.getCapabilitiesURI, qryParams, MediaType.APPLICATION_XML_TYPE);
            Assert.assertEquals((int)this.response.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
            Source source = ClientUtils.getResponseEntityAsSource(this.response, null);
            if (section.equals("All")) {
                URL schemaUrl = this.getClass().getResource(SCHEMATRON_CSW_CAPABILITIES);
                ETSAssert.assertSchematronValid(schemaUrl, source);
                continue;
            }
            String xpath = String.format("count(/csw:Capabilities/*) = count(//*[local-name()='%s'])", section);
            try {
                Boolean result = (Boolean)XMLUtils.evaluateXPath(source, xpath, null, XPathConstants.BOOLEAN);
                Assert.assertTrue((boolean)result, (String)ErrorMessage.format("XPathError", xpath));
            }
            catch (XPathExpressionException ex) {
                TestSuiteLogger.log(Level.WARNING, ex.getMessage());
            }
        }
    }
}

