/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat30.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.referencing.CommonCRS;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SpatialUtils {
    public static Envelope envelopeFromSimpleGeoRSSBox(Node boxNode) {
        if (!boxNode.getNamespaceURI().equals("http://www.georss.org/georss/10")) {
            throw new IllegalArgumentException("Not a GeoRSS element.");
        }
        GeographicCRS crs = CommonCRS.WGS84.geographic();
        GeneralEnvelope env = new GeneralEnvelope((CoordinateReferenceSystem)crs);
        String[] coords = boxNode.getTextContent().trim().split("\\s+");
        if (coords.length != 4) {
            throw new IllegalArgumentException("Expected two coordinate tuples (lower and upper corners).");
        }
        double[] coordArray = new double[coords.length];
        for (int i = 0; i < coords.length; ++i) {
            coordArray[i] = Double.parseDouble(coords[i]);
        }
        env.setEnvelope(coordArray);
        return env;
    }

    public static Element createGML32Envelope(Node oldEnvNode) {
        if (!oldEnvNode.getNamespaceURI().equals("http://www.opengis.net/gml")) {
            return null;
        }
        Element oldEnvelope = (Element)oldEnvNode;
        DocumentBuilder builder = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(SpatialUtils.class.getName()).log(Level.WARNING, null, ex);
        }
        Document doc = builder.newDocument();
        Element envelope = doc.createElementNS("http://www.opengis.net/gml/3.2", "Envelope");
        envelope.setAttribute("srsName", oldEnvelope.getAttribute("srsName"));
        Element lowerCorner = doc.createElementNS("http://www.opengis.net/gml/3.2", "lowerCorner");
        lowerCorner.setTextContent(oldEnvelope.getElementsByTagNameNS("http://www.opengis.net/gml", "lowerCorner").item(0).getTextContent());
        envelope.appendChild(lowerCorner);
        Element upperCorner = doc.createElementNS("http://www.opengis.net/gml/3.2", "upperCorner");
        upperCorner.setTextContent(oldEnvelope.getElementsByTagNameNS("http://www.opengis.net/gml", "upperCorner").item(0).getTextContent());
        envelope.appendChild(upperCorner);
        return envelope;
    }
}

