/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat30.basic;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.opengis.cite.cat30.CommonFixture;
import org.opengis.cite.cat30.ETSAssert;
import org.opengis.cite.cat30.ErrorMessage;
import org.opengis.cite.cat30.SuiteAttribute;
import org.opengis.cite.cat30.util.ServiceMetadataUtils;
import org.opengis.cite.cat30.util.TestSuiteLogger;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class OGCWebServiceTests
extends CommonFixture {
    private Document cswCapabilities;
    private Schema cswSchema;
    private static final String SCHEMATRON_CSW_CAPABILITIES = "/org/opengis/cite/cat30/sch/csw-capabilities-3.0.sch";
    private URI getCapabilitiesURI;

    @BeforeSuite
    public void verifyTestSubject(ITestContext testContext) {
        Object sutObj = testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        if (null != sutObj && Document.class.isInstance(sutObj)) {
            Document capabilitiesDoc = (Document)sutObj;
            String docElemNamespace = capabilitiesDoc.getDocumentElement().getNamespaceURI();
            Assert.assertEquals((String)docElemNamespace, (String)"http://www.opengis.net/cat/csw/3.0", (String)"Document element in unexpected namespace;");
            URI getCapabilitiesGET = ServiceMetadataUtils.getOperationEndpoint(capabilitiesDoc, "GetCapabilities", "GET");
            try {
                URL url = getCapabilitiesGET.toURL();
                URLConnection connection = url.openConnection();
                connection.connect();
            }
            catch (IOException iox) {
                throw new AssertionError("Service not available at " + getCapabilitiesGET, iox);
            }
        } else {
            String msg = String.format("Value of test suite attribute %s is missing or is not a DOM Document.", SuiteAttribute.TEST_SUBJECT.getName());
            TestSuiteLogger.log(Level.SEVERE, msg);
            throw new AssertionError((Object)msg);
        }
    }

    @BeforeClass
    public void initOGCWebServiceTests(ITestContext testContext) {
        Object obj = testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        if (null == obj) {
            throw new SkipException("Capabilities document not found in ITestContext.");
        }
        this.cswCapabilities = (Document)Document.class.cast(obj);
        this.getCapabilitiesURI = ServiceMetadataUtils.getOperationEndpoint(this.cswCapabilities, "GetCapabilities", "GET");
        obj = testContext.getSuite().getAttribute(SuiteAttribute.CSW_SCHEMA.getName());
        if (null == obj) {
            throw new SkipException("CSW schema not found in ITestContext.");
        }
        this.cswSchema = (Schema)Schema.class.cast(obj);
    }

    public void setServiceCapabilities(Document cswCapabilities) {
        this.cswCapabilities = cswCapabilities;
    }

    @Test(description="Requirement-043,Requirement-045")
    public void getFullCapabilities_v3() {
        MultivaluedMapImpl qryParams = new MultivaluedMapImpl();
        qryParams.add((Object)"request", (Object)"GetCapabilities");
        qryParams.add((Object)"service", (Object)"CSW");
        qryParams.add((Object)"acceptVersions", (Object)"3.0.0");
        WebResource resource = this.client.resource(this.getCapabilitiesURI).queryParams((MultivaluedMap)qryParams);
        WebResource.Builder builder = resource.accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
        ClientResponse rsp = (ClientResponse)builder.get(ClientResponse.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        DOMSource source = new DOMSource((Node)rsp.getEntity(Document.class));
        Validator validator = this.cswSchema.newValidator();
        ETSAssert.assertSchemaValid(validator, source);
        URL schemaUrl = this.getClass().getResource(SCHEMATRON_CSW_CAPABILITIES);
        ETSAssert.assertSchematronValid(schemaUrl, source);
    }

    @Test(description="Requirement-011")
    public void getCapabilitiesWithMixedCaseParamNames() {
        MultivaluedMapImpl qryParams = new MultivaluedMapImpl();
        qryParams.add((Object)"Request", (Object)"GetCapabilities");
        qryParams.add((Object)"SERVICE", (Object)"CSW");
        qryParams.add((Object)"acceptversions", (Object)"3.0.0");
        WebResource resource = this.client.resource(this.getCapabilitiesURI).queryParams((MultivaluedMap)qryParams);
        WebResource.Builder builder = resource.accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
        ClientResponse rsp = (ClientResponse)builder.get(ClientResponse.class);
        Document doc = (Document)rsp.getEntity(Document.class);
        QName qName = new QName("http://www.opengis.net/cat/csw/3.0", "Capabilities");
        ETSAssert.assertQualifiedName(doc.getDocumentElement(), qName);
    }

    @Test(description="Requirement-012")
    public void getCapabilitiesWithInvalidParamValue() {
        MultivaluedMapImpl qryParams = new MultivaluedMapImpl();
        qryParams.add((Object)"request", (Object)"getCapabilities");
        qryParams.add((Object)"service", (Object)"CSW");
        qryParams.add((Object)"acceptVersions", (Object)"3.0.0");
        WebResource resource = this.client.resource(this.getCapabilitiesURI).queryParams((MultivaluedMap)qryParams);
        WebResource.Builder builder = resource.accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
        ClientResponse rsp = (ClientResponse)builder.get(ClientResponse.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.BAD_REQUEST.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Document doc = (Document)rsp.getEntity(Document.class);
        String xpath = String.format("//ows:Exception[@exceptionCode = '%s']", "InvalidParameterValue");
        ETSAssert.assertXPath(xpath, doc, null);
    }

    @Test(description="Requirement-010")
    public void getCapabilitiesIsMissingServiceParam() {
        MultivaluedMapImpl qryParams = new MultivaluedMapImpl();
        qryParams.add((Object)"request", (Object)"GetCapabilities");
        qryParams.add((Object)"acceptVersions", (Object)"3.0.0");
        WebResource resource = this.client.resource(this.getCapabilitiesURI).queryParams((MultivaluedMap)qryParams);
        WebResource.Builder builder = resource.accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
        ClientResponse rsp = (ClientResponse)builder.get(ClientResponse.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.BAD_REQUEST.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Document doc = (Document)rsp.getEntity(Document.class);
        String xpath = String.format("//ows:Exception[@exceptionCode = '%s']", "MissingParameterValue");
        ETSAssert.assertXPath(xpath, doc, null);
    }

    @Test(description="Requirement-036,Requirement-037,Requirement-042")
    public void getCapabilitiesWithUnsupportedVersion() {
        MultivaluedMapImpl qryParams = new MultivaluedMapImpl();
        qryParams.add((Object)"request", (Object)"GetCapabilities");
        qryParams.add((Object)"service", (Object)"CSW");
        qryParams.add((Object)"acceptVersions", (Object)"9999.12.31");
        WebResource resource = this.client.resource(this.getCapabilitiesURI).queryParams((MultivaluedMap)qryParams);
        WebResource.Builder builder = resource.accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
        ClientResponse rsp = (ClientResponse)builder.get(ClientResponse.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.BAD_REQUEST.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        String xpath = String.format("//ows:Exception[@exceptionCode = '%s']", "VersionNegotiationFailed");
        ETSAssert.assertXPath(xpath, (Node)rsp.getEntity(Document.class), null);
    }

    @Test(description="Requirement-127,Requirement-141")
    public void getRecordById_noMatchingRecord() {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.cswCapabilities, "GetRecordById", "GET");
        MultivaluedMapImpl qryParams = new MultivaluedMapImpl();
        qryParams.add((Object)"request", (Object)"GetRecordById");
        qryParams.add((Object)"service", (Object)"CSW");
        qryParams.add((Object)"version", (Object)"3.0.0");
        qryParams.add((Object)"id", (Object)("urn:example:" + System.currentTimeMillis()));
        WebResource resource = this.client.resource(endpoint).queryParams((MultivaluedMap)qryParams);
        WebResource.Builder builder = resource.accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
        ClientResponse rsp = (ClientResponse)builder.get(ClientResponse.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.NOT_FOUND.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
    }
}

