/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat30.opensearch;

import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.opengis.cite.cat30.CommonFixture;
import org.opengis.cite.cat30.ETSAssert;
import org.opengis.cite.cat30.ErrorMessage;
import org.opengis.cite.cat30.SuiteAttribute;
import org.opengis.cite.cat30.util.ServiceMetadataUtils;
import org.opengis.cite.cat30.util.TestSuiteLogger;
import org.opengis.cite.validation.RelaxNGValidator;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class OpenSearchDescriptionTests
extends CommonFixture {
    private RelaxNGValidator osdValidator;
    private URI baseUri;
    private static final String SCHEMATRON_OPENSEARCH_DESCR = "/org/opengis/cite/cat30/sch/opensearch-1.1.sch";

    @BeforeTest
    public void checkOpenSearchImplementationStatus(ITestContext testContext) {
        Document cswCapabilities = (Document)testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        String xpath = String.format("//ows:Constraint[@name='%s']/ows:DefaultValue = 'TRUE'", "OpenSearch");
        ETSAssert.assertXPath(xpath, cswCapabilities.getDocumentElement(), null);
    }

    @BeforeClass
    public void initFixture(ITestContext testContext) {
        URL schemaUrl = this.getClass().getResource("/org/opengis/cite/cat30/rnc/osd-1.1-draft5.rnc");
        try {
            this.osdValidator = new RelaxNGValidator(schemaUrl);
        }
        catch (IOException | SAXException ex) {
            TestSuiteLogger.log(Level.WARNING, this.getClass().getName(), ex);
        }
        Document cswCapabilities = (Document)testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        this.baseUri = ServiceMetadataUtils.getOperationEndpoint(cswCapabilities, "GetCapabilities", "GET");
    }

    @Test(description="Test-008, Requirement-008")
    public void preferOpenSearchDescription() {
        WebResource resource = this.client.resource(this.baseUri);
        String xmlNotPreferred = "application/xml; q=0.5";
        WebResource.Builder builder = resource.accept(new String[]{xmlNotPreferred, "application/opensearchdescription+xml"});
        Document entity = (Document)builder.get(Document.class);
        QName osdDocElemName = new QName("http://a9.com/-/spec/opensearch/1.1/", "OpenSearchDescription");
        ETSAssert.assertQualifiedName(entity.getDocumentElement(), osdDocElemName);
    }

    @Test(description="Test-021, Requirement-021")
    public void getOpenSearchDescription() throws SAXException, IOException {
        WebResource resource = this.client.resource(this.baseUri);
        WebResource.Builder builder = resource.accept(new String[]{"application/vnd.a9.opensearchdescription+xml", "application/opensearchdescription+xml"});
        DOMSource entity = new DOMSource((Node)builder.get(Document.class));
        this.osdValidator.validate((Source)entity);
        ValidationErrorHandler err = this.osdValidator.getErrorHandler();
        Assert.assertFalse((boolean)err.errorsDetected(), (String)ErrorMessage.format("NotSchemaValid", err.getErrorCount(), err.toString()));
        URL schemaUrl = this.getClass().getResource(SCHEMATRON_OPENSEARCH_DESCR);
        ETSAssert.assertSchematronValid(schemaUrl, entity);
    }
}

