/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat30.util;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URL;

public class ClientUtils {
    public static Client buildClient() {
        DefaultClientConfig config = new DefaultClientConfig();
        config.getProperties().put("com.sun.jersey.client.property.followRedirects", true);
        Client client = Client.create((ClientConfig)config);
        client.addFilter((ClientFilter)new LoggingFilter());
        return client;
    }

    public static Client buildClientWithProxy(final String proxyHost, final int proxyPort) {
        DefaultClientConfig config = new DefaultClientConfig();
        config.getProperties().put("com.sun.jersey.client.property.followRedirects", true);
        Client client = new Client((ClientHandler)new URLConnectionClientHandler(new HttpURLConnectionFactory(){
            SocketAddress addr;
            Proxy proxy;
            {
                this.addr = new InetSocketAddress(proxyHost, proxyPort);
                this.proxy = new Proxy(Proxy.Type.HTTP, this.addr);
            }

            public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
                return (HttpURLConnection)url.openConnection(this.proxy);
            }
        }), (ClientConfig)config);
        client.addFilter((ClientFilter)new LoggingFilter());
        return client;
    }
}

