/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat30.util;

import java.net.URI;
import java.util.logging.Level;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.opengis.cite.cat30.util.NamespaceBindings;
import org.opengis.cite.cat30.util.TestSuiteLogger;
import org.w3c.dom.Document;

public class ServiceMetadataUtils {
    public static URI getOperationEndpoint(Document cswMetadata, String opName, String httpMethod) {
        String expr;
        if (null == httpMethod || httpMethod.isEmpty()) {
            expr = String.format("//ows:Operation[@name='%s']//ows:HTTP/*[1]/@xlink:href", opName);
        } else {
            StringBuilder method = new StringBuilder(httpMethod);
            method.replace(1, method.length(), method.substring(1).toLowerCase());
            expr = String.format("//ows:Operation[@name='%s']//ows:%s/@xlink:href", opName, method.toString());
        }
        NamespaceBindings nsBindings = new NamespaceBindings();
        nsBindings.addNamespaceBinding("http://www.opengis.net/ows/2.0", "ows");
        nsBindings.addNamespaceBinding("http://www.w3.org/1999/xlink", "xlink");
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(nsBindings);
        URI endpoint = null;
        try {
            String href = xpath.evaluate(expr, cswMetadata);
            endpoint = URI.create(href);
        }
        catch (XPathExpressionException ex) {
            TestSuiteLogger.log(Level.INFO, ex.getMessage());
        }
        if (null != endpoint && null != endpoint.getQuery()) {
            String uriRef = endpoint.toString();
            endpoint = URI.create(uriRef.substring(0, uriRef.indexOf(63)));
        }
        return endpoint;
    }
}

