/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.CastableExpression;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.IdentityComparison;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.ParentNodeExpression;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.PositionVariable;
import net.sf.saxon.expr.QuantifiedExpression;
import net.sf.saxon.expr.RangeExpression;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.Tokenizer;
import net.sf.saxon.expr.TreatExpression;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.VennExpression;
import net.sf.saxon.functions.CurrentGroup;
import net.sf.saxon.functions.RegexGroup;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.Choose;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.LocationMap;
import net.sf.saxon.instruct.TraceExpression;
import net.sf.saxon.om.Axis;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyChildNodePattern;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.IDPattern;
import net.sf.saxon.pattern.KeyPattern;
import net.sf.saxon.pattern.LocalNameTest;
import net.sf.saxon.pattern.LocationPathPattern;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NamespaceTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.UnionPattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class ExpressionParser {
    protected Tokenizer t;
    protected StaticContext env;
    protected Stack rangeVariables = null;
    protected NameChecker nameChecker;
    protected boolean scanOnly = false;
    protected boolean compileWithTracing = false;
    protected int language = 0;
    protected static final int XPATH = 0;
    protected static final int XSLT_PATTERN = 1;
    protected static final int SEQUENCE_TYPE = 2;
    protected static final int XQUERY = 3;
    private static final boolean SUPPRESS_EARLY_EVALUATION = false;

    public void setCompileWithTracing(boolean trueOrFalse) {
        this.compileWithTracing = trueOrFalse;
    }

    public boolean isCompileWithTracing() {
        return this.compileWithTracing;
    }

    public Tokenizer getTokenizer() {
        return this.t;
    }

    protected void nextToken() throws XPathException {
        try {
            this.t.next();
        }
        catch (XPathException err) {
            this.grumble(err.getMessage());
        }
    }

    protected void expect(int token) throws XPathException {
        if (this.t.currentToken != token) {
            this.grumble("expected \"" + Token.tokens[token] + "\", found " + this.currentTokenDisplay());
        }
    }

    protected void grumble(String message) throws XPathException {
        this.grumble(message, this.language == 1 ? "XTSE0340" : "XPST0003");
    }

    protected void grumble(String message, String errorCode) throws XPathException {
        if (errorCode == null) {
            errorCode = "XPST0003";
        }
        String s = this.t.recentText();
        int line = this.t.getLineNumber();
        int column = this.t.getColumnNumber();
        String lineInfo = line == 1 ? "" : "on line " + line + ' ';
        String columnInfo = "at char " + column + ' ';
        String prefix = this.getLanguage() + " syntax error " + columnInfo + lineInfo + (message.startsWith("...") ? "near" : "in") + ' ' + Err.wrap(s) + ":\n    ";
        XPathException err = new XPathException(prefix + message);
        err.setIsStaticError(true);
        err.setErrorCode(errorCode);
        throw err;
    }

    protected void warning(String message) throws XPathException {
        String s = this.t.recentText();
        int line = this.t.getLineNumber();
        String lineInfo = line == 1 ? "" : "on line " + line + ' ';
        String prefix = lineInfo + (message.startsWith("...") ? "near" : "in") + ' ' + Err.wrap(s) + ":\n    ";
        this.env.issueWarning(prefix + message, null);
    }

    protected String getLanguage() {
        switch (this.language) {
            case 0: {
                return "XPath";
            }
            case 1: {
                return "XSLT Pattern";
            }
            case 2: {
                return "SequenceType";
            }
            case 3: {
                return "XQuery";
            }
        }
        return "XPath";
    }

    protected String currentTokenDisplay() {
        if (this.t.currentToken == 101) {
            return "name \"" + this.t.currentTokenValue + '\"';
        }
        if (this.t.currentToken == -1) {
            return "(unknown token)";
        }
        return '\"' + Token.tokens[this.t.currentToken] + '\"';
    }

    public Expression parse(String expression, int start, int terminator, int lineNumber, StaticContext env) throws XPathException {
        this.env = env;
        this.nameChecker = env.getConfiguration().getNameChecker();
        this.t = new Tokenizer();
        try {
            this.t.tokenize(expression, start, -1, lineNumber);
        }
        catch (XPathException err) {
            this.grumble(err.getMessage());
        }
        Expression exp = this.parseExpression();
        if (this.t.currentToken != terminator) {
            if (this.t.currentToken == 0 && terminator == 115) {
                this.grumble("Missing curly brace after expression in attribute value template", "XTSE0350");
            } else {
                this.grumble("Unexpected token " + this.currentTokenDisplay() + " beyond end of expression");
            }
        }
        return exp;
    }

    public Pattern parsePattern(String pattern, StaticContext env) throws XPathException {
        this.env = env;
        this.nameChecker = env.getConfiguration().getNameChecker();
        this.language = 1;
        this.t = new Tokenizer();
        try {
            this.t.tokenize(pattern, 0, -1, env.getLineNumber());
        }
        catch (XPathException err) {
            this.grumble(err.getMessage());
        }
        Pattern pat = this.parseUnionPattern();
        if (this.t.currentToken != 0) {
            this.grumble("Unexpected token " + this.currentTokenDisplay() + " beyond end of pattern");
        }
        return pat;
    }

    public SequenceType parseSequenceType(String input, StaticContext env) throws XPathException {
        this.env = env;
        this.nameChecker = env.getConfiguration().getNameChecker();
        this.language = 2;
        this.t = new Tokenizer();
        try {
            this.t.tokenize(input, 0, -1, 1);
        }
        catch (XPathException err) {
            this.grumble(err.getMessage());
        }
        SequenceType req = this.parseSequenceType();
        if (this.t.currentToken != 0) {
            this.grumble("Unexpected token " + this.currentTokenDisplay() + " beyond end of SequenceType");
        }
        return req;
    }

    protected Expression parseExpression() throws XPathException {
        Expression exp = this.parseExprSingle();
        ArrayList<Expression> list = null;
        while (this.t.currentToken == 7) {
            if (list == null) {
                list = new ArrayList<Expression>(10);
                list.add(exp);
            }
            this.nextToken();
            Expression next = this.parseExprSingle();
            this.setLocation(next);
            list.add(next);
        }
        if (list != null) {
            exp = Block.makeBlock(list);
            this.setLocation(exp);
        }
        return exp;
    }

    protected Expression parseExprSingle() throws XPathException {
        switch (this.t.currentToken) {
            case 111: 
            case 116: {
                return this.parseForExpression();
            }
            case 31: 
            case 32: {
                return this.parseQuantifiedExpression();
            }
            case 36: {
                return this.parseIfExpression();
            }
            case 58: {
                return this.parseTypeswitchExpression();
            }
            case 81: 
            case 82: 
            case 83: {
                return this.parseValidateExpression();
            }
            case 118: {
                return this.parseExtensionExpression();
            }
        }
        return this.parseOrExpression();
    }

    protected Expression parseTypeswitchExpression() throws XPathException {
        this.grumble("typeswitch is not allowed in XPath");
        return null;
    }

    protected Expression parseValidateExpression() throws XPathException {
        this.grumble("validate{} expressions are not allowed in XPath");
        return null;
    }

    protected Expression parseExtensionExpression() throws XPathException {
        this.grumble("extension expressions (#...#) are not allowed in XPath");
        return null;
    }

    private Expression parseOrExpression() throws XPathException {
        Expression exp = this.parseAndExpression();
        while (this.t.currentToken == 9) {
            this.nextToken();
            exp = new BooleanExpression(exp, 9, this.parseAndExpression());
            this.setLocation(exp);
        }
        return exp;
    }

    private Expression parseAndExpression() throws XPathException {
        Expression exp = this.parseComparisonExpression();
        while (this.t.currentToken == 10) {
            this.nextToken();
            exp = new BooleanExpression(exp, 10, this.parseComparisonExpression());
            this.setLocation(exp);
        }
        return exp;
    }

    protected Expression parseForExpression() throws XPathException {
        if (this.t.currentToken == 116) {
            this.grumble("'let' is not supported in XPath");
        }
        return this.parseMappingExpression();
    }

    private Expression parseQuantifiedExpression() throws XPathException {
        return this.parseMappingExpression();
    }

    protected Expression parseMappingExpression() throws XPathException {
        int i;
        int offset = this.t.currentTokenStartOffset;
        int operator = this.t.currentToken;
        ArrayList<ForClause> clauseList = new ArrayList<ForClause>(3);
        do {
            Assignation v;
            ForClause clause = new ForClause();
            clause.offset = offset;
            clause.requiredType = SequenceType.SINGLE_ITEM;
            clauseList.add(clause);
            this.nextToken();
            this.expect(21);
            this.nextToken();
            this.expect(101);
            String var = this.t.currentTokenValue;
            if (operator == 111) {
                v = new ForExpression();
            } else {
                v = new QuantifiedExpression();
                ((QuantifiedExpression)v).setOperator(operator);
            }
            v.setRequiredType(SequenceType.SINGLE_ITEM);
            v.setVariableQName(this.makeStructuredQName(var, false));
            clause.rangeVariable = v;
            this.nextToken();
            if (this.isKeyword("as") && this.language == 3) {
                SequenceType type;
                this.nextToken();
                clause.requiredType = type = this.parseSequenceType();
                if (type.getCardinality() != 16384) {
                    this.warning("Occurrence indicator on singleton range variable has no effect");
                    type = SequenceType.makeSequenceType(type.getPrimaryType(), 16384);
                }
                v.setRequiredType(type);
            }
            clause.positionVariable = null;
            this.expect(30);
            this.nextToken();
            clause.sequence = this.parseExprSingle();
            this.declareRangeVariable(clause.rangeVariable);
        } while (this.t.currentToken == 7);
        if (operator == 111) {
            this.expect(25);
        } else {
            this.expect(33);
        }
        this.nextToken();
        Expression action = this.parseExprSingle();
        TypeHierarchy th = this.env.getConfiguration().getTypeHierarchy();
        for (i = clauseList.size() - 1; i >= 0; --i) {
            ForClause fc = (ForClause)clauseList.get(i);
            Assignation exp = fc.rangeVariable;
            this.setLocation(exp, offset);
            exp.setSequence(fc.sequence);
            if (fc.requiredType == SequenceType.SINGLE_ITEM) {
                SequenceType type = SequenceType.makeSequenceType(fc.sequence.getItemType(th), 16384);
                fc.rangeVariable.setRequiredType(type);
            } else {
                fc.rangeVariable.setRequiredType(fc.requiredType);
            }
            exp.setAction(action);
            action = exp;
        }
        for (i = clauseList.size() - 1; i >= 0; --i) {
            this.undeclareRangeVariable();
        }
        return action;
    }

    private Expression parseIfExpression() throws XPathException {
        int ifoffset = this.t.currentTokenStartOffset;
        this.nextToken();
        Expression condition = this.parseExpression();
        this.expect(104);
        this.nextToken();
        int thenoffset = this.t.currentTokenStartOffset;
        this.expect(26);
        this.nextToken();
        Expression thenExp = this.makeTracer(thenoffset, this.parseExpression(), 2016, null);
        int elseoffset = this.t.currentTokenStartOffset;
        this.expect(27);
        this.nextToken();
        Expression elseExp = this.makeTracer(elseoffset, this.parseExprSingle(), 2017, null);
        Expression ifExp = Choose.makeConditional(condition, thenExp, elseExp);
        this.setLocation(ifExp, ifoffset);
        return this.makeTracer(ifoffset, ifExp, 2015, null);
    }

    private Expression parseInstanceOfExpression() throws XPathException {
        Expression exp = this.parseTreatExpression();
        if (this.t.currentToken == 41) {
            this.nextToken();
            exp = new InstanceOfExpression(exp, this.parseSequenceType());
            this.setLocation(exp);
        }
        return exp;
    }

    private Expression parseTreatExpression() throws XPathException {
        Expression exp = this.parseCastableExpression();
        if (this.t.currentToken == 43) {
            this.nextToken();
            SequenceType target = this.parseSequenceType();
            exp = TreatExpression.make(exp, target);
            this.setLocation(exp);
        }
        return exp;
    }

    private Expression parseCastableExpression() throws XPathException {
        Expression exp = this.parseCastExpression();
        if (this.t.currentToken == 51) {
            boolean allowEmpty;
            this.nextToken();
            this.expect(101);
            AtomicType at = this.getAtomicType(this.t.currentTokenValue);
            if (at.getFingerprint() == 632) {
                this.grumble("No value is castable to xs:anyAtomicType", "XPST0080");
            }
            if (at.getFingerprint() == 531) {
                this.grumble("No value is castable to xs:NOTATION", "XPST0080");
            }
            this.nextToken();
            boolean bl = allowEmpty = this.t.currentToken == 113;
            if (allowEmpty) {
                this.nextToken();
            }
            if (at.isNamespaceSensitive()) {
                if (exp instanceof StringLiteral) {
                    try {
                        String source = ((StringLiteral)exp).getStringValue();
                        this.makeNameCode(source, false);
                        exp = new Literal(BooleanValue.TRUE);
                    }
                    catch (Exception e) {
                        exp = new Literal(BooleanValue.FALSE);
                    }
                } else {
                    exp = new CastableExpression(exp, at, allowEmpty);
                }
            } else {
                exp = new CastableExpression(exp, at, allowEmpty);
            }
            this.setLocation(exp);
        }
        return exp;
    }

    private Expression parseCastExpression() throws XPathException {
        Expression exp = this.parseUnaryExpression();
        if (this.t.currentToken == 42) {
            boolean allowEmpty;
            this.nextToken();
            this.expect(101);
            AtomicType at = this.getAtomicType(this.t.currentTokenValue);
            if (at.getFingerprint() == 632) {
                this.grumble("Cannot cast to xs:anyAtomicType", "XPST0080");
            }
            if (at.getFingerprint() == 531) {
                this.grumble("Cannot cast to xs:NOTATION", "XPST0080");
            }
            this.nextToken();
            boolean bl = allowEmpty = this.t.currentToken == 113;
            if (allowEmpty) {
                this.nextToken();
            }
            if (at.isNamespaceSensitive() && exp instanceof StringLiteral) {
                try {
                    String source = ((StringLiteral)exp).getStringValue();
                    return new Literal(CastExpression.castStringToQName(source, at, this.env));
                }
                catch (XPathException e) {
                    this.grumble(e.getMessage(), e.getErrorCodeLocalPart());
                }
            } else {
                exp = new CastExpression(exp, at, allowEmpty);
                exp = ExpressionVisitor.make(this.env).simplify(exp);
            }
            this.setLocation(exp);
        }
        return exp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AtomicType getAtomicType(String qname2) throws XPathException {
        if (this.scanOnly) {
            return BuiltInAtomicType.STRING;
        }
        try {
            block22: {
                String uri;
                String[] parts = this.nameChecker.getQNameParts(qname2);
                if (parts[0].length() == 0) {
                    uri = this.env.getDefaultElementNamespace();
                } else {
                    try {
                        uri = this.env.getURIForPrefix(parts[0]);
                    }
                    catch (XPathException err) {
                        this.grumble(err.getMessage(), err.getErrorCodeLocalPart());
                        uri = "";
                    }
                }
                boolean builtInNamespace = uri.equals("http://www.w3.org/2001/XMLSchema");
                if (builtInNamespace) {
                    ItemType t = Type.getBuiltInItemType(uri, parts[1]);
                    if (t == null) {
                        this.grumble("Unknown atomic type " + qname2, "XPST0051");
                    }
                    if (t instanceof BuiltInAtomicType) {
                        if (this.env.isAllowedBuiltInType((BuiltInAtomicType)t)) return (AtomicType)t;
                        this.grumble("The type " + qname2 + " is not recognized by a Basic XSLT Processor. ", "XPST0080");
                        return (AtomicType)t;
                    }
                    this.grumble("The type " + qname2 + " is not atomic", "XPST0051");
                } else {
                    if (uri.equals("http://saxon.sf.net/java-type")) {
                        Class theClass = null;
                        try {
                            String className = parts[1].replace('-', '$');
                            theClass = this.env.getConfiguration().getClass(className, false, null);
                            return new ExternalObjectType(theClass, this.env.getConfiguration());
                        }
                        catch (XPathException err) {
                            this.grumble("Unknown Java class " + parts[1]);
                        }
                        return new ExternalObjectType(theClass, this.env.getConfiguration());
                    }
                    if (uri.equals("http://saxon.sf.net/clitype")) {
                        return (AtomicType)Configuration.getPlatform().getExternalObjectType(this.env.getConfiguration(), uri, parts[1]);
                    }
                    if (this.env.isImportedSchema(uri)) {
                        SchemaType st;
                        int fp = this.env.getNamePool().getFingerprint(uri, parts[1]);
                        if (fp == -1) {
                            this.grumble("Unknown type " + qname2);
                        }
                        if ((st = this.env.getConfiguration().getSchemaType(fp)) == null) {
                            this.grumble("Unknown atomic type " + qname2);
                            break block22;
                        } else {
                            if (st.isAtomicType()) {
                                return (AtomicType)st;
                            }
                            if (st.isComplexType()) {
                                this.grumble("Type (" + qname2 + ") is a complex type");
                                return null;
                            }
                            this.grumble("Type (" + qname2 + ") is a list or union type");
                            return null;
                        }
                    }
                    if (uri.length() == 0) {
                        this.grumble("There is no imported schema for the null namespace");
                        return null;
                    }
                    this.grumble("There is no imported schema for namespace " + uri);
                    return null;
                }
            }
            this.grumble("Unknown atomic type " + qname2);
            return null;
        }
        catch (QNameException err) {
            this.grumble(err.getMessage());
        }
        return null;
    }

    private Expression parseComparisonExpression() throws XPathException {
        Expression exp = this.parseRangeExpression();
        switch (this.t.currentToken) {
            case 20: 
            case 37: 
            case 38: {
                int op = this.t.currentToken;
                this.nextToken();
                exp = new IdentityComparison(exp, op, this.parseRangeExpression());
                this.setLocation(exp);
                return exp;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: {
                int op = this.t.currentToken;
                this.nextToken();
                exp = this.env.getConfiguration().getOptimizer().makeGeneralComparison(exp, op, this.parseRangeExpression(), this.env.isInBackwardsCompatibleMode());
                this.setLocation(exp);
                return exp;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                int op = this.t.currentToken;
                this.nextToken();
                exp = new ValueComparison(exp, op, this.parseRangeExpression());
                this.setLocation(exp);
                return exp;
            }
        }
        return exp;
    }

    private Expression parseRangeExpression() throws XPathException {
        Expression exp = this.parseAdditiveExpression();
        if (this.t.currentToken == 29) {
            this.nextToken();
            exp = new RangeExpression(exp, 29, this.parseAdditiveExpression());
            this.setLocation(exp);
        }
        return exp;
    }

    protected SequenceType parseSequenceType() throws XPathException {
        int occurrenceFlag;
        ItemType primaryType;
        if (this.t.currentToken == 101) {
            primaryType = this.getAtomicType(this.t.currentTokenValue);
            this.nextToken();
        } else if (this.t.currentToken == 61) {
            if (this.t.currentTokenValue.equals("item")) {
                this.nextToken();
                this.expect(104);
                this.nextToken();
                primaryType = AnyItemType.getInstance();
            } else {
                if (this.t.currentTokenValue.equals("empty-sequence")) {
                    this.nextToken();
                    this.expect(104);
                    this.nextToken();
                    return SequenceType.makeSequenceType(EmptySequenceTest.getInstance(), 8192);
                }
                primaryType = this.parseKindTest();
            }
        } else {
            this.grumble("Expected type name in SequenceType, found " + Token.tokens[this.t.currentToken]);
            return null;
        }
        switch (this.t.currentToken) {
            case 17: 
            case 107: {
                occurrenceFlag = 57344;
                this.t.currentToken = 104;
                this.nextToken();
                break;
            }
            case 15: {
                occurrenceFlag = 49152;
                this.t.currentToken = 104;
                this.nextToken();
                break;
            }
            case 113: {
                occurrenceFlag = 24576;
                this.t.currentToken = 104;
                this.nextToken();
                break;
            }
            default: {
                occurrenceFlag = 16384;
            }
        }
        return SequenceType.makeSequenceType(primaryType, occurrenceFlag);
    }

    private Expression parseAdditiveExpression() throws XPathException {
        Expression exp = this.parseMultiplicativeExpression();
        while (this.t.currentToken == 15 || this.t.currentToken == 16) {
            int op = this.t.currentToken;
            this.nextToken();
            exp = new ArithmeticExpression(exp, op, this.parseMultiplicativeExpression());
            this.setLocation(exp);
        }
        return exp;
    }

    private Expression parseMultiplicativeExpression() throws XPathException {
        Expression exp = this.parseUnionExpression();
        while (this.t.currentToken == 17 || this.t.currentToken == 18 || this.t.currentToken == 50 || this.t.currentToken == 19) {
            int op = this.t.currentToken;
            this.nextToken();
            exp = new ArithmeticExpression(exp, op, this.parseUnionExpression());
            this.setLocation(exp);
        }
        return exp;
    }

    private Expression parseUnaryExpression() throws XPathException {
        Expression exp;
        switch (this.t.currentToken) {
            case 16: {
                this.nextToken();
                exp = new ArithmeticExpression(new Literal(Int64Value.ZERO), 199, this.parseUnaryExpression());
                break;
            }
            case 15: {
                this.nextToken();
                exp = new ArithmeticExpression(new Literal(Int64Value.ZERO), 15, this.parseUnaryExpression());
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                exp = this.parseValidateExpression();
                break;
            }
            case 118: {
                exp = this.parseExtensionExpression();
                break;
            }
            default: {
                exp = this.parsePathExpression();
            }
        }
        this.setLocation(exp);
        return exp;
    }

    private Expression parseUnionExpression() throws XPathException {
        Expression exp = this.parseIntersectExpression();
        while (this.t.currentToken == 1) {
            this.nextToken();
            exp = new VennExpression(exp, 1, this.parseIntersectExpression());
            this.setLocation(exp);
        }
        return exp;
    }

    private Expression parseIntersectExpression() throws XPathException {
        Expression exp = this.parseInstanceOfExpression();
        while (this.t.currentToken == 23 || this.t.currentToken == 24) {
            int op = this.t.currentToken;
            this.nextToken();
            exp = new VennExpression(exp, op, this.parseInstanceOfExpression());
            this.setLocation(exp);
        }
        return exp;
    }

    private boolean atStartOfRelativePath() {
        switch (this.t.currentToken) {
            case 3: 
            case 5: 
            case 34: 
            case 35: 
            case 61: 
            case 62: 
            case 101: 
            case 102: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                return true;
            }
        }
        return false;
    }

    private Expression parsePathExpression() throws XPathException {
        switch (this.t.currentToken) {
            case 2: {
                this.nextToken();
                RootExpression start = new RootExpression();
                this.setLocation(start);
                if (this.atStartOfRelativePath()) {
                    Expression path = this.parseRemainingPath(start);
                    this.setLocation(path);
                    return path;
                }
                return start;
            }
            case 8: {
                this.nextToken();
                RootExpression start2 = new RootExpression();
                this.setLocation(start2);
                AxisExpression axisExp = new AxisExpression(5, null);
                this.setLocation(axisExp);
                Expression exp = this.parseRemainingPath(new PathExpression(start2, axisExp));
                this.setLocation(exp);
                return exp;
            }
        }
        return this.parseRelativePath();
    }

    protected Expression parseRelativePath() throws XPathException {
        Expression exp = this.parseStepExpression();
        while (this.t.currentToken == 2 || this.t.currentToken == 8) {
            int op = this.t.currentToken;
            this.nextToken();
            Expression next = this.parseStepExpression();
            exp = op == 2 ? new PathExpression(exp, next) : new PathExpression(exp, new PathExpression(new AxisExpression(5, null), next));
            this.setLocation(exp);
        }
        return exp;
    }

    protected Expression parseRemainingPath(Expression start) throws XPathException {
        Expression exp = start;
        int op = 2;
        while (true) {
            Expression next = this.parseStepExpression();
            exp = op == 2 ? new PathExpression(exp, next) : new PathExpression(exp, new PathExpression(new AxisExpression(5, null), next));
            this.setLocation(exp);
            op = this.t.currentToken;
            if (op != 2 && op != 8) break;
            this.nextToken();
        }
        return exp;
    }

    protected Expression parseStepExpression() throws XPathException {
        boolean reverse;
        Expression step = this.parseBasicStep();
        boolean bl = reverse = step instanceof AxisExpression && Axis.isReverse[((AxisExpression)step).getAxis()] && ((AxisExpression)step).getAxis() != 12;
        while (this.t.currentToken == 4) {
            this.nextToken();
            Expression predicate = this.parseExpression();
            this.expect(103);
            this.nextToken();
            step = new FilterExpression(step, predicate);
            this.setLocation(step);
        }
        if (reverse) {
            return SystemFunction.makeSystemFunction("reverse", new Expression[]{step});
        }
        return step;
    }

    private Expression parseBasicStep() throws XPathException {
        switch (this.t.currentToken) {
            case 21: {
                VariableReference ref;
                this.nextToken();
                this.expect(101);
                String var = this.t.currentTokenValue;
                this.nextToken();
                if (this.scanOnly) {
                    return new ContextItemExpression();
                }
                StructuredQName vtest = this.makeStructuredQName(var, false);
                Binding b = this.findRangeVariable(vtest);
                if (b != null) {
                    ref = new LocalVariableReference(b);
                } else {
                    try {
                        ref = this.env.bindVariable(vtest);
                    }
                    catch (XPathException err) {
                        if ("XPST0008".equals(err.getErrorCodeLocalPart())) {
                            this.grumble("Variable $" + var + " has not been declared", "XPST0008");
                            ref = null;
                        }
                        throw err;
                    }
                }
                this.setLocation(ref);
                return ref;
            }
            case 5: {
                this.nextToken();
                if (this.t.currentToken == 104) {
                    this.nextToken();
                    return new Literal(EmptySequence.getInstance());
                }
                Expression seq = this.parseExpression();
                this.expect(104);
                this.nextToken();
                return seq;
            }
            case 102: {
                Literal literal = this.makeStringLiteral(this.t.currentTokenValue);
                this.nextToken();
                return literal;
            }
            case 109: {
                NumericValue number = NumericValue.parseNumber(this.t.currentTokenValue);
                if (number.isNaN()) {
                    this.grumble("Invalid numeric literal " + Err.wrap(this.t.currentTokenValue, 4));
                }
                this.nextToken();
                return new Literal(number);
            }
            case 34: {
                return this.parseFunctionCall();
            }
            case 105: {
                this.nextToken();
                ContextItemExpression cie = new ContextItemExpression();
                this.setLocation(cie);
                return cie;
            }
            case 106: {
                this.nextToken();
                ParentNodeExpression pne = new ParentNodeExpression();
                this.setLocation(pne);
                return pne;
            }
            case 61: 
            case 62: 
            case 101: 
            case 107: 
            case 108: {
                int defaultAxis = 3;
                if (this.t.currentToken == 61 && (this.t.currentTokenValue.equals("attribute") || this.t.currentTokenValue.equals("schema-attribute"))) {
                    defaultAxis = 2;
                }
                AxisExpression ae = new AxisExpression((byte)defaultAxis, this.parseNodeTest((short)1));
                this.setLocation(ae);
                return ae;
            }
            case 3: {
                this.nextToken();
                switch (this.t.currentToken) {
                    case 61: 
                    case 62: 
                    case 101: 
                    case 107: 
                    case 108: {
                        AxisExpression ae2 = new AxisExpression(2, this.parseNodeTest((short)2));
                        this.setLocation(ae2);
                        return ae2;
                    }
                }
                this.grumble("@ must be followed by a NodeTest");
                break;
            }
            case 35: {
                byte axis;
                try {
                    axis = Axis.getAxisNumber(this.t.currentTokenValue);
                }
                catch (XPathException err) {
                    this.grumble(err.getMessage());
                    axis = 3;
                }
                if (axis == 8 && this.language == 3) {
                    this.grumble("The namespace axis is not available in XQuery");
                }
                short principalNodeType = Axis.principalNodeType[axis];
                this.nextToken();
                switch (this.t.currentToken) {
                    case 61: 
                    case 62: 
                    case 101: 
                    case 107: 
                    case 108: {
                        AxisExpression ax = new AxisExpression(axis, this.parseNodeTest(principalNodeType));
                        this.setLocation(ax);
                        return ax;
                    }
                }
                this.grumble("Unexpected token " + this.currentTokenDisplay() + " after axis name");
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 117: {
                return this.parseConstructor();
            }
            default: {
                this.grumble("Unexpected token " + this.currentTokenDisplay() + " in path expression");
            }
        }
        return null;
    }

    protected Literal makeStringLiteral(String currentTokenValue) throws XPathException {
        return new StringLiteral(currentTokenValue);
    }

    protected Expression parseConstructor() throws XPathException {
        this.grumble("Node constructor expressions are allowed only in XQuery, not in XPath");
        return null;
    }

    protected NodeTest parseNodeTest(short nodeType) throws XPathException {
        int tok = this.t.currentToken;
        String tokv = this.t.currentTokenValue;
        switch (tok) {
            case 101: {
                this.nextToken();
                return this.makeNameTest(nodeType, tokv, nodeType == 1);
            }
            case 108: {
                this.nextToken();
                return this.makeNamespaceTest(nodeType, tokv);
            }
            case 62: {
                this.nextToken();
                tokv = this.t.currentTokenValue;
                this.expect(101);
                this.nextToken();
                return this.makeLocalNameTest(nodeType, tokv);
            }
            case 107: {
                this.nextToken();
                return NodeKindTest.makeNodeKindTest(nodeType);
            }
            case 61: {
                return this.parseKindTest();
            }
        }
        this.grumble("Unrecognized node test");
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private NodeTest parseKindTest() throws XPathException {
        typeName = this.t.currentTokenValue;
        schemaDeclaration = typeName.startsWith("schema-");
        primaryType = this.getSystemType(typeName);
        nameCode = -1;
        empty = false;
        this.nextToken();
        if (this.t.currentToken == 104) {
            if (schemaDeclaration) {
                this.grumble("schema-element() and schema-attribute() require a name to be supplied");
                return null;
            }
            empty = true;
            this.nextToken();
        }
        switch (primaryType) {
            case 88: {
                this.grumble("item() is not allowed in a path expression");
                return null;
            }
            case 0: {
                if (empty) {
                    return AnyNodeTest.getInstance();
                }
                this.grumble("No arguments are allowed in node()");
                return null;
            }
            case 3: {
                if (empty) {
                    return NodeKindTest.TEXT;
                }
                this.grumble("No arguments are allowed in text()");
                return null;
            }
            case 8: {
                if (empty) {
                    return NodeKindTest.COMMENT;
                }
                this.grumble("No arguments are allowed in comment()");
                return null;
            }
            case 13: {
                this.grumble("No node test is defined for namespace nodes");
                return null;
            }
            case 9: {
                if (empty) {
                    return NodeKindTest.DOCUMENT;
                }
                try {
                    innerType = this.getSystemType(this.t.currentTokenValue);
                }
                catch (XPathException err) {
                    innerType = 88;
                }
                if (innerType != 1) {
                    this.grumble("Argument to document-node() must be an element type descriptor");
                    return null;
                }
                inner = this.parseKindTest();
                this.expect(104);
                this.nextToken();
                return new DocumentNodeTest(inner);
            }
            case 7: {
                if (empty) {
                    return NodeKindTest.PROCESSING_INSTRUCTION;
                }
                if (this.t.currentToken != 102) ** GOTO lbl66
                try {
                    parts = this.nameChecker.getQNameParts(this.t.currentTokenValue);
                    if (parts[0].length() != 0) ** GOTO lbl59
                    nameCode = this.makeNameCode(parts[1], false);
                    ** GOTO lbl78
lbl59:
                    // 1 sources

                    this.warning("No processing instruction name will ever contain a colon");
                    nameCode = this.env.getNamePool().allocate("prefix", "http://saxon.sf.net/ nonexistent namespace", "___invalid-name");
                }
                catch (QNameException e) {
                    this.warning("No processing instruction will ever be named '" + this.t.currentTokenValue + "'. " + e.getMessage());
                    nameCode = this.env.getNamePool().allocate("prefix", "http://saxon.sf.net/ nonexistent namespace", "___invalid-name");
                }
                ** GOTO lbl78
lbl66:
                // 1 sources

                if (this.t.currentToken != 101) ** GOTO lbl77
                try {
                    parts = this.nameChecker.getQNameParts(this.t.currentTokenValue);
                    if (parts[0].length() != 0) ** GOTO lbl72
                    nameCode = this.makeNameCode(parts[1], false);
                    ** GOTO lbl78
lbl72:
                    // 1 sources

                    this.grumble("Processing instruction name must not contain a colon");
                }
                catch (QNameException e) {
                    this.grumble("Invalid processing instruction name. " + e.getMessage());
                }
                ** GOTO lbl78
lbl77:
                // 1 sources

                this.grumble("Processing instruction name must be a QName or a string literal");
lbl78:
                // 7 sources

                this.nextToken();
                this.expect(104);
                this.nextToken();
                return new NameTest(7, nameCode, this.env.getNamePool());
            }
            case 1: 
            case 2: {
                nodeName = "";
                if (empty) {
                    return NodeKindTest.makeNodeKindTest(primaryType);
                }
                if (this.t.currentToken == 107 || this.t.currentToken == 17) {
                    if (schemaDeclaration) {
                        this.grumble("schema-element() and schema-attribute() must specify an actual name, not '*'");
                        return null;
                    }
                    nameCode = -1;
                } else if (this.t.currentToken == 101) {
                    nodeName = this.t.currentTokenValue;
                    nameCode = this.makeNameCode(this.t.currentTokenValue, primaryType == 1);
                } else {
                    this.grumble("Unexpected " + Token.tokens[this.t.currentToken] + " after '(' in SequenceType");
                }
                suri = null;
                if (nameCode != -1) {
                    suri = this.env.getNamePool().getURI(nameCode);
                }
                this.nextToken();
                if (this.t.currentToken != 104) ** GOTO lbl142
                this.nextToken();
                if (nameCode == -1) {
                    return NodeKindTest.makeNodeKindTest(primaryType);
                }
                nameTest /* !! */  = null;
                schemaType = null;
                nillable = false;
                if (primaryType != 2) ** GOTO lbl121
                if (schemaDeclaration) {
                    attributeDecl = this.env.getConfiguration().getAttributeDeclaration(nameCode & 1048575);
                    if (!this.env.isImportedSchema(suri)) {
                        this.grumble("No schema has been imported for namespace '" + suri + '\'', "XPST0008");
                    }
                    if (attributeDecl == null) {
                        this.grumble("There is no declaration for attribute @" + nodeName + " in an imported schema", "XPST0008");
                    } else {
                        schemaType = attributeDecl.getType();
                        nameTest /* !! */  = new NameTest(2, nameCode, this.env.getNamePool());
                    }
                } else {
                    nameTest /* !! */  = new NameTest(2, nameCode, this.env.getNamePool());
                    return nameTest /* !! */ ;
lbl121:
                    // 1 sources

                    if (schemaDeclaration) {
                        if (!this.env.isImportedSchema(suri)) {
                            this.grumble("No schema has been imported for namespace '" + suri + '\'', "XPST0008");
                        }
                        if ((elementDecl = this.env.getConfiguration().getElementDeclaration(nameCode & 1048575)) == null) {
                            this.grumble("There is no declaration for element <" + nodeName + "> in an imported schema", "XPST0008");
                        } else {
                            schemaType = elementDecl.getType();
                            nameTest /* !! */  = elementDecl.makeSchemaNodeTest();
                            nillable = elementDecl.isNillable();
                        }
                    } else {
                        nameTest /* !! */  = new NameTest(1, nameCode, this.env.getNamePool());
                        return nameTest /* !! */ ;
                    }
                }
                contentTest = null;
                if (schemaType != null) {
                    contentTest = new ContentTypeTest(primaryType, schemaType, this.env.getConfiguration());
                    contentTest.setNillable(nillable);
                }
                if (contentTest == null) {
                    return nameTest /* !! */ ;
                }
                combo = new CombinedNodeTest(nameTest /* !! */ , 23, contentTest);
                combo.setGlobalComponentTest(schemaDeclaration);
                return combo;
lbl142:
                // 1 sources

                if (this.t.currentToken == 7) {
                    if (schemaDeclaration) {
                        this.grumble("schema-element() and schema-attribute() must have one argument only");
                        return null;
                    }
                    this.nextToken();
                    if (this.t.currentToken == 107) {
                        this.grumble("'*' is no longer permitted as the second argument of element() and attribute()");
                        return null;
                    }
                    if (this.t.currentToken == 101) {
                        contentType = this.makeNameCode(this.t.currentTokenValue, true) & 1048575;
                        uri = this.env.getNamePool().getURI(contentType);
                        lname = this.env.getNamePool().getLocalName(contentType);
                        if (uri.equals("http://www.w3.org/2001/XMLSchema")) {
                            schemaType = this.env.getConfiguration().getSchemaType(contentType);
                        } else {
                            if (!this.env.isImportedSchema(uri)) {
                                this.grumble("No schema has been imported for namespace '" + uri + '\'', "XPST0008");
                            }
                            schemaType = this.env.getConfiguration().getSchemaType(contentType);
                        }
                        if (schemaType == null) {
                            this.grumble("Unknown type name " + lname, "XPST0008");
                        }
                        if (primaryType == 2 && schemaType.isComplexType()) {
                            this.warning("An attribute cannot have a complex type");
                        }
                        typeTest = new ContentTypeTest(primaryType, schemaType, this.env.getConfiguration());
                        if (nameCode == -1) {
                            result /* !! */  = typeTest;
                            if (primaryType == 2) {
                                this.nextToken();
                            } else {
                                this.nextToken();
                                if (this.t.currentToken == 113) {
                                    typeTest.setNillable(true);
                                    this.nextToken();
                                }
                            }
                        } else if (primaryType == 2) {
                            nameTest = new NameTest(2, nameCode, this.env.getNamePool());
                            result /* !! */  = new CombinedNodeTest(nameTest, 23, typeTest);
                            this.nextToken();
                        } else {
                            nameTest = new NameTest(1, nameCode, this.env.getNamePool());
                            result /* !! */  = new CombinedNodeTest(nameTest, 23, typeTest);
                            this.nextToken();
                            if (this.t.currentToken == 113) {
                                typeTest.setNillable(true);
                                this.nextToken();
                            }
                        }
                    } else {
                        this.grumble("Unexpected " + Token.tokens[this.t.currentToken] + " after ',' in SequenceType");
                        return null;
                    }
                    this.expect(104);
                    this.nextToken();
                    return result /* !! */ ;
                }
                this.grumble("Expected ')' or ',' in SequenceType");
                return null;
            }
        }
        this.grumble("Unknown node kind");
        return null;
    }

    private int getSystemType(String name) throws XPathException {
        if ("item".equals(name)) {
            return 88;
        }
        if ("document-node".equals(name)) {
            return 9;
        }
        if ("element".equals(name)) {
            return 1;
        }
        if ("schema-element".equals(name)) {
            return 1;
        }
        if ("attribute".equals(name)) {
            return 2;
        }
        if ("schema-attribute".equals(name)) {
            return 2;
        }
        if ("text".equals(name)) {
            return 3;
        }
        if ("comment".equals(name)) {
            return 8;
        }
        if ("processing-instruction".equals(name)) {
            return 7;
        }
        if ("namespace".equals(name)) {
            return 13;
        }
        if ("node".equals(name)) {
            return 0;
        }
        this.grumble("Unknown type " + name);
        return -1;
    }

    protected Expression parseFunctionCall() throws XPathException {
        Expression fcall;
        ItemType t;
        String uri;
        String[] parts;
        String fname = this.t.currentTokenValue;
        int offset = this.t.currentTokenStartOffset;
        ArrayList<Expression> args = new ArrayList<Expression>(10);
        this.nextToken();
        if (this.t.currentToken != 104) {
            Expression arg = this.parseExprSingle();
            args.add(arg);
            while (this.t.currentToken == 7) {
                this.nextToken();
                arg = this.parseExprSingle();
                args.add(arg);
            }
            this.expect(104);
        }
        this.nextToken();
        if (this.scanOnly) {
            return new StringLiteral(StringValue.EMPTY_STRING);
        }
        Expression[] arguments = new Expression[args.size()];
        args.toArray(arguments);
        try {
            parts = this.nameChecker.getQNameParts(fname);
        }
        catch (QNameException e) {
            this.grumble("Unknown prefix in function name " + fname + "()");
            return null;
        }
        if (parts[0].length() == 0) {
            uri = this.env.getDefaultFunctionNamespace();
        } else {
            try {
                uri = this.env.getURIForPrefix(parts[0]);
            }
            catch (XPathException err) {
                this.grumble(err.getMessage());
                return null;
            }
        }
        StructuredQName functionName = new StructuredQName(parts[0], uri, parts[1]);
        if (uri.equals("http://www.w3.org/2001/XMLSchema") && (t = Type.getBuiltInItemType(uri, parts[1])) instanceof BuiltInAtomicType && !this.env.isAllowedBuiltInType((BuiltInAtomicType)t)) {
            this.grumble("The type " + fname + " is not recognized by a Basic XSLT Processor. ", "XPST0080");
        }
        try {
            fcall = this.env.getFunctionLibrary().bind(functionName, arguments, this.env);
        }
        catch (XPathException err) {
            if (err.getErrorCodeLocalPart() == null) {
                err.setErrorCode("XPST0017");
                err.setIsStaticError(true);
            }
            this.grumble(err.getMessage(), err.getErrorCodeLocalPart());
            return null;
        }
        if (fcall == null) {
            String msg = "Cannot find a matching " + arguments.length + "-argument function named " + functionName.getClarkName() + "()";
            if (!this.env.getConfiguration().isAllowExternalFunctions()) {
                msg = msg + ". Note: external function calls have been disabled";
            }
            if (this.env.isInBackwardsCompatibleMode()) {
                XPathException err = new XPathException(msg);
                ErrorExpression exp = new ErrorExpression(err);
                this.setLocation(exp);
                return exp;
            }
            this.grumble(msg, "XPST0017");
        }
        if (fcall instanceof CastExpression && ((AtomicType)fcall.getItemType(this.env.getConfiguration().getTypeHierarchy())).isNamespaceSensitive() && arguments[0] instanceof StringLiteral) {
            try {
                AtomicValue av = CastExpression.castStringToQName(((StringLiteral)arguments[0]).getStringValue(), (AtomicType)fcall.getItemType(this.env.getConfiguration().getTypeHierarchy()), this.env);
                return new Literal(av);
            }
            catch (XPathException e) {
                this.grumble(e.getMessage(), e.getErrorCodeLocalPart());
            }
        }
        if (this.language == 1) {
            if (fcall instanceof RegexGroup) {
                return new Literal(EmptySequence.getInstance());
            }
            if (fcall instanceof CurrentGroup) {
                String errorCode = "XTSE1060";
                String function = ((CurrentGroup)fcall).getDisplayName();
                if (function.equals("current-grouping-key")) {
                    errorCode = "XTSE1070";
                }
                this.grumble("The " + Err.wrap(function, 3) + " function cannot be used in a pattern", errorCode);
            }
        }
        this.setLocation(fcall, offset);
        for (int a = 0; a < arguments.length; ++a) {
            fcall.adoptChildExpression(arguments[a]);
        }
        return this.makeTracer(offset, fcall, 2009, functionName);
    }

    protected void declareRangeVariable(Binding declaration) throws XPathException {
        if (this.rangeVariables == null) {
            this.rangeVariables = new Stack();
        }
        this.rangeVariables.push(declaration);
    }

    protected void undeclareRangeVariable() {
        this.rangeVariables.pop();
    }

    private Binding findRangeVariable(StructuredQName qName) {
        if (this.rangeVariables == null) {
            return null;
        }
        for (int v = this.rangeVariables.size() - 1; v >= 0; --v) {
            Binding b = (Binding)this.rangeVariables.elementAt(v);
            if (!b.getVariableQName().equals(qName)) continue;
            return b;
        }
        return null;
    }

    public Stack getRangeVariableStack() {
        return this.rangeVariables;
    }

    public void setRangeVariableStack(Stack stack) {
        this.rangeVariables = stack;
    }

    private Pattern parseUnionPattern() throws XPathException {
        Pattern exp1 = this.parsePathPattern();
        while (this.t.currentToken == 1) {
            if (this.t.currentTokenValue.equals("union")) {
                this.grumble("Union operator in a pattern must be written as '|'");
            }
            this.nextToken();
            Pattern exp2 = this.parsePathPattern();
            exp1 = new UnionPattern(exp1, exp2);
        }
        return exp1;
    }

    private Pattern parsePathPattern() throws XPathException {
        Pattern pat;
        Pattern prev = null;
        int connector = -1;
        boolean rootonly = false;
        switch (this.t.currentToken) {
            case 2: {
                connector = this.t.currentToken;
                this.nextToken();
                prev = new NodeTestPattern(NodeKindTest.makeNodeKindTest(9));
                rootonly = true;
                break;
            }
            case 8: {
                connector = this.t.currentToken;
                this.nextToken();
                prev = new NodeTestPattern(NodeKindTest.makeNodeKindTest(9));
                rootonly = false;
                break;
            }
        }
        while (true) {
            pat = null;
            switch (this.t.currentToken) {
                case 35: {
                    if ("child".equals(this.t.currentTokenValue)) {
                        this.nextToken();
                        pat = this.parsePatternStep((short)1);
                        break;
                    }
                    if ("attribute".equals(this.t.currentTokenValue)) {
                        this.nextToken();
                        pat = this.parsePatternStep((short)2);
                        break;
                    }
                    this.grumble("Axis in pattern must be child or attribute");
                    break;
                }
                case 62: 
                case 101: 
                case 107: 
                case 108: {
                    pat = this.parsePatternStep((short)1);
                    break;
                }
                case 61: {
                    pat = this.parsePatternStep(this.t.currentTokenValue.equals("attribute") || this.t.currentTokenValue.equals("schema-attribute") ? (short)2 : 1);
                    break;
                }
                case 3: {
                    this.nextToken();
                    pat = this.parsePatternStep((short)2);
                    break;
                }
                case 34: {
                    if (prev != null) {
                        this.grumble("Function call may appear only at the start of a pattern");
                    }
                    if ("id".equals(this.t.currentTokenValue)) {
                        this.nextToken();
                        Expression idValue = null;
                        if (this.t.currentToken == 102) {
                            idValue = new StringLiteral(this.t.currentTokenValue);
                        } else if (this.t.currentToken == 21) {
                            this.nextToken();
                            this.expect(101);
                            StructuredQName varName = this.makeStructuredQName(this.t.currentTokenValue, false);
                            idValue = this.env.bindVariable(varName);
                        } else {
                            this.grumble("id value in pattern must be either a literal or a variable reference");
                        }
                        pat = new IDPattern(idValue);
                        this.nextToken();
                        this.expect(104);
                        this.nextToken();
                        break;
                    }
                    if ("key".equals(this.t.currentTokenValue)) {
                        this.nextToken();
                        this.expect(102);
                        String keyname = this.t.currentTokenValue;
                        this.nextToken();
                        this.expect(7);
                        this.nextToken();
                        Expression idValue = null;
                        if (this.t.currentToken == 102) {
                            idValue = new StringLiteral(this.t.currentTokenValue);
                        } else if (this.t.currentToken == 21) {
                            this.nextToken();
                            this.expect(101);
                            StructuredQName varName = this.makeStructuredQName(this.t.currentTokenValue, false);
                            idValue = this.env.bindVariable(varName);
                        } else {
                            this.grumble("key value must be either a literal or a variable reference");
                        }
                        pat = new KeyPattern(this.makeStructuredQName(keyname, false), idValue);
                        this.nextToken();
                        this.expect(104);
                        this.nextToken();
                        break;
                    }
                    this.grumble("The only functions allowed in a pattern are id() and key()");
                    break;
                }
                default: {
                    if (rootonly) {
                        return prev;
                    }
                    this.grumble("Unexpected token in pattern, found " + this.currentTokenDisplay());
                }
            }
            if (prev != null) {
                if (connector == 2) {
                    ((LocationPathPattern)pat).parentPattern = prev;
                } else {
                    ((LocationPathPattern)pat).ancestorPattern = prev;
                }
            }
            connector = this.t.currentToken;
            rootonly = false;
            if (connector != 2 && connector != 8) break;
            prev = pat;
            this.nextToken();
        }
        return pat;
    }

    private Pattern parsePatternStep(short principalNodeType) throws XPathException {
        LocationPathPattern step = new LocationPathPattern();
        NodeTest test = this.parseNodeTest(principalNodeType);
        if (test instanceof AnyNodeTest) {
            test = principalNodeType == 1 ? AnyChildNodePattern.getInstance() : NodeKindTest.makeNodeKindTest(principalNodeType);
        }
        int kind = test.getPrimitiveType();
        if (principalNodeType == 1 && (kind == 2 || kind == 13)) {
            test = EmptySequenceTest.getInstance();
        } else if (principalNodeType == 2 && (kind == 8 || kind == 3 || kind == 7 || kind == 1 || kind == 9)) {
            test = EmptySequenceTest.getInstance();
        }
        step.nodeTest = test;
        this.parseFilters(step);
        return step;
    }

    private void parseFilters(LocationPathPattern path) throws XPathException {
        while (this.t.currentToken == 4) {
            this.nextToken();
            Expression qual = this.parseExpression();
            this.expect(103);
            this.nextToken();
            path.addFilter(qual);
        }
    }

    public final int makeNameCode(String qname2, boolean useDefault) throws XPathException {
        if (this.scanOnly) {
            return 386;
        }
        try {
            String[] parts = this.nameChecker.getQNameParts(qname2);
            String prefix = parts[0];
            if (prefix.length() == 0) {
                if (useDefault) {
                    String uri = this.env.getDefaultElementNamespace();
                    return this.env.getNamePool().allocate("", uri, qname2);
                }
                return this.env.getNamePool().allocate("", "", qname2);
            }
            try {
                String uri = this.env.getURIForPrefix(prefix);
                return this.env.getNamePool().allocate(prefix, uri, parts[1]);
            }
            catch (XPathException err) {
                this.grumble(err.getMessage(), err.getErrorCodeLocalPart());
                return -1;
            }
        }
        catch (QNameException e) {
            this.grumble(e.getMessage());
            return -1;
        }
    }

    public final int makeNameCodeSilently(String qname2, boolean useDefault) throws XPathException, QNameException {
        if (this.scanOnly) {
            return 386;
        }
        String[] parts = this.nameChecker.getQNameParts(qname2);
        String prefix = parts[0];
        if (prefix.length() == 0) {
            if (useDefault) {
                String uri = this.env.getDefaultElementNamespace();
                return this.env.getNamePool().allocate("", uri, qname2);
            }
            return this.env.getNamePool().allocate("", "", qname2);
        }
        String uri = this.env.getURIForPrefix(prefix);
        return this.env.getNamePool().allocate(prefix, uri, parts[1]);
    }

    public final StructuredQName makeStructuredQName(String qname2, boolean useDefault) throws XPathException {
        if (this.scanOnly) {
            return null;
        }
        try {
            String[] parts = this.nameChecker.getQNameParts(qname2);
            String prefix = parts[0];
            if (prefix.length() == 0) {
                if (useDefault) {
                    String uri = this.env.getDefaultElementNamespace();
                    return new StructuredQName("", uri, qname2);
                }
                return new StructuredQName("", "", qname2);
            }
            try {
                String uri = this.env.getURIForPrefix(prefix);
                return new StructuredQName(prefix, uri, parts[1]);
            }
            catch (XPathException err) {
                this.grumble(err.getMessage(), err.getErrorCodeLocalPart());
                return null;
            }
        }
        catch (QNameException e) {
            this.grumble(e.getMessage());
            return null;
        }
    }

    public NameTest makeNameTest(short nodeType, String qname2, boolean useDefault) throws XPathException {
        int nameCode = this.makeNameCode(qname2, useDefault);
        return new NameTest(nodeType, nameCode, this.env.getNamePool());
    }

    public NamespaceTest makeNamespaceTest(short nodeType, String prefix) throws XPathException {
        if (this.scanOnly) {
            return new NamespaceTest(this.env.getNamePool(), nodeType, "http://saxon.sf.net/");
        }
        try {
            return new NamespaceTest(this.env.getNamePool(), nodeType, this.env.getURIForPrefix(prefix));
        }
        catch (XPathException e) {
            this.grumble(e.getMessage(), "XPST0081");
            return null;
        }
    }

    public LocalNameTest makeLocalNameTest(short nodeType, String localName) throws XPathException {
        if (!this.nameChecker.isValidNCName(localName)) {
            this.grumble("Local name [" + localName + "] contains invalid characters");
        }
        return new LocalNameTest(this.env.getNamePool(), nodeType, localName);
    }

    protected void setLocation(Expression exp) {
        this.setLocation(exp, this.t.currentTokenStartOffset);
    }

    protected void setLocation(Expression exp, int offset) {
        int line = this.t.getLineNumber(offset);
        if (exp.getLocationId() == -1) {
            int loc = this.env.getLocationMap().allocateLocationId(this.env.getSystemId(), line);
            exp.setLocationId(loc);
            if (exp.getContainer() == null) {
                TemporaryContainer container = new TemporaryContainer(this.env.getLocationMap(), loc);
                exp.setContainer(container);
            }
        }
    }

    protected Expression makeTracer(int startOffset, Expression exp, int construct, StructuredQName qName) {
        if (this.isCompileWithTracing()) {
            TraceExpression trace = new TraceExpression(exp);
            long lc = this.t.getLineAndColumn(startOffset);
            trace.setLineNumber((int)(lc >> 32));
            trace.setColumnNumber((int)(lc & Integer.MAX_VALUE));
            trace.setSystemId(this.env.getSystemId());
            trace.setNamespaceResolver(this.env.getNamespaceResolver());
            trace.setConstructType(construct);
            trace.setObjectName(qName);
            return trace;
        }
        return exp;
    }

    protected boolean isKeyword(String s) {
        return this.t.currentToken == 101 && this.t.currentTokenValue.equals(s);
    }

    public void setScanOnly(boolean scanOnly) {
        this.scanOnly = scanOnly;
    }

    protected static class TemporaryContainer
    implements Container,
    LocationProvider,
    Serializable {
        private LocationMap map;
        private int locationId;

        public TemporaryContainer(LocationMap map, int locationId) {
            this.map = map;
            this.locationId = locationId;
        }

        public Executable getExecutable() {
            return null;
        }

        public LocationProvider getLocationProvider() {
            return this.map;
        }

        public String getPublicId() {
            return null;
        }

        public String getSystemId() {
            return this.map.getSystemId(this.locationId);
        }

        public int getLineNumber() {
            return this.map.getLineNumber(this.locationId);
        }

        public int getColumnNumber() {
            return -1;
        }

        public String getSystemId(long locationId) {
            return this.getSystemId();
        }

        public int getLineNumber(long locationId) {
            return this.getLineNumber();
        }

        public int getHostLanguage() {
            return 54;
        }

        public boolean replaceSubExpression(Expression original, Expression replacement) {
            throw new IllegalArgumentException("Invalid replacement");
        }
    }

    public static class ForClause {
        public Assignation rangeVariable;
        public PositionVariable positionVariable;
        public Expression sequence;
        public SequenceType requiredType;
        public int offset;
    }
}

