/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.charcode.UTF16;
import net.sf.saxon.charcode.XMLCharacterData;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.regex.RegexData;
import net.sf.saxon.regex.RegexSyntaxException;
import net.sf.saxon.regex.RegexTranslator;
import net.sf.saxon.regex.SurrogateRegexTranslator;
import net.sf.saxon.sort.IntRangeSet;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class JDK14RegexTranslator
extends SurrogateRegexTranslator {
    private static final SurrogateRegexTranslator.CharClass[] specialBlockCharClasses = new SurrogateRegexTranslator.CharClass[]{new SurrogateRegexTranslator.CharRange(66304, 66351), new SurrogateRegexTranslator.CharRange(66352, 66383), new SurrogateRegexTranslator.CharRange(66560, 66639), new SurrogateRegexTranslator.CharRange(118784, 119039), new SurrogateRegexTranslator.CharRange(119040, 119295), new SurrogateRegexTranslator.CharRange(119808, 120831), new SurrogateRegexTranslator.CharRange(131072, 173782), new SurrogateRegexTranslator.CharRange(194560, 195103), new SurrogateRegexTranslator.CharRange(917504, 917631), new Union(new SurrogateRegexTranslator.CharClass[]{new SurrogateRegexTranslator.CharRange(57344, 63743), new SurrogateRegexTranslator.CharRange(983040, 1048573), new SurrogateRegexTranslator.CharRange(0x100000, 1114109)}), SurrogateRegexTranslator.Empty.getInstance(), SurrogateRegexTranslator.Empty.getInstance(), SurrogateRegexTranslator.Empty.getInstance()};
    private static final SurrogateRegexTranslator.CharClass DOT_SCHEMA = new SurrogateRegexTranslator.Complement(new Union(new SurrogateRegexTranslator.CharClass[]{new SurrogateRegexTranslator.SingleChar('\n'), new SurrogateRegexTranslator.SingleChar('\r')}));
    private static final SurrogateRegexTranslator.CharClass DOT_XPATH = new SurrogateRegexTranslator.Dot();
    private static final SurrogateRegexTranslator.CharClass ESC_d = new SurrogateRegexTranslator.Property("Nd");
    private static final SurrogateRegexTranslator.CharClass ESC_D = new SurrogateRegexTranslator.Complement(ESC_d);
    private static final SurrogateRegexTranslator.CharClass ESC_W = new Union(new SurrogateRegexTranslator.CharClass[]{JDK14RegexTranslator.computeCategoryCharClass('P'), JDK14RegexTranslator.computeCategoryCharClass('Z'), JDK14RegexTranslator.computeCategoryCharClass('C')});
    private static final SurrogateRegexTranslator.CharClass ESC_w = new SurrogateRegexTranslator.Complement(ESC_W);
    private static final SurrogateRegexTranslator.CharClass ESC_s = new Union(new SurrogateRegexTranslator.CharClass[]{new SurrogateRegexTranslator.SingleChar(' '), new SurrogateRegexTranslator.SingleChar('\n'), new SurrogateRegexTranslator.SingleChar('\r'), new SurrogateRegexTranslator.SingleChar('\t')});
    private static final SurrogateRegexTranslator.CharClass ESC_S = new SurrogateRegexTranslator.Complement(ESC_s);
    private static final SurrogateRegexTranslator.CharClass ESC_i_10 = JDK14RegexTranslator.makeNameCharClass((byte)4);
    private static final SurrogateRegexTranslator.CharClass ESC_i_11 = JDK14RegexTranslator.makeNameCharClass((byte)32);
    private static final SurrogateRegexTranslator.CharClass ESC_I_10 = new SurrogateRegexTranslator.Complement(ESC_i_10);
    private static final SurrogateRegexTranslator.CharClass ESC_I_11 = new SurrogateRegexTranslator.Complement(ESC_i_11);
    private static final SurrogateRegexTranslator.CharClass ESC_c_10 = JDK14RegexTranslator.makeNameCharClass((byte)2);
    private static final SurrogateRegexTranslator.CharClass ESC_c_11 = JDK14RegexTranslator.makeNameCharClass((byte)16);
    private static final SurrogateRegexTranslator.CharClass ESC_C_10 = new SurrogateRegexTranslator.Complement(ESC_c_10);
    private static final SurrogateRegexTranslator.CharClass ESC_C_11 = new SurrogateRegexTranslator.Complement(ESC_c_11);

    public void setIgnoreWhitespace(boolean ignore) {
        this.ignoreWhitespace = ignore;
    }

    public String translate(CharSequence regExp, int xmlVersion, boolean xpath2) throws RegexSyntaxException {
        this.regExp = regExp;
        this.xmlVersion = xmlVersion;
        this.isXPath = xpath2;
        this.length = regExp.length();
        this.advance();
        this.translateTop();
        return this.result.toString();
    }

    protected boolean translateAtom() throws RegexSyntaxException {
        switch (this.curChar) {
            case '\u0000': {
                if (!this.eos) break;
            }
            case ')': 
            case '*': 
            case '+': 
            case '?': 
            case ']': 
            case '{': 
            case '|': 
            case '}': {
                return false;
            }
            case '(': {
                this.copyCurChar();
                int thisCapture = ++this.currentCapture;
                this.translateRegExp();
                this.expect(')');
                this.captures.add(thisCapture);
                this.copyCurChar();
                return true;
            }
            case '\\': {
                this.advance();
                this.parseEsc().output(this.result);
                return true;
            }
            case '[': {
                this.inCharClassExpr = true;
                this.advance();
                this.parseCharClassExpr().output(this.result);
                return true;
            }
            case '.': {
                if (this.isXPath) {
                    DOT_XPATH.output(this.result);
                    this.advance();
                    return true;
                }
                DOT_SCHEMA.output(this.result);
                this.advance();
                return true;
            }
            case '$': 
            case '^': {
                if (this.isXPath) {
                    this.copyCurChar();
                    return true;
                }
                this.result.append('\\');
            }
        }
        this.copyCurChar();
        return true;
    }

    private static SurrogateRegexTranslator.CharClass makeNameCharClass(byte mask) {
        ArrayList<SurrogateRegexTranslator.SimpleCharClass> ranges = new ArrayList<SurrogateRegexTranslator.SimpleCharClass>();
        ranges.add(new SurrogateRegexTranslator.SingleChar(':'));
        IntRangeSet members = XMLCharacterData.getCategory(mask);
        int used = members.getNumberOfRanges();
        int[] startPoints = members.getStartPoints();
        int[] endPoints = members.getEndPoints();
        for (int i = 0; i < used; ++i) {
            if (startPoints[i] == endPoints[i] && i <= 65535) {
                ranges.add(new SurrogateRegexTranslator.SingleChar((char)startPoints[i]));
                continue;
            }
            ranges.add(new SurrogateRegexTranslator.CharRange(startPoints[i], endPoints[i]));
        }
        return new Union(ranges);
    }

    private SurrogateRegexTranslator.CharClass parseEsc() throws RegexSyntaxException {
        switch (this.curChar) {
            case 'n': {
                this.advance();
                return new SurrogateRegexTranslator.SingleChar('\n');
            }
            case 'r': {
                this.advance();
                return new SurrogateRegexTranslator.SingleChar('\r');
            }
            case 't': {
                this.advance();
                return new SurrogateRegexTranslator.SingleChar('\t');
            }
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': {
                break;
            }
            case 's': {
                this.advance();
                return ESC_s;
            }
            case 'S': {
                this.advance();
                return ESC_S;
            }
            case 'i': {
                this.advance();
                return this.xmlVersion == 10 ? ESC_i_10 : ESC_i_11;
            }
            case 'I': {
                this.advance();
                return this.xmlVersion == 10 ? ESC_I_10 : ESC_I_11;
            }
            case 'c': {
                this.advance();
                return this.xmlVersion == 10 ? ESC_c_10 : ESC_c_11;
            }
            case 'C': {
                this.advance();
                return this.xmlVersion == 10 ? ESC_C_10 : ESC_C_11;
            }
            case 'd': {
                this.advance();
                return ESC_d;
            }
            case 'D': {
                this.advance();
                return ESC_D;
            }
            case 'w': {
                this.advance();
                return ESC_w;
            }
            case 'W': {
                this.advance();
                return ESC_W;
            }
            case 'p': {
                this.advance();
                return this.parseProp();
            }
            case 'P': {
                this.advance();
                return new SurrogateRegexTranslator.Complement(this.parseProp());
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (this.isXPath) {
                    if (this.inCharClassExpr) {
                        throw this.makeException("back-reference not allowed within []");
                    }
                    char c = this.curChar;
                    int c0 = c - 48;
                    this.advance();
                    int c1 = "0123456789".indexOf(this.curChar);
                    if (c1 >= 0) {
                        int n = c0 * 10 + c1;
                        this.advance();
                        if (this.captures.contains(n)) {
                            return new SurrogateRegexTranslator.BackReference(n);
                        }
                        this.recede();
                    }
                    if (this.captures.contains(c0)) {
                        return new SurrogateRegexTranslator.BackReference(c0);
                    }
                    throw this.makeException("invalid backreference \\" + c0 + " (no such group)");
                }
                throw this.makeException("digit not allowed after \\");
            }
            case '$': {
                if (this.isXPath) break;
            }
            default: {
                throw this.makeException("invalid escape sequence");
            }
        }
        SurrogateRegexTranslator.SingleChar tem = new SurrogateRegexTranslator.SingleChar(this.curChar);
        this.advance();
        return tem;
    }

    private SurrogateRegexTranslator.CharClass parseProp() throws RegexSyntaxException {
        this.expect('{');
        int start = this.pos;
        while (true) {
            this.advance();
            if (this.curChar == '}') break;
            if (JDK14RegexTranslator.isAsciiAlnum(this.curChar) || this.curChar == '-') continue;
            this.expect('}');
        }
        CharSequence propertyNameCS = this.regExp.subSequence(start, this.pos - 1);
        if (this.ignoreWhitespace && !this.inCharClassExpr) {
            propertyNameCS = Whitespace.removeAllWhitespace(propertyNameCS);
        }
        String propertyName = propertyNameCS.toString();
        this.advance();
        switch (propertyName.length()) {
            case 0: {
                throw this.makeException("empty property name");
            }
            case 2: {
                int sci = "LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn".indexOf(propertyName);
                if (sci < 0 || sci % 2 == 1) {
                    throw this.makeException("unknown category");
                }
                return JDK14RegexTranslator.getSubCategoryCharClass(sci / 2);
            }
            case 1: {
                int ci = "LMNPZSC".indexOf(propertyName.charAt(0));
                if (ci < 0) {
                    throw this.makeException("unknown category", propertyName);
                }
                return JDK14RegexTranslator.getCategoryCharClass(ci);
            }
        }
        if (propertyName.startsWith("Is")) {
            String blockName = propertyName.substring(2);
            for (int i = 0; i < RegexData.specialBlockNames.length; ++i) {
                if (!blockName.equals(RegexData.specialBlockNames[i])) continue;
                return specialBlockCharClasses[i];
            }
            if (!JDK14RegexTranslator.isBlock(blockName)) {
                throw this.makeException("invalid block name", blockName);
            }
            return new SurrogateRegexTranslator.Property("In" + blockName);
        }
        throw this.makeException("invalid property name", propertyName);
    }

    private SurrogateRegexTranslator.CharClass parseCharClassExpr() throws RegexSyntaxException {
        boolean compl;
        if (this.curChar == '^') {
            this.advance();
            compl = true;
        } else {
            compl = false;
        }
        ArrayList<SurrogateRegexTranslator.CharClass> members = new ArrayList<SurrogateRegexTranslator.CharClass>(10);
        do {
            SurrogateRegexTranslator.CharClass lower = this.parseCharClassEscOrXmlChar();
            members.add(lower);
            if (this.curChar == ']' || this.eos) break;
            if (this.curChar != '-') continue;
            char next = this.regExp.charAt(this.pos);
            if (next == '[') {
                this.advance();
                break;
            }
            if (next == ']') continue;
            this.advance();
            SurrogateRegexTranslator.CharClass upper = this.parseCharClassEscOrXmlChar();
            if (lower.getSingleChar() < 0 || upper.getSingleChar() < 0) {
                throw this.makeException("the ends of a range must be single characters");
            }
            if (lower.getSingleChar() > upper.getSingleChar()) {
                throw this.makeException("invalid range (start > end)");
            }
            members.set(members.size() - 1, new SurrogateRegexTranslator.CharRange(lower.getSingleChar(), upper.getSingleChar()));
            if (this.curChar != '-' || this.regExp.charAt(this.pos) != '[') continue;
            this.advance();
            break;
        } while (this.curChar != ']');
        if (this.eos) {
            this.expect(']');
        }
        SurrogateRegexTranslator.CharClass result = members.size() == 1 ? (SurrogateRegexTranslator.CharClass)members.get(0) : new Union(members);
        if (compl) {
            result = new SurrogateRegexTranslator.Complement(result);
        }
        if (this.curChar == '[') {
            this.advance();
            result = new Subtraction(result, this.parseCharClassExpr());
            this.expect(']');
        }
        this.inCharClassExpr = false;
        this.advance();
        return result;
    }

    private SurrogateRegexTranslator.CharClass parseCharClassEscOrXmlChar() throws RegexSyntaxException {
        SurrogateRegexTranslator.SimpleCharClass tem;
        switch (this.curChar) {
            case '\u0000': {
                if (!this.eos) break;
                this.expect(']');
                break;
            }
            case '\\': {
                this.advance();
                return this.parseEsc();
            }
            case '[': 
            case ']': {
                throw this.makeException("character must be escaped", new String(new char[]{this.curChar}));
            }
        }
        if (UTF16.isSurrogate(this.curChar)) {
            if (!UTF16.isHighSurrogate(this.curChar)) {
                throw this.makeException("invalid surrogate pair");
            }
            char c1 = this.curChar;
            this.advance();
            if (!UTF16.isLowSurrogate(this.curChar)) {
                throw this.makeException("invalid surrogate pair");
            }
            tem = new SurrogateRegexTranslator.WideSingleChar(UTF16.combinePair(c1, this.curChar));
        } else {
            tem = new SurrogateRegexTranslator.SingleChar(this.curChar);
        }
        this.advance();
        return tem;
    }

    private static synchronized SurrogateRegexTranslator.CharClass getCategoryCharClass(int ci) {
        if (categoryCharClasses[ci] == null) {
            JDK14RegexTranslator.categoryCharClasses[ci] = JDK14RegexTranslator.computeCategoryCharClass("LMNPZSC".charAt(ci));
        }
        return categoryCharClasses[ci];
    }

    private static synchronized SurrogateRegexTranslator.CharClass getSubCategoryCharClass(int sci) {
        if (subCategoryCharClasses[sci] == null) {
            JDK14RegexTranslator.subCategoryCharClasses[sci] = JDK14RegexTranslator.computeSubCategoryCharClass("LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn".substring(sci * 2, (sci + 1) * 2));
        }
        return subCategoryCharClasses[sci];
    }

    private static SurrogateRegexTranslator.CharClass computeCategoryCharClass(char code) {
        ArrayList<SurrogateRegexTranslator.CharClass> classes = new ArrayList<SurrogateRegexTranslator.CharClass>(5);
        classes.add(new SurrogateRegexTranslator.Property(new String(new char[]{code})));
        int ci = "NoLoMnCfLlNlPoLuMcNdSoSmCo".indexOf(code);
        while (ci >= 0) {
            int[] addRanges = RegexData.CATEGORY_RANGES[ci / 2];
            for (int i = 0; i < addRanges.length; i += 2) {
                classes.add(new SurrogateRegexTranslator.CharRange(addRanges[i], addRanges[i + 1]));
            }
            ci = "NoLoMnCfLlNlPoLuMcNdSoSmCo".indexOf(code, ci + 1);
        }
        if (code == 'P') {
            classes.add(JDK14RegexTranslator.makeCharClass("\u00ab\u2018\u201b\u201c\u201f\u2039\u00bb\u2019\u201d\u203a"));
        }
        if (code == 'L') {
            classes.add(new SurrogateRegexTranslator.SingleChar('\u03f5'));
            classes.add(new SurrogateRegexTranslator.SingleChar('\u03f4'));
        }
        if (code == 'C') {
            classes.add(new Subtraction(new SurrogateRegexTranslator.Property("Cn"), new Union(new SurrogateRegexTranslator.CharClass[]{new SurrogateRegexTranslator.SingleChar('\u03f4'), new SurrogateRegexTranslator.SingleChar('\u03f5')})));
            ArrayList<SurrogateRegexTranslator.CharRange> assignedRanges = new ArrayList<SurrogateRegexTranslator.CharRange>(5);
            for (int i = 0; i < RegexData.CATEGORY_RANGES.length; ++i) {
                for (int j = 0; j < RegexData.CATEGORY_RANGES[i].length; j += 2) {
                    assignedRanges.add(new SurrogateRegexTranslator.CharRange(RegexData.CATEGORY_RANGES[i][j], RegexData.CATEGORY_RANGES[i][j + 1]));
                }
            }
            classes.add(new Subtraction(new SurrogateRegexTranslator.CharRange(65536, 0x10FFFF), new Union(assignedRanges)));
        }
        if (classes.size() == 1) {
            return (SurrogateRegexTranslator.CharClass)classes.get(0);
        }
        return new Union(classes);
    }

    private static SurrogateRegexTranslator.CharClass computeSubCategoryCharClass(String name) {
        SurrogateRegexTranslator.Property base = new SurrogateRegexTranslator.Property(name);
        int sci = "NoLoMnCfLlNlPoLuMcNdSoSmCo".indexOf(name);
        if (sci < 0) {
            if (name.equals("Cn")) {
                ArrayList<SurrogateRegexTranslator.SimpleCharClass> assignedRanges = new ArrayList<SurrogateRegexTranslator.SimpleCharClass>(5);
                assignedRanges.add(new SurrogateRegexTranslator.SingleChar('\u03f4'));
                assignedRanges.add(new SurrogateRegexTranslator.SingleChar('\u03f5'));
                for (int i = 0; i < RegexData.CATEGORY_RANGES.length; ++i) {
                    for (int j = 0; j < RegexData.CATEGORY_RANGES[i].length; j += 2) {
                        assignedRanges.add(new SurrogateRegexTranslator.CharRange(RegexData.CATEGORY_RANGES[i][j], RegexData.CATEGORY_RANGES[i][j + 1]));
                    }
                }
                return new Subtraction(new Union(new SurrogateRegexTranslator.CharClass[]{base, new SurrogateRegexTranslator.CharRange(65536, 0x10FFFF)}), new Union(assignedRanges));
            }
            if (name.equals("Pi")) {
                return JDK14RegexTranslator.makeCharClass("\u00ab\u2018\u201b\u201c\u201f\u2039");
            }
            if (name.equals("Pf")) {
                return JDK14RegexTranslator.makeCharClass("\u00bb\u2019\u201d\u203a");
            }
            return base;
        }
        ArrayList<SurrogateRegexTranslator.SimpleCharClass> classes = new ArrayList<SurrogateRegexTranslator.SimpleCharClass>(5);
        classes.add(base);
        int[] addRanges = RegexData.CATEGORY_RANGES[sci / 2];
        for (int i = 0; i < addRanges.length; i += 2) {
            classes.add(new SurrogateRegexTranslator.CharRange(addRanges[i], addRanges[i + 1]));
        }
        if (name.equals("Lu")) {
            classes.add(new SurrogateRegexTranslator.SingleChar('\u03f4'));
        } else if (name.equals("Ll")) {
            classes.add(new SurrogateRegexTranslator.SingleChar('\u03f5'));
        } else if (name.equals("Nl")) {
            classes.add(new SurrogateRegexTranslator.CharRange(5870, 5872));
        } else if (name.equals("No")) {
            return new Subtraction(new Union(classes), new SurrogateRegexTranslator.CharRange(5870, 5872));
        }
        return new Union(classes);
    }

    private static SurrogateRegexTranslator.CharClass makeCharClass(String members) {
        ArrayList<SurrogateRegexTranslator.SingleChar> list = new ArrayList<SurrogateRegexTranslator.SingleChar>(5);
        int len = members.length();
        for (int i = 0; i < len; ++i) {
            list.add(new SurrogateRegexTranslator.SingleChar(members.charAt(i)));
        }
        return new Union(list);
    }

    public static void main(String[] args) throws RegexSyntaxException {
        String s = new JDK14RegexTranslator().translate(args[0], 11, args[1].equals("xpath"));
        System.err.println(StringValue.diagnosticDisplay(s));
    }

    static class Union
    extends SurrogateRegexTranslator.CharClass {
        private final List members;

        Union(SurrogateRegexTranslator.CharClass[] v) {
            this(Union.toList(v));
        }

        private static List toList(SurrogateRegexTranslator.CharClass[] v) {
            ArrayList<SurrogateRegexTranslator.CharClass> members = new ArrayList<SurrogateRegexTranslator.CharClass>(5);
            for (int i = 0; i < v.length; ++i) {
                members.add(v[i]);
            }
            return members;
        }

        Union(List members) {
            super(Union.computeContainsBmp(members), Union.computeContainsNonBmp(members));
            this.members = members;
        }

        public void outputBmp(FastStringBuffer buf) {
            buf.append('[');
            int len = this.members.size();
            for (int i = 0; i < len; ++i) {
                SurrogateRegexTranslator.CharClass cc = (SurrogateRegexTranslator.CharClass)this.members.get(i);
                if (cc.getContainsBmp() == -1) continue;
                if (cc instanceof SurrogateRegexTranslator.SimpleCharClass) {
                    ((SurrogateRegexTranslator.SimpleCharClass)cc).inClassOutputBmp(buf);
                    continue;
                }
                cc.outputBmp(buf);
            }
            buf.append(']');
        }

        public void outputComplementBmp(FastStringBuffer buf) {
            SurrogateRegexTranslator.CharClass cc;
            int i;
            boolean first = true;
            int len = this.members.size();
            for (i = 0; i < len; ++i) {
                cc = (SurrogateRegexTranslator.CharClass)this.members.get(i);
                if (cc.getContainsBmp() == -1 || !(cc instanceof SurrogateRegexTranslator.SimpleCharClass)) continue;
                if (first) {
                    buf.append("[^");
                    first = false;
                }
                ((SurrogateRegexTranslator.SimpleCharClass)cc).inClassOutputBmp(buf);
            }
            for (i = 0; i < len; ++i) {
                cc = (SurrogateRegexTranslator.CharClass)this.members.get(i);
                if (cc.getContainsBmp() == -1 || cc instanceof SurrogateRegexTranslator.SimpleCharClass) continue;
                if (first) {
                    buf.append('[');
                    first = false;
                } else {
                    buf.append("&&");
                }
                cc.outputComplementBmp(buf);
            }
            if (first) {
                buf.append("[\u0000-\uffff]");
            } else {
                buf.append(']');
            }
        }

        public void addNonBmpRanges(List ranges) {
            int len = this.members.size();
            for (int i = 0; i < len; ++i) {
                ((SurrogateRegexTranslator.CharClass)this.members.get(i)).addNonBmpRanges(ranges);
            }
        }

        private static int computeContainsBmp(List members) {
            int ret = -1;
            int len = members.size();
            for (int i = 0; i < len; ++i) {
                ret = Math.max(ret, ((SurrogateRegexTranslator.CharClass)members.get(i)).getContainsBmp());
            }
            return ret;
        }

        private static int computeContainsNonBmp(List members) {
            int ret = -1;
            int len = members.size();
            for (int i = 0; i < len; ++i) {
                ret = Math.max(ret, ((SurrogateRegexTranslator.CharClass)members.get(i)).getContainsNonBmp());
            }
            return ret;
        }
    }

    static class Subtraction
    extends SurrogateRegexTranslator.CharClass {
        private final SurrogateRegexTranslator.CharClass cc1;
        private final SurrogateRegexTranslator.CharClass cc2;

        Subtraction(SurrogateRegexTranslator.CharClass cc1, SurrogateRegexTranslator.CharClass cc2) {
            super(Math.min(cc1.getContainsBmp(), -cc2.getContainsBmp()), Math.min(cc1.getContainsNonBmp(), -cc2.getContainsNonBmp()));
            this.cc1 = cc1;
            this.cc2 = cc2;
        }

        public void outputBmp(FastStringBuffer buf) {
            buf.append('[');
            this.cc1.outputBmp(buf);
            buf.append("&&");
            this.cc2.outputComplementBmp(buf);
            buf.append(']');
        }

        public void outputComplementBmp(FastStringBuffer buf) {
            buf.append('[');
            this.cc1.outputComplementBmp(buf);
            this.cc2.outputBmp(buf);
            buf.append(']');
        }

        public void addNonBmpRanges(List ranges) {
            ArrayList posList = new ArrayList(5);
            this.cc1.addNonBmpRanges(posList);
            ArrayList negList = new ArrayList(5);
            this.cc2.addNonBmpRanges(negList);
            JDK14RegexTranslator.sortRangeList(posList);
            JDK14RegexTranslator.sortRangeList(negList);
            Iterator negIter = negList.iterator();
            RegexTranslator.Range negRange = negIter.hasNext() ? (RegexTranslator.Range)negIter.next() : null;
            int len = posList.size();
            for (int i = 0; i < len; ++i) {
                RegexTranslator.Range posRange = (RegexTranslator.Range)posList.get(i);
                while (negRange != null && negRange.getMax() < posRange.getMin()) {
                    if (negIter.hasNext()) {
                        negRange = (RegexTranslator.Range)negIter.next();
                        continue;
                    }
                    negRange = null;
                }
                int min = posRange.getMin();
                while (negRange != null && negRange.getMin() <= posRange.getMax()) {
                    if (min < negRange.getMin()) {
                        ranges.add(new RegexTranslator.Range(min, negRange.getMin() - 1));
                    }
                    if ((min = negRange.getMax() + 1) > posRange.getMax()) break;
                    if (negIter.hasNext()) {
                        negRange = (RegexTranslator.Range)negIter.next();
                        continue;
                    }
                    negRange = null;
                }
                if (min > posRange.getMax()) continue;
                ranges.add(new RegexTranslator.Range(min, posRange.getMax()));
            }
        }
    }
}

