/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public final class NamespaceTest
extends NodeTest {
    private NamePool namePool;
    private int nodeKind;
    private short uriCode;
    private String uri;

    public NamespaceTest(NamePool pool, int nodeKind, String uri) {
        this.namePool = pool;
        this.nodeKind = nodeKind;
        this.uri = uri;
        this.uriCode = pool.allocateCodeForURI(uri);
    }

    public boolean matches(int nodeType, int fingerprint, int annotation2) {
        if (fingerprint == -1) {
            return false;
        }
        if (nodeType != this.nodeKind) {
            return false;
        }
        return this.uriCode == this.namePool.getURICode(fingerprint);
    }

    public boolean matches(TinyTree tree, int nodeNr) {
        int fingerprint = tree.getNameCode(nodeNr) & 0xFFFFF;
        if (fingerprint == -1) {
            return false;
        }
        if (tree.getNodeKind(nodeNr) != this.nodeKind) {
            return false;
        }
        return this.uriCode == this.namePool.getURICode(fingerprint);
    }

    public boolean matches(NodeInfo node) {
        return node.getNodeKind() == this.nodeKind && node.getURI().equals(this.uri);
    }

    public final double getDefaultPriority() {
        return -0.25;
    }

    public int getPrimitiveType() {
        return this.nodeKind;
    }

    public ItemType getSuperType(TypeHierarchy th) {
        return NodeKindTest.makeNodeKindTest(this.nodeKind);
    }

    public int getNodeKindMask() {
        return 1 << this.nodeKind;
    }

    public String getNamespaceURI() {
        return this.namePool.getURIFromURICode(this.uriCode);
    }

    public String toString() {
        return '{' + this.namePool.getURIFromURICode(this.uriCode) + "}:*";
    }

    public int hashCode() {
        return this.uriCode << 5 + this.nodeKind;
    }

    public boolean equals(Object other) {
        return other instanceof NamespaceTest && ((NamespaceTest)other).namePool == this.namePool && ((NamespaceTest)other).nodeKind == this.nodeKind && ((NamespaceTest)other).uriCode == this.uriCode;
    }
}

