/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.ExtendedNodeInfo;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.FingerprintedNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceIterator;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.PrependIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tinytree.AncestorEnumeration;
import net.sf.saxon.tinytree.AttributeEnumeration;
import net.sf.saxon.tinytree.DescendantEnumeration;
import net.sf.saxon.tinytree.FollowingEnumeration;
import net.sf.saxon.tinytree.PrecedingEnumeration;
import net.sf.saxon.tinytree.PrecedingSiblingEnumeration;
import net.sf.saxon.tinytree.SiblingEnumeration;
import net.sf.saxon.tinytree.TinyAttributeImpl;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.tinytree.TinyParentNodeImpl;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public abstract class TinyNodeImpl
implements NodeInfo,
ExtendedNodeInfo,
FingerprintedNode,
SourceLocator {
    protected TinyTree tree;
    protected int nodeNr;
    protected TinyNodeImpl parent = null;
    public static final char[] NODE_LETTER = new char[]{'x', 'e', 'a', 't', 'x', 'x', 'x', 'p', 'c', 'r', 'x', 'x', 'x', 'n'};

    public CharSequence getStringValueCS() {
        return this.getStringValue();
    }

    public int getTypeAnnotation() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    public String getPublicId() {
        return null;
    }

    public SequenceIterator getTypedValue() throws XPathException {
        int annotation2 = this.getTypeAnnotation();
        if ((annotation2 & 0x40000000) != 0) {
            annotation2 = 631;
        }
        if ((annotation2 &= 0xFFFFF) == -1 || annotation2 == 631 || annotation2 == 630) {
            return SingletonIterator.makeIterator(new UntypedAtomicValue(this.getStringValueCS()));
        }
        SchemaType stype = this.getConfiguration().getSchemaType(annotation2);
        if (stype == null) {
            String typeName;
            try {
                typeName = this.getNamePool().getDisplayName(annotation2);
            }
            catch (Exception err) {
                typeName = annotation2 + "";
            }
            throw new XPathException("Unknown type annotation " + Err.wrap(typeName) + " in document instance");
        }
        return stype.getTypedValue(this);
    }

    public Value atomize() throws XPathException {
        int annotation2 = this.getTypeAnnotation();
        if ((annotation2 & 0x40000000) != 0) {
            annotation2 = 631;
        }
        if (annotation2 == -1 || annotation2 == 631 || annotation2 == 630) {
            return new UntypedAtomicValue(this.getStringValueCS());
        }
        SchemaType stype = this.getConfiguration().getSchemaType(annotation2);
        if (stype == null) {
            String typeName = this.getNamePool().getDisplayName(annotation2);
            throw new XPathException("Unknown type annotation " + Err.wrap(typeName) + " in document instance");
        }
        return stype.atomize(this);
    }

    public void setSystemId(String uri) {
        short type = this.tree.nodeKind[this.nodeNr];
        if (type == 2 || type == 13) {
            this.getParent().setSystemId(uri);
        } else {
            this.tree.setSystemId(this.nodeNr, uri);
        }
    }

    protected void setParentNode(TinyNodeImpl parent) {
        this.parent = parent;
    }

    public boolean isSameNodeInfo(NodeInfo other) {
        return this == other || other instanceof TinyNodeImpl && this.tree == ((TinyNodeImpl)other).tree && this.nodeNr == ((TinyNodeImpl)other).nodeNr && this.getNodeKind() == other.getNodeKind();
    }

    public boolean equals(Object other) {
        return other instanceof NodeInfo && this.isSameNodeInfo((NodeInfo)other);
    }

    public int hashCode() {
        return (this.tree.getDocumentNumber() & 0x3FF) << 20 ^ this.nodeNr ^ this.getNodeKind() << 14;
    }

    public String getSystemId() {
        return this.tree.getSystemId(this.nodeNr);
    }

    public String getBaseURI() {
        return this.getParent().getBaseURI();
    }

    public int getLineNumber() {
        return this.tree.getLineNumber(this.nodeNr);
    }

    protected long getSequenceNumber() {
        return (long)this.nodeNr << 32;
    }

    public final int compareOrder(NodeInfo other) {
        long a = this.getSequenceNumber();
        if (other instanceof TinyNodeImpl) {
            long b = ((TinyNodeImpl)other).getSequenceNumber();
            if (a < b) {
                return -1;
            }
            if (a > b) {
                return 1;
            }
            return 0;
        }
        return 0 - other.compareOrder(this);
    }

    public int getFingerprint() {
        int nc = this.getNameCode();
        if (nc == -1) {
            return -1;
        }
        return nc & 0xFFFFF;
    }

    public int getNameCode() {
        return this.tree.nameCode[this.nodeNr];
    }

    public String getPrefix() {
        int code = this.tree.nameCode[this.nodeNr];
        if (code < 0) {
            return "";
        }
        if (NamePool.getPrefixIndex(code) == 0) {
            return "";
        }
        return this.tree.getNamePool().getPrefix(code);
    }

    public String getURI() {
        int code = this.tree.nameCode[this.nodeNr];
        if (code < 0) {
            return "";
        }
        return this.tree.getNamePool().getURI(code);
    }

    public String getDisplayName() {
        int code = this.tree.nameCode[this.nodeNr];
        if (code < 0) {
            return "";
        }
        return this.tree.getNamePool().getDisplayName(code);
    }

    public String getLocalPart() {
        int code = this.tree.nameCode[this.nodeNr];
        if (code < 0) {
            return "";
        }
        return this.tree.getNamePool().getLocalName(code);
    }

    public AxisIterator iterateAxis(byte axisNumber) {
        if (axisNumber == 3) {
            if (this.hasChildNodes()) {
                return new SiblingEnumeration(this.tree, this, null, true);
            }
            return EmptyIterator.getInstance();
        }
        return this.iterateAxis(axisNumber, AnyNodeTest.getInstance());
    }

    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        int type = this.getNodeKind();
        switch (axisNumber) {
            case 0: {
                return new AncestorEnumeration(this, nodeTest, false);
            }
            case 1: {
                return new AncestorEnumeration(this, nodeTest, true);
            }
            case 2: {
                if (type != 1) {
                    return EmptyIterator.getInstance();
                }
                if (this.tree.alpha[this.nodeNr] < 0) {
                    return EmptyIterator.getInstance();
                }
                return new AttributeEnumeration(this.tree, this.nodeNr, nodeTest);
            }
            case 3: {
                if (this.hasChildNodes()) {
                    return new SiblingEnumeration(this.tree, this, nodeTest, true);
                }
                return EmptyIterator.getInstance();
            }
            case 4: {
                if (type == 9 && nodeTest instanceof NameTest && nodeTest.getPrimitiveType() == 1) {
                    return ((TinyDocumentImpl)this).getAllElements(nodeTest.getFingerprint());
                }
                if (this.hasChildNodes()) {
                    return new DescendantEnumeration(this.tree, this, nodeTest, false);
                }
                return EmptyIterator.getInstance();
            }
            case 5: {
                if (this.hasChildNodes()) {
                    return new DescendantEnumeration(this.tree, this, nodeTest, true);
                }
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 6: {
                if (type == 2 || type == 13) {
                    return new FollowingEnumeration(this.tree, (TinyNodeImpl)this.getParent(), nodeTest, true);
                }
                if (this.tree.depth[this.nodeNr] == 0) {
                    return EmptyIterator.getInstance();
                }
                return new FollowingEnumeration(this.tree, this, nodeTest, false);
            }
            case 7: {
                if (type == 2 || type == 13 || this.tree.depth[this.nodeNr] == 0) {
                    return EmptyIterator.getInstance();
                }
                return new SiblingEnumeration(this.tree, this, nodeTest, false);
            }
            case 8: {
                if (type != 1) {
                    return EmptyIterator.getInstance();
                }
                return NamespaceIterator.makeIterator(this, nodeTest);
            }
            case 9: {
                NodeInfo parent = this.getParent();
                return Navigator.filteredSingleton(parent, nodeTest);
            }
            case 10: {
                if (type == 2 || type == 13) {
                    return new PrecedingEnumeration(this.tree, (TinyNodeImpl)this.getParent(), nodeTest, false);
                }
                if (this.tree.depth[this.nodeNr] == 0) {
                    return EmptyIterator.getInstance();
                }
                return new PrecedingEnumeration(this.tree, this, nodeTest, false);
            }
            case 11: {
                if (type == 2 || type == 13 || this.tree.depth[this.nodeNr] == 0) {
                    return EmptyIterator.getInstance();
                }
                return new PrecedingSiblingEnumeration(this.tree, this, nodeTest);
            }
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 13: {
                if (type == 9) {
                    return EmptyIterator.getInstance();
                }
                if (type == 2 || type == 13) {
                    TinyNodeImpl el = (TinyNodeImpl)this.getParent();
                    return new PrependIterator(el, new PrecedingEnumeration(this.tree, el, nodeTest, true));
                }
                return new PrecedingEnumeration(this.tree, this, nodeTest, true);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + axisNumber);
    }

    public NodeInfo getParent() {
        if (this.parent != null) {
            return this.parent;
        }
        int p = TinyNodeImpl.getParentNodeNr(this.tree, this.nodeNr);
        this.parent = p == -1 ? null : this.tree.getNode(p);
        return this.parent;
    }

    static int getParentNodeNr(TinyTree tree, int nodeNr) {
        if (tree.depth[nodeNr] == 0) {
            return -1;
        }
        int p = tree.next[nodeNr];
        while (p > nodeNr) {
            if (tree.nodeKind[p] == 12) {
                return tree.alpha[p];
            }
            p = tree.next[p];
        }
        return p;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public String getAttributeValue(int fingerprint) {
        return null;
    }

    public NodeInfo getRoot() {
        if (this.tree.depth[this.nodeNr] == 0) {
            return this;
        }
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return this.tree.getNode(this.tree.getRootNode(this.nodeNr));
    }

    public DocumentInfo getDocumentRoot() {
        NodeInfo root = this.getRoot();
        if (root.getNodeKind() == 9) {
            return (DocumentInfo)root;
        }
        return null;
    }

    public Configuration getConfiguration() {
        return this.tree.getConfiguration();
    }

    public NamePool getNamePool() {
        return this.tree.getNamePool();
    }

    public int[] getDeclaredNamespaces(int[] buffer) {
        return null;
    }

    public void generateId(FastStringBuffer buffer) {
        buffer.append("d");
        buffer.append(Integer.toString(this.tree.getDocumentNumber()));
        buffer.append(NODE_LETTER[this.getNodeKind()]);
        buffer.append(Integer.toString(this.nodeNr));
    }

    public final int getDocumentNumber() {
        return this.tree.getDocumentNumber();
    }

    public boolean isAncestorOrSelf(TinyNodeImpl d) {
        if (this.tree != d.tree) {
            return false;
        }
        int dn = d.nodeNr;
        if (d instanceof TinyAttributeImpl) {
            if (this instanceof TinyAttributeImpl) {
                return this.nodeNr == dn;
            }
            dn = this.tree.attParent[dn];
        }
        if (this instanceof TinyAttributeImpl) {
            return false;
        }
        if (this.nodeNr > dn) {
            return false;
        }
        if (this.nodeNr == dn) {
            return true;
        }
        if (!(this instanceof TinyParentNodeImpl)) {
            return false;
        }
        if (this.tree.depth[this.nodeNr] >= this.tree.depth[dn]) {
            return false;
        }
        int n = this.nodeNr;
        while (true) {
            int nextSib;
            if ((nextSib = this.tree.next[n]) > dn) {
                return true;
            }
            if (this.tree.depth[nextSib] == 0) {
                return true;
            }
            if (nextSib >= n) break;
            n = nextSib;
        }
        return false;
    }

    public boolean isId() {
        return false;
    }

    public boolean isIdref() {
        return false;
    }

    public boolean isNilled() {
        return this.tree.isNilled(this.nodeNr);
    }

    public int getNodeNumber() {
        return this.nodeNr;
    }
}

