/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.shared.NotFoundException;
import org.apache.jena.system.JenaSystem;
import org.apache.jena.util.FileUtils;
import org.apache.jena.util.LocationMapper;
import org.apache.jena.util.Locator;
import org.apache.jena.util.LocatorClassLoader;
import org.apache.jena.util.LocatorFile;
import org.apache.jena.util.LocatorURL;
import org.apache.jena.util.LocatorZip;
import org.apache.jena.util.TypedStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileManager {
    private static Logger log = LoggerFactory.getLogger(FileManager.class);
    public static final String PATH_DELIMITER = ";";
    public static final String filePathSeparator = File.separator;
    static FileManager fmInstance = null;
    static boolean logAllLookups = true;
    protected List<Locator> fmHandlers = new ArrayList<Locator>();
    protected LocationMapper fmMapper = null;
    boolean cacheModelLoads = false;
    Map<String, Model> modelCache = null;

    public static FileManager get() {
        if (fmInstance == null) {
            fmInstance = FileManager.makeGlobal();
        }
        return fmInstance;
    }

    public static void setGlobalFileManager(FileManager globalFileManager) {
        fmInstance = globalFileManager;
    }

    public FileManager() {
    }

    public FileManager clone() {
        return FileManager.clone(this);
    }

    private static FileManager clone(FileManager filemanager) {
        FileManager newFm = new FileManager();
        newFm.fmHandlers.addAll(filemanager.fmHandlers);
        newFm.fmMapper = null;
        if (filemanager.getLocationMapper() != null) {
            newFm.fmMapper = new LocationMapper(filemanager.getLocationMapper());
        }
        newFm.cacheModelLoads = false;
        newFm.modelCache = null;
        return newFm;
    }

    public static FileManager makeGlobal() {
        FileManager fMgr = new FileManager(LocationMapper.get());
        FileManager.setStdLocators(fMgr);
        return fMgr;
    }

    public static void setStdLocators(FileManager fMgr) {
        fMgr.fmHandlers.clear();
        fMgr.addLocatorFile();
        fMgr.addLocatorURL();
        fMgr.addLocatorClassLoader(fMgr.getClass().getClassLoader());
    }

    public FileManager(LocationMapper _mapper) {
        this.setLocationMapper(_mapper);
    }

    public void setLocationMapper(LocationMapper _mapper) {
        this.fmMapper = _mapper;
    }

    public LocationMapper getLocationMapper() {
        return this.fmMapper;
    }

    public Iterator<Locator> locators() {
        return this.fmHandlers.listIterator();
    }

    public void addLocator(Locator loc) {
        log.debug("Add location: " + loc.getName());
        this.fmHandlers.add(loc);
    }

    public void addLocatorFile() {
        this.addLocatorFile(null);
    }

    public void addLocatorFile(String dir) {
        LocatorFile fLoc = new LocatorFile(dir);
        this.addLocator(fLoc);
    }

    public void addLocatorClassLoader(ClassLoader cLoad) {
        LocatorClassLoader cLoc = new LocatorClassLoader(cLoad);
        this.addLocator(cLoc);
    }

    public void addLocatorURL() {
        LocatorURL loc = new LocatorURL();
        this.addLocator(loc);
    }

    public void addLocatorZip(String zfn) {
        LocatorZip loc = new LocatorZip(zfn);
        this.addLocator(loc);
    }

    public void remove(Locator loc) {
        this.fmHandlers.remove(loc);
    }

    public void resetCache() {
        if (this.modelCache != null) {
            this.modelCache.clear();
        }
    }

    public void setModelCaching(boolean state) {
        this.cacheModelLoads = state;
        if (this.cacheModelLoads && this.modelCache == null) {
            this.modelCache = new HashMap<String, Model>();
        }
    }

    public boolean isCachingModels() {
        return this.cacheModelLoads;
    }

    public Model getFromCache(String filenameOrURI) {
        if (!this.isCachingModels()) {
            return null;
        }
        return this.modelCache.get(filenameOrURI);
    }

    public boolean hasCachedModel(String filenameOrURI) {
        if (!this.isCachingModels()) {
            return false;
        }
        return this.modelCache.containsKey(filenameOrURI);
    }

    public void addCacheModel(String uri, Model m) {
        if (this.isCachingModels()) {
            this.modelCache.put(uri, m);
        }
    }

    public void removeCacheModel(String uri) {
        if (this.isCachingModels()) {
            this.modelCache.remove(uri);
        }
    }

    public Model loadModel(String filenameOrURI) {
        if (log.isDebugEnabled()) {
            log.debug("loadModel(" + filenameOrURI + ")");
        }
        return this.loadModelWorker(filenameOrURI, null, null);
    }

    public Model loadModel(String filenameOrURI, String rdfSyntax) {
        if (log.isDebugEnabled()) {
            log.debug("loadModel(" + filenameOrURI + ", " + rdfSyntax + ")");
        }
        return this.loadModelWorker(filenameOrURI, null, rdfSyntax);
    }

    public Model loadModel(String filenameOrURI, String baseURI, String rdfSyntax) {
        if (log.isDebugEnabled()) {
            log.debug("loadModel(" + filenameOrURI + ", " + baseURI + ", " + rdfSyntax + ")");
        }
        return this.loadModelWorker(filenameOrURI, baseURI, rdfSyntax);
    }

    private Model loadModelWorker(String filenameOrURI, String baseURI, String rdfSyntax) {
        if (this.hasCachedModel(filenameOrURI)) {
            if (log.isDebugEnabled()) {
                log.debug("Model cache hit: " + filenameOrURI);
            }
            return this.getFromCache(filenameOrURI);
        }
        Model m = ModelFactory.createDefaultModel();
        this.readModelWorker(m, filenameOrURI, baseURI, rdfSyntax);
        if (this.isCachingModels()) {
            this.addCacheModel(filenameOrURI, m);
        }
        return m;
    }

    public Model readModel(Model model, String filenameOrURI) {
        if (log.isDebugEnabled()) {
            log.debug("readModel(model," + filenameOrURI + ")");
        }
        return this.readModel(model, filenameOrURI, null);
    }

    public Model readModel(Model model, String filenameOrURI, String rdfSyntax) {
        if (log.isDebugEnabled()) {
            log.debug("readModel(model," + filenameOrURI + ", " + rdfSyntax + ")");
        }
        return this.readModelWorker(model, filenameOrURI, null, rdfSyntax);
    }

    public Model readModel(Model model, String filenameOrURI, String baseURI, String syntax) {
        if (log.isDebugEnabled()) {
            log.debug("readModel(model," + filenameOrURI + ", " + baseURI + ", " + syntax + ")");
        }
        return this.readModelWorker(model, filenameOrURI, baseURI, syntax);
    }

    protected Model readModelWorker(Model model, String filenameOrURI, String baseURI, String syntax) {
        TypedStream in;
        String mappedURI = this.mapURI(filenameOrURI);
        if (log.isDebugEnabled() && !mappedURI.equals(filenameOrURI)) {
            log.debug("Map: " + filenameOrURI + " => " + mappedURI);
        }
        if (syntax == null && baseURI == null && mappedURI.startsWith("http:")) {
            syntax = FileUtils.guessLang(mappedURI);
            model.read(mappedURI, syntax);
            return model;
        }
        if (syntax == null) {
            syntax = FileUtils.guessLang(mappedURI);
            if (syntax == null || syntax.equals("")) {
                syntax = "RDF/XML";
            }
            if (log.isDebugEnabled()) {
                log.debug("Syntax guess: " + syntax);
            }
        }
        if (baseURI == null) {
            baseURI = FileManager.chooseBaseURI(filenameOrURI);
        }
        if ((in = this.openNoMapOrNull(mappedURI)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to locate '" + mappedURI + "'");
            }
            throw new NotFoundException("Not found: " + filenameOrURI);
        }
        if (in.getMimeType() != null) {
            // empty if block
        }
        model.read(in.getInput(), baseURI, syntax);
        try {
            in.getInput().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return model;
    }

    private static String chooseBaseURI(String baseURI) {
        String scheme = FileUtils.getScheme(baseURI);
        if (scheme != null) {
            if (scheme.equals("file") && !baseURI.startsWith("file:///")) {
                try {
                    String tmp = baseURI.substring("file:".length());
                    File f = new File(tmp);
                    baseURI = "file:///" + f.getCanonicalPath();
                    baseURI = baseURI.replace('\\', '/');
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return baseURI;
        }
        if (baseURI.startsWith("/")) {
            return "file://" + baseURI;
        }
        return "file:" + baseURI;
    }

    public InputStream open(String filenameOrURI) {
        if (log.isDebugEnabled()) {
            log.debug("open(" + filenameOrURI + ")");
        }
        String uri = this.mapURI(filenameOrURI);
        if (log.isDebugEnabled() && !uri.equals(filenameOrURI)) {
            log.debug("open: mapped to " + uri);
        }
        return this.openNoMap(uri);
    }

    public String mapURI(String filenameOrURI) {
        if (this.fmMapper == null) {
            return filenameOrURI;
        }
        String uri = this.fmMapper.altMapping(filenameOrURI, null);
        if (uri == null) {
            if (logAllLookups && log.isDebugEnabled()) {
                log.debug("Not mapped: " + filenameOrURI);
            }
            uri = filenameOrURI;
        } else if (log.isDebugEnabled()) {
            log.debug("Mapped: " + filenameOrURI + " => " + uri);
        }
        return uri;
    }

    /*
     * Exception decompiling
     */
    public String readWholeFileAsUTF8(InputStream in) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String readWholeFileAsUTF8(String filename) {
        InputStream in = this.open(filename);
        if (in == null) {
            throw new NotFoundException("File not found: " + filename);
        }
        return this.readWholeFileAsUTF8(in);
    }

    public InputStream openNoMap(String filenameOrURI) {
        TypedStream in = this.openNoMapOrNull(filenameOrURI);
        if (in == null) {
            return null;
        }
        return in.getInput();
    }

    public TypedStream openNoMapOrNull(String filenameOrURI) {
        for (Locator loc : this.fmHandlers) {
            TypedStream in = loc.open(filenameOrURI);
            if (in == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("Found: " + filenameOrURI + " (" + loc.getName() + ")");
            }
            return in;
        }
        return null;
    }

    static {
        JenaSystem.init();
    }
}

