/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.citygml4j.builder.cityjson.CityJSONBuilder;
import org.citygml4j.builder.cityjson.extension.CityJSONExtension;
import org.citygml4j.builder.cityjson.extension.CityJSONExtensionContext;
import org.citygml4j.builder.cityjson.extension.CityJSONExtensionModule;
import org.citygml4j.builder.jaxb.CityGMLBuilder;
import org.citygml4j.builder.jaxb.CityGMLBuilderException;
import org.citygml4j.builder.jaxb.CityGMLBuilderFactory;
import org.citygml4j.cityjson.CityJSONRegistry;
import org.citygml4j.cityjson.extension.ExtensibleType;
import org.citygml4j.cityjson.extension.ExtensionException;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.geometry.SemanticsType;
import org.citygml4j.model.citygml.ade.ADEException;
import org.citygml4j.model.citygml.ade.binding.ADEContext;
import org.citygml4j.model.module.Modules;
import org.citygml4j.model.module.ade.ADEModule;

public class CityGMLContext {
    private static CityGMLContext instance;
    private final Set<ADEContext> adeContexts = ConcurrentHashMap.newKeySet();

    private CityGMLContext() {
    }

    public static synchronized CityGMLContext getInstance() {
        if (instance == null) {
            instance = new CityGMLContext();
        }
        return instance;
    }

    public void registerADEContext(ADEContext adeContext) throws ADEException {
        if (adeContext == null) {
            throw new ADEException("The ADE context must not be null.");
        }
        if (this.adeContexts.contains(adeContext)) {
            return;
        }
        if (adeContext.getModelPackageNames() == null || adeContext.getModelPackageNames().isEmpty()) {
            throw new ADEException("No model package names defined for the ADE context.");
        }
        if (adeContext.getADEModules() == null || adeContext.getADEModules().isEmpty()) {
            throw new ADEException("No ADE module defined for the ADE context.");
        }
        for (ADEModule module : adeContext.getADEModules()) {
            if (module.getNamespaceURI() == null || module.getNamespaceURI().isEmpty()) {
                throw new ADEException("The namespace URI of the ADE module must not be null.");
            }
            if (Modules.getModule(module.getNamespaceURI()) != null) {
                throw new ADEException("A module has already been registered for the namespace '" + module.getNamespaceURI() + "'.");
            }
            for (ADEContext registeredContext : this.adeContexts) {
                for (ADEModule registeredModule : registeredContext.getADEModules()) {
                    for (String packageName : adeContext.getModelPackageNames()) {
                        if (registeredModule.getCityGMLVersion() != module.getCityGMLVersion() || !registeredContext.getModelPackageNames().contains(packageName)) continue;
                        throw new ADEException("An ADE module has already been registered for the package '" + packageName + "' and CityGML version " + module.getCityGMLVersion() + ".");
                    }
                }
            }
            if (module.getJAXBPackageNames() != null && !module.getJAXBPackageNames().isEmpty()) continue;
            throw new ADEException("No JAXB package names defined for ADE module.");
        }
        if (adeContext instanceof CityJSONExtensionContext) {
            CityJSONExtension cityJSONExtension = ((CityJSONExtensionContext)((Object)adeContext)).getCityJSONExtension();
            if (cityJSONExtension == null) {
                throw new ADEException("The CityJSON extension must no be null.");
            }
            try {
                this.registerCityJSONExtension(((CityJSONExtensionContext)((Object)adeContext)).getCityJSONExtension());
            }
            catch (ExtensionException e) {
                throw new ADEException("Failed to register CityJSON extension.", e);
            }
        }
        for (ADEModule module : adeContext.getADEModules()) {
            Modules.registerADEModule(module);
        }
        this.adeContexts.add(adeContext);
    }

    private void registerCityJSONExtension(CityJSONExtension cityJSONExtension) throws ExtensionException {
        if (cityJSONExtension.getExtensionModules() == null || cityJSONExtension.getExtensionModules().isEmpty()) {
            throw new ExtensionException("No extension module defined for the CityJSON extension.");
        }
        CityJSONRegistry registry = CityJSONRegistry.getInstance();
        for (CityJSONExtensionModule module : cityJSONExtension.getExtensionModules()) {
            Map<Class<? extends ExtensibleType>, Map<String, Type>> properties;
            Map<String, Class<? extends SemanticsType>> map;
            Map<String, Class<? extends AbstractCityObjectType>> cityObjects;
            if (module.getSchemaURI() != null) {
                for (ADEContext aDEContext : this.adeContexts) {
                    if (!(aDEContext instanceof CityJSONExtension)) continue;
                    for (CityJSONExtensionModule cityJSONExtensionModule : ((CityJSONExtension)((Object)aDEContext)).getExtensionModules()) {
                        if (!module.getSchemaURI().equals(cityJSONExtensionModule.getSchemaURI())) continue;
                        throw new ExtensionException("A CityJSON extension module has already been registered for the schema URI '" + module.getSchemaURI() + "'.");
                    }
                }
            }
            if ((cityObjects = module.getCityObjects()) != null) {
                for (Object entry : cityObjects.entrySet()) {
                    registry.registerCityObject((String)entry.getKey(), (Class)entry.getValue());
                }
            }
            if ((map = module.getSemanticSurfaces()) != null) {
                Object entry;
                entry = map.entrySet().iterator();
                while (entry.hasNext()) {
                    Map.Entry entry2 = (Map.Entry)entry.next();
                    registry.registerSemanticSurface((String)entry2.getKey(), (Class)entry2.getValue());
                }
            }
            if ((properties = module.getExtensionProperties()) == null) continue;
            for (Map.Entry<Class<? extends ExtensibleType>, Map<String, Type>> entry : properties.entrySet()) {
                for (Map.Entry<String, Type> property : entry.getValue().entrySet()) {
                    registry.registerExtensionProperty(property.getKey(), property.getValue(), entry.getKey());
                }
            }
        }
    }

    public void unregisterADEContext(ADEContext adeContext) {
        for (ADEModule module : adeContext.getADEModules()) {
            Modules.unregisterADEModule(module);
        }
        if (adeContext instanceof CityJSONExtensionContext) {
            this.unregisterCityJSONExtension(((CityJSONExtensionContext)((Object)adeContext)).getCityJSONExtension());
        }
        this.adeContexts.remove(adeContext);
    }

    private void unregisterCityJSONExtension(CityJSONExtension cityJSONExtension) {
        CityJSONRegistry registry = CityJSONRegistry.getInstance();
        for (CityJSONExtensionModule module : cityJSONExtension.getExtensionModules()) {
            Map<Class<? extends ExtensibleType>, Map<String, Type>> map;
            Map<String, Class<? extends SemanticsType>> semanticSurfaces;
            Map<String, Class<? extends AbstractCityObjectType>> cityObjects = module.getCityObjects();
            if (cityObjects != null) {
                for (String string : cityObjects.keySet()) {
                    registry.unregisterCityObject(string);
                }
            }
            if ((semanticSurfaces = module.getSemanticSurfaces()) != null) {
                for (String type2 : semanticSurfaces.keySet()) {
                    registry.unregisterSemanticSurface(type2);
                }
            }
            if ((map = module.getExtensionProperties()) == null) continue;
            for (Map.Entry<Class<? extends ExtensibleType>, Map<String, Type>> entry : map.entrySet()) {
                for (String name : entry.getValue().keySet()) {
                    registry.unregisterExtensionProperty(name, entry.getKey());
                }
            }
        }
    }

    public boolean hasADEContexts() {
        return !this.adeContexts.isEmpty();
    }

    public boolean hasCityJSONExtensionContexts() {
        return this.hasADEContexts() && this.adeContexts.stream().anyMatch(ade -> ade instanceof CityJSONExtensionContext);
    }

    public List<ADEContext> getADEContexts() {
        return new ArrayList<ADEContext>(this.adeContexts);
    }

    public ADEContext getADEContext(String namespaceURI) {
        for (ADEContext adeContext : this.adeContexts) {
            for (ADEModule module : adeContext.getADEModules()) {
                if (!module.getNamespaceURI().equals(namespaceURI)) continue;
                return adeContext;
            }
        }
        return null;
    }

    public CityGMLBuilder createCityGMLBuilder() throws CityGMLBuilderException {
        return CityGMLBuilderFactory.defaults().build();
    }

    public CityGMLBuilder createCityGMLBuilder(ClassLoader classLoader) throws CityGMLBuilderException {
        return CityGMLBuilderFactory.defaults().withClassLoader(classLoader).build();
    }

    public CityGMLBuilder createCityGMLBuilder(String ... packageNames) throws CityGMLBuilderException {
        return CityGMLBuilderFactory.defaults().withPackageNames(packageNames).build();
    }

    public CityGMLBuilder createCityGMLBuilder(ClassLoader classLoader, String ... packageNames) throws CityGMLBuilderException {
        return CityGMLBuilderFactory.defaults().withClassLoader(classLoader).withPackageNames(packageNames).build();
    }

    public CityJSONBuilder createCityJSONBuilder() {
        return new CityJSONBuilder();
    }
}

