/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.marshal.citygml;

import org.citygml4j.builder.cityjson.marshal.CityJSONMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.appearance.AppearanceMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.bridge.BridgeMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.building.BuildingMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.cityfurniture.CityFurnitureMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.cityobjectgroup.CityObjectGroupMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.core.CoreMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.generics.GenericsMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.landuse.LandUseMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.relief.ReliefMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.transportation.TransportationMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.tunnel.TunnelMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.vegetation.VegetationMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.waterbody.WaterBodyMarshaller;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.geometry.SemanticsType;
import org.citygml4j.model.citygml.ade.binding.ADEModelObject;
import org.citygml4j.model.citygml.bridge.BridgeModuleComponent;
import org.citygml4j.model.citygml.building.BuildingModuleComponent;
import org.citygml4j.model.citygml.cityfurniture.CityFurnitureModuleComponent;
import org.citygml4j.model.citygml.cityobjectgroup.CityObjectGroupModuleComponent;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.core.CoreModuleComponent;
import org.citygml4j.model.citygml.generics.GenericsModuleComponent;
import org.citygml4j.model.citygml.landuse.LandUseModuleComponent;
import org.citygml4j.model.citygml.relief.ReliefModuleComponent;
import org.citygml4j.model.citygml.transportation.TransportationModuleComponent;
import org.citygml4j.model.citygml.tunnel.TunnelModuleComponent;
import org.citygml4j.model.citygml.vegetation.VegetationModuleComponent;
import org.citygml4j.model.citygml.waterbody.WaterBodyModuleComponent;
import org.citygml4j.model.common.base.ModelObject;

public class CityGMLMarshaller {
    private final CityJSONMarshaller json;
    private final AppearanceMarshaller app;
    private final BridgeMarshaller brid;
    private final BuildingMarshaller bldg;
    private final CityFurnitureMarshaller frn;
    private final CityObjectGroupMarshaller grp;
    private final CoreMarshaller core;
    private final GenericsMarshaller gen;
    private final LandUseMarshaller luse;
    private final ReliefMarshaller dem;
    private final TransportationMarshaller tran;
    private final TunnelMarshaller tun;
    private final VegetationMarshaller veg;
    private final WaterBodyMarshaller wtr;

    public CityGMLMarshaller(CityJSONMarshaller json) {
        this.json = json;
        this.app = new AppearanceMarshaller(this);
        this.brid = new BridgeMarshaller(this);
        this.bldg = new BuildingMarshaller(this);
        this.frn = new CityFurnitureMarshaller(this);
        this.grp = new CityObjectGroupMarshaller(this);
        this.core = new CoreMarshaller(this);
        this.gen = new GenericsMarshaller(this);
        this.luse = new LandUseMarshaller(this);
        this.dem = new ReliefMarshaller(this);
        this.tran = new TransportationMarshaller(this);
        this.tun = new TunnelMarshaller(this);
        this.veg = new VegetationMarshaller(this);
        this.wtr = new WaterBodyMarshaller(this);
    }

    public AbstractCityObjectType marshal(ModelObject src, CityJSON cityJSON) {
        AbstractCityObjectType dest = null;
        if (src instanceof ADEModelObject) {
            dest = this.json.getADEMarshaller().marshalCityObject((ADEModelObject)src, cityJSON);
        } else if (src instanceof BridgeModuleComponent) {
            dest = this.brid.marshal(src, cityJSON);
        } else if (src instanceof BuildingModuleComponent) {
            dest = this.bldg.marshal(src, cityJSON);
        } else if (src instanceof CityFurnitureModuleComponent) {
            dest = this.frn.marshal(src, cityJSON);
        } else if (src instanceof GenericsModuleComponent) {
            dest = this.gen.marshal(src, cityJSON);
        } else if (src instanceof LandUseModuleComponent) {
            dest = this.luse.marshal(src, cityJSON);
        } else if (src instanceof ReliefModuleComponent) {
            dest = this.dem.marshal(src, cityJSON);
        } else if (src instanceof TransportationModuleComponent) {
            dest = this.tran.marshal(src, cityJSON);
        } else if (src instanceof TunnelModuleComponent) {
            dest = this.tun.marshal(src, cityJSON);
        } else if (src instanceof VegetationModuleComponent) {
            dest = this.veg.marshal(src, cityJSON);
        } else if (src instanceof WaterBodyModuleComponent) {
            dest = this.wtr.marshal(src, cityJSON);
        } else if (src instanceof CityObjectGroupModuleComponent) {
            dest = this.grp.marshal(src, cityJSON);
        } else if (src instanceof CoreModuleComponent) {
            dest = this.core.marshal(src, cityJSON);
        }
        return dest;
    }

    public SemanticsType marshalSemantics(AbstractCityObject cityObject) {
        SemanticsType semantics = null;
        if (cityObject instanceof ADEModelObject) {
            semantics = this.json.getADEMarshaller().marshalSemanticSurface((ADEModelObject)((Object)cityObject));
        } else if (cityObject instanceof BridgeModuleComponent) {
            semantics = this.brid.marshalSemantics(cityObject);
        } else if (cityObject instanceof BuildingModuleComponent) {
            semantics = this.bldg.marshalSemantics(cityObject);
        } else if (cityObject instanceof TransportationModuleComponent) {
            semantics = this.tran.marshalSemantics(cityObject);
        } else if (cityObject instanceof TunnelModuleComponent) {
            semantics = this.tun.marshalSemantics(cityObject);
        } else if (cityObject instanceof WaterBodyModuleComponent) {
            semantics = this.wtr.marshalSemantics(cityObject);
        }
        return semantics;
    }

    public AppearanceMarshaller getAppearanceMarshaller() {
        return this.app;
    }

    public BridgeMarshaller getBridgeMarshaller() {
        return this.brid;
    }

    public BuildingMarshaller getBuildingMarshaller() {
        return this.bldg;
    }

    public CoreMarshaller getCoreMarshaller() {
        return this.core;
    }

    public CityFurnitureMarshaller getCityFurnitureMarshaller() {
        return this.frn;
    }

    public CityObjectGroupMarshaller getCityObjectGroupMarshaller() {
        return this.grp;
    }

    public GenericsMarshaller getGenericsMarshaller() {
        return this.gen;
    }

    public LandUseMarshaller getLandUseMarshaller() {
        return this.luse;
    }

    public ReliefMarshaller getReliefMarshaller() {
        return this.dem;
    }

    public TransportationMarshaller getTransportationMarshaller() {
        return this.tran;
    }

    public TunnelMarshaller getTunnelMarshaller() {
        return this.tun;
    }

    public VegetationMarshaller getVegetationMarshaller() {
        return this.veg;
    }

    public WaterBodyMarshaller getWaterBodyMarshaller() {
        return this.wtr;
    }

    public CityJSONMarshaller getCityJSONMarshaller() {
        return this.json;
    }
}

