/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.marshal.citygml.building;

import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.citygml4j.builder.cityjson.marshal.CityJSONMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.CityGMLMarshaller;
import org.citygml4j.builder.cityjson.marshal.util.DuplicateGeometryRemover;
import org.citygml4j.builder.cityjson.marshal.util.SemanticSurfaceCollector;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.feature.AbstractBuildingType;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.feature.Attributes;
import org.citygml4j.cityjson.feature.BuildingAttributes;
import org.citygml4j.cityjson.feature.BuildingInstallationType;
import org.citygml4j.cityjson.feature.BuildingPartType;
import org.citygml4j.cityjson.feature.BuildingType;
import org.citygml4j.cityjson.geometry.AbstractGeometryObjectType;
import org.citygml4j.cityjson.geometry.AbstractGeometryType;
import org.citygml4j.cityjson.geometry.SemanticsType;
import org.citygml4j.model.citygml.building.AbstractBoundarySurface;
import org.citygml4j.model.citygml.building.AbstractBuilding;
import org.citygml4j.model.citygml.building.BoundarySurfaceProperty;
import org.citygml4j.model.citygml.building.Building;
import org.citygml4j.model.citygml.building.BuildingInstallation;
import org.citygml4j.model.citygml.building.BuildingInstallationProperty;
import org.citygml4j.model.citygml.building.BuildingPart;
import org.citygml4j.model.citygml.building.BuildingPartProperty;
import org.citygml4j.model.citygml.building.ClosureSurface;
import org.citygml4j.model.citygml.building.Door;
import org.citygml4j.model.citygml.building.GroundSurface;
import org.citygml4j.model.citygml.building.OuterCeilingSurface;
import org.citygml4j.model.citygml.building.OuterFloorSurface;
import org.citygml4j.model.citygml.building.RoofSurface;
import org.citygml4j.model.citygml.building.WallSurface;
import org.citygml4j.model.citygml.building.Window;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.core.AddressProperty;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.model.gml.basicTypes.DoubleOrNull;
import org.citygml4j.model.gml.geometry.aggregates.MultiSurfaceProperty;
import org.citygml4j.util.mapper.BiFunctionTypeMapper;

public class BuildingMarshaller {
    private final ReentrantLock lock = new ReentrantLock();
    private final CityJSONMarshaller json;
    private final CityGMLMarshaller citygml;
    private BiFunctionTypeMapper<CityJSON, AbstractCityObjectType> typeMapper;

    public BuildingMarshaller(CityGMLMarshaller citygml) {
        this.citygml = citygml;
        this.json = citygml.getCityJSONMarshaller();
    }

    private BiFunctionTypeMapper<CityJSON, AbstractCityObjectType> getTypeMapper() {
        if (this.typeMapper == null) {
            this.lock.lock();
            try {
                if (this.typeMapper == null) {
                    this.typeMapper = BiFunctionTypeMapper.create().with(Building.class, this::marshalBuilding).with(BuildingPart.class, this::marshalBuildingPart).with(BuildingInstallation.class, this::marshalBuildingInstallation);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.typeMapper;
    }

    public AbstractCityObjectType marshal(ModelObject src, CityJSON cityJSON) {
        return this.getTypeMapper().apply(src, cityJSON);
    }

    public SemanticsType marshalSemantics(AbstractCityObject cityObject) {
        SemanticsType semantics = null;
        if (cityObject instanceof RoofSurface) {
            semantics = new SemanticsType("RoofSurface");
        } else if (cityObject instanceof GroundSurface) {
            semantics = new SemanticsType("GroundSurface");
        } else if (cityObject instanceof WallSurface) {
            semantics = new SemanticsType("WallSurface");
        } else if (cityObject instanceof ClosureSurface) {
            semantics = new SemanticsType("ClosureSurface");
        } else if (cityObject instanceof OuterCeilingSurface) {
            semantics = new SemanticsType("OuterCeilingSurface");
        } else if (cityObject instanceof OuterFloorSurface) {
            semantics = new SemanticsType("OuterFloorSurface");
        } else if (cityObject instanceof Window) {
            semantics = new SemanticsType("Window");
        } else if (cityObject instanceof Door) {
            semantics = new SemanticsType("Door");
        }
        if (semantics != null) {
            this.citygml.getCoreMarshaller().marshalSemanticSurfaceAttributes(cityObject, semantics);
        }
        return semantics;
    }

    public void marshalAbstractBuilding(AbstractBuilding src, AbstractBuildingType dest, CityJSON cityJSON) {
        AbstractCityObjectType cityObject;
        AbstractGeometryObjectType geometry;
        MultiSurfaceProperty lod0Representation;
        this.citygml.getCoreMarshaller().marshalAbstractSite(src, dest, cityJSON);
        BuildingAttributes attributes = dest.getAttributes();
        if (src.isSetClazz()) {
            attributes.setClazz(src.getClazz().getValue());
        }
        if (src.isSetFunction()) {
            for (Code function : src.getFunction()) {
                if (!function.isSetValue()) continue;
                attributes.setFunction(function.getValue());
                break;
            }
        }
        if (src.isSetUsage()) {
            for (Code usage : src.getUsage()) {
                if (!usage.isSetValue()) continue;
                attributes.setUsage(usage.getValue());
                break;
            }
        }
        if (src.isSetMeasuredHeight()) {
            attributes.setMeasuredHeight(src.getMeasuredHeight().getValue());
        }
        if (src.isSetRoofType()) {
            attributes.setRoofType(src.getRoofType().getValue());
        }
        if (src.isSetStoreysAboveGround()) {
            attributes.setStoreysAboveGround(src.getStoreysAboveGround());
        }
        if (src.isSetStoreysBelowGround()) {
            attributes.setStoreysBelowGround(src.getStoreysBelowGround());
        }
        if (src.isSetStoreyHeightsAboveGround()) {
            for (DoubleOrNull value : src.getStoreyHeightsAboveGround().getDoubleOrNull()) {
                if (!value.isSetDouble()) continue;
                attributes.addStoreyHeightsAboveGround(value.getDouble());
            }
        }
        if (src.isSetStoreyHeightsBelowGround()) {
            for (DoubleOrNull value : src.getStoreyHeightsBelowGround().getDoubleOrNull()) {
                if (!value.isSetDouble()) continue;
                attributes.addStoreyHeightsBelowGround(value.getDouble());
            }
        }
        if (src.isSetYearOfConstruction()) {
            attributes.setYearOfConstruction(src.getYearOfConstruction().getYear());
        }
        if (src.isSetYearOfDemolition()) {
            attributes.setYearOfDemolition(src.getYearOfDemolition().getYear());
        }
        if (src.isSetGenericApplicationPropertyOfAbstractBuilding()) {
            this.json.getADEMarshaller().marshal(src.getGenericApplicationPropertyOfAbstractBuilding(), dest, cityJSON);
        }
        SemanticSurfaceCollector collector = null;
        if (src.isSetBoundedBySurface()) {
            collector = this.preprocessGeometry(src);
        }
        MultiSurfaceProperty multiSurfaceProperty = lod0Representation = src.isSetLod0FootPrint() ? src.getLod0FootPrint() : src.getLod0RoofEdge();
        if (lod0Representation != null && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(lod0Representation)) != null) {
            geometry.setLod(0);
            dest.addGeometry(geometry);
        }
        if (src.isSetLod1MultiSurface() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod1MultiSurface())) != null) {
            geometry.setLod(1);
            dest.addGeometry(geometry);
        }
        if (src.isSetLod2MultiSurface() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod2MultiSurface())) != null) {
            geometry.setLod(2);
            dest.addGeometry(geometry);
        }
        if (src.isSetLod3MultiSurface() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod3MultiSurface())) != null) {
            geometry.setLod(3);
            dest.addGeometry(geometry);
        }
        if (src.isSetLod1Solid() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod1Solid())) != null) {
            geometry.setLod(1);
            dest.addGeometry(geometry);
        }
        if (src.isSetLod2Solid() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod2Solid())) != null) {
            geometry.setLod(2);
            dest.addGeometry(geometry);
        }
        if (src.isSetLod3Solid() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod3Solid())) != null) {
            geometry.setLod(3);
            dest.addGeometry(geometry);
        }
        DuplicateGeometryRemover remover = null;
        if (this.json.isRemoveDuplicateChildGeometries()) {
            remover = new DuplicateGeometryRemover(dest);
        }
        if (src.isSetOuterBuildingInstallation()) {
            for (BuildingInstallationProperty buildingInstallationProperty : src.getOuterBuildingInstallation()) {
                cityObject = this.json.getGMLMarshaller().marshalFeatureProperty(buildingInstallationProperty, cityJSON);
                if (!(cityObject instanceof BuildingInstallationType)) continue;
                if (remover != null) {
                    remover.removeDuplicateGeometries(cityObject);
                    if (!cityObject.isSetGeometry()) continue;
                }
                dest.addChild(cityObject);
                cityJSON.addCityObject(cityObject);
            }
        }
        if (dest instanceof BuildingType && src.isSetConsistsOfBuildingPart()) {
            for (BuildingPartProperty buildingPartProperty : src.getConsistsOfBuildingPart()) {
                cityObject = this.json.getGMLMarshaller().marshalFeatureProperty(buildingPartProperty, cityJSON);
                if (!(cityObject instanceof BuildingPartType)) continue;
                if (remover != null) {
                    remover.removeDuplicateGeometries(cityObject);
                    if (!cityObject.isSetGeometry()) continue;
                }
                dest.addChild(cityObject);
                cityJSON.addCityObject(cityObject);
            }
        }
        if (src.isSetAddress()) {
            for (AddressProperty addressProperty : src.getAddress()) {
                if (!addressProperty.isSetAddress()) continue;
                dest.setAddress(this.citygml.getCoreMarshaller().marshalAddress(addressProperty.getAddress()));
                break;
            }
        }
        if (collector != null) {
            this.postprocessGeometry(src, collector);
        }
    }

    public void marshalBuilding(Building src, BuildingType dest, CityJSON cityJSON) {
        this.marshalAbstractBuilding(src, dest, cityJSON);
        if (src.isSetGenericApplicationPropertyOfBuilding()) {
            this.json.getADEMarshaller().marshal(src.getGenericApplicationPropertyOfBuilding(), dest, cityJSON);
        }
    }

    public BuildingType marshalBuilding(Building src, CityJSON cityJSON) {
        BuildingType dest = new BuildingType();
        this.marshalBuilding(src, dest, cityJSON);
        return dest;
    }

    public void marshalBuildingPart(BuildingPart src, BuildingPartType dest, CityJSON cityJSON) {
        this.marshalAbstractBuilding(src, dest, cityJSON);
        if (src.isSetGenericApplicationPropertyOfBuildingPart()) {
            this.json.getADEMarshaller().marshal(src.getGenericApplicationPropertyOfBuildingPart(), dest, cityJSON);
        }
    }

    public BuildingPartType marshalBuildingPart(BuildingPart src, CityJSON cityJSON) {
        BuildingPartType dest = new BuildingPartType();
        this.marshalBuildingPart(src, dest, cityJSON);
        return dest;
    }

    public void marshalBuildingInstallation(BuildingInstallation src, BuildingInstallationType dest, CityJSON cityJSON) {
        AbstractGeometryType geometry;
        this.citygml.getCoreMarshaller().marshalAbstractCityObject(src, dest, cityJSON);
        Attributes attributes = dest.getAttributes();
        if (src.isSetClazz()) {
            attributes.setClazz(src.getClazz().getValue());
        }
        if (src.isSetFunction()) {
            for (Code function : src.getFunction()) {
                if (!function.isSetValue()) continue;
                attributes.setFunction(function.getValue());
                break;
            }
        }
        if (src.isSetUsage()) {
            for (Code usage : src.getUsage()) {
                if (!usage.isSetValue()) continue;
                attributes.setUsage(usage.getValue());
                break;
            }
        }
        if (src.isSetGenericApplicationPropertyOfBuildingInstallation()) {
            this.json.getADEMarshaller().marshal(src.getGenericApplicationPropertyOfBuildingInstallation(), dest, cityJSON);
        }
        SemanticSurfaceCollector collector = null;
        if (src.isSetBoundedBySurface()) {
            collector = this.preprocessGeometry(src);
        }
        if (src.isSetLod2Geometry() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod2Geometry())) != null) {
            geometry.setLod(2);
            dest.addGeometry(geometry);
        }
        if (src.isSetLod3Geometry() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod3Geometry())) != null) {
            geometry.setLod(3);
            dest.addGeometry(geometry);
        }
        if (src.isSetLod2ImplicitRepresentation() && (geometry = this.citygml.getCoreMarshaller().marshalImplicitRepresentationProperty(src.getLod2ImplicitRepresentation(), 2)) != null) {
            dest.addGeometry(geometry);
        }
        if (src.isSetLod3ImplicitRepresentation() && (geometry = this.citygml.getCoreMarshaller().marshalImplicitRepresentationProperty(src.getLod3ImplicitRepresentation(), 3)) != null) {
            dest.addGeometry(geometry);
        }
        if (collector != null) {
            this.postprocessGeometry(src, collector);
        }
    }

    public BuildingInstallationType marshalBuildingInstallation(BuildingInstallation src, CityJSON cityJSON) {
        BuildingInstallationType dest = new BuildingInstallationType();
        this.marshalBuildingInstallation(src, dest, cityJSON);
        return dest;
    }

    private SemanticSurfaceCollector preprocessGeometry(AbstractBuilding src) {
        SemanticSurfaceCollector collector = this.collectBoundarySurfaces(src, src.getBoundedBySurface());
        for (int lod = 2; lod < 4; ++lod) {
            if (!collector.hasSurfaces(lod)) continue;
            if (lod == 2) {
                collector.assignSurfaces(src::getLod2MultiSurface, src::setLod2MultiSurface, lod);
                continue;
            }
            collector.assignSurfaces(src::getLod3MultiSurface, src::setLod3MultiSurface, lod);
        }
        return collector;
    }

    private void postprocessGeometry(AbstractBuilding src, SemanticSurfaceCollector collector) {
        for (int lod = 2; lod < 4; ++lod) {
            if (!collector.hasSurfaces(lod)) continue;
            if (lod == 2) {
                collector.clean(src::getLod2MultiSurface, src::unsetLod2MultiSurface);
                continue;
            }
            collector.clean(src::getLod3MultiSurface, src::unsetLod3MultiSurface);
        }
    }

    private SemanticSurfaceCollector preprocessGeometry(BuildingInstallation src) {
        SemanticSurfaceCollector collector = this.collectBoundarySurfaces(src, src.getBoundedBySurface());
        for (int lod = 2; lod < 4; ++lod) {
            if (!collector.hasSurfaces(lod)) continue;
            if (lod == 2) {
                collector.assignSurfaces(src::getLod2Geometry, src::setLod2Geometry, lod);
                continue;
            }
            collector.assignSurfaces(src::getLod3Geometry, src::setLod3Geometry, lod);
        }
        return collector;
    }

    private void postprocessGeometry(BuildingInstallation src, SemanticSurfaceCollector collector) {
        for (int lod = 2; lod < 4; ++lod) {
            if (!collector.hasSurfaces(lod)) continue;
            if (lod == 2) {
                collector.clean(src::getLod2Geometry, src::unsetLod2Geometry);
                continue;
            }
            collector.clean(src::getLod3Geometry, src::unsetLod3Geometry);
        }
    }

    private SemanticSurfaceCollector collectBoundarySurfaces(AbstractCityObject cityObject, List<BoundarySurfaceProperty> boundaryProperties) {
        SemanticSurfaceCollector collector = new SemanticSurfaceCollector(cityObject);
        for (BoundarySurfaceProperty boundaryProperty : boundaryProperties) {
            if (!boundaryProperty.isSetBoundarySurface()) continue;
            AbstractBoundarySurface boundarySurface = boundaryProperty.getBoundarySurface();
            collector.collectSurfaces(boundarySurface, 2, 3);
            collector.collectSurfaces(boundarySurface.getOpening(), 2, 3);
        }
        return collector;
    }
}

