/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.marshal.citygml.cityfurniture;

import org.citygml4j.builder.cityjson.marshal.CityJSONMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.CityGMLMarshaller;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.feature.Attributes;
import org.citygml4j.cityjson.feature.CityFurnitureType;
import org.citygml4j.cityjson.geometry.AbstractGeometryType;
import org.citygml4j.model.citygml.cityfurniture.CityFurniture;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.gml.basicTypes.Code;

public class CityFurnitureMarshaller {
    private final CityJSONMarshaller json;
    private final CityGMLMarshaller citygml;

    public CityFurnitureMarshaller(CityGMLMarshaller citygml) {
        this.citygml = citygml;
        this.json = citygml.getCityJSONMarshaller();
    }

    public AbstractCityObjectType marshal(ModelObject src, CityJSON cityJSON) {
        if (src instanceof CityFurniture) {
            return this.marshalCityFurniture((CityFurniture)src, cityJSON);
        }
        return null;
    }

    public void marshalCityFurniture(CityFurniture src, CityFurnitureType dest, CityJSON cityJSON) {
        AbstractGeometryType geometry;
        this.citygml.getCoreMarshaller().marshalAbstractCityObject(src, dest, cityJSON);
        Attributes attributes = dest.getAttributes();
        if (src.isSetClazz()) {
            attributes.setClazz(src.getClazz().getValue());
        }
        if (src.isSetFunction()) {
            for (Code function : src.getFunction()) {
                if (!function.isSetValue()) continue;
                attributes.setFunction(function.getValue());
                break;
            }
        }
        if (src.isSetUsage()) {
            for (Code usage : src.getUsage()) {
                if (!usage.isSetValue()) continue;
                attributes.setUsage(usage.getValue());
                break;
            }
        }
        if (src.isSetGenericApplicationPropertyOfCityFurniture()) {
            this.json.getADEMarshaller().marshal(src.getGenericApplicationPropertyOfCityFurniture(), dest, cityJSON);
        }
        if (src.isSetLod1Geometry() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod1Geometry())) != null) {
            geometry.setLod(1);
            dest.addGeometry(geometry);
        }
        if (src.isSetLod2Geometry() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod2Geometry())) != null) {
            geometry.setLod(2);
            dest.addGeometry(geometry);
        }
        if (src.isSetLod3Geometry() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod3Geometry())) != null) {
            geometry.setLod(3);
            dest.addGeometry(geometry);
        }
        if (src.isSetLod1ImplicitRepresentation() && (geometry = this.citygml.getCoreMarshaller().marshalImplicitRepresentationProperty(src.getLod1ImplicitRepresentation(), 1)) != null) {
            dest.addGeometry(geometry);
        }
        if (src.isSetLod2ImplicitRepresentation() && (geometry = this.citygml.getCoreMarshaller().marshalImplicitRepresentationProperty(src.getLod2ImplicitRepresentation(), 2)) != null) {
            dest.addGeometry(geometry);
        }
        if (src.isSetLod3ImplicitRepresentation() && (geometry = this.citygml.getCoreMarshaller().marshalImplicitRepresentationProperty(src.getLod3ImplicitRepresentation(), 3)) != null) {
            dest.addGeometry(geometry);
        }
    }

    public CityFurnitureType marshalCityFurniture(CityFurniture src, CityJSON cityJSON) {
        CityFurnitureType dest = new CityFurnitureType();
        this.marshalCityFurniture(src, dest, cityJSON);
        return dest;
    }
}

