/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.marshal.citygml.tunnel;

import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.citygml4j.builder.cityjson.marshal.CityJSONMarshaller;
import org.citygml4j.builder.cityjson.marshal.citygml.CityGMLMarshaller;
import org.citygml4j.builder.cityjson.marshal.util.DuplicateGeometryRemover;
import org.citygml4j.builder.cityjson.marshal.util.SemanticSurfaceCollector;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.feature.AbstractTunnelType;
import org.citygml4j.cityjson.feature.Attributes;
import org.citygml4j.cityjson.feature.TunnelAttributes;
import org.citygml4j.cityjson.feature.TunnelInstallationType;
import org.citygml4j.cityjson.feature.TunnelPartType;
import org.citygml4j.cityjson.feature.TunnelType;
import org.citygml4j.cityjson.geometry.AbstractGeometryObjectType;
import org.citygml4j.cityjson.geometry.AbstractGeometryType;
import org.citygml4j.cityjson.geometry.SemanticsType;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.tunnel.AbstractBoundarySurface;
import org.citygml4j.model.citygml.tunnel.AbstractTunnel;
import org.citygml4j.model.citygml.tunnel.BoundarySurfaceProperty;
import org.citygml4j.model.citygml.tunnel.ClosureSurface;
import org.citygml4j.model.citygml.tunnel.Door;
import org.citygml4j.model.citygml.tunnel.GroundSurface;
import org.citygml4j.model.citygml.tunnel.OuterCeilingSurface;
import org.citygml4j.model.citygml.tunnel.OuterFloorSurface;
import org.citygml4j.model.citygml.tunnel.RoofSurface;
import org.citygml4j.model.citygml.tunnel.Tunnel;
import org.citygml4j.model.citygml.tunnel.TunnelInstallation;
import org.citygml4j.model.citygml.tunnel.TunnelInstallationProperty;
import org.citygml4j.model.citygml.tunnel.TunnelPart;
import org.citygml4j.model.citygml.tunnel.TunnelPartProperty;
import org.citygml4j.model.citygml.tunnel.WallSurface;
import org.citygml4j.model.citygml.tunnel.Window;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.util.mapper.BiFunctionTypeMapper;

public class TunnelMarshaller {
    private final ReentrantLock lock = new ReentrantLock();
    private final CityJSONMarshaller json;
    private final CityGMLMarshaller citygml;
    private BiFunctionTypeMapper<CityJSON, AbstractCityObjectType> typeMapper;

    public TunnelMarshaller(CityGMLMarshaller citygml) {
        this.citygml = citygml;
        this.json = citygml.getCityJSONMarshaller();
    }

    private BiFunctionTypeMapper<CityJSON, AbstractCityObjectType> getTypeMapper() {
        if (this.typeMapper == null) {
            this.lock.lock();
            try {
                if (this.typeMapper == null) {
                    this.typeMapper = BiFunctionTypeMapper.create().with(Tunnel.class, this::marshalTunnel).with(TunnelPart.class, this::marshalTunnelPart).with(TunnelInstallation.class, this::marshalTunnelInstallation);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.typeMapper;
    }

    public AbstractCityObjectType marshal(ModelObject src, CityJSON cityJSON) {
        return this.getTypeMapper().apply(src, cityJSON);
    }

    public SemanticsType marshalSemantics(AbstractCityObject cityObject) {
        SemanticsType semantics = null;
        if (cityObject instanceof RoofSurface) {
            semantics = new SemanticsType("RoofSurface");
        } else if (cityObject instanceof GroundSurface) {
            semantics = new SemanticsType("GroundSurface");
        } else if (cityObject instanceof WallSurface) {
            semantics = new SemanticsType("WallSurface");
        } else if (cityObject instanceof ClosureSurface) {
            semantics = new SemanticsType("ClosureSurface");
        } else if (cityObject instanceof OuterCeilingSurface) {
            semantics = new SemanticsType("OuterCeilingSurface");
        } else if (cityObject instanceof OuterFloorSurface) {
            semantics = new SemanticsType("OuterFloorSurface");
        } else if (cityObject instanceof Window) {
            semantics = new SemanticsType("Window");
        } else if (cityObject instanceof Door) {
            semantics = new SemanticsType("Door");
        }
        if (semantics != null) {
            this.citygml.getGenericsMarshaller().marshalGenericAttributes(cityObject, semantics);
        }
        return semantics;
    }

    public void marshalAbstractTunnel(AbstractTunnel src, AbstractTunnelType dest, CityJSON cityJSON) {
        AbstractCityObjectType cityObject;
        AbstractGeometryObjectType geometry;
        this.citygml.getCoreMarshaller().marshalAbstractSite(src, dest, cityJSON);
        TunnelAttributes attributes = dest.getAttributes();
        if (src.isSetClazz()) {
            attributes.setClazz(src.getClazz().getValue());
        }
        if (src.isSetFunction()) {
            for (Code function : src.getFunction()) {
                if (!function.isSetValue()) continue;
                attributes.setFunction(function.getValue());
                break;
            }
        }
        if (src.isSetUsage()) {
            for (Code usage : src.getUsage()) {
                if (!usage.isSetValue()) continue;
                attributes.setUsage(usage.getValue());
                break;
            }
        }
        if (src.isSetYearOfConstruction()) {
            attributes.setYearOfConstruction(src.getYearOfConstruction().getYear());
        }
        if (src.isSetYearOfDemolition()) {
            attributes.setYearOfDemolition(src.getYearOfDemolition().getYear());
        }
        if (src.isSetGenericApplicationPropertyOfAbstractTunnel()) {
            this.json.getADEMarshaller().marshal(src.getGenericApplicationPropertyOfAbstractTunnel(), dest, cityJSON);
        }
        SemanticSurfaceCollector collector = null;
        if (src.isSetBoundedBySurface()) {
            collector = this.preprocessGeometry(src);
        }
        if (src.isSetLod1MultiSurface() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod1MultiSurface())) != null) {
            geometry.setLod(1);
            dest.addGeometry(geometry);
        }
        if (src.isSetLod2MultiSurface() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod2MultiSurface())) != null) {
            geometry.setLod(2);
            dest.addGeometry(geometry);
        }
        if (src.isSetLod3MultiSurface() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod3MultiSurface())) != null) {
            geometry.setLod(3);
            dest.addGeometry(geometry);
        }
        if (src.isSetLod1Solid() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod1Solid())) != null) {
            geometry.setLod(1);
            dest.addGeometry(geometry);
        }
        if (src.isSetLod2Solid() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod2Solid())) != null) {
            geometry.setLod(2);
            dest.addGeometry(geometry);
        }
        if (src.isSetLod3Solid() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod3Solid())) != null) {
            geometry.setLod(3);
            dest.addGeometry(geometry);
        }
        DuplicateGeometryRemover remover = null;
        if (this.json.isRemoveDuplicateChildGeometries()) {
            remover = new DuplicateGeometryRemover(dest);
        }
        if (src.isSetOuterTunnelInstallation()) {
            for (TunnelInstallationProperty tunnelInstallationProperty : src.getOuterTunnelInstallation()) {
                cityObject = this.json.getGMLMarshaller().marshalFeatureProperty(tunnelInstallationProperty, cityJSON);
                if (!(cityObject instanceof TunnelInstallationType)) continue;
                if (remover != null) {
                    remover.removeDuplicateGeometries(cityObject);
                    if (!cityObject.isSetGeometry()) continue;
                }
                dest.addChild(cityObject);
                cityJSON.addCityObject(cityObject);
            }
        }
        if (dest instanceof TunnelType && src.isSetConsistsOfTunnelPart()) {
            for (TunnelPartProperty tunnelPartProperty : src.getConsistsOfTunnelPart()) {
                cityObject = this.json.getGMLMarshaller().marshalFeatureProperty(tunnelPartProperty, cityJSON);
                if (!(cityObject instanceof TunnelPartType)) continue;
                if (remover != null) {
                    remover.removeDuplicateGeometries(cityObject);
                    if (!cityObject.isSetGeometry()) continue;
                }
                dest.addChild(cityObject);
                cityJSON.addCityObject(cityObject);
            }
        }
        if (collector != null) {
            this.postprocessGeometry(src, collector);
        }
    }

    public void marshalTunnel(Tunnel src, TunnelType dest, CityJSON cityJSON) {
        this.marshalAbstractTunnel(src, dest, cityJSON);
        if (src.isSetGenericApplicationPropertyOfTunnel()) {
            this.json.getADEMarshaller().marshal(src.getGenericApplicationPropertyOfTunnel(), dest, cityJSON);
        }
    }

    public TunnelType marshalTunnel(Tunnel src, CityJSON cityJSON) {
        TunnelType dest = new TunnelType();
        this.marshalTunnel(src, dest, cityJSON);
        return dest;
    }

    public void marshalTunnelPart(TunnelPart src, TunnelPartType dest, CityJSON cityJSON) {
        this.marshalAbstractTunnel(src, dest, cityJSON);
        if (src.isSetGenericApplicationPropertyOfTunnelPart()) {
            this.json.getADEMarshaller().marshal(src.getGenericApplicationPropertyOfTunnelPart(), dest, cityJSON);
        }
    }

    public TunnelPartType marshalTunnelPart(TunnelPart src, CityJSON cityJSON) {
        TunnelPartType dest = new TunnelPartType();
        this.marshalTunnelPart(src, dest, cityJSON);
        return dest;
    }

    public void marshalTunnelInstallation(TunnelInstallation src, TunnelInstallationType dest, CityJSON cityJSON) {
        AbstractGeometryType geometry;
        this.citygml.getCoreMarshaller().marshalAbstractCityObject(src, dest, cityJSON);
        Attributes attributes = dest.getAttributes();
        if (src.isSetClazz()) {
            attributes.setClazz(src.getClazz().getValue());
        }
        if (src.isSetFunction()) {
            for (Code function : src.getFunction()) {
                if (!function.isSetValue()) continue;
                attributes.setFunction(function.getValue());
                break;
            }
        }
        if (src.isSetUsage()) {
            for (Code usage : src.getUsage()) {
                if (!usage.isSetValue()) continue;
                attributes.setUsage(usage.getValue());
                break;
            }
        }
        if (src.isSetGenericApplicationPropertyOfTunnelInstallation()) {
            this.json.getADEMarshaller().marshal(src.getGenericApplicationPropertyOfTunnelInstallation(), dest, cityJSON);
        }
        SemanticSurfaceCollector collector = null;
        if (src.isSetBoundedBySurface()) {
            collector = this.preprocessGeometry(src);
        }
        if (src.isSetLod2Geometry() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod2Geometry())) != null) {
            geometry.setLod(2);
            dest.addGeometry(geometry);
        }
        if (src.isSetLod3Geometry() && (geometry = this.json.getGMLMarshaller().marshalGeometryProperty(src.getLod3Geometry())) != null) {
            geometry.setLod(3);
            dest.addGeometry(geometry);
        }
        if (src.isSetLod2ImplicitRepresentation() && (geometry = this.citygml.getCoreMarshaller().marshalImplicitRepresentationProperty(src.getLod2ImplicitRepresentation(), 2)) != null) {
            dest.addGeometry(geometry);
        }
        if (src.isSetLod3ImplicitRepresentation() && (geometry = this.citygml.getCoreMarshaller().marshalImplicitRepresentationProperty(src.getLod3ImplicitRepresentation(), 3)) != null) {
            dest.addGeometry(geometry);
        }
        if (collector != null) {
            this.postprocessGeometry(src, collector);
        }
    }

    public TunnelInstallationType marshalTunnelInstallation(TunnelInstallation src, CityJSON cityJSON) {
        TunnelInstallationType dest = new TunnelInstallationType();
        this.marshalTunnelInstallation(src, dest, cityJSON);
        return dest;
    }

    private SemanticSurfaceCollector preprocessGeometry(AbstractTunnel src) {
        SemanticSurfaceCollector collector = this.collectBoundarySurfaces(src, src.getBoundedBySurface());
        for (int lod = 2; lod < 4; ++lod) {
            if (!collector.hasSurfaces(lod)) continue;
            if (lod == 2) {
                collector.assignSurfaces(src::getLod2MultiSurface, src::setLod2MultiSurface, lod);
                continue;
            }
            collector.assignSurfaces(src::getLod3MultiSurface, src::setLod3MultiSurface, lod);
        }
        return collector;
    }

    private void postprocessGeometry(AbstractTunnel src, SemanticSurfaceCollector collector) {
        for (int lod = 2; lod < 4; ++lod) {
            if (!collector.hasSurfaces(lod)) continue;
            if (lod == 2) {
                collector.clean(src::getLod2MultiSurface, src::unsetLod2MultiSurface);
                continue;
            }
            collector.clean(src::getLod3MultiSurface, src::unsetLod3MultiSurface);
        }
    }

    private SemanticSurfaceCollector preprocessGeometry(TunnelInstallation src) {
        SemanticSurfaceCollector collector = this.collectBoundarySurfaces(src, src.getBoundedBySurface());
        for (int lod = 2; lod < 4; ++lod) {
            if (!collector.hasSurfaces(lod)) continue;
            if (lod == 2) {
                collector.assignSurfaces(src::getLod2Geometry, src::setLod2Geometry, lod);
                continue;
            }
            collector.assignSurfaces(src::getLod3Geometry, src::setLod3Geometry, lod);
        }
        return collector;
    }

    private void postprocessGeometry(TunnelInstallation src, SemanticSurfaceCollector collector) {
        for (int lod = 2; lod < 4; ++lod) {
            if (!collector.hasSurfaces(lod)) continue;
            if (lod == 2) {
                collector.clean(src::getLod2Geometry, src::unsetLod2Geometry);
                continue;
            }
            collector.clean(src::getLod3Geometry, src::unsetLod3Geometry);
        }
    }

    private SemanticSurfaceCollector collectBoundarySurfaces(AbstractCityObject cityObject, List<BoundarySurfaceProperty> boundaryProperties) {
        SemanticSurfaceCollector collector = new SemanticSurfaceCollector(cityObject);
        for (BoundarySurfaceProperty boundaryProperty : boundaryProperties) {
            if (!boundaryProperty.isSetBoundarySurface()) continue;
            AbstractBoundarySurface boundarySurface = boundaryProperty.getBoundarySurface();
            collector.collectSurfaces(boundarySurface, 2, 3);
            collector.collectSurfaces(boundarySurface.getOpening(), 2, 3);
        }
        return collector;
    }
}

