/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.marshal.gml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.citygml4j.builder.cityjson.marshal.CityJSONMarshaller;
import org.citygml4j.builder.cityjson.marshal.util.SemanticsBuilder;
import org.citygml4j.builder.cityjson.marshal.util.VerticesBuilder;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.appearance.AbstractMaterialObject;
import org.citygml4j.cityjson.appearance.AbstractTextureObject;
import org.citygml4j.cityjson.appearance.SolidCollectionMaterialObject;
import org.citygml4j.cityjson.appearance.SolidCollectionTextureObject;
import org.citygml4j.cityjson.appearance.SolidMaterialObject;
import org.citygml4j.cityjson.appearance.SolidTextureObject;
import org.citygml4j.cityjson.appearance.SurfaceCollectionMaterialObject;
import org.citygml4j.cityjson.appearance.SurfaceCollectionTextureObject;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.geometry.AbstractGeometryObjectType;
import org.citygml4j.cityjson.geometry.AbstractSemanticsObject;
import org.citygml4j.cityjson.geometry.AbstractSolidCollectionType;
import org.citygml4j.cityjson.geometry.AbstractSurfaceCollectionType;
import org.citygml4j.cityjson.geometry.CompositeSolidType;
import org.citygml4j.cityjson.geometry.CompositeSurfaceType;
import org.citygml4j.cityjson.geometry.GeometryWithAppearance;
import org.citygml4j.cityjson.geometry.GeometryWithSemantics;
import org.citygml4j.cityjson.geometry.MultiLineStringType;
import org.citygml4j.cityjson.geometry.MultiPointType;
import org.citygml4j.cityjson.geometry.MultiSolidType;
import org.citygml4j.cityjson.geometry.MultiSurfaceType;
import org.citygml4j.cityjson.geometry.SolidCollectionSemanticsObject;
import org.citygml4j.cityjson.geometry.SolidSemanticsObject;
import org.citygml4j.cityjson.geometry.SolidType;
import org.citygml4j.cityjson.geometry.SurfaceCollectionSemanticsObject;
import org.citygml4j.model.gml.GMLClass;
import org.citygml4j.model.gml.feature.AbstractFeature;
import org.citygml4j.model.gml.feature.FeatureProperty;
import org.citygml4j.model.gml.geometry.AbstractGeometry;
import org.citygml4j.model.gml.geometry.GeometryProperty;
import org.citygml4j.model.gml.geometry.aggregates.MultiCurve;
import org.citygml4j.model.gml.geometry.aggregates.MultiPoint;
import org.citygml4j.model.gml.geometry.aggregates.MultiSolid;
import org.citygml4j.model.gml.geometry.aggregates.MultiSurface;
import org.citygml4j.model.gml.geometry.complexes.CompositeCurve;
import org.citygml4j.model.gml.geometry.complexes.CompositeSolid;
import org.citygml4j.model.gml.geometry.complexes.CompositeSurface;
import org.citygml4j.model.gml.geometry.complexes.GeometricComplex;
import org.citygml4j.model.gml.geometry.complexes.GeometricComplexProperty;
import org.citygml4j.model.gml.geometry.primitives.AbstractCurve;
import org.citygml4j.model.gml.geometry.primitives.AbstractCurveSegment;
import org.citygml4j.model.gml.geometry.primitives.AbstractRing;
import org.citygml4j.model.gml.geometry.primitives.AbstractRingProperty;
import org.citygml4j.model.gml.geometry.primitives.Curve;
import org.citygml4j.model.gml.geometry.primitives.CurveSegmentArrayProperty;
import org.citygml4j.model.gml.geometry.primitives.GeometricPrimitiveProperty;
import org.citygml4j.model.gml.geometry.primitives.LineString;
import org.citygml4j.model.gml.geometry.primitives.LineStringSegment;
import org.citygml4j.model.gml.geometry.primitives.LinearRing;
import org.citygml4j.model.gml.geometry.primitives.OrientableCurve;
import org.citygml4j.model.gml.geometry.primitives.OrientableSurface;
import org.citygml4j.model.gml.geometry.primitives.Point;
import org.citygml4j.model.gml.geometry.primitives.PointArrayProperty;
import org.citygml4j.model.gml.geometry.primitives.PointProperty;
import org.citygml4j.model.gml.geometry.primitives.Polygon;
import org.citygml4j.model.gml.geometry.primitives.PolygonPatch;
import org.citygml4j.model.gml.geometry.primitives.Sign;
import org.citygml4j.model.gml.geometry.primitives.Solid;
import org.citygml4j.model.gml.geometry.primitives.Surface;
import org.citygml4j.model.gml.geometry.primitives.SurfaceProperty;
import org.citygml4j.model.gml.geometry.primitives.Tin;
import org.citygml4j.model.gml.geometry.primitives.TriangulatedSurface;
import org.citygml4j.util.child.ChildInfo;
import org.citygml4j.util.mapper.TypeMapper;
import org.citygml4j.util.walker.GeometryWalker;

public class GMLMarshaller {
    private final ReentrantLock lock = new ReentrantLock();
    private final CityJSONMarshaller json;
    private final Supplier<VerticesBuilder> verticesBuilder;
    private final ChildInfo childInfo;
    private TypeMapper<AbstractGeometryObjectType> typeMapper;

    public GMLMarshaller(CityJSONMarshaller json, Supplier<VerticesBuilder> verticesBuilder) {
        this.json = json;
        this.verticesBuilder = verticesBuilder;
        this.childInfo = new ChildInfo();
    }

    private TypeMapper<AbstractGeometryObjectType> getTypeMapper() {
        if (this.typeMapper == null) {
            this.lock.lock();
            try {
                if (this.typeMapper == null) {
                    this.typeMapper = TypeMapper.create().with(Point.class, this::marshalPoint).with(MultiPoint.class, this::marshalMultiPoint).with(Curve.class, this::marshalMultiLineString).with(CompositeCurve.class, this::marshalMultiLineString).with(LineString.class, this::marshalMultiLineString).with(MultiCurve.class, this::marshalMultiLineString).with(Surface.class, this::marshalSurface).with(TriangulatedSurface.class, this::marshalTriangulatedSurface).with(Tin.class, this::marshalTin).with(MultiSurface.class, this::marshalMultiSurface).with(CompositeSurface.class, this::marshalCompositeSurface).with(Solid.class, this::marshalSolid).with(CompositeSolid.class, this::marshalCompositeSolid).with(MultiSolid.class, this::marshalMultiSolid);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.typeMapper;
    }

    public AbstractGeometryObjectType marshal(AbstractGeometry src) {
        return this.getTypeMapper().apply(src);
    }

    public AbstractCityObjectType marshalFeatureProperty(FeatureProperty<? extends AbstractFeature> featureProperty, CityJSON cityJSON) {
        return featureProperty.isSetFeature() ? this.json.getCityGMLMarshaller().marshal(featureProperty.getFeature(), cityJSON) : null;
    }

    public void marshalPoint(Point src, MultiPointType dest) {
        List<Double> vertex = src.toList3d();
        if (!vertex.isEmpty()) {
            dest.addPoints(this.verticesBuilder.get().addVertices(vertex));
        }
    }

    public MultiPointType marshalPoint(Point src) {
        MultiPointType dest = new MultiPointType();
        this.marshalPoint(src, dest);
        return dest;
    }

    public void marshalMultiPoint(MultiPoint src, MultiPointType dest) {
        block3: {
            block2: {
                if (!src.isSetPointMember()) break block2;
                for (PointProperty pointProperty : src.getPointMember()) {
                    List<Double> vertex;
                    if (!pointProperty.isSetPoint() || (vertex = pointProperty.getPoint().toList3d()).isEmpty()) continue;
                    dest.addPoints(this.verticesBuilder.get().addVertices(vertex));
                }
                break block3;
            }
            if (!src.isSetPointMembers()) break block3;
            PointArrayProperty pointArrayProperty = src.getPointMembers();
            for (Point point : pointArrayProperty.getPoint()) {
                List<Double> vertex = point.toList3d();
                if (vertex.isEmpty()) continue;
                dest.addPoints(this.verticesBuilder.get().addVertices(vertex));
            }
        }
    }

    public MultiPointType marshalMultiPoint(MultiPoint src) {
        MultiPointType dest = new MultiPointType();
        this.marshalMultiPoint(src, dest);
        return dest;
    }

    public void marshalMultiLineString(AbstractCurve src, MultiLineStringType dest) {
        MultiLineStringBuilder builder = new MultiLineStringBuilder();
        builder.process(src, dest);
    }

    public MultiLineStringType marshalMultiLineString(Curve src) {
        MultiLineStringType dest = new MultiLineStringType();
        this.marshalMultiLineString(src, dest);
        return dest;
    }

    public MultiLineStringType marshalMultiLineString(CompositeCurve src) {
        MultiLineStringType dest = new MultiLineStringType();
        this.marshalMultiLineString(src, dest);
        return dest;
    }

    public MultiLineStringType marshalMultiLineString(LineString src) {
        MultiLineStringType dest = new MultiLineStringType();
        this.marshalMultiLineString(src, dest);
        return dest;
    }

    public MultiLineStringType marshalMultiLineString(List<GeometricComplexProperty> src) {
        MultiLineStringType dest = new MultiLineStringType();
        for (GeometricComplexProperty property : src) {
            GeometricComplex complex;
            if (property.isSetCompositeCurve()) {
                this.marshalMultiLineString(property.getCompositeCurve(), dest);
                continue;
            }
            if (!property.isSetGeometricComplex() || !(complex = property.getGeometricComplex()).isSetElement()) continue;
            for (GeometricPrimitiveProperty element : complex.getElement()) {
                if (!(element.getGeometricPrimitive() instanceof AbstractCurve)) continue;
                AbstractCurve curve = (AbstractCurve)element.getGeometricPrimitive();
                this.marshalMultiLineString(curve, dest);
            }
        }
        return !dest.getLineStrings().isEmpty() ? dest : null;
    }

    public void marshalMultiLineString(MultiCurve src, MultiLineStringType dest) {
        MultiLineStringBuilder builder = new MultiLineStringBuilder();
        builder.process(src, dest);
    }

    public MultiLineStringType marshalMultiLineString(MultiCurve src) {
        MultiLineStringType dest = new MultiLineStringType();
        this.marshalMultiLineString(src, dest);
        return dest;
    }

    public void marshalSurface(Surface src, CompositeSurfaceType dest) {
        SurfaceCollectionBuilder surfaceBuilder = new SurfaceCollectionBuilder();
        SemanticsBuilder semanticsBuilder = new SemanticsBuilder(this.childInfo.getParentCityObject(src), this.json.getCityGMLMarshaller());
        surfaceBuilder.process(src, dest, semanticsBuilder, true);
        if (dest.isSetSemantics()) {
            dest.getSemantics().setSurfaces(semanticsBuilder.getSurfaces());
        }
    }

    public CompositeSurfaceType marshalSurface(Surface src) {
        CompositeSurfaceType dest = new CompositeSurfaceType();
        this.marshalSurface(src, dest);
        return dest;
    }

    public CompositeSurfaceType marshalTriangulatedSurface(TriangulatedSurface src) {
        return this.marshalSurface(src);
    }

    public CompositeSurfaceType marshalTin(Tin src) {
        return this.marshalTriangulatedSurface(src);
    }

    public void marshalSurfaceCollection(AbstractGeometry src, AbstractSurfaceCollectionType dest) {
        SurfaceCollectionBuilder surfaceBuilder = new SurfaceCollectionBuilder();
        SemanticsBuilder semanticsBuilder = new SemanticsBuilder(this.childInfo.getParentCityObject(src), this.json.getCityGMLMarshaller());
        surfaceBuilder.process(src, dest, semanticsBuilder, true);
        if (dest.isSetSemantics()) {
            dest.getSemantics().setSurfaces(semanticsBuilder.getSurfaces());
        }
    }

    public MultiSurfaceType marshalMultiSurface(MultiSurface src) {
        MultiSurfaceType dest = new MultiSurfaceType();
        this.marshalSurfaceCollection(src, dest);
        return dest;
    }

    public CompositeSurfaceType marshalCompositeSurface(CompositeSurface src) {
        CompositeSurfaceType dest = new CompositeSurfaceType();
        this.marshalSurfaceCollection(src, dest);
        return dest;
    }

    public void marshalSolid(Solid src, SolidType dest, SemanticsBuilder semanticsBuilder, boolean collapseMaterialValues) {
        SurfaceCollectionBuilder surfaceBuilder = new SurfaceCollectionBuilder();
        int index = 0;
        if (src.isSetExterior() && src.getExterior().getSurface() instanceof CompositeSurface) {
            ArrayList<CompositeSurface> shells = new ArrayList<CompositeSurface>();
            shells.add((CompositeSurface)src.getExterior().getSurface());
            if (src.isSetInterior()) {
                for (SurfaceProperty property : src.getInterior()) {
                    if (!(property.getSurface() instanceof CompositeSurface)) continue;
                    shells.add((CompositeSurface)property.getSurface());
                }
            }
            for (CompositeSurface shell : shells) {
                CompositeSurfaceType shellType = new CompositeSurfaceType();
                surfaceBuilder.process(shell, shellType, semanticsBuilder, false);
                if (!shellType.getSurfaces().isEmpty()) {
                    dest.addShell(shellType.getSurfaces());
                    if (shellType.isSetSemantics()) {
                        SolidSemanticsObject semantics = dest.getSemantics();
                        if (semantics == null) {
                            semantics = new SolidSemanticsObject();
                            dest.setSemantics(semantics);
                        }
                        this.appendNulls(semantics, index);
                        semantics.addValues(shellType.getSemantics().getValues());
                    }
                    if (shellType.isSetMaterial()) {
                        for (SurfaceCollectionMaterialObject surfaceCollectionMaterialObject : shellType.getMaterial()) {
                            SolidMaterialObject material = dest.getMaterial(surfaceCollectionMaterialObject.getTheme());
                            if (material == null) {
                                material = new SolidMaterialObject(surfaceCollectionMaterialObject.getTheme());
                                dest.addMaterial(material);
                            }
                            this.appendNulls(material, index);
                            material.addValue(surfaceCollectionMaterialObject.getValues());
                        }
                    }
                    if (shellType.isSetTexture()) {
                        for (SurfaceCollectionTextureObject surfaceCollectionTextureObject : shellType.getTexture()) {
                            SolidTextureObject texture = dest.getTexture(surfaceCollectionTextureObject.getTheme());
                            if (texture == null) {
                                texture = new SolidTextureObject(surfaceCollectionTextureObject.getTheme());
                                dest.addTexture(texture);
                            }
                            this.appendNulls(texture, index);
                            texture.addValue(surfaceCollectionTextureObject.getValues());
                        }
                    }
                    ++index;
                    continue;
                }
                if (index != 0) continue;
                break;
            }
            this.postprocess(dest, index, collapseMaterialValues);
        }
    }

    public SolidType marshalSolid(Solid src) {
        SolidType dest = new SolidType();
        SemanticsBuilder semanticsBuilder = new SemanticsBuilder(this.childInfo.getParentCityObject(src), this.json.getCityGMLMarshaller());
        this.marshalSolid(src, dest, semanticsBuilder, true);
        if (dest.isSetSemantics()) {
            dest.getSemantics().setSurfaces(semanticsBuilder.getSurfaces());
        }
        return dest;
    }

    public void marshalSolidCollection(AbstractGeometry src, AbstractSolidCollectionType dest) {
        SolidCollectionBuilder builder = new SolidCollectionBuilder();
        SemanticsBuilder semanticsBuilder = new SemanticsBuilder(this.childInfo.getParentCityObject(src), this.json.getCityGMLMarshaller());
        builder.process(src, dest, semanticsBuilder);
        if (dest.isSetSemantics()) {
            dest.getSemantics().setSurfaces(semanticsBuilder.getSurfaces());
        }
    }

    public CompositeSolidType marshalCompositeSolid(CompositeSolid src) {
        CompositeSolidType dest = new CompositeSolidType();
        this.marshalSolidCollection(src, dest);
        return dest;
    }

    public MultiSolidType marshalMultiSolid(MultiSolid src) {
        MultiSolidType dest = new MultiSolidType();
        this.marshalSolidCollection(src, dest);
        return dest;
    }

    public AbstractGeometryObjectType marshalGeometryProperty(GeometryProperty<?> src) {
        AbstractGeometryObjectType dest = null;
        if (src.isSetGeometry()) {
            dest = this.marshal((AbstractGeometry)src.getGeometry());
        } else if (src.hasLocalProperty("org.citygml4j.geometry.xlink")) {
            dest = this.marshal((AbstractGeometry)src.getLocalProperty("org.citygml4j.geometry.xlink"));
        }
        return dest;
    }

    private List<List<Integer>> marshalPolygon(Polygon polygon, boolean reverse) {
        List<Integer> indexes;
        AbstractRing exterior;
        ArrayList<List<Integer>> vertices = null;
        if (polygon.isSetExterior() && (exterior = polygon.getExterior().getRing()) instanceof LinearRing && (indexes = this.marshalLinearRing((LinearRing)exterior, reverse)) != null) {
            vertices = new ArrayList<List<Integer>>();
            vertices.add(indexes);
            if (polygon.isSetInterior()) {
                for (AbstractRingProperty property : polygon.getInterior()) {
                    AbstractRing interior = property.getRing();
                    if (!(interior instanceof LinearRing) || (indexes = this.marshalLinearRing((LinearRing)interior, reverse)) == null) continue;
                    vertices.add(indexes);
                }
            }
        }
        return vertices;
    }

    private List<Integer> marshalLinearRing(LinearRing linearRing, boolean reverse) {
        List<Integer> vertices = null;
        List<Double> values = linearRing.toList3d(reverse);
        if (values.size() > 11) {
            vertices = this.verticesBuilder.get().addVertices(values.subList(0, values.size() - 3));
        }
        return vertices;
    }

    private void appendNulls(AbstractSemanticsObject semantics, int index) {
        while (semantics.getNumValues() < index) {
            semantics.addNullValue();
        }
    }

    private void appendNulls(AbstractMaterialObject material, int index) {
        while (material.getNumValues() < index) {
            material.addNullValue();
        }
    }

    private void appendNulls(AbstractTextureObject texture, int index) {
        while (texture.getNumValues() < index) {
            texture.addNullValue();
        }
    }

    private void postprocess(AbstractGeometryObjectType dest, int index, boolean collapseMaterialValues) {
        Object geometry;
        if (dest instanceof GeometryWithSemantics && (geometry = (GeometryWithSemantics)((Object)dest)).isSetSemantics()) {
            this.appendNulls(geometry.getSemantics(), index);
        }
        if (dest instanceof GeometryWithAppearance) {
            geometry = (GeometryWithAppearance)((Object)dest);
            if (geometry.isSetMaterial()) {
                for (AbstractMaterialObject material : geometry.getMaterial()) {
                    if (collapseMaterialValues && material.collapseValues()) continue;
                    this.appendNulls(material, index);
                }
            }
            if (geometry.isSetTexture()) {
                for (AbstractTextureObject texture : geometry.getTexture()) {
                    this.appendNulls(texture, index);
                }
            }
        }
    }

    private final class SolidCollectionBuilder
    extends GeometryWalker {
        private AbstractSolidCollectionType dest;
        private SemanticsBuilder semanticsBuilder;
        private int index = 0;

        private SolidCollectionBuilder() {
        }

        @Override
        public void visit(Solid solid) {
            SolidType solidType = new SolidType();
            GMLMarshaller.this.marshalSolid(solid, solidType, this.semanticsBuilder, false);
            if (!solidType.getShells().isEmpty()) {
                this.dest.addSolid(solidType.getShells());
                if (solidType.isSetSemantics()) {
                    SolidCollectionSemanticsObject semantics = this.dest.getSemantics();
                    if (semantics == null) {
                        semantics = new SolidCollectionSemanticsObject();
                        this.dest.setSemantics(semantics);
                    }
                    GMLMarshaller.this.appendNulls(semantics, this.index);
                    semantics.addValues(solidType.getSemantics().getValues());
                }
                if (solidType.isSetMaterial()) {
                    for (SolidMaterialObject solidMaterialObject : solidType.getMaterial()) {
                        SolidCollectionMaterialObject material = this.dest.getMaterial(solidMaterialObject.getTheme());
                        if (material == null) {
                            material = new SolidCollectionMaterialObject(solidMaterialObject.getTheme());
                            this.dest.addMaterial(material);
                        }
                        GMLMarshaller.this.appendNulls(material, this.index);
                        material.addValue(solidMaterialObject.getValues());
                    }
                }
                if (solidType.isSetTexture()) {
                    for (SolidTextureObject solidTextureObject : solidType.getTexture()) {
                        SolidCollectionTextureObject texture = this.dest.getTexture(solidTextureObject.getTheme());
                        if (texture == null) {
                            texture = new SolidCollectionTextureObject(solidTextureObject.getTheme());
                            this.dest.addTexture(texture);
                        }
                        GMLMarshaller.this.appendNulls(texture, this.index);
                        texture.addValue(solidTextureObject.getValues());
                    }
                }
                ++this.index;
            }
        }

        @Override
        public <T extends AbstractGeometry> void visit(GeometryProperty<T> property) {
            if (property.hasLocalProperty("org.citygml4j.geometry.xlink")) {
                ((AbstractGeometry)property.getLocalProperty("org.citygml4j.geometry.xlink")).accept(this);
            } else {
                super.visit(property);
            }
        }

        public void process(AbstractGeometry src, AbstractSolidCollectionType dest, SemanticsBuilder semanticsBuilder) {
            this.dest = dest;
            this.semanticsBuilder = semanticsBuilder;
            src.accept(this);
            GMLMarshaller.this.postprocess(dest, this.index, true);
        }
    }

    private final class SurfaceCollectionBuilder
    extends GeometryWalker {
        private AbstractSurfaceCollectionType dest;
        private SemanticsBuilder semanticsBuilder;
        private boolean reverse = false;
        private int index = 0;

        private SurfaceCollectionBuilder() {
        }

        @Override
        public void visit(Polygon polygon) {
            List surface = GMLMarshaller.this.marshalPolygon(polygon, this.reverse);
            if (surface != null) {
                Integer semanticsIndex = this.semanticsBuilder.addSemanticSurface(GMLMarshaller.this.childInfo.getParentCityObject(polygon));
                Map<String, Integer> materials = GMLMarshaller.this.json.getCityGMLMarshaller().getAppearanceMarshaller().getMaterials(polygon, this.reverse);
                Map<String, List<List<Integer>>> textures = GMLMarshaller.this.json.getCityGMLMarshaller().getAppearanceMarshaller().getTextures(polygon, this.reverse);
                this.addSurface(surface, semanticsIndex, materials, textures);
            }
        }

        @Override
        public void visit(PolygonPatch polygonPatch) {
            Polygon polygon = new Polygon();
            polygon.setExterior(polygonPatch.getExterior());
            polygon.setInterior(polygonPatch.getInterior());
            this.visit(polygon);
        }

        @Override
        public void visit(LinearRing linearRing) {
            List vertices = GMLMarshaller.this.marshalLinearRing(linearRing, this.reverse);
            if (vertices != null) {
                Integer semanticsIndex = this.semanticsBuilder.addSemanticSurface(GMLMarshaller.this.childInfo.getParentCityObject(linearRing));
                Map<String, Integer> materials = GMLMarshaller.this.json.getCityGMLMarshaller().getAppearanceMarshaller().getMaterials(linearRing, this.reverse);
                Map<String, List<List<Integer>>> textures = GMLMarshaller.this.json.getCityGMLMarshaller().getAppearanceMarshaller().getTextures(linearRing, this.reverse);
                this.addSurface(Collections.singletonList(vertices), semanticsIndex, materials, textures);
            }
        }

        @Override
        public void visit(OrientableSurface orientableSurface) {
            if (orientableSurface.getOrientation() == Sign.MINUS) {
                this.reverse = !this.reverse;
                super.visit(orientableSurface);
                this.reverse = !this.reverse;
            } else {
                super.visit(orientableSurface);
            }
        }

        @Override
        public <T extends AbstractGeometry> void visit(GeometryProperty<T> property) {
            if (property.hasLocalProperty("org.citygml4j.geometry.xlink")) {
                ((AbstractGeometry)property.getLocalProperty("org.citygml4j.geometry.xlink")).accept(this);
            } else {
                super.visit(property);
            }
        }

        private void addSurface(List<List<Integer>> surface, Integer semanticsIndex, Map<String, Integer> materials, Map<String, List<List<Integer>>> textures) {
            this.dest.addSurface(surface);
            if (semanticsIndex != null) {
                SurfaceCollectionSemanticsObject semantics = this.dest.getSemantics();
                if (semantics == null) {
                    semantics = new SurfaceCollectionSemanticsObject();
                    this.dest.setSemantics(semantics);
                }
                GMLMarshaller.this.appendNulls(semantics, this.index);
                semantics.addValue(semanticsIndex);
            }
            if (materials != null) {
                for (Map.Entry<String, Object> entry : materials.entrySet()) {
                    SurfaceCollectionMaterialObject material = this.dest.getMaterial(entry.getKey());
                    if (material == null) {
                        material = new SurfaceCollectionMaterialObject(entry.getKey());
                        this.dest.addMaterial(material);
                    }
                    GMLMarshaller.this.appendNulls(material, this.index);
                    material.addValue((Integer)entry.getValue());
                }
            }
            if (textures != null) {
                for (Map.Entry<String, Object> entry : textures.entrySet()) {
                    SurfaceCollectionTextureObject texture = this.dest.getTexture(entry.getKey());
                    if (texture == null) {
                        texture = new SurfaceCollectionTextureObject(entry.getKey());
                        this.dest.addTexture(texture);
                    }
                    GMLMarshaller.this.appendNulls(texture, this.index);
                    texture.addValue((List)entry.getValue());
                }
            }
            ++this.index;
        }

        public void process(AbstractGeometry src, AbstractSurfaceCollectionType dest, SemanticsBuilder semanticsBuilder, boolean collapseMaterialValues) {
            this.dest = dest;
            this.semanticsBuilder = semanticsBuilder;
            src.accept(this);
            GMLMarshaller.this.postprocess(dest, this.index, collapseMaterialValues);
        }
    }

    private final class MultiLineStringBuilder
    extends GeometryWalker {
        private MultiLineStringType dest;
        private boolean reverse = false;

        private MultiLineStringBuilder() {
        }

        @Override
        public void visit(LineString lineString) {
            List<Double> vertices = lineString.toList3d(this.reverse);
            if (!vertices.isEmpty()) {
                this.dest.addLineString(((VerticesBuilder)GMLMarshaller.this.verticesBuilder.get()).addVertices(vertices));
            }
        }

        @Override
        public void visit(Curve curve) {
            CurveSegmentArrayProperty arrayProperty;
            if (curve.isSetSegments() && (arrayProperty = curve.getSegments()).isSetCurveSegment()) {
                ArrayList<Double> vertices = new ArrayList<Double>();
                for (AbstractCurveSegment abstractCurveSegment : arrayProperty.getCurveSegment()) {
                    List<Double> values;
                    if (abstractCurveSegment.getGMLClass() != GMLClass.LINE_STRING_SEGMENT || (values = ((LineStringSegment)abstractCurveSegment).toList3d()).isEmpty()) continue;
                    vertices.addAll(values);
                }
                if (!vertices.isEmpty()) {
                    if (!this.reverse) {
                        this.dest.addLineString(((VerticesBuilder)GMLMarshaller.this.verticesBuilder.get()).addVertices(vertices));
                    } else {
                        for (int i = vertices.size() - 3; i >= 0; i -= 3) {
                            this.dest.addLineString(((VerticesBuilder)GMLMarshaller.this.verticesBuilder.get()).addVertices(vertices.subList(i, i + 3)));
                        }
                    }
                }
            }
        }

        @Override
        public void visit(OrientableCurve orientableCurve) {
            if (orientableCurve.getOrientation() == Sign.MINUS) {
                this.reverse = !this.reverse;
                super.visit(orientableCurve);
                this.reverse = !this.reverse;
            } else {
                super.visit(orientableCurve);
            }
        }

        @Override
        public <T extends AbstractGeometry> void visit(GeometryProperty<T> property) {
            if (property.hasLocalProperty("org.citygml4j.geometry.xlink")) {
                ((AbstractGeometry)property.getLocalProperty("org.citygml4j.geometry.xlink")).accept(this);
            } else {
                super.visit(property);
            }
        }

        public void process(AbstractCurve src, MultiLineStringType dest) {
            this.dest = dest;
            src.accept(this);
        }

        public void process(MultiCurve src, MultiLineStringType dest) {
            this.dest = dest;
            src.accept(this);
        }
    }
}

