/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.marshal.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.citygml4j.builder.cityjson.marshal.util.TextureVerticesBuilder;

public class DefaultTextureVerticesBuilder
implements TextureVerticesBuilder {
    private final ReentrantLock lock = new ReentrantLock();
    private final Map<String, Integer> indexes = new ConcurrentHashMap<String, Integer>();
    private final List<List<Double>> vertices = new ArrayList<List<Double>>();
    private int significantDigits = 7;

    public DefaultTextureVerticesBuilder withSignificantDigits(int significantDigits) {
        if (significantDigits > 0) {
            this.significantDigits = significantDigits;
        }
        return this;
    }

    public int getSignificantDigits() {
        return this.significantDigits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Integer> addTextureVertices(List<Double> vertices) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < vertices.size(); i += 2) {
            List<Double> vertex = vertices.subList(i, i + 2);
            vertex.set(0, this.round(vertex.get(0)).doubleValue());
            vertex.set(1, this.round(vertex.get(1)).doubleValue());
            String key = vertex.get(0).toString() + vertex.get(1).toString();
            Integer index = this.indexes.get(key);
            if (index == null) {
                Integer tmp = null;
                this.lock.lock();
                try {
                    tmp = this.vertices.size();
                    this.vertices.add(vertex);
                }
                finally {
                    this.lock.unlock();
                }
                index = this.indexes.putIfAbsent(key, tmp);
                if (index == null) {
                    index = tmp;
                }
            }
            result.add(index);
        }
        return result;
    }

    @Override
    public List<List<Double>> build() {
        this.indexes.clear();
        return this.vertices;
    }

    @Override
    public void reset() {
        this.indexes.clear();
        this.vertices.clear();
    }

    private BigDecimal round(double value) {
        return BigDecimal.valueOf(value).setScale(this.significantDigits, RoundingMode.HALF_UP);
    }
}

