/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.unmarshal;

import java.lang.reflect.Type;
import java.util.Objects;
import org.citygml4j.builder.cityjson.unmarshal.CityObjectProcessor;
import org.citygml4j.builder.cityjson.unmarshal.citygml.CityGMLUnmarshaller;
import org.citygml4j.builder.cityjson.unmarshal.citygml.ade.ADEUnmarshaller;
import org.citygml4j.builder.cityjson.unmarshal.gml.GMLUnmarshaller;
import org.citygml4j.builder.cityjson.util.CityGMLMetadata;
import org.citygml4j.builder.cityjson.util.DefaultTextureFileHandler;
import org.citygml4j.builder.cityjson.util.TextureFileHandler;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.CityJSONRegistry;
import org.citygml4j.cityjson.extension.ExtensibleType;
import org.citygml4j.cityjson.extension.ExtensionException;
import org.citygml4j.model.citygml.appearance.Appearance;
import org.citygml4j.model.citygml.appearance.AppearanceMember;
import org.citygml4j.model.citygml.core.CityModel;
import org.citygml4j.xml.io.reader.CityGMLInputFilter;

public class CityJSONUnmarshaller {
    public static final String SURFACE_DATA_ID = "org.citygml4j.appearance.id";
    public static final String TEXTURE_COORDINATES = "org.citygml4j.textureCoordinates";
    public static final String GEOMETRY_INSTANCE_LOD = "org.citygml4j.implicitGeometry.lod";
    private final CityGMLUnmarshaller citygml;
    private final GMLUnmarshaller gml;
    private final ADEUnmarshaller ade;
    private final CityJSONRegistry registry;
    private TextureFileHandler textureFileHandler = new DefaultTextureFileHandler();
    private CityGMLInputFilter nameFilter;
    private boolean releaseCityJSONContent = true;

    public CityJSONUnmarshaller() {
        this.citygml = new CityGMLUnmarshaller(this);
        this.gml = new GMLUnmarshaller(this);
        this.ade = new ADEUnmarshaller(this);
        this.registry = CityJSONRegistry.getInstance();
        if (!this.registry.hasExtensionProperty("CityGMLMetadata", CityJSON.class)) {
            try {
                this.registry.registerExtensionProperty("CityGMLMetadata", (Type)((Object)CityGMLMetadata.class), (Class<? extends ExtensibleType>)CityJSON.class);
            }
            catch (ExtensionException extensionException) {
                // empty catch block
            }
        }
    }

    public CityModel unmarshal(CityJSON src) {
        this.prepareUnmarshaller(src);
        CityModel dest = this.citygml.getCoreUnmarshaller().unmarshalCityModel(src);
        if (dest != null && this.citygml.getCoreUnmarshaller().hasGlobalAppearances()) {
            for (Appearance appearance : this.citygml.getCoreUnmarshaller().getGlobalAppearances()) {
                dest.addAppearanceMember(new AppearanceMember(appearance));
            }
        }
        this.releaseCityJSONContent(src);
        return dest;
    }

    public void unmarshal(CityJSON src, CityModel stub, CityObjectProcessor processor) throws Exception {
        this.prepareUnmarshaller(src);
        this.citygml.getCoreUnmarshaller().unmarshalCityModel(src, stub, processor);
        if (this.citygml.getCoreUnmarshaller().hasGlobalAppearances()) {
            for (Appearance appearance : this.citygml.getCoreUnmarshaller().getGlobalAppearances()) {
                processor.process(appearance);
            }
        }
        this.releaseCityJSONContent(src);
    }

    private void prepareUnmarshaller(CityJSON src) {
        Object metadata;
        this.gml.setVertices(src.getVertices());
        if (src.isSetTransform()) {
            this.gml.applyTransformation(src.getTransform());
        }
        if (src.isSetAppearance()) {
            this.citygml.getAppearanceUnmarshaller().setAppearanceInfo(src.getAppearance());
        }
        if (src.isSetGeometryTemplates()) {
            this.citygml.getCoreUnmarshaller().setGeometryTemplatesInfo(src.getGeometryTemplates());
        }
        if (src.isSetExtensionProperties() && (metadata = src.getExtensionProperties().get("CityGMLMetadata")) instanceof CityGMLMetadata) {
            this.citygml.getGenericsUnmarshaller().setGenericAttributeTypes(((CityGMLMetadata)metadata).getGenericAttributeTypes());
        }
    }

    private void releaseCityJSONContent(CityJSON src) {
        if (this.releaseCityJSONContent) {
            src.unsetMetadata();
            src.unsetExtensions();
            src.unsetExtensionProperties();
            src.unsetCityObjects();
            src.unsetVertices();
            src.unsetTransform();
            src.unsetGeometryTemplates();
            src.unsetAppearance();
        }
    }

    public CityGMLUnmarshaller getCityGMLUnmarshaller() {
        return this.citygml;
    }

    public GMLUnmarshaller getGMLUnmarshaller() {
        return this.gml;
    }

    public ADEUnmarshaller getADEUnmarshaller() {
        return this.ade;
    }

    public TextureFileHandler getTextureFileHandler() {
        return this.textureFileHandler;
    }

    public void setTextureFileHandler(TextureFileHandler textureFileHandler) {
        this.textureFileHandler = Objects.requireNonNull(textureFileHandler, "texture file handler builder may not be null.");
    }

    public boolean isSetCityGMLNameFilter() {
        return this.nameFilter != null;
    }

    public CityGMLInputFilter getCityGMLNameFilter() {
        return this.nameFilter;
    }

    public void setCityGMLNameFilter(CityGMLInputFilter nameFilter) {
        this.nameFilter = nameFilter;
    }

    public CityJSONRegistry getCityJSONRegistry() {
        return this.registry;
    }

    public boolean isReleaseCityJSONContent() {
        return this.releaseCityJSONContent;
    }

    public void setReleaseCityJSONContent(boolean releaseCityJSONContent) {
        this.releaseCityJSONContent = releaseCityJSONContent;
    }
}

