/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.unmarshal.citygml.cityfurniture;

import org.citygml4j.builder.cityjson.unmarshal.CityJSONUnmarshaller;
import org.citygml4j.builder.cityjson.unmarshal.citygml.CityGMLUnmarshaller;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.feature.Attributes;
import org.citygml4j.cityjson.feature.CityFurnitureType;
import org.citygml4j.cityjson.geometry.AbstractGeometryObjectType;
import org.citygml4j.cityjson.geometry.AbstractGeometryType;
import org.citygml4j.cityjson.geometry.GeometryInstanceType;
import org.citygml4j.model.citygml.cityfurniture.CityFurniture;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.core.ImplicitGeometry;
import org.citygml4j.model.citygml.core.ImplicitRepresentationProperty;
import org.citygml4j.model.gml.base.AbstractGML;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.model.gml.geometry.GeometryProperty;

public class CityFurnitureUnmarshaller {
    private final CityJSONUnmarshaller json;
    private final CityGMLUnmarshaller citygml;

    public CityFurnitureUnmarshaller(CityGMLUnmarshaller citygml) {
        this.citygml = citygml;
        this.json = citygml.getCityJSONUnmarshaller();
    }

    public AbstractCityObject unmarshal(AbstractCityObjectType src, CityJSON cityJSON) {
        if (src instanceof CityFurnitureType) {
            return this.unmarshalCityFurniture((CityFurnitureType)src, cityJSON);
        }
        return null;
    }

    public void unmarshalCityFurniture(CityFurnitureType src, CityFurniture dest, CityJSON cityJSON) {
        this.citygml.getCoreUnmarshaller().unmarshalAbstractCityObject(src, dest, cityJSON);
        if (src.isSetAttributes()) {
            Attributes attributes = src.getAttributes();
            if (attributes.isSetClazz()) {
                dest.setClazz(new Code(attributes.getClazz()));
            }
            if (attributes.isSetFunction()) {
                dest.addFunction(new Code(attributes.getFunction()));
            }
            if (attributes.isSetUsage()) {
                dest.addUsage(new Code(attributes.getUsage()));
            }
        }
        for (AbstractGeometryType geometryType : src.getGeometry()) {
            AbstractGML geometry;
            if (geometryType instanceof AbstractGeometryObjectType) {
                AbstractGeometryObjectType geometryObject = (AbstractGeometryObjectType)geometryType;
                geometry = this.json.getGMLUnmarshaller().unmarshal(geometryObject, dest);
                if (geometry == null) continue;
                int lod = geometryObject.getLod().intValue();
                switch (lod) {
                    case 1: {
                        dest.setLod1Geometry(new GeometryProperty<AbstractGML>(geometry));
                        break;
                    }
                    case 2: {
                        dest.setLod2Geometry(new GeometryProperty<AbstractGML>(geometry));
                        break;
                    }
                    case 3: {
                        dest.setLod3Geometry(new GeometryProperty<AbstractGML>(geometry));
                    }
                }
                continue;
            }
            if (!(geometryType instanceof GeometryInstanceType)) continue;
            GeometryInstanceType geometryInstance = (GeometryInstanceType)geometryType;
            geometry = this.citygml.getCoreUnmarshaller().unmarshalGeometryInstance(geometryInstance);
            if (geometry == null) continue;
            switch ((Integer)geometry.getLocalProperty("org.citygml4j.implicitGeometry.lod")) {
                case 1: {
                    dest.setLod1ImplicitRepresentation(new ImplicitRepresentationProperty((ImplicitGeometry)geometry));
                    break;
                }
                case 2: {
                    dest.setLod2ImplicitRepresentation(new ImplicitRepresentationProperty((ImplicitGeometry)geometry));
                    break;
                }
                case 3: {
                    dest.setLod3ImplicitRepresentation(new ImplicitRepresentationProperty((ImplicitGeometry)geometry));
                }
            }
        }
    }

    public CityFurniture unmarshalCityFurniture(CityFurnitureType src, CityJSON cityJSON) {
        CityFurniture dest = new CityFurniture();
        this.unmarshalCityFurniture(src, dest, cityJSON);
        return dest;
    }
}

