/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.unmarshal.citygml.cityobjectgroup;

import java.util.Iterator;
import org.citygml4j.builder.cityjson.unmarshal.CityJSONUnmarshaller;
import org.citygml4j.builder.cityjson.unmarshal.citygml.CityGMLUnmarshaller;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.feature.Attributes;
import org.citygml4j.cityjson.feature.CityObjectGroupType;
import org.citygml4j.cityjson.geometry.AbstractGeometryObjectType;
import org.citygml4j.cityjson.geometry.AbstractGeometryType;
import org.citygml4j.model.citygml.cityobjectgroup.CityObjectGroup;
import org.citygml4j.model.citygml.cityobjectgroup.CityObjectGroupMember;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.core.CityModel;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.model.gml.geometry.AbstractGeometry;
import org.citygml4j.model.gml.geometry.GeometryProperty;
import org.citygml4j.util.walker.FeatureWalker;

public class CityObjectGroupUnmarshaller {
    private final CityJSONUnmarshaller json;
    private final CityGMLUnmarshaller citygml;

    public CityObjectGroupUnmarshaller(CityGMLUnmarshaller citygml) {
        this.citygml = citygml;
        this.json = citygml.getCityJSONUnmarshaller();
    }

    public AbstractCityObject unmarshal(AbstractCityObjectType src, CityJSON cityJSON) {
        if (src instanceof CityObjectGroupType) {
            return this.unmarshalCityObjectGroup((CityObjectGroupType)src, cityJSON);
        }
        return null;
    }

    public void unmarshalCityObjectGroup(CityObjectGroupType src, CityObjectGroup dest, CityJSON cityJSON) {
        this.citygml.getCoreUnmarshaller().unmarshalAbstractCityObject(src, dest, cityJSON);
        if (src.isSetAttributes()) {
            Attributes attributes = src.getAttributes();
            if (attributes.isSetClazz()) {
                dest.setClazz(new Code(attributes.getClazz()));
            }
            if (attributes.isSetFunction()) {
                dest.addFunction(new Code(attributes.getFunction()));
            }
            if (attributes.isSetUsage()) {
                dest.addUsage(new Code(attributes.getUsage()));
            }
        }
        for (AbstractGeometryType geometryType : src.getGeometry()) {
            if (!(geometryType instanceof AbstractGeometryObjectType)) continue;
            AbstractGeometryObjectType geometryObject = (AbstractGeometryObjectType)geometryType;
            AbstractGeometry geometry = this.json.getGMLUnmarshaller().unmarshal(geometryObject, dest);
            if (geometry == null) continue;
            dest.setGeometry(new GeometryProperty<AbstractGeometry>(geometry));
            break;
        }
        if (src.isSetMembers()) {
            for (String member : src.getMembers()) {
                dest.addGroupMember(new CityObjectGroupMember("#" + member));
            }
        }
    }

    public CityObjectGroup unmarshalCityObjectGroup(CityObjectGroupType src, CityJSON cityJSON) {
        CityObjectGroup dest = new CityObjectGroup();
        this.unmarshalCityObjectGroup(src, dest, cityJSON);
        return dest;
    }

    public void postprocessGroupMembers(final CityObjectGroup cityObjectGroup, CityModel dest) {
        if (cityObjectGroup.isSetGroupMember()) {
            dest.accept(new FeatureWalker(){

                @Override
                public void visit(AbstractCityObject cityObject) {
                    if (cityObject.isSetId()) {
                        for (CityObjectGroupMember member : cityObjectGroup.getGroupMember()) {
                            if (!member.isSetHref() || !member.getHref().equals("#" + cityObject.getId())) continue;
                            member.setLocalProperty("isPresent", true);
                        }
                    }
                    super.visit(cityObject);
                }
            });
            Iterator<CityObjectGroupMember> iter = cityObjectGroup.getGroupMember().iterator();
            while (iter.hasNext()) {
                CityObjectGroupMember member = iter.next();
                if (!member.hasLocalProperty("isPresent")) {
                    iter.remove();
                }
                member.unsetLocalProperty("isPresent");
            }
        }
    }
}

