/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.unmarshal.citygml.landuse;

import org.citygml4j.builder.cityjson.unmarshal.CityJSONUnmarshaller;
import org.citygml4j.builder.cityjson.unmarshal.citygml.CityGMLUnmarshaller;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.feature.Attributes;
import org.citygml4j.cityjson.feature.LandUseType;
import org.citygml4j.cityjson.geometry.AbstractGeometryType;
import org.citygml4j.cityjson.geometry.AbstractSurfaceCollectionType;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.landuse.LandUse;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.model.gml.geometry.aggregates.MultiSurface;
import org.citygml4j.model.gml.geometry.aggregates.MultiSurfaceProperty;

public class LandUseUnmarshaller {
    private final CityJSONUnmarshaller json;
    private final CityGMLUnmarshaller citygml;

    public LandUseUnmarshaller(CityGMLUnmarshaller citygml) {
        this.citygml = citygml;
        this.json = citygml.getCityJSONUnmarshaller();
    }

    public AbstractCityObject unmarshal(AbstractCityObjectType src, CityJSON cityJSON) {
        if (src instanceof LandUseType) {
            return this.unmarshalLandUse((LandUseType)src, cityJSON);
        }
        return null;
    }

    public void unmarshalLandUse(LandUseType src, LandUse dest, CityJSON cityJSON) {
        this.citygml.getCoreUnmarshaller().unmarshalAbstractCityObject(src, dest, cityJSON);
        if (src.isSetAttributes()) {
            Attributes attributes = src.getAttributes();
            if (attributes.isSetClazz()) {
                dest.setClazz(new Code(attributes.getClazz()));
            }
            if (attributes.isSetFunction()) {
                dest.addFunction(new Code(attributes.getFunction()));
            }
            if (attributes.isSetUsage()) {
                dest.addUsage(new Code(attributes.getUsage()));
            }
        }
        for (AbstractGeometryType geometryType : src.getGeometry()) {
            if (!(geometryType instanceof AbstractSurfaceCollectionType)) continue;
            AbstractSurfaceCollectionType surfaceType = (AbstractSurfaceCollectionType)geometryType;
            MultiSurface multiSurface = this.json.getGMLUnmarshaller().unmarshalMultiSurface(surfaceType, dest);
            if (multiSurface == null) continue;
            int lod = surfaceType.getLod().intValue();
            switch (lod) {
                case 0: {
                    dest.setLod0MultiSurface(new MultiSurfaceProperty(multiSurface));
                    break;
                }
                case 1: {
                    dest.setLod1MultiSurface(new MultiSurfaceProperty(multiSurface));
                    break;
                }
                case 2: {
                    dest.setLod2MultiSurface(new MultiSurfaceProperty(multiSurface));
                    break;
                }
                case 3: {
                    dest.setLod3MultiSurface(new MultiSurfaceProperty(multiSurface));
                }
            }
        }
    }

    public LandUse unmarshalLandUse(LandUseType src, CityJSON cityJSON) {
        LandUse dest = new LandUse();
        this.unmarshalLandUse(src, dest, cityJSON);
        return dest;
    }
}

