/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.unmarshal.citygml.transportation;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.citygml4j.builder.cityjson.unmarshal.CityJSONUnmarshaller;
import org.citygml4j.builder.cityjson.unmarshal.citygml.CityGMLUnmarshaller;
import org.citygml4j.cityjson.CityJSON;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.feature.AbstractTransportationComplexType;
import org.citygml4j.cityjson.feature.RailwayType;
import org.citygml4j.cityjson.feature.RoadType;
import org.citygml4j.cityjson.feature.TransportSquareType;
import org.citygml4j.cityjson.feature.TransportationComplexAttributes;
import org.citygml4j.cityjson.geometry.AbstractGeometryObjectType;
import org.citygml4j.cityjson.geometry.AbstractGeometryType;
import org.citygml4j.cityjson.geometry.GeometryInstanceType;
import org.citygml4j.cityjson.geometry.SemanticsType;
import org.citygml4j.model.citygml.ade.binding.ADEModelObject;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.generics.StringAttribute;
import org.citygml4j.model.citygml.transportation.AbstractTransportationObject;
import org.citygml4j.model.citygml.transportation.AuxiliaryTrafficArea;
import org.citygml4j.model.citygml.transportation.AuxiliaryTrafficAreaProperty;
import org.citygml4j.model.citygml.transportation.Railway;
import org.citygml4j.model.citygml.transportation.Road;
import org.citygml4j.model.citygml.transportation.Square;
import org.citygml4j.model.citygml.transportation.TrafficArea;
import org.citygml4j.model.citygml.transportation.TrafficAreaProperty;
import org.citygml4j.model.citygml.transportation.TransportationComplex;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.model.gml.geometry.AbstractGeometry;
import org.citygml4j.model.gml.geometry.aggregates.MultiCurve;
import org.citygml4j.model.gml.geometry.aggregates.MultiSurface;
import org.citygml4j.model.gml.geometry.aggregates.MultiSurfaceProperty;
import org.citygml4j.model.gml.geometry.complexes.CompositeCurve;
import org.citygml4j.model.gml.geometry.complexes.GeometricComplexProperty;
import org.citygml4j.model.gml.geometry.primitives.AbstractSurface;
import org.citygml4j.model.gml.geometry.primitives.SurfaceProperty;
import org.citygml4j.util.mapper.BiFunctionTypeMapper;

public class TransportationUnmarshaller {
    private final ReentrantLock lock = new ReentrantLock();
    private final CityJSONUnmarshaller json;
    private final CityGMLUnmarshaller citygml;
    private BiFunctionTypeMapper<CityJSON, AbstractCityObject> typeMapper;

    public TransportationUnmarshaller(CityGMLUnmarshaller citygml) {
        this.citygml = citygml;
        this.json = citygml.getCityJSONUnmarshaller();
    }

    private BiFunctionTypeMapper<CityJSON, AbstractCityObject> getTypeMapper() {
        if (this.typeMapper == null) {
            this.lock.lock();
            try {
                if (this.typeMapper == null) {
                    this.typeMapper = BiFunctionTypeMapper.create().with(RoadType.class, this::unmarshalRoad).with(RailwayType.class, this::unmarshalRailway).with(TransportSquareType.class, this::unmarshalTransportSquare);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.typeMapper;
    }

    public AbstractCityObject unmarshal(AbstractCityObjectType src, CityJSON cityJSON) {
        return this.getTypeMapper().apply(src, cityJSON);
    }

    public AbstractCityObject unmarshalSemantics(SemanticsType semanticsType, List<AbstractSurface> surfaces, Number lod, AbstractCityObject parent) {
        boolean success;
        AbstractTransportationObject trafficArea = null;
        switch (semanticsType.getType()) {
            case "TrafficArea": {
                trafficArea = this.unmarshalTrafficArea(semanticsType, surfaces, lod);
                break;
            }
            case "AuxiliaryTrafficArea": {
                trafficArea = this.unmarshalAuxiliaryTrafficArea(semanticsType, surfaces, lod);
                break;
            }
            default: {
                return null;
            }
        }
        if (parent instanceof ADEModelObject && (success = this.json.getADEUnmarshaller().assignSemanticSurface(trafficArea, lod, parent))) {
            return trafficArea;
        }
        if (parent instanceof TransportationComplex) {
            TransportationComplex complex = (TransportationComplex)parent;
            if (trafficArea instanceof TrafficArea) {
                complex.addTrafficArea(new TrafficAreaProperty((TrafficArea)trafficArea));
            } else if (trafficArea != null) {
                complex.addAuxiliaryTrafficArea(new AuxiliaryTrafficAreaProperty((AuxiliaryTrafficArea)trafficArea));
            }
        }
        return trafficArea;
    }

    public void unmarshalTransportationComplex(AbstractTransportationComplexType src, TransportationComplex dest, CityJSON cityJSON) {
        this.citygml.getCoreUnmarshaller().unmarshalAbstractCityObject(src, dest, cityJSON);
        if (src.isSetAttributes()) {
            TransportationComplexAttributes attributes = src.getAttributes();
            if (attributes.isSetClazz()) {
                dest.setClazz(new Code(attributes.getClazz()));
            }
            if (attributes.isSetFunction()) {
                dest.addFunction(new Code(attributes.getFunction()));
            }
            if (attributes.isSetUsage()) {
                dest.addUsage(new Code(attributes.getUsage()));
            }
            if (attributes.isSetSurfaceMaterials()) {
                StringAttribute surfaceMaterial = new StringAttribute();
                surfaceMaterial.setName("surfaceMaterial");
                surfaceMaterial.setValue(String.join((CharSequence)" ", attributes.getSurfaceMaterials()));
                dest.addGenericAttribute(surfaceMaterial);
            }
        }
        for (AbstractGeometryType geometryType : src.getGeometry()) {
            AbstractGeometry geometry = null;
            int lod = 0;
            if (geometryType instanceof AbstractGeometryObjectType) {
                AbstractGeometryObjectType geometryObject = (AbstractGeometryObjectType)geometryType;
                geometry = this.json.getGMLUnmarshaller().unmarshal(geometryObject, dest);
                lod = geometryObject.getLod().intValue();
            } else if (geometryType instanceof GeometryInstanceType) {
                GeometryInstanceType geometryInstance = (GeometryInstanceType)geometryType;
                geometry = this.citygml.getCoreUnmarshaller().unmarshalAndTransformGeometryInstance(geometryInstance, dest);
                lod = (Integer)geometry.getLocalProperty("org.citygml4j.implicitGeometry.lod");
            }
            if (geometry == null) continue;
            if (geometry instanceof MultiSurface) {
                MultiSurface multiSurface = (MultiSurface)geometry;
                switch (lod) {
                    case 1: {
                        dest.setLod1MultiSurface(new MultiSurfaceProperty(multiSurface));
                        break;
                    }
                    case 2: {
                        dest.setLod2MultiSurface(new MultiSurfaceProperty(multiSurface));
                        break;
                    }
                    case 3: {
                        dest.setLod3MultiSurface(new MultiSurfaceProperty(multiSurface));
                    }
                }
                continue;
            }
            if (!(geometry instanceof MultiCurve) || lod != 0) continue;
            CompositeCurve compositeCurve = new CompositeCurve();
            compositeCurve.setCurveMember(((MultiCurve)geometry).getCurveMember());
            GeometricComplexProperty property = new GeometricComplexProperty(compositeCurve);
            dest.setLod0Network(Collections.singletonList(property));
        }
    }

    public void unmarshalRoad(RoadType src, Road dest, CityJSON cityJSON) {
        this.unmarshalTransportationComplex(src, dest, cityJSON);
    }

    public Road unmarshalRoad(RoadType src, CityJSON cityJSON) {
        Road dest = new Road();
        this.unmarshalRoad(src, dest, cityJSON);
        return dest;
    }

    public void unmarshalRailway(RailwayType src, Railway dest, CityJSON cityJSON) {
        this.unmarshalTransportationComplex(src, dest, cityJSON);
    }

    public Railway unmarshalRailway(RailwayType src, CityJSON cityJSON) {
        Railway dest = new Railway();
        this.unmarshalRailway(src, dest, cityJSON);
        return dest;
    }

    public void unmarshalTransportSquare(TransportSquareType src, Square dest, CityJSON cityJSON) {
        this.unmarshalTransportationComplex(src, dest, cityJSON);
    }

    public Square unmarshalTransportSquare(TransportSquareType src, CityJSON cityJSON) {
        Square dest = new Square();
        this.unmarshalTransportSquare(src, dest, cityJSON);
        return dest;
    }

    public void unmarshalTrafficArea(SemanticsType src, TrafficArea dest, List<AbstractSurface> surfaces, Number lod) {
        if (src.isSetAttributes()) {
            Object attribute = src.getAttributes().get("surfaceMaterial");
            if (attribute instanceof String) {
                dest.setSurfaceMaterial(new Code((String)attribute));
                src.getAttributes().remove("surfaceMaterial");
            }
            if ((attribute = src.getAttributes().get("class")) instanceof String) {
                dest.setClazz(new Code((String)attribute));
                src.getAttributes().remove("class");
            }
            if ((attribute = src.getAttributes().get("function")) instanceof String) {
                dest.addFunction(new Code((String)attribute));
                src.getAttributes().remove("function");
            }
            if ((attribute = src.getAttributes().get("usage")) instanceof String) {
                dest.addFunction(new Code((String)attribute));
                src.getAttributes().remove("usage");
            }
            this.citygml.getCoreUnmarshaller().unmarshalSemanticsAttributes(src, dest);
        }
        MultiSurface multiSurface = new MultiSurface();
        for (AbstractSurface surface : surfaces) {
            multiSurface.addSurfaceMember(new SurfaceProperty(surface));
        }
        switch (lod.intValue()) {
            case 2: {
                dest.setLod2MultiSurface(new MultiSurfaceProperty(multiSurface));
                break;
            }
            case 3: {
                dest.setLod3MultiSurface(new MultiSurfaceProperty(multiSurface));
            }
        }
    }

    public TrafficArea unmarshalTrafficArea(SemanticsType src, List<AbstractSurface> surfaces, Number lod) {
        TrafficArea dest = new TrafficArea();
        this.unmarshalTrafficArea(src, dest, surfaces, lod);
        return dest;
    }

    public void unmarshalAuxiliaryTrafficArea(SemanticsType src, AuxiliaryTrafficArea dest, List<AbstractSurface> surfaces, Number lod) {
        if (src.isSetAttributes()) {
            Object attribute = src.getAttributes().get("surfaceMaterial");
            if (attribute instanceof String) {
                dest.setSurfaceMaterial(new Code((String)attribute));
                src.getAttributes().remove("surfaceMaterial");
            }
            if ((attribute = src.getAttributes().get("class")) instanceof String) {
                dest.setClazz(new Code((String)attribute));
                src.getAttributes().remove("class");
            }
            if ((attribute = src.getAttributes().get("function")) instanceof String) {
                dest.addFunction(new Code((String)attribute));
                src.getAttributes().remove("function");
            }
            if ((attribute = src.getAttributes().get("usage")) instanceof String) {
                dest.addFunction(new Code((String)attribute));
                src.getAttributes().remove("usage");
            }
            this.citygml.getCoreUnmarshaller().unmarshalSemanticsAttributes(src, dest);
        }
        MultiSurface multiSurface = new MultiSurface();
        for (AbstractSurface surface : surfaces) {
            multiSurface.addSurfaceMember(new SurfaceProperty(surface));
        }
        switch (lod.intValue()) {
            case 2: {
                dest.setLod2MultiSurface(new MultiSurfaceProperty(multiSurface));
                break;
            }
            case 3: {
                dest.setLod3MultiSurface(new MultiSurfaceProperty(multiSurface));
            }
        }
    }

    public AuxiliaryTrafficArea unmarshalAuxiliaryTrafficArea(SemanticsType src, List<AbstractSurface> surfaces, Number lod) {
        AuxiliaryTrafficArea dest = new AuxiliaryTrafficArea();
        this.unmarshalAuxiliaryTrafficArea(src, dest, surfaces, lod);
        return dest;
    }
}

