/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.cityjson.util;

import org.citygml4j.model.citygml.CityGMLClass;

public enum GenericAttributeType {
    STRING_ATTRIBUTE("stringAttribute"),
    INT_ATTRIBUTE("intAttribute"),
    DOUBLE_ATTRIBUTE("doubleAttribute"),
    DATE_ATTRIBUTE("dateAttribute"),
    URI_ATTRIBUTE("uriAttribute"),
    MEASURE_ATTRIBUTE("measureAttribute"),
    GENERIC_ATTRIBUTE_SET("genericAttributeSet");

    private final String value;

    private GenericAttributeType(String value) {
        this.value = value;
    }

    public String toValue() {
        return this.value;
    }

    public static GenericAttributeType fromValue(String value) {
        for (GenericAttributeType v : GenericAttributeType.values()) {
            if (!v.value.equals(value)) continue;
            return v;
        }
        return null;
    }

    public static GenericAttributeType fromType(CityGMLClass type) {
        if (type != null) {
            switch (type) {
                case STRING_ATTRIBUTE: {
                    return STRING_ATTRIBUTE;
                }
                case INT_ATTRIBUTE: {
                    return INT_ATTRIBUTE;
                }
                case DOUBLE_ATTRIBUTE: {
                    return DOUBLE_ATTRIBUTE;
                }
                case DATE_ATTRIBUTE: {
                    return DATE_ATTRIBUTE;
                }
                case URI_ATTRIBUTE: {
                    return URI_ATTRIBUTE;
                }
                case MEASURE_ATTRIBUTE: {
                    return MEASURE_ATTRIBUTE;
                }
                case GENERIC_ATTRIBUTE_SET: {
                    return GENERIC_ATTRIBUTE_SET;
                }
            }
        }
        return null;
    }

    public String toString() {
        return this.value;
    }
}

