/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.jaxb.marshal.citygml.core;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.bind.JAXBElement;
import net.opengis.citygml._2.AbstractCityObjectType;
import net.opengis.citygml._2.AbstractSiteType;
import net.opengis.citygml._2.AddressPropertyType;
import net.opengis.citygml._2.AddressType;
import net.opengis.citygml._2.CityModelType;
import net.opengis.citygml._2.ExternalObjectReferenceType;
import net.opengis.citygml._2.ExternalReferenceType;
import net.opengis.citygml._2.GeneralizationRelationType;
import net.opengis.citygml._2.ImplicitGeometryType;
import net.opengis.citygml._2.ImplicitRepresentationPropertyType;
import net.opengis.citygml._2.ObjectFactory;
import net.opengis.citygml._2.RelativeToTerrainType;
import net.opengis.citygml._2.RelativeToWaterType;
import net.opengis.citygml._2.XalAddressPropertyType;
import net.opengis.citygml.generics._2.AbstractGenericAttributeType;
import net.opengis.gml.FeaturePropertyType;
import org.citygml4j.builder.jaxb.marshal.JAXBMarshaller;
import org.citygml4j.builder.jaxb.marshal.citygml.CityGMLMarshaller;
import org.citygml4j.model.citygml.ade.ADEComponent;
import org.citygml4j.model.citygml.appearance.AppearanceMember;
import org.citygml4j.model.citygml.appearance.AppearanceProperty;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.core.AbstractSite;
import org.citygml4j.model.citygml.core.Address;
import org.citygml4j.model.citygml.core.AddressProperty;
import org.citygml4j.model.citygml.core.CityModel;
import org.citygml4j.model.citygml.core.CityObjectMember;
import org.citygml4j.model.citygml.core.ExternalObject;
import org.citygml4j.model.citygml.core.ExternalReference;
import org.citygml4j.model.citygml.core.GeneralizationRelation;
import org.citygml4j.model.citygml.core.ImplicitGeometry;
import org.citygml4j.model.citygml.core.ImplicitRepresentationProperty;
import org.citygml4j.model.citygml.core.RelativeToTerrain;
import org.citygml4j.model.citygml.core.RelativeToWater;
import org.citygml4j.model.citygml.core.TransformationMatrix2x2;
import org.citygml4j.model.citygml.core.TransformationMatrix3x4;
import org.citygml4j.model.citygml.core.TransformationMatrix4x4;
import org.citygml4j.model.citygml.core.XalAddressProperty;
import org.citygml4j.model.citygml.generics.AbstractGenericAttribute;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.util.mapper.TypeMapper;
import org.w3._1999.xlink.ActuateType;
import org.w3._1999.xlink.ShowType;
import org.w3._1999.xlink.TypeType;
import org.w3c.dom.Element;

public class Core200Marshaller {
    private final ReentrantLock lock = new ReentrantLock();
    private final ObjectFactory core = new ObjectFactory();
    private final JAXBMarshaller jaxb;
    private final CityGMLMarshaller citygml;
    private TypeMapper<JAXBElement<?>> elementMapper;
    private TypeMapper<Object> typeMapper;

    public Core200Marshaller(CityGMLMarshaller citygml) {
        this.citygml = citygml;
        this.jaxb = citygml.getJAXBMarshaller();
    }

    private TypeMapper<JAXBElement<?>> getElementMapper() {
        if (this.elementMapper == null) {
            this.lock.lock();
            try {
                if (this.elementMapper == null) {
                    this.elementMapper = TypeMapper.create().with(Address.class, this::createAddress).with(CityModel.class, this::createCityModel).with(CityObjectMember.class, this::createCityObjectMember).with(ImplicitGeometry.class, this::createImplicitGeometry);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.elementMapper;
    }

    private TypeMapper<Object> getTypeMapper() {
        if (this.typeMapper == null) {
            this.lock.lock();
            try {
                if (this.typeMapper == null) {
                    this.typeMapper = TypeMapper.create().with(Address.class, this::marshalAddress).with(AddressProperty.class, this::marshalAddressProperty).with(CityModel.class, this::marshalCityModel).with(CityObjectMember.class, this::marshalCityObjectMember).with(ExternalObject.class, this::marshalExternalObject).with(ExternalReference.class, this::marshalExternalReference).with(GeneralizationRelation.class, this::marshalGeneralizationRelation).with(ImplicitGeometry.class, this::marshalImplicitGeometry).with(ImplicitRepresentationProperty.class, this::marshalImplicitRepresentationProperty).with(RelativeToTerrain.class, this::marshalRelativeToTerrain).with(RelativeToWater.class, this::marshalRelativeToWater).with(XalAddressProperty.class, this::marshalXalAddressProperty);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.typeMapper;
    }

    public JAXBElement<?> marshalJAXBElement(ModelObject src) {
        return this.getElementMapper().apply(src);
    }

    public Object marshal(ModelObject src) {
        return this.getTypeMapper().apply(src);
    }

    public void marshalAbstractCityObject(AbstractCityObject src, AbstractCityObjectType dest) {
        ZonedDateTime date;
        this.jaxb.getGMLMarshaller().marshalAbstractFeature(src, dest);
        if (src.isSetCreationDate()) {
            date = src.getCreationDate();
            dest.setCreationDate(this.jaxb.getDataTypeFactory().newXMLGregorianCalendarDate(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), Integer.MIN_VALUE));
        }
        if (src.isSetTerminationDate()) {
            date = src.getTerminationDate();
            dest.setTerminationDate(this.jaxb.getDataTypeFactory().newXMLGregorianCalendarDate(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), Integer.MIN_VALUE));
        }
        if (src.isSetExternalReference()) {
            for (ExternalReference externalReference : src.getExternalReference()) {
                dest.getExternalReference().add(this.marshalExternalReference(externalReference));
            }
        }
        if (src.isSetGeneralizesTo()) {
            for (GeneralizationRelation generalizationRelation : src.getGeneralizesTo()) {
                dest.getGeneralizesTo().add(this.marshalGeneralizationRelation(generalizationRelation));
            }
        }
        if (src.isSetRelativeToTerrain()) {
            dest.setRelativeToTerrain(this.marshalRelativeToTerrain(src.getRelativeToTerrain()));
        }
        if (src.isSetRelativeToWater()) {
            dest.setRelativeToWater(this.marshalRelativeToWater(src.getRelativeToWater()));
        }
        if (src.isSetGenericAttribute()) {
            for (AbstractGenericAttribute genericAttribute : src.getGenericAttribute()) {
                JAXBElement<?> elem = this.citygml.getGenerics200Marshaller().marshalJAXBElement(genericAttribute);
                if (elem == null || !(elem.getValue() instanceof AbstractGenericAttributeType)) continue;
                dest.get_GenericAttribute().add(elem);
            }
        }
        if (src.isSetAppearance()) {
            for (AppearanceProperty appearanceProperty : src.getAppearance()) {
                dest.getAppearance().add(this.citygml.getAppearance200Marshaller().marshalAppearancePropertyElement(appearanceProperty));
            }
        }
        if (src.isSetGenericApplicationPropertyOfCityObject()) {
            for (ADEComponent adeComponent : src.getGenericApplicationPropertyOfCityObject()) {
                JAXBElement<Object> jaxbElement = this.jaxb.getADEMarshaller().marshalJAXBElement(adeComponent);
                if (jaxbElement == null) continue;
                dest.get_GenericApplicationPropertyOfCityObject().add(jaxbElement);
            }
        }
    }

    public void marshalAbstractSite(AbstractSite src, AbstractSiteType dest) {
        this.marshalAbstractCityObject(src, dest);
        if (src.isSetGenericApplicationPropertyOfSite()) {
            for (ADEComponent adeComponent : src.getGenericApplicationPropertyOfSite()) {
                JAXBElement<Object> jaxbElement = this.jaxb.getADEMarshaller().marshalJAXBElement(adeComponent);
                if (jaxbElement == null) continue;
                dest.get_GenericApplicationPropertyOfSite().add(jaxbElement);
            }
        }
    }

    public void marshalAddress(Address src, AddressType dest) {
        this.jaxb.getGMLMarshaller().marshalAbstractFeature(src, dest);
        if (src.isSetXalAddress()) {
            dest.setXalAddress(this.marshalXalAddressProperty(src.getXalAddress()));
        }
        if (src.isSetMultiPoint()) {
            dest.setMultiPoint(this.jaxb.getGMLMarshaller().marshalMultiPointProperty(src.getMultiPoint()));
        }
        if (src.isSetGenericApplicationPropertyOfAddress()) {
            for (ADEComponent adeComponent : src.getGenericApplicationPropertyOfAddress()) {
                JAXBElement<Object> jaxbElement = this.jaxb.getADEMarshaller().marshalJAXBElement(adeComponent);
                if (jaxbElement == null) continue;
                dest.get_GenericApplicationPropertyOfAddress().add(jaxbElement);
            }
        }
    }

    public AddressType marshalAddress(Address src) {
        AddressType dest = this.core.createAddressType();
        this.marshalAddress(src, dest);
        return dest;
    }

    public AddressPropertyType marshalAddressProperty(AddressProperty src) {
        Element element;
        JAXBElement<?> elem;
        AddressPropertyType dest = this.core.createAddressPropertyType();
        if (src.isSetAddress() && (elem = this.jaxb.marshalJAXBElement(src.getAddress())) != null && elem.getValue() instanceof AddressType) {
            dest.set_Feature(elem);
        }
        if (src.isSetGenericADEElement() && (element = this.jaxb.getADEMarshaller().marshalDOMElement(src.getGenericADEElement())) != null) {
            dest.set_ADEComponent(element);
        }
        if (src.isSetRemoteSchema()) {
            dest.setRemoteSchema(src.getRemoteSchema());
        }
        if (src.isSetType()) {
            dest.setType(TypeType.fromValue(src.getType().getValue()));
        }
        if (src.isSetHref()) {
            dest.setHref(src.getHref());
        }
        if (src.isSetRole()) {
            dest.setRole(src.getRole());
        }
        if (src.isSetArcrole()) {
            dest.setArcrole(src.getArcrole());
        }
        if (src.isSetTitle()) {
            dest.setTitle(src.getTitle());
        }
        if (src.isSetShow()) {
            dest.setShow(ShowType.fromValue(src.getShow().getValue()));
        }
        if (src.isSetActuate()) {
            dest.setActuate(ActuateType.fromValue(src.getActuate().getValue()));
        }
        return dest;
    }

    public void marshalCityModel(CityModel src, CityModelType dest) {
        JAXBElement<?> elem;
        this.jaxb.getGMLMarshaller().marshalAbstractFeatureCollection(src, dest);
        if (src.isSetAppearanceMember()) {
            for (AppearanceMember appearanceMember : src.getAppearanceMember()) {
                elem = this.jaxb.marshalJAXBElement(appearanceMember);
                if (elem == null || !(elem.getValue() instanceof FeaturePropertyType)) continue;
                dest.getFeatureMember().add(elem);
            }
        }
        if (src.isSetCityObjectMember()) {
            for (CityObjectMember cityObjectMember : src.getCityObjectMember()) {
                elem = this.jaxb.marshalJAXBElement(cityObjectMember);
                if (elem == null || !(elem.getValue() instanceof FeaturePropertyType)) continue;
                dest.getFeatureMember().add(elem);
            }
        }
        if (src.isSetGenericApplicationPropertyOfCityModel()) {
            for (ADEComponent aDEComponent : src.getGenericApplicationPropertyOfCityModel()) {
                JAXBElement<Object> jaxbElement = this.jaxb.getADEMarshaller().marshalJAXBElement(aDEComponent);
                if (jaxbElement == null) continue;
                dest.get_GenericApplicationPropertyOfCityModel().add(jaxbElement);
            }
        }
    }

    public CityModelType marshalCityModel(CityModel src) {
        CityModelType dest = this.core.createCityModelType();
        this.marshalCityModel(src, dest);
        return dest;
    }

    public FeaturePropertyType marshalCityObjectMember(CityObjectMember src) {
        return this.jaxb.getGMLMarshaller().marshalFeatureProperty(src);
    }

    public void marshalExternalObject(ExternalObject src, ExternalObjectReferenceType dest) {
        if (src.isSetName()) {
            dest.setName(src.getName());
        }
        if (src.isSetUri()) {
            dest.setUri(src.getUri());
        }
    }

    public ExternalObjectReferenceType marshalExternalObject(ExternalObject src) {
        ExternalObjectReferenceType dest = this.core.createExternalObjectReferenceType();
        this.marshalExternalObject(src, dest);
        return dest;
    }

    public void marshalExternalReference(ExternalReference src, ExternalReferenceType dest) {
        if (src.isSetExternalObject()) {
            dest.setExternalObject(this.marshalExternalObject(src.getExternalObject()));
        }
        if (src.isSetInformationSystem()) {
            dest.setInformationSystem(src.getInformationSystem());
        }
    }

    public ExternalReferenceType marshalExternalReference(ExternalReference src) {
        ExternalReferenceType dest = this.core.createExternalReferenceType();
        this.marshalExternalReference(src, dest);
        return dest;
    }

    public GeneralizationRelationType marshalGeneralizationRelation(GeneralizationRelation src) {
        Element element;
        JAXBElement<?> elem;
        GeneralizationRelationType dest = this.core.createGeneralizationRelationType();
        if (src.isSetCityObject() && (elem = this.jaxb.marshalJAXBElement(src)) != null && elem.getValue() instanceof AbstractCityObjectType) {
            dest.set_CityObject(elem);
        }
        if (src.isSetGenericADEElement() && (element = this.jaxb.getADEMarshaller().marshalDOMElement(src.getGenericADEElement())) != null) {
            dest.set_ADEComponent(element);
        }
        if (src.isSetRemoteSchema()) {
            dest.setRemoteSchema(src.getRemoteSchema());
        }
        if (src.isSetType()) {
            dest.setType(TypeType.fromValue(src.getType().getValue()));
        }
        if (src.isSetHref()) {
            dest.setHref(src.getHref());
        }
        if (src.isSetRole()) {
            dest.setRole(src.getRole());
        }
        if (src.isSetArcrole()) {
            dest.setArcrole(src.getArcrole());
        }
        if (src.isSetTitle()) {
            dest.setTitle(src.getTitle());
        }
        if (src.isSetShow()) {
            dest.setShow(ShowType.fromValue(src.getShow().getValue()));
        }
        if (src.isSetActuate()) {
            dest.setActuate(ActuateType.fromValue(src.getActuate().getValue()));
        }
        return dest;
    }

    public void marshalImplicitGeometry(ImplicitGeometry src, ImplicitGeometryType dest) {
        List<Double> matrix;
        this.jaxb.getGMLMarshaller().marshalAbstractGML(src, dest);
        if (src.isSetMimeType()) {
            dest.setMimeType(this.jaxb.getGMLMarshaller().marshalCode(src.getMimeType()));
        }
        if (src.isSetLibraryObject()) {
            dest.setLibraryObject(src.getLibraryObject());
        }
        if (src.isSetTransformationMatrix() && (matrix = this.marshalTransformationMatrix4x4(src.getTransformationMatrix())) != null) {
            dest.setTransformationMatrix(matrix);
        }
        if (src.isSetReferencePoint()) {
            dest.setReferencePoint(this.jaxb.getGMLMarshaller().marshalPointProperty(src.getReferencePoint()));
        }
        if (src.isSetRelativeGMLGeometry()) {
            dest.setRelativeGMLGeometry(this.jaxb.getGMLMarshaller().marshalGeometryProperty(src.getRelativeGMLGeometry()));
        }
    }

    public ImplicitGeometryType marshalImplicitGeometry(ImplicitGeometry src) {
        ImplicitGeometryType dest = this.core.createImplicitGeometryType();
        this.marshalImplicitGeometry(src, dest);
        return dest;
    }

    public ImplicitRepresentationPropertyType marshalImplicitRepresentationProperty(ImplicitRepresentationProperty src) {
        ImplicitRepresentationPropertyType dest = this.core.createImplicitRepresentationPropertyType();
        if (src.isSetImplicitGeometry()) {
            dest.setImplicitGeometry(this.marshalImplicitGeometry(src.getImplicitGeometry()));
        }
        if (src.isSetRemoteSchema()) {
            dest.setRemoteSchema(src.getRemoteSchema());
        }
        if (src.isSetType()) {
            dest.setType(TypeType.fromValue(src.getType().getValue()));
        }
        if (src.isSetHref()) {
            dest.setHref(src.getHref());
        }
        if (src.isSetRole()) {
            dest.setRole(src.getRole());
        }
        if (src.isSetArcrole()) {
            dest.setArcrole(src.getArcrole());
        }
        if (src.isSetTitle()) {
            dest.setTitle(src.getTitle());
        }
        if (src.isSetShow()) {
            dest.setShow(ShowType.fromValue(src.getShow().getValue()));
        }
        if (src.isSetActuate()) {
            dest.setActuate(ActuateType.fromValue(src.getActuate().getValue()));
        }
        return dest;
    }

    public List<Double> marshalTransformationMatrix2x2(TransformationMatrix2x2 src) {
        if (src.isSetMatrix()) {
            return src.getMatrix().toRowPackedList();
        }
        return null;
    }

    public List<Double> marshalTransformationMatrix3x4(TransformationMatrix3x4 src) {
        if (src.isSetMatrix()) {
            return src.getMatrix().toRowPackedList();
        }
        return null;
    }

    public List<Double> marshalTransformationMatrix4x4(TransformationMatrix4x4 src) {
        if (src.isSetMatrix()) {
            return src.getMatrix().toRowPackedList();
        }
        return null;
    }

    public RelativeToTerrainType marshalRelativeToTerrain(RelativeToTerrain src) {
        return RelativeToTerrainType.fromValue(src.getValue());
    }

    public RelativeToWaterType marshalRelativeToWater(RelativeToWater src) {
        return RelativeToWaterType.fromValue(src.getValue());
    }

    public XalAddressPropertyType marshalXalAddressProperty(XalAddressProperty src) {
        XalAddressPropertyType dest = this.core.createXalAddressPropertyType();
        if (src.isSetAddressDetails()) {
            dest.setAddressDetails(this.jaxb.getXALMarshaller().marshalAddressDetails(src.getAddressDetails()));
        }
        return dest;
    }

    private JAXBElement<?> createAddress(Address src) {
        return this.core.createAddress(this.marshalAddress(src));
    }

    private JAXBElement<?> createCityModel(CityModel src) {
        return this.core.createCityModel(this.marshalCityModel(src));
    }

    private JAXBElement<?> createCityObjectMember(CityObjectMember src) {
        return this.core.createCityObjectMember(this.marshalCityObjectMember(src));
    }

    private JAXBElement<?> createImplicitGeometry(ImplicitGeometry src) {
        return this.core.createImplicitGeometry(this.marshalImplicitGeometry(src));
    }
}

