/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.jaxb.xml.io.reader;

import java.io.InputStream;
import java.net.URI;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.citygml4j.builder.jaxb.xml.io.reader.AbstractJAXBReader;
import org.citygml4j.builder.jaxb.xml.io.reader.JAXBInputFactory;
import org.citygml4j.builder.jaxb.xml.io.reader.XMLChunkImpl;
import org.citygml4j.builder.jaxb.xml.io.reader.XMLElementChecker;
import org.citygml4j.model.citygml.CityGML;
import org.citygml4j.model.module.gml.GMLCoreModule;
import org.citygml4j.model.module.gml.XLinkModule;
import org.citygml4j.xml.io.reader.CityGMLReadException;
import org.citygml4j.xml.io.reader.CityGMLReader;
import org.citygml4j.xml.io.reader.MissingADESchemaException;
import org.citygml4j.xml.io.reader.ParentInfo;
import org.citygml4j.xml.io.reader.UnmarshalException;
import org.citygml4j.xml.io.reader.XMLChunk;
import org.xml.sax.SAXException;

public class JAXBChunkReader
extends AbstractJAXBReader
implements CityGMLReader {
    private XMLChunkImpl current;
    private XMLChunkImpl iterator;
    private Stack<XMLChunkImpl> chunks;
    private XMLChunkImpl chunk;
    private XMLElementChecker.ElementInfo elementInfo;
    private Stack<XMLElementChecker.ElementInfo> elementInfos;
    private boolean isInited = false;
    private boolean setXLink = false;

    public JAXBChunkReader(XMLStreamReader reader, InputStream in, JAXBInputFactory factory, URI baseURI) throws CityGMLReadException {
        super(reader, in, factory, baseURI);
        this.jaxbUnmarshaller.setParseSchema(false);
        this.chunks = new Stack();
        this.elementInfos = new Stack();
    }

    @Override
    public void close() throws CityGMLReadException {
        super.close();
        this.current = null;
        this.iterator = null;
        this.chunks.clear();
        this.chunk = null;
        this.elementInfos.clear();
        this.elementInfo = null;
    }

    @Override
    public boolean hasNext() throws CityGMLReadException {
        if (this.iterator == null) {
            try {
                this.iterator = (XMLChunkImpl)this.nextChunk();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return this.iterator != null;
    }

    @Override
    public XMLChunk nextChunk() throws CityGMLReadException {
        if (this.iterator == null) {
            try {
                this.current = null;
                while (this.reader.hasNext()) {
                    int event = this.reader.next();
                    if (event == 1 && this.parseSchema) {
                        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
                            if (this.reader.getAttributeLocalName(i).equals("schemaLocation")) {
                                this.parseSchema(this.reader.getAttributeValue(i));
                                continue;
                            }
                            if (!this.reader.getAttributeLocalName(i).equals("noNamespaceSchemaLocation")) continue;
                            this.schemaHandler.parseSchema("", this.reader.getAttributeValue(i));
                        }
                    }
                    if (!this.isInited) {
                        if (event != 1) continue;
                        this.elementInfo = this.elementChecker.getElementInfo(this.reader.getName());
                        if (this.elementInfo == null || !this.elementInfo.isFeature()) continue;
                        this.isInited = true;
                        this.chunks.clear();
                        this.chunk = new XMLChunkImpl(this, null);
                        this.chunk.setFirstElement(this.reader.getName());
                        if (this.isFilteredReader()) {
                            this.chunk.setIsFiltered(!this.filter.accept(this.reader.getName()));
                        }
                    }
                    if (event == 1) {
                        XMLElementChecker.ElementInfo lastElementInfo = this.elementInfos.push(this.elementInfo);
                        this.elementInfo = this.elementChecker.getElementInfo(this.reader.getName(), lastElementInfo);
                        if (this.elementInfo != null && this.elementInfo.isFeature()) {
                            this.chunk.removeTrailingCharacters();
                            this.chunks.add(this.chunk);
                            this.chunk = new XMLChunkImpl(this, this.chunks.peek());
                            this.chunk.setFirstElement(this.reader.getName());
                            if (this.isFilteredReader()) {
                                this.chunk.setIsFiltered(!this.filter.accept(this.reader.getName()));
                            }
                            if (lastElementInfo != null) {
                                this.setXLink = lastElementInfo.hasXLink();
                            }
                        }
                    } else if (event == 2) {
                        this.elementInfo = this.elementInfos.pop();
                    }
                    this.chunk.addEvent(this.reader);
                    if (this.setXLink) {
                        this.setXLink(this.reader);
                    }
                    if (!this.chunk.isComplete()) continue;
                    this.current = this.chunk;
                    if (!this.chunks.isEmpty()) {
                        this.chunk = this.chunks.pop();
                    } else {
                        this.chunk = null;
                        this.isInited = false;
                    }
                    if (this.isFilteredReader() && this.current.isFiltered()) {
                        this.current = null;
                        continue;
                    }
                    break;
                }
            }
            catch (XMLStreamException | MissingADESchemaException | SAXException e) {
                throw new CityGMLReadException("Caused by: ", e);
            }
            if (this.current == null) {
                throw new NoSuchElementException();
            }
        } else {
            this.current = this.iterator;
        }
        this.iterator = null;
        return this.current;
    }

    @Override
    public CityGML nextFeature() throws CityGMLReadException {
        CityGML cityGML = null;
        XMLChunkImpl next = (XMLChunkImpl)this.nextChunk();
        try {
            cityGML = next.unmarshal();
        }
        catch (UnmarshalException e) {
            throw new CityGMLReadException("Caused by: ", e.getCause());
        }
        catch (MissingADESchemaException e) {
            throw new CityGMLReadException("Caused by: ", e);
        }
        return cityGML;
    }

    private void setXLink(XMLStreamReader reader) {
        this.setXLink = false;
        String gmlId = null;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            if (!reader.getAttributeLocalName(i).equals("id")) continue;
            gmlId = reader.getAttributeValue(i);
            break;
        }
        if (gmlId == null) {
            gmlId = this.factory.getGMLIdManager().generateUUID();
            this.chunk.addAttribute(GMLCoreModule.v3_1_1.getNamespaceURI(), "id", "id", "CDATA", gmlId);
        }
        this.chunks.peek().addAttribute(XLinkModule.v3_1_1.getNamespaceURI(), "href", "href", "CDATA", '#' + gmlId);
    }

    @Override
    public boolean isSetParentInfo() {
        return this.getParentInfo() != null;
    }

    @Override
    public ParentInfo getParentInfo() {
        return this.current != null ? this.current.getParentInfo() : null;
    }
}

