/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.builder.jaxb.xml.validation;

import java.io.IOException;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.ValidationEventImpl;
import javax.xml.bind.helpers.ValidationEventLocatorImpl;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.citygml4j.builder.jaxb.CityGMLBuilder;
import org.citygml4j.builder.jaxb.marshal.JAXBMarshaller;
import org.citygml4j.builder.jaxb.xml.validation.ValidationSchemaHandler;
import org.citygml4j.model.citygml.ade.generic.ADEGenericElement;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.module.ModuleContext;
import org.citygml4j.model.module.citygml.CityGMLVersion;
import org.citygml4j.xml.schema.SchemaHandler;
import org.citygml4j.xml.validation.CityGMLValidateException;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class JAXBValidator
implements org.citygml4j.xml.validation.Validator {
    private final CityGMLBuilder builder;
    private ValidationSchemaHandler validationSchemaHandler;
    private ValidationEventHandler validationEventHandler;

    public JAXBValidator(CityGMLBuilder builder, SchemaHandler schemaHandler) {
        this.builder = builder;
        this.validationSchemaHandler = new ValidationSchemaHandler(schemaHandler);
    }

    @Override
    public SchemaHandler getSchemaHandler() {
        return this.validationSchemaHandler.getSchemaHandler();
    }

    @Override
    public ValidationEventHandler getValidationEventHandler() {
        return this.validationEventHandler;
    }

    @Override
    public void setSchemaHandler(SchemaHandler schemaHandler) {
        if (schemaHandler == null) {
            throw new IllegalArgumentException("schema handler may not be null.");
        }
        this.validationSchemaHandler.setSchemaHandler(schemaHandler);
    }

    @Override
    public void setValidationEventHandler(ValidationEventHandler validationEventHandler) {
        this.validationEventHandler = validationEventHandler;
    }

    @Override
    public void validate(Object object, CityGMLVersion version) throws CityGMLValidateException {
        this.validate(object, new ModuleContext(version));
    }

    @Override
    public void validate(Object object, ModuleContext moduleContext) throws CityGMLValidateException {
        block11: {
            try {
                Schema schema = this.validationSchemaHandler.getSchema();
                if (object instanceof ADEGenericElement) {
                    object = ((ADEGenericElement)object).getContent();
                }
                if (object instanceof Element) {
                    Validator validator = schema.newValidator();
                    if (this.validationEventHandler != null) {
                        validator.setErrorHandler(new ErrorHandler2ValidationEventHandler());
                    }
                    try {
                        validator.validate(new DOMSource((Element)object));
                        break block11;
                    }
                    catch (IOException e) {
                        throw new CityGMLValidateException("Caused by: ", e);
                    }
                }
                if (!(object instanceof ModelObject)) break block11;
                JAXBMarshaller marshaller = this.builder.createJAXBMarshaller(moduleContext);
                JAXBElement<?> jaxb = marshaller.marshalJAXBElement((ModelObject)object);
                if (jaxb != null) {
                    try {
                        Marshaller m = this.builder.getJAXBContext().createMarshaller();
                        m.setSchema(schema);
                        if (this.validationEventHandler != null) {
                            m.setEventHandler(this.validationEventHandler);
                        }
                        m.marshal(jaxb, new DefaultHandler());
                        break block11;
                    }
                    catch (JAXBException e) {
                        throw new CityGMLValidateException("Caused by: ", e);
                    }
                }
                throw new CityGMLValidateException("failed to marshal citygml4j object to JAXB - validation aborted.");
            }
            catch (SAXException e) {
                throw new CityGMLValidateException("Caused by: ", e);
            }
        }
    }

    private final class ErrorHandler2ValidationEventHandler
    implements ErrorHandler {
        private ErrorHandler2ValidationEventHandler() {
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.handleValidationEvent(exception, 2);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.handleValidationEvent(exception, 0);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.handleValidationEvent(exception, 1);
        }

        private void handleValidationEvent(SAXParseException exception, int severity) throws SAXException {
            if (!JAXBValidator.this.validationEventHandler.handleEvent(new ValidationEventImpl(severity, exception.getMessage(), new ValidationEventLocatorImpl(), exception.getCause()))) {
                throw exception;
            }
        }
    }
}

