/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson;

import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.citygml4j.cityjson.appearance.AppearanceType;
import org.citygml4j.cityjson.extension.ExtensibleType;
import org.citygml4j.cityjson.extension.ExtensionType;
import org.citygml4j.cityjson.feature.AbstractCityObjectType;
import org.citygml4j.cityjson.geometry.AbstractGeometryObjectType;
import org.citygml4j.cityjson.geometry.AbstractGeometryType;
import org.citygml4j.cityjson.geometry.GeometryTemplatesType;
import org.citygml4j.cityjson.geometry.TransformType;
import org.citygml4j.cityjson.geometry.VerticesList;
import org.citygml4j.cityjson.metadata.MetadataType;

public class CityJSON
implements ExtensibleType {
    private final String type = "CityJSON";
    private final String version = "1.0";
    MetadataType metadata;
    Map<String, ExtensionType> extensions;
    @SerializedName(value="CityObjects")
    Map<String, AbstractCityObjectType> cityObjects = new LinkedHashMap<String, AbstractCityObjectType>();
    VerticesList vertices = new VerticesList();
    TransformType transform;
    AppearanceType appearance;
    @SerializedName(value="geometry-templates")
    GeometryTemplatesType geometryTemplates;
    private transient Map<String, Object> extensionProperties;

    public String getType() {
        return "CityJSON";
    }

    public boolean isSetVersion() {
        return "1.0" != null;
    }

    public String getVersion() {
        return "1.0";
    }

    public boolean isSetMetadata() {
        return this.metadata != null;
    }

    public MetadataType getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MetadataType metadata) {
        this.metadata = metadata;
    }

    public void unsetMetadata() {
        this.metadata = null;
    }

    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    public void addExtension(String identifier, ExtensionType extension) {
        if (this.extensions == null) {
            this.extensions = new HashMap<String, ExtensionType>();
        }
        this.extensions.put(identifier, extension);
    }

    public Map<String, ExtensionType> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Map<String, ExtensionType> extensions) {
        if (extensions != null && !extensions.isEmpty()) {
            this.extensions = extensions;
        }
    }

    public void unsetExtensions() {
        this.extensions = null;
    }

    public boolean hasCityObjects() {
        return !this.cityObjects.isEmpty();
    }

    public void addCityObject(AbstractCityObjectType cityObject) {
        if (!cityObject.isSetGmlId()) {
            cityObject.setGmlId("UUID_" + UUID.randomUUID().toString());
        }
        this.cityObjects.put(cityObject.getGmlId(), cityObject);
    }

    @Override
    public void addChild(AbstractCityObjectType child) {
        this.addCityObject(child);
    }

    public AbstractCityObjectType getCityObject(String gmlId) {
        return this.cityObjects.get(gmlId);
    }

    public boolean hasCityObject(String gmlId) {
        return this.cityObjects.containsKey(gmlId);
    }

    public <T extends AbstractCityObjectType> List<T> getCityObjects(Class<T> type) {
        return this.cityObjects.values().stream().filter(type::isInstance).map(type::cast).collect(Collectors.toList());
    }

    public <T extends AbstractCityObjectType> T getCityObject(String gmlId, Class<T> type) {
        AbstractCityObjectType cityObject = this.cityObjects.get(gmlId);
        return (T)(type.isInstance(cityObject) ? (AbstractCityObjectType)type.cast(cityObject) : null);
    }

    public Collection<AbstractCityObjectType> getCityObjects() {
        return this.cityObjects.values();
    }

    public void setCityObjects(List<AbstractCityObjectType> cityObjects) {
        if (cityObjects != null) {
            for (AbstractCityObjectType cityObject : cityObjects) {
                this.addCityObject(cityObject);
            }
        }
    }

    public void removeCityObject(AbstractCityObjectType cityObject) {
        this.cityObjects.remove(cityObject.getGmlId());
    }

    public void removeCityObject(String gmlId) {
        this.cityObjects.remove(gmlId);
    }

    public void unsetCityObjects() {
        this.cityObjects.clear();
    }

    public void addVertex(List<Double> vertex) {
        if (vertex != null && vertex.size() == 3) {
            this.vertices.addVertex(vertex);
        }
    }

    public List<List<Double>> getVertices() {
        return this.vertices.getVertices();
    }

    public void setVertices(List<List<Double>> vertices) {
        if (vertices != null) {
            this.vertices.setVertices(vertices);
        }
    }

    public void unsetVertices() {
        this.vertices.clear();
    }

    public boolean isSetTransform() {
        return this.transform != null;
    }

    public TransformType getTransform() {
        return this.transform;
    }

    public void setTransform(TransformType transform) {
        this.transform = transform;
    }

    public void unsetTransform() {
        this.transform = null;
    }

    public boolean isSetAppearance() {
        return this.appearance != null;
    }

    public AppearanceType getAppearance() {
        return this.appearance;
    }

    public void setAppearance(AppearanceType appearance) {
        this.appearance = appearance;
    }

    public void unsetAppearance() {
        this.appearance = null;
    }

    public boolean isSetGeometryTemplates() {
        return this.geometryTemplates != null;
    }

    public GeometryTemplatesType getGeometryTemplates() {
        return this.geometryTemplates;
    }

    public void setGeometryTemplates(GeometryTemplatesType geometryTemplates) {
        this.geometryTemplates = geometryTemplates;
    }

    public void unsetGeometryTemplates() {
        this.geometryTemplates = null;
    }

    public boolean isSetExtensionProperties() {
        return this.extensionProperties != null;
    }

    public void addExtensionProperty(String name, Object value) {
        if (this.extensionProperties == null) {
            this.extensionProperties = new HashMap<String, Object>();
        }
        this.extensionProperties.put(name, value);
    }

    public Map<String, Object> getExtensionProperties() {
        return this.extensionProperties;
    }

    public void setExtensionProperties(Map<String, Object> extensionProperties) {
        this.extensionProperties = extensionProperties;
    }

    public void removeExtensionProperty(String name) {
        if (this.extensionProperties != null) {
            this.extensionProperties.remove(name);
        }
    }

    public void unsetExtensionProperties() {
        this.extensionProperties = null;
    }

    public List<Double> calcBoundingBox() {
        Double[] bbox = new Double[]{Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE, -1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308};
        for (List<Double> vertex : this.vertices.getVertices()) {
            if (vertex.size() <= 2) continue;
            double x = vertex.get(0);
            double y = vertex.get(1);
            double z = vertex.get(2);
            if (x < bbox[0]) {
                bbox[0] = x;
            }
            if (y < bbox[1]) {
                bbox[1] = y;
            }
            if (z < bbox[2]) {
                bbox[2] = z;
            }
            if (x > bbox[3]) {
                bbox[3] = x;
            }
            if (y > bbox[4]) {
                bbox[4] = y;
            }
            if (!(z > bbox[5])) continue;
            bbox[5] = z;
        }
        if (this.transform != null) {
            for (int i = 0; i < bbox.length; ++i) {
                bbox[i] = bbox[i] * this.transform.getScale().get(i % 3) + this.transform.getTranslate().get(i % 3);
            }
        }
        return Arrays.asList(bbox);
    }

    public Map<String, Integer> calcPresentLoDs() {
        HashMap<String, Integer> lods = new HashMap<String, Integer>();
        for (AbstractCityObjectType cityObject : this.cityObjects.values()) {
            for (AbstractGeometryType geometry : cityObject.getGeometry()) {
                String lod;
                if (!(geometry instanceof AbstractGeometryObjectType) || (lod = String.valueOf(((AbstractGeometryObjectType)geometry).getLod())) == null) continue;
                lods.merge(lod, 1, Integer::sum);
            }
        }
        if (this.geometryTemplates != null) {
            for (AbstractGeometryObjectType geometry : this.geometryTemplates.getTemplates()) {
                String lod = String.valueOf(geometry.getLod());
                if (lod == null) continue;
                lods.merge(lod, 1, Integer::sum);
            }
        }
        return lods;
    }

    public void removeDuplicateVertices() {
        HashMap<String, Integer> indexes = new HashMap<String, Integer>();
        HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
        int oldIndex = 0;
        int newIndex = 0;
        Iterator<List<Double>> iter = this.getVertices().iterator();
        while (iter.hasNext()) {
            List<Double> vertex = iter.next();
            String key = vertex.get(0).intValue() + " " + vertex.get(1).intValue() + " " + vertex.get(2).intValue();
            Integer index = (Integer)indexes.get(key);
            if (index == null) {
                indexes.put(key, newIndex);
                indexMap.put(oldIndex, newIndex);
                ++newIndex;
            } else {
                iter.remove();
                indexMap.put(oldIndex, index);
            }
            ++oldIndex;
        }
        indexes.clear();
        if (this.getVertices().size() != indexMap.size()) {
            for (AbstractCityObjectType cityObject : this.getCityObjects()) {
                for (AbstractGeometryType geometry : cityObject.getGeometry()) {
                    geometry.updateIndexes(indexMap);
                }
            }
        }
        indexMap.clear();
    }
}

