/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.appearance;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.citygml4j.cityjson.appearance.AbstractTextureObject;
import org.citygml4j.cityjson.appearance.SurfaceCollectionTextureObject;

public class SolidTextureObject
extends AbstractTextureObject {
    public static final List<List<List<Integer>>> NULL_VALUE = Collections.singletonList(SurfaceCollectionTextureObject.NULL_VALUE);
    private List<List<List<List<Integer>>>> values;

    SolidTextureObject() {
    }

    public SolidTextureObject(String theme) {
        super(theme);
    }

    @Override
    public boolean isSetValues() {
        return this.values != null;
    }

    public void addValue(List<List<List<Integer>>> value) {
        if (this.values == null) {
            this.values = new ArrayList<List<List<List<Integer>>>>();
        }
        this.values.add(value);
    }

    @Override
    public void addNullValue() {
        this.addValue(NULL_VALUE);
    }

    public List<List<List<List<Integer>>>> getValues() {
        return this.values;
    }

    public void setValues(List<List<List<List<Integer>>>> values) {
        this.values = values;
    }

    @Override
    public int getNumValues() {
        return this.values != null ? this.values.size() : 0;
    }

    @Override
    public List<List<List<Integer>>> flatValues() {
        return this.values != null ? this.values.stream().flatMap(a -> a != null ? a.stream() : Stream.of((List)null)).collect(Collectors.toList()) : null;
    }

    @Override
    public void unsetValues() {
        this.values = null;
    }
}

