/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.appearance;

public enum TextureTypeName {
    PNG("PNG", "image/png"),
    JPG("JPG", "image/jpeg");

    private final String value;
    private final String mimeType;

    private TextureTypeName(String value, String mimeType) {
        this.value = value;
        this.mimeType = mimeType;
    }

    public String getValue() {
        return this.value;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String toString() {
        return this.value;
    }

    public static TextureTypeName fromValue(String value) {
        for (TextureTypeName type : TextureTypeName.values()) {
            if (!type.value.equals(value)) continue;
            return type;
        }
        return null;
    }

    public static TextureTypeName fromFileName(String fileName) {
        String tmp = fileName.toLowerCase();
        if (tmp.endsWith(".png")) {
            return PNG;
        }
        if (tmp.endsWith(".jpg") || tmp.endsWith(".jpeg") || tmp.endsWith(".jpe") || tmp.endsWith(".jfif") || tmp.endsWith(".jif")) {
            return JPG;
        }
        return null;
    }
}

