/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.geometry;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.citygml4j.cityjson.geometry.AbstractGeometryType;
import org.citygml4j.cityjson.geometry.GeometryTypeName;

public class GeometryInstanceType
extends AbstractGeometryType {
    private final GeometryTypeName type = GeometryTypeName.GEOMETRY_INSTANCE;
    private int template;
    private List<Integer> boundaries = Collections.singletonList(0);
    private List<Double> transformationMatrix = Arrays.asList(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);

    @Override
    public GeometryTypeName getType() {
        return this.type;
    }

    public int getTemplate() {
        return this.template;
    }

    public void setTemplate(int template) {
        this.template = template;
    }

    public int getReferencePoint() {
        return this.boundaries.get(0);
    }

    public void setReferencePoint(int point) {
        this.boundaries = Collections.singletonList(point);
    }

    public List<Double> getTransformationMatrix() {
        return this.transformationMatrix;
    }

    public void setTransformationMatrix(List<Double> transformationMatrix) {
        if (transformationMatrix != null && transformationMatrix.size() >= 16) {
            this.transformationMatrix = transformationMatrix.subList(0, 16);
        }
    }

    @Override
    public void updateIndexes(Map<Integer, Integer> indexMap) {
        Integer update = indexMap.get(this.getReferencePoint());
        if (update != null) {
            this.setReferencePoint(update);
        }
    }
}

