/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.geometry;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.citygml4j.cityjson.geometry.AbstractGeometryObjectType;
import org.citygml4j.cityjson.geometry.GeometryTypeName;

public class MultiLineStringType
extends AbstractGeometryObjectType {
    private final GeometryTypeName type = GeometryTypeName.MULTI_LINE_STRING;
    private List<List<Integer>> boundaries = new ArrayList<List<Integer>>();

    @Override
    public GeometryTypeName getType() {
        return this.type;
    }

    public void addLineString(List<Integer> lineString) {
        if (lineString != null && lineString.size() > 0) {
            this.boundaries.add(lineString);
        }
    }

    public List<List<Integer>> getLineStrings() {
        return this.boundaries;
    }

    public void setLineStrings(List<List<Integer>> lineStrings) {
        if (lineStrings != null) {
            this.boundaries = lineStrings;
        }
    }

    public void unsetLineStrings() {
        this.boundaries.clear();
    }

    @Override
    public void updateIndexes(Map<Integer, Integer> indexMap) {
        for (List<Integer> lineString : this.boundaries) {
            for (int index = 0; index < lineString.size(); ++index) {
                Integer update = indexMap.get(lineString.get(index));
                if (update == null) continue;
                lineString.set(index, update);
            }
        }
    }
}

