/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertyHelper {
    public List<String> getDeclaredProperties(Class<?> clazz) {
        ArrayList<String> attributeNames = new ArrayList<String>();
        do {
            for (Field field : clazz.getDeclaredFields()) {
                if (Modifier.isTransient(field.getModifiers())) continue;
                SerializedName name = field.getAnnotation(SerializedName.class);
                attributeNames.add(name != null ? name.value() : field.getName());
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return attributeNames;
    }

    public Object deserialize(JsonElement element) {
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean();
            }
            if (primitive.isNumber()) {
                Number value = primitive.getAsNumber();
                if (value.toString().equals(String.valueOf(value.intValue()))) {
                    return value.intValue();
                }
                return value.doubleValue();
            }
            String value = primitive.getAsString();
            try {
                return LocalDate.parse(value, DateTimeFormatter.ISO_LOCAL_DATE);
            }
            catch (DateTimeParseException e) {
                return value;
            }
        }
        if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            HashMap<String, Object> attributeSet = new HashMap<String, Object>();
            for (Map.Entry<String, JsonElement> nested : object.entrySet()) {
                Object value = this.deserialize(nested.getValue());
                if (value == null) continue;
                attributeSet.put(nested.getKey(), value);
            }
            if (!attributeSet.isEmpty()) {
                return attributeSet;
            }
        } else if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            ArrayList<Object> items = new ArrayList<Object>();
            for (int i = 0; i < array.size(); ++i) {
                Object value = this.deserialize(array.get(i));
                if (value == null) continue;
                items.add(value);
            }
            if (!items.isEmpty()) {
                return items;
            }
        }
        return null;
    }
}

