/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.citygml.bridge;

import java.time.LocalDate;
import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.model.citygml.ade.ADEClass;
import org.citygml4j.model.citygml.ade.ADEComponent;
import org.citygml4j.model.citygml.ade.binding.ADEBoundingBoxHelper;
import org.citygml4j.model.citygml.ade.binding.ADEModelObject;
import org.citygml4j.model.citygml.bridge.AbstractBoundarySurface;
import org.citygml4j.model.citygml.bridge.BoundarySurfaceProperty;
import org.citygml4j.model.citygml.bridge.BridgeConstructionElement;
import org.citygml4j.model.citygml.bridge.BridgeConstructionElementProperty;
import org.citygml4j.model.citygml.bridge.BridgeInstallation;
import org.citygml4j.model.citygml.bridge.BridgeInstallationProperty;
import org.citygml4j.model.citygml.bridge.BridgeModuleComponent;
import org.citygml4j.model.citygml.bridge.BridgePart;
import org.citygml4j.model.citygml.bridge.BridgePartProperty;
import org.citygml4j.model.citygml.bridge.IntBridgeInstallationProperty;
import org.citygml4j.model.citygml.bridge.InteriorBridgeRoomProperty;
import org.citygml4j.model.citygml.core.AbstractSite;
import org.citygml4j.model.citygml.core.AddressProperty;
import org.citygml4j.model.citygml.core.LodRepresentation;
import org.citygml4j.model.citygml.core.StandardObjectClassifier;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.Child;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.gml.basicTypes.Code;
import org.citygml4j.model.gml.feature.BoundingShape;
import org.citygml4j.model.gml.geometry.aggregates.MultiCurveProperty;
import org.citygml4j.model.gml.geometry.aggregates.MultiSurfaceProperty;
import org.citygml4j.model.gml.geometry.primitives.SolidProperty;
import org.citygml4j.model.module.Module;
import org.citygml4j.util.bbox.BoundingBoxOptions;

public abstract class AbstractBridge
extends AbstractSite
implements BridgeModuleComponent,
StandardObjectClassifier {
    private Code clazz;
    private List<Code> function;
    private List<Code> usage;
    private Boolean isMovable;
    private LocalDate yearOfConstruction;
    private LocalDate yearOfDemolition;
    private SolidProperty lod1Solid;
    private SolidProperty lod2Solid;
    private SolidProperty lod3Solid;
    private SolidProperty lod4Solid;
    private MultiCurveProperty lod1TerrainIntersection;
    private MultiCurveProperty lod2TerrainIntersection;
    private MultiCurveProperty lod3TerrainIntersection;
    private MultiCurveProperty lod4TerrainIntersection;
    private MultiCurveProperty lod2MultiCurve;
    private MultiCurveProperty lod3MultiCurve;
    private MultiCurveProperty lod4MultiCurve;
    private MultiSurfaceProperty lod1MultiSurface;
    private MultiSurfaceProperty lod2MultiSurface;
    private MultiSurfaceProperty lod3MultiSurface;
    private MultiSurfaceProperty lod4MultiSurface;
    private List<BridgeInstallationProperty> outerBridgeInstallation;
    private List<BridgeConstructionElementProperty> outerBridgeConstructionElement;
    private List<IntBridgeInstallationProperty> interiorBridgeInstallation;
    private List<BoundarySurfaceProperty> boundedBySurface;
    private List<BridgePartProperty> bridgePart;
    private List<InteriorBridgeRoomProperty> interiorBridgeRoom;
    private List<AddressProperty> address;
    private List<ADEComponent> ade;

    public AbstractBridge() {
    }

    public AbstractBridge(Module module) {
        super(module);
    }

    public void addAddress(AddressProperty address) {
        this.getAddress().add(address);
    }

    public void addBoundedBySurface(BoundarySurfaceProperty boundedBySurface) {
        this.getBoundedBySurface().add(boundedBySurface);
    }

    public void addConsistsOfBridgePart(BridgePartProperty bridgePart) {
        this.getConsistsOfBridgePart().add(bridgePart);
    }

    @Override
    public void addFunction(Code function) {
        this.getFunction().add(function);
    }

    @Override
    public void addUsage(Code usage) {
        this.getUsage().add(usage);
    }

    public void addGenericApplicationPropertyOfAbstractBridge(ADEComponent ade) {
        this.getGenericApplicationPropertyOfAbstractBridge().add(ade);
    }

    public void addInteriorBridgeInstallation(IntBridgeInstallationProperty interiorBridgeInstallation) {
        this.getInteriorBridgeInstallation().add(interiorBridgeInstallation);
    }

    public void addInteriorBridgeRoom(InteriorBridgeRoomProperty interiorBridgeRoom) {
        this.getInteriorBridgeRoom().add(interiorBridgeRoom);
    }

    public void addOuterBridgeInstallation(BridgeInstallationProperty outerBridgeInstallation) {
        this.getOuterBridgeInstallation().add(outerBridgeInstallation);
    }

    public void addOuterBridgeConstructionElement(BridgeConstructionElementProperty outerBridgeConstructionElement) {
        this.getOuterBridgeConstructionElement().add(outerBridgeConstructionElement);
    }

    public List<AddressProperty> getAddress() {
        if (this.address == null) {
            this.address = new ChildList<AddressProperty>(this);
        }
        return this.address;
    }

    public List<BoundarySurfaceProperty> getBoundedBySurface() {
        if (this.boundedBySurface == null) {
            this.boundedBySurface = new ChildList<BoundarySurfaceProperty>(this);
        }
        return this.boundedBySurface;
    }

    @Override
    public Code getClazz() {
        return this.clazz;
    }

    @Override
    public List<Code> getFunction() {
        if (this.function == null) {
            this.function = new ChildList<Code>(this);
        }
        return this.function;
    }

    @Override
    public List<Code> getUsage() {
        if (this.usage == null) {
            this.usage = new ChildList<Code>(this);
        }
        return this.usage;
    }

    public Boolean getIsMovable() {
        return this.isMovable;
    }

    public List<BridgePartProperty> getConsistsOfBridgePart() {
        if (this.bridgePart == null) {
            this.bridgePart = new ChildList<BridgePartProperty>(this);
        }
        return this.bridgePart;
    }

    public List<ADEComponent> getGenericApplicationPropertyOfAbstractBridge() {
        if (this.ade == null) {
            this.ade = new ChildList<ADEComponent>(this);
        }
        return this.ade;
    }

    public List<IntBridgeInstallationProperty> getInteriorBridgeInstallation() {
        if (this.interiorBridgeInstallation == null) {
            this.interiorBridgeInstallation = new ChildList<IntBridgeInstallationProperty>(this);
        }
        return this.interiorBridgeInstallation;
    }

    public List<InteriorBridgeRoomProperty> getInteriorBridgeRoom() {
        if (this.interiorBridgeRoom == null) {
            this.interiorBridgeRoom = new ChildList<InteriorBridgeRoomProperty>(this);
        }
        return this.interiorBridgeRoom;
    }

    public MultiSurfaceProperty getLod1MultiSurface() {
        return this.lod1MultiSurface;
    }

    public SolidProperty getLod1Solid() {
        return this.lod1Solid;
    }

    public MultiCurveProperty getLod1TerrainIntersection() {
        return this.lod1TerrainIntersection;
    }

    public MultiCurveProperty getLod2MultiCurve() {
        return this.lod2MultiCurve;
    }

    public MultiSurfaceProperty getLod2MultiSurface() {
        return this.lod2MultiSurface;
    }

    public SolidProperty getLod2Solid() {
        return this.lod2Solid;
    }

    public MultiCurveProperty getLod2TerrainIntersection() {
        return this.lod2TerrainIntersection;
    }

    public MultiCurveProperty getLod3MultiCurve() {
        return this.lod3MultiCurve;
    }

    public MultiSurfaceProperty getLod3MultiSurface() {
        return this.lod3MultiSurface;
    }

    public SolidProperty getLod3Solid() {
        return this.lod3Solid;
    }

    public MultiCurveProperty getLod3TerrainIntersection() {
        return this.lod3TerrainIntersection;
    }

    public MultiCurveProperty getLod4MultiCurve() {
        return this.lod4MultiCurve;
    }

    public MultiSurfaceProperty getLod4MultiSurface() {
        return this.lod4MultiSurface;
    }

    public SolidProperty getLod4Solid() {
        return this.lod4Solid;
    }

    public MultiCurveProperty getLod4TerrainIntersection() {
        return this.lod4TerrainIntersection;
    }

    public List<BridgeInstallationProperty> getOuterBridgeInstallation() {
        if (this.outerBridgeInstallation == null) {
            this.outerBridgeInstallation = new ChildList<BridgeInstallationProperty>(this);
        }
        return this.outerBridgeInstallation;
    }

    public List<BridgeConstructionElementProperty> getOuterBridgeConstructionElement() {
        if (this.outerBridgeConstructionElement == null) {
            this.outerBridgeConstructionElement = new ChildList<BridgeConstructionElementProperty>(this);
        }
        return this.outerBridgeConstructionElement;
    }

    public LocalDate getYearOfConstruction() {
        return this.yearOfConstruction;
    }

    public LocalDate getYearOfDemolition() {
        return this.yearOfDemolition;
    }

    public boolean isSetAddress() {
        return this.address != null && !this.address.isEmpty();
    }

    public boolean isSetBoundedBySurface() {
        return this.boundedBySurface != null && !this.boundedBySurface.isEmpty();
    }

    @Override
    public boolean isSetClazz() {
        return this.clazz != null;
    }

    public boolean isSetConsistsOfBridgePart() {
        return this.bridgePart != null && !this.bridgePart.isEmpty();
    }

    @Override
    public boolean isSetFunction() {
        return this.function != null && !this.function.isEmpty();
    }

    public boolean isSetIsMovable() {
        return this.isMovable != null;
    }

    public boolean isSetGenericApplicationPropertyOfAbstractBridge() {
        return this.ade != null && !this.ade.isEmpty();
    }

    public boolean isSetInteriorBridgeInstallation() {
        return this.interiorBridgeInstallation != null && !this.interiorBridgeInstallation.isEmpty();
    }

    public boolean isSetInteriorBridgeRoom() {
        return this.interiorBridgeRoom != null && !this.interiorBridgeRoom.isEmpty();
    }

    public boolean isSetLod1MultiSurface() {
        return this.lod1MultiSurface != null;
    }

    public boolean isSetLod1Solid() {
        return this.lod1Solid != null;
    }

    public boolean isSetLod1TerrainIntersection() {
        return this.lod1TerrainIntersection != null;
    }

    public boolean isSetLod2MultiCurve() {
        return this.lod2MultiCurve != null;
    }

    public boolean isSetLod2MultiSurface() {
        return this.lod2MultiSurface != null;
    }

    public boolean isSetLod2Solid() {
        return this.lod2Solid != null;
    }

    public boolean isSetLod2TerrainIntersection() {
        return this.lod2TerrainIntersection != null;
    }

    public boolean isSetLod3MultiCurve() {
        return this.lod3MultiCurve != null;
    }

    public boolean isSetLod3MultiSurface() {
        return this.lod3MultiSurface != null;
    }

    public boolean isSetLod3Solid() {
        return this.lod3Solid != null;
    }

    public boolean isSetLod3TerrainIntersection() {
        return this.lod3TerrainIntersection != null;
    }

    public boolean isSetLod4MultiCurve() {
        return this.lod4MultiCurve != null;
    }

    public boolean isSetLod4MultiSurface() {
        return this.lod4MultiSurface != null;
    }

    public boolean isSetLod4Solid() {
        return this.lod4Solid != null;
    }

    public boolean isSetLod4TerrainIntersection() {
        return this.lod4TerrainIntersection != null;
    }

    public boolean isSetOuterBridgeInstallation() {
        return this.outerBridgeInstallation != null && !this.outerBridgeInstallation.isEmpty();
    }

    public boolean isSetOuterBridgeConstructionElement() {
        return this.outerBridgeConstructionElement != null && !this.outerBridgeConstructionElement.isEmpty();
    }

    @Override
    public boolean isSetUsage() {
        return this.usage != null && !this.usage.isEmpty();
    }

    public boolean isSetYearOfConstruction() {
        return this.yearOfConstruction != null;
    }

    public boolean isSetYearOfDemolition() {
        return this.yearOfDemolition != null;
    }

    public void setAddress(List<AddressProperty> address) {
        this.address = new ChildList<AddressProperty>((ModelObject)this, address);
    }

    public void setBoundedBySurface(List<BoundarySurfaceProperty> boundedBySurface) {
        this.boundedBySurface = new ChildList<BoundarySurfaceProperty>((ModelObject)this, boundedBySurface);
    }

    @Override
    public void setClazz(Code clazz) {
        this.clazz = ModelObjects.setParent(clazz, (ModelObject)this);
    }

    @Override
    public void setFunction(List<Code> function) {
        this.function = new ChildList<Code>((ModelObject)this, function);
    }

    @Override
    public void setUsage(List<Code> usage) {
        this.usage = new ChildList<Code>((ModelObject)this, usage);
    }

    public void setIsMovable(Boolean isMovable) {
        this.isMovable = isMovable;
    }

    public void setConsistsOfBridgePart(List<BridgePartProperty> bridgePart) {
        this.bridgePart = new ChildList<BridgePartProperty>((ModelObject)this, bridgePart);
    }

    public void setGenericApplicationPropertyOfAbstractBridge(List<ADEComponent> ade) {
        this.ade = new ChildList<ADEComponent>((ModelObject)this, ade);
    }

    public void setInteriorBridgeInstallation(List<IntBridgeInstallationProperty> interiorBridgeInstallation) {
        this.interiorBridgeInstallation = new ChildList<IntBridgeInstallationProperty>((ModelObject)this, interiorBridgeInstallation);
    }

    public void setInteriorBridgeRoom(List<InteriorBridgeRoomProperty> interiorBridgeRoom) {
        this.interiorBridgeRoom = new ChildList<InteriorBridgeRoomProperty>((ModelObject)this, interiorBridgeRoom);
    }

    public void setLod1MultiSurface(MultiSurfaceProperty lod1MultiSurface) {
        this.lod1MultiSurface = ModelObjects.setParent(lod1MultiSurface, (ModelObject)this);
    }

    public void setLod1Solid(SolidProperty lod1Solid) {
        this.lod1Solid = ModelObjects.setParent(lod1Solid, (ModelObject)this);
    }

    public void setLod1TerrainIntersection(MultiCurveProperty lod1TerrainIntersection) {
        this.lod1TerrainIntersection = ModelObjects.setParent(lod1TerrainIntersection, (ModelObject)this);
    }

    public void setLod2MultiCurve(MultiCurveProperty lod2MultiCurve) {
        this.lod2MultiCurve = ModelObjects.setParent(lod2MultiCurve, (ModelObject)this);
    }

    public void setLod2MultiSurface(MultiSurfaceProperty lod2MultiSurface) {
        this.lod2MultiSurface = ModelObjects.setParent(lod2MultiSurface, (ModelObject)this);
    }

    public void setLod2Solid(SolidProperty lod2Solid) {
        this.lod2Solid = ModelObjects.setParent(lod2Solid, (ModelObject)this);
    }

    public void setLod2TerrainIntersection(MultiCurveProperty lod2TerrainIntersection) {
        this.lod2TerrainIntersection = ModelObjects.setParent(lod2TerrainIntersection, (ModelObject)this);
    }

    public void setLod3MultiCurve(MultiCurveProperty lod3MultiCurve) {
        this.lod3MultiCurve = ModelObjects.setParent(lod3MultiCurve, (ModelObject)this);
    }

    public void setLod3MultiSurface(MultiSurfaceProperty lod3MultiSurface) {
        this.lod3MultiSurface = ModelObjects.setParent(lod3MultiSurface, (ModelObject)this);
    }

    public void setLod3Solid(SolidProperty lod3Solid) {
        this.lod3Solid = ModelObjects.setParent(lod3Solid, (ModelObject)this);
    }

    public void setLod3TerrainIntersection(MultiCurveProperty lod3TerrainIntersection) {
        this.lod3TerrainIntersection = ModelObjects.setParent(lod3TerrainIntersection, (ModelObject)this);
    }

    public void setLod4MultiCurve(MultiCurveProperty lod4MultiCurve) {
        this.lod4MultiCurve = ModelObjects.setParent(lod4MultiCurve, (ModelObject)this);
    }

    public void setLod4MultiSurface(MultiSurfaceProperty lod4MultiSurface) {
        this.lod4MultiSurface = ModelObjects.setParent(lod4MultiSurface, (ModelObject)this);
    }

    public void setLod4Solid(SolidProperty lod4Solid) {
        this.lod4Solid = ModelObjects.setParent(lod4Solid, (ModelObject)this);
    }

    public void setLod4TerrainIntersection(MultiCurveProperty lod4TerrainIntersection) {
        this.lod4TerrainIntersection = ModelObjects.setParent(lod4TerrainIntersection, (ModelObject)this);
    }

    public void setOuterBridgeInstallation(List<BridgeInstallationProperty> outerBridgeInstallation) {
        this.outerBridgeInstallation = new ChildList<BridgeInstallationProperty>((ModelObject)this, outerBridgeInstallation);
    }

    public void setOuterBridgeConstructionElement(List<BridgeConstructionElementProperty> outerBridgeConstructionElement) {
        this.outerBridgeConstructionElement = new ChildList<BridgeConstructionElementProperty>((ModelObject)this, outerBridgeConstructionElement);
    }

    public void setYearOfConstruction(LocalDate yearOfConstruction) {
        this.yearOfConstruction = yearOfConstruction;
    }

    public void setYearOfConstruction(int yearOfConstruction) {
        this.yearOfConstruction = LocalDate.of(yearOfConstruction, 1, 1);
    }

    public void setYearOfDemolition(LocalDate yearOfDemolition) {
        this.yearOfDemolition = yearOfDemolition;
    }

    public void setYearOfDemolition(int yearOfDemolition) {
        this.yearOfDemolition = LocalDate.of(yearOfDemolition, 1, 1);
    }

    public void unsetAddress() {
        this.address = ModelObjects.setNull(this.address);
    }

    public boolean unsetAddress(AddressProperty address) {
        return this.isSetAddress() && this.address.remove(address);
    }

    public void unsetBoundedBySurface() {
        this.boundedBySurface = ModelObjects.setNull(this.boundedBySurface);
    }

    public boolean unsetBoundedBySurface(BoundarySurfaceProperty boundedBySurface) {
        return this.isSetBoundedBySurface() && this.boundedBySurface.remove(boundedBySurface);
    }

    @Override
    public void unsetClazz() {
        this.clazz = ModelObjects.setNull(this.clazz);
    }

    public void unsetConsistsOfBridgePart() {
        this.bridgePart = ModelObjects.setNull(this.bridgePart);
    }

    public boolean unsetConsistsOfBridgePart(BridgePartProperty bridgePart) {
        return this.isSetConsistsOfBridgePart() && this.bridgePart.remove(bridgePart);
    }

    @Override
    public void unsetFunction() {
        this.function = ModelObjects.setNull(this.function);
    }

    @Override
    public boolean unsetFunction(Code function) {
        return this.isSetFunction() && this.function.remove(function);
    }

    @Override
    public void unsetUsage() {
        this.usage = ModelObjects.setNull(this.usage);
    }

    @Override
    public boolean unsetUsage(Code usage) {
        return this.isSetUsage() && this.usage.remove(usage);
    }

    public void unsetIsMovable() {
        this.isMovable = null;
    }

    public void unsetGenericApplicationPropertyOfAbstractBridge() {
        this.ade = ModelObjects.setNull(this.ade);
    }

    public boolean unsetGenericApplicationPropertyOfAbstractBridge(ADEComponent ade) {
        return this.isSetGenericApplicationPropertyOfAbstractBridge() && this.ade.remove(ade);
    }

    public void unsetInteriorBridgeInstallation() {
        this.interiorBridgeInstallation = ModelObjects.setNull(this.interiorBridgeInstallation);
    }

    public boolean unsetInteriorBridgeInstallation(IntBridgeInstallationProperty interiorBridgeInstallation) {
        return this.isSetInteriorBridgeInstallation() && this.interiorBridgeInstallation.remove(interiorBridgeInstallation);
    }

    public void unsetInteriorBridgeRoom() {
        this.interiorBridgeRoom = ModelObjects.setNull(this.interiorBridgeRoom);
    }

    public boolean unsetInteriorBridgeRoom(InteriorBridgeRoomProperty interiorBridgeRoom) {
        return this.isSetInteriorBridgeRoom() && this.interiorBridgeRoom.remove(interiorBridgeRoom);
    }

    public void unsetLod1MultiSurface() {
        this.lod1MultiSurface = ModelObjects.setNull(this.lod1MultiSurface);
    }

    public void unsetLod1Solid() {
        this.lod1Solid = ModelObjects.setNull(this.lod1Solid);
    }

    public void unsetLod1TerrainIntersection() {
        this.lod1TerrainIntersection = ModelObjects.setNull(this.lod1TerrainIntersection);
    }

    public void unsetLod2MultiCurve() {
        this.lod2MultiCurve = ModelObjects.setNull(this.lod2MultiCurve);
    }

    public void unsetLod2MultiSurface() {
        this.lod2MultiSurface = ModelObjects.setNull(this.lod2MultiSurface);
    }

    public void unsetLod2Solid() {
        this.lod2Solid = ModelObjects.setNull(this.lod2Solid);
    }

    public void unsetLod2TerrainIntersection() {
        this.lod2TerrainIntersection = ModelObjects.setNull(this.lod2TerrainIntersection);
    }

    public void unsetLod3MultiCurve() {
        this.lod3MultiCurve = ModelObjects.setNull(this.lod3MultiCurve);
    }

    public void unsetLod3MultiSurface() {
        this.lod3MultiSurface = ModelObjects.setNull(this.lod3MultiSurface);
    }

    public void unsetLod3Solid() {
        this.lod3Solid = ModelObjects.setNull(this.lod3Solid);
    }

    public void unsetLod3TerrainIntersection() {
        this.lod3TerrainIntersection = ModelObjects.setNull(this.lod3TerrainIntersection);
    }

    public void unsetLod4MultiCurve() {
        this.lod4MultiCurve = ModelObjects.setNull(this.lod4MultiCurve);
    }

    public void unsetLod4MultiSurface() {
        this.lod4MultiSurface = ModelObjects.setNull(this.lod4MultiSurface);
    }

    public void unsetLod4Solid() {
        this.lod4Solid = ModelObjects.setNull(this.lod4Solid);
    }

    public void unsetLod4TerrainIntersection() {
        this.lod4TerrainIntersection = ModelObjects.setNull(this.lod4TerrainIntersection);
    }

    public void unsetOuterBridgeInstallation() {
        this.outerBridgeInstallation = ModelObjects.setNull(this.outerBridgeInstallation);
    }

    public boolean unsetOuterBridgeInstallation(BridgeInstallationProperty outerBridgeInstallation) {
        return this.isSetOuterBridgeInstallation() && this.outerBridgeInstallation.remove(outerBridgeInstallation);
    }

    public void unsetOuterBridgeConstructionElement() {
        this.outerBridgeConstructionElement = ModelObjects.setNull(this.outerBridgeConstructionElement);
    }

    public boolean unsetOuterBridgeConstructionElement(BridgeConstructionElementProperty outerBridgeConstructionElement) {
        return this.isSetOuterBridgeConstructionElement() && this.outerBridgeConstructionElement.remove(outerBridgeConstructionElement);
    }

    public void unsetYearOfConstruction() {
        this.yearOfConstruction = null;
    }

    public void unsetYearOfDemolition() {
        this.yearOfDemolition = null;
    }

    @Override
    public BoundingShape calcBoundedBy(BoundingBoxOptions options) {
        BoundingShape boundedBy = super.calcBoundedBy(options);
        if (options.isUseExistingEnvelopes() && !boundedBy.isEmpty()) {
            return boundedBy;
        }
        SolidProperty solidProperty = null;
        for (int lod = 1; lod < 5; ++lod) {
            switch (lod) {
                case 1: {
                    solidProperty = this.lod1Solid;
                    break;
                }
                case 2: {
                    solidProperty = this.lod2Solid;
                    break;
                }
                case 3: {
                    solidProperty = this.lod3Solid;
                    break;
                }
                case 4: {
                    solidProperty = this.lod4Solid;
                }
            }
            if (solidProperty == null || !solidProperty.isSetSolid()) continue;
            boundedBy.updateEnvelope(solidProperty.getSolid().calcBoundingBox());
        }
        MultiSurfaceProperty multiSurfaceProperty = null;
        for (int lod = 1; lod < 5; ++lod) {
            switch (lod) {
                case 1: {
                    multiSurfaceProperty = this.lod1MultiSurface;
                    break;
                }
                case 2: {
                    multiSurfaceProperty = this.lod2MultiSurface;
                    break;
                }
                case 3: {
                    multiSurfaceProperty = this.lod3MultiSurface;
                    break;
                }
                case 4: {
                    multiSurfaceProperty = this.lod4MultiSurface;
                }
            }
            if (multiSurfaceProperty == null || !multiSurfaceProperty.isSetMultiSurface()) continue;
            boundedBy.updateEnvelope(multiSurfaceProperty.getMultiSurface().calcBoundingBox());
        }
        MultiCurveProperty multiCurveProperty = null;
        for (int lod = 2; lod < 5; ++lod) {
            switch (lod) {
                case 2: {
                    multiCurveProperty = this.lod2MultiCurve;
                    break;
                }
                case 3: {
                    multiCurveProperty = this.lod3MultiCurve;
                    break;
                }
                case 4: {
                    multiCurveProperty = this.lod4MultiCurve;
                }
            }
            if (multiCurveProperty == null || !multiCurveProperty.isSetMultiCurve()) continue;
            boundedBy.updateEnvelope(multiCurveProperty.getMultiCurve().calcBoundingBox());
        }
        if (this.isSetBoundedBySurface()) {
            for (BoundarySurfaceProperty boundarySurfaceProperty : this.getBoundedBySurface()) {
                if (!boundarySurfaceProperty.isSetObject()) continue;
                boundedBy.updateEnvelope(((AbstractBoundarySurface)boundarySurfaceProperty.getObject()).calcBoundedBy(options).getEnvelope());
            }
        }
        if (this.isSetOuterBridgeInstallation()) {
            for (BridgeInstallationProperty bridgeInstallationProperty : this.getOuterBridgeInstallation()) {
                if (!bridgeInstallationProperty.isSetObject()) continue;
                boundedBy.updateEnvelope(((BridgeInstallation)bridgeInstallationProperty.getObject()).calcBoundedBy(options).getEnvelope());
            }
        }
        if (this.isSetOuterBridgeConstructionElement()) {
            for (BridgeConstructionElementProperty bridgeConstructionElementProperty : this.getOuterBridgeConstructionElement()) {
                if (!bridgeConstructionElementProperty.isSetObject()) continue;
                boundedBy.updateEnvelope(((BridgeConstructionElement)bridgeConstructionElementProperty.getObject()).calcBoundedBy(options).getEnvelope());
            }
        }
        if (this.isSetConsistsOfBridgePart()) {
            for (BridgePartProperty bridgePartProperty : this.getConsistsOfBridgePart()) {
                if (!bridgePartProperty.isSetObject()) continue;
                boundedBy.updateEnvelope(((BridgePart)bridgePartProperty.getObject()).calcBoundedBy(options).getEnvelope());
            }
        }
        if (this.isSetGenericApplicationPropertyOfAbstractBridge()) {
            for (ADEComponent ade : this.getGenericApplicationPropertyOfAbstractBridge()) {
                if (ade.getADEClass() != ADEClass.MODEL_OBJECT) continue;
                boundedBy.updateEnvelope(ADEBoundingBoxHelper.calcBoundedBy((ADEModelObject)ade, options).getEnvelope());
            }
        }
        if (options.isAssignResultToFeatures()) {
            this.setBoundedBy(boundedBy);
        }
        return boundedBy;
    }

    @Override
    public LodRepresentation getLodRepresentation() {
        LodRepresentation lodRepresentation = new LodRepresentation();
        lodRepresentation.addRepresentation(1, this.lod1Solid);
        lodRepresentation.addRepresentation(2, this.lod2Solid);
        lodRepresentation.addRepresentation(3, this.lod3Solid);
        lodRepresentation.addRepresentation(4, this.lod4Solid);
        lodRepresentation.addRepresentation(1, this.lod1MultiSurface);
        lodRepresentation.addRepresentation(2, this.lod2MultiSurface);
        lodRepresentation.addRepresentation(3, this.lod3MultiSurface);
        lodRepresentation.addRepresentation(4, this.lod4MultiSurface);
        lodRepresentation.addRepresentation(2, this.lod2MultiCurve);
        lodRepresentation.addRepresentation(3, this.lod3MultiCurve);
        lodRepresentation.addRepresentation(4, this.lod4MultiCurve);
        return lodRepresentation;
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        Child copyPart;
        if (target == null) {
            throw new IllegalArgumentException("Target argument must not be null for abstract copyable classes.");
        }
        AbstractBridge copy = (AbstractBridge)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetClazz()) {
            copy.setClazz((Code)copyBuilder.copy(this.clazz));
        }
        if (this.isSetFunction()) {
            for (Code code : this.function) {
                copyPart = (Code)copyBuilder.copy(code);
                copy.addFunction((Code)copyPart);
                if (code == null || copyPart != code) continue;
                code.setParent(this);
            }
        }
        if (this.isSetUsage()) {
            for (Code code : this.usage) {
                copyPart = (Code)copyBuilder.copy(code);
                copy.addUsage((Code)copyPart);
                if (code == null || copyPart != code) continue;
                code.setParent(this);
            }
        }
        if (this.isSetYearOfConstruction()) {
            copy.setYearOfConstruction((LocalDate)copyBuilder.copy(this.yearOfConstruction));
        }
        if (this.isSetYearOfDemolition()) {
            copy.setYearOfDemolition((LocalDate)copyBuilder.copy(this.yearOfDemolition));
        }
        if (this.isSetIsMovable()) {
            copy.setIsMovable(copyBuilder.copy(this.isMovable));
        }
        if (this.isSetLod1Solid()) {
            copy.setLod1Solid((SolidProperty)copyBuilder.copy(this.lod1Solid));
            if (copy.getLod1Solid() == this.lod1Solid) {
                this.lod1Solid.setParent(this);
            }
        }
        if (this.isSetLod2Solid()) {
            copy.setLod2Solid((SolidProperty)copyBuilder.copy(this.lod2Solid));
            if (copy.getLod2Solid() == this.lod2Solid) {
                this.lod2Solid.setParent(this);
            }
        }
        if (this.isSetLod3Solid()) {
            copy.setLod3Solid((SolidProperty)copyBuilder.copy(this.lod3Solid));
            if (copy.getLod3Solid() == this.lod3Solid) {
                this.lod3Solid.setParent(this);
            }
        }
        if (this.isSetLod4Solid()) {
            copy.setLod4Solid((SolidProperty)copyBuilder.copy(this.lod4Solid));
            if (copy.getLod4Solid() == this.lod4Solid) {
                this.lod4Solid.setParent(this);
            }
        }
        if (this.isSetLod1TerrainIntersection()) {
            copy.setLod1TerrainIntersection((MultiCurveProperty)copyBuilder.copy(this.lod1TerrainIntersection));
            if (copy.getLod1TerrainIntersection() == this.lod1TerrainIntersection) {
                this.lod1TerrainIntersection.setParent(this);
            }
        }
        if (this.isSetLod2TerrainIntersection()) {
            copy.setLod2TerrainIntersection((MultiCurveProperty)copyBuilder.copy(this.lod2TerrainIntersection));
            if (copy.getLod2TerrainIntersection() == this.lod2TerrainIntersection) {
                this.lod2TerrainIntersection.setParent(this);
            }
        }
        if (this.isSetLod3TerrainIntersection()) {
            copy.setLod3TerrainIntersection((MultiCurveProperty)copyBuilder.copy(this.lod3TerrainIntersection));
            if (copy.getLod3TerrainIntersection() == this.lod3TerrainIntersection) {
                this.lod3TerrainIntersection.setParent(this);
            }
        }
        if (this.isSetLod4TerrainIntersection()) {
            copy.setLod4TerrainIntersection((MultiCurveProperty)copyBuilder.copy(this.lod4TerrainIntersection));
            if (copy.getLod4TerrainIntersection() == this.lod4TerrainIntersection) {
                this.lod4TerrainIntersection.setParent(this);
            }
        }
        if (this.isSetLod2MultiCurve()) {
            copy.setLod2MultiCurve((MultiCurveProperty)copyBuilder.copy(this.lod2MultiCurve));
            if (copy.getLod2MultiCurve() == this.lod2MultiCurve) {
                this.lod2MultiCurve.setParent(this);
            }
        }
        if (this.isSetLod3MultiCurve()) {
            copy.setLod3MultiCurve((MultiCurveProperty)copyBuilder.copy(this.lod3MultiCurve));
            if (copy.getLod3MultiCurve() == this.lod3MultiCurve) {
                this.lod3MultiCurve.setParent(this);
            }
        }
        if (this.isSetLod4MultiCurve()) {
            copy.setLod4MultiCurve((MultiCurveProperty)copyBuilder.copy(this.lod4MultiCurve));
            if (copy.getLod4MultiCurve() == this.lod4MultiCurve) {
                this.lod4MultiCurve.setParent(this);
            }
        }
        if (this.isSetLod1MultiSurface()) {
            copy.setLod1MultiSurface((MultiSurfaceProperty)copyBuilder.copy(this.lod1MultiSurface));
            if (copy.getLod1MultiSurface() == this.lod1MultiSurface) {
                this.lod1MultiSurface.setParent(this);
            }
        }
        if (this.isSetLod2MultiSurface()) {
            copy.setLod2MultiSurface((MultiSurfaceProperty)copyBuilder.copy(this.lod2MultiSurface));
            if (copy.getLod2MultiSurface() == this.lod2MultiSurface) {
                this.lod2MultiSurface.setParent(this);
            }
        }
        if (this.isSetLod3MultiSurface()) {
            copy.setLod3MultiSurface((MultiSurfaceProperty)copyBuilder.copy(this.lod3MultiSurface));
            if (copy.getLod3MultiSurface() == this.lod3MultiSurface) {
                this.lod3MultiSurface.setParent(this);
            }
        }
        if (this.isSetLod4MultiSurface()) {
            copy.setLod4MultiSurface((MultiSurfaceProperty)copyBuilder.copy(this.lod4MultiSurface));
            if (copy.getLod4MultiSurface() == this.lod4MultiSurface) {
                this.lod4MultiSurface.setParent(this);
            }
        }
        if (this.isSetAddress()) {
            for (AddressProperty addressProperty : this.address) {
                copyPart = (AddressProperty)copyBuilder.copy(addressProperty);
                copy.addAddress((AddressProperty)copyPart);
                if (addressProperty == null || copyPart != addressProperty) continue;
                addressProperty.setParent(this);
            }
        }
        if (this.isSetBoundedBySurface()) {
            for (BoundarySurfaceProperty boundarySurfaceProperty : this.boundedBySurface) {
                copyPart = (BoundarySurfaceProperty)copyBuilder.copy(boundarySurfaceProperty);
                copy.addBoundedBySurface((BoundarySurfaceProperty)copyPart);
                if (boundarySurfaceProperty == null || copyPart != boundarySurfaceProperty) continue;
                boundarySurfaceProperty.setParent(this);
            }
        }
        if (this.isSetOuterBridgeInstallation()) {
            for (BridgeInstallationProperty bridgeInstallationProperty : this.outerBridgeInstallation) {
                copyPart = (BridgeInstallationProperty)copyBuilder.copy(bridgeInstallationProperty);
                copy.addOuterBridgeInstallation((BridgeInstallationProperty)copyPart);
                if (bridgeInstallationProperty == null || copyPart != bridgeInstallationProperty) continue;
                bridgeInstallationProperty.setParent(this);
            }
        }
        if (this.isSetOuterBridgeConstructionElement()) {
            for (BridgeConstructionElementProperty bridgeConstructionElementProperty : this.outerBridgeConstructionElement) {
                copyPart = (BridgeConstructionElementProperty)copyBuilder.copy(bridgeConstructionElementProperty);
                copy.addOuterBridgeConstructionElement((BridgeConstructionElementProperty)copyPart);
                if (bridgeConstructionElementProperty == null || copyPart != bridgeConstructionElementProperty) continue;
                bridgeConstructionElementProperty.setParent(this);
            }
        }
        if (this.isSetInteriorBridgeInstallation()) {
            for (IntBridgeInstallationProperty intBridgeInstallationProperty : this.interiorBridgeInstallation) {
                copyPart = (IntBridgeInstallationProperty)copyBuilder.copy(intBridgeInstallationProperty);
                copy.addInteriorBridgeInstallation((IntBridgeInstallationProperty)copyPart);
                if (intBridgeInstallationProperty == null || copyPart != intBridgeInstallationProperty) continue;
                intBridgeInstallationProperty.setParent(this);
            }
        }
        if (this.isSetConsistsOfBridgePart()) {
            for (BridgePartProperty bridgePartProperty : this.bridgePart) {
                copyPart = (BridgePartProperty)copyBuilder.copy(bridgePartProperty);
                copy.addConsistsOfBridgePart((BridgePartProperty)copyPart);
                if (bridgePartProperty == null || copyPart != bridgePartProperty) continue;
                bridgePartProperty.setParent(this);
            }
        }
        if (this.isSetInteriorBridgeRoom()) {
            for (InteriorBridgeRoomProperty interiorBridgeRoomProperty : this.interiorBridgeRoom) {
                copyPart = (InteriorBridgeRoomProperty)copyBuilder.copy(interiorBridgeRoomProperty);
                copy.addInteriorBridgeRoom((InteriorBridgeRoomProperty)copyPart);
                if (interiorBridgeRoomProperty == null || copyPart != interiorBridgeRoomProperty) continue;
                interiorBridgeRoomProperty.setParent(this);
            }
        }
        if (this.isSetGenericApplicationPropertyOfAbstractBridge()) {
            for (ADEComponent aDEComponent : this.ade) {
                copyPart = (ADEComponent)copyBuilder.copy(aDEComponent);
                copy.addGenericApplicationPropertyOfAbstractBridge((ADEComponent)copyPart);
                if (aDEComponent == null || copyPart != aDEComponent) continue;
                aDEComponent.setParent(this);
            }
        }
        return copy;
    }
}

