/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.citygml.core;

import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.model.citygml.CityGMLClass;
import org.citygml4j.model.citygml.ade.ADEClass;
import org.citygml4j.model.citygml.ade.ADEComponent;
import org.citygml4j.model.citygml.ade.binding.ADEBoundingBoxHelper;
import org.citygml4j.model.citygml.ade.binding.ADEModelObject;
import org.citygml4j.model.citygml.core.CoreModuleComponent;
import org.citygml4j.model.citygml.core.XalAddressProperty;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.common.visitor.FeatureFunctor;
import org.citygml4j.model.common.visitor.FeatureVisitor;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.gml.feature.AbstractFeature;
import org.citygml4j.model.gml.feature.BoundingShape;
import org.citygml4j.model.gml.feature.SpatialRepresentation;
import org.citygml4j.model.gml.geometry.aggregates.MultiPoint;
import org.citygml4j.model.gml.geometry.aggregates.MultiPointProperty;
import org.citygml4j.model.module.Module;
import org.citygml4j.util.bbox.BoundingBoxOptions;

public class Address
extends AbstractFeature
implements CoreModuleComponent {
    private XalAddressProperty xalAddress;
    private MultiPointProperty multiPoint;
    private List<ADEComponent> ade;

    public Address() {
    }

    public Address(Module module) {
        super(module);
    }

    public void addGenericApplicationPropertyOfAddress(ADEComponent ade) {
        this.getGenericApplicationPropertyOfAddress().add(ade);
    }

    public List<ADEComponent> getGenericApplicationPropertyOfAddress() {
        if (this.ade == null) {
            this.ade = new ChildList<ADEComponent>(this);
        }
        return this.ade;
    }

    public MultiPointProperty getMultiPoint() {
        return this.multiPoint;
    }

    public XalAddressProperty getXalAddress() {
        return this.xalAddress;
    }

    public boolean isSetGenericApplicationPropertyOfAddress() {
        return this.ade != null && !this.ade.isEmpty();
    }

    public boolean isSetMultiPoint() {
        return this.multiPoint != null;
    }

    public boolean isSetXalAddress() {
        return this.xalAddress != null;
    }

    public void setGenericApplicationPropertyOfAddress(List<ADEComponent> ade) {
        this.ade = new ChildList<ADEComponent>((ModelObject)this, ade);
    }

    public void setMultiPoint(MultiPointProperty multiPoint) {
        this.multiPoint = ModelObjects.setParent(multiPoint, (ModelObject)this);
    }

    public void setXalAddress(XalAddressProperty xalAddress) {
        this.xalAddress = ModelObjects.setParent(xalAddress, (ModelObject)this);
    }

    public void unsetGenericApplicationPropertyOfAddress() {
        this.ade = ModelObjects.setNull(this.ade);
    }

    public boolean unsetGenericApplicationPropertyOfAddress(ADEComponent ade) {
        return this.isSetGenericApplicationPropertyOfAddress() && this.ade.remove(ade);
    }

    public void unsetMultiPoint() {
        this.multiPoint = ModelObjects.setNull(this.multiPoint);
    }

    public void unsetXalAddress() {
        this.xalAddress = ModelObjects.setNull(this.xalAddress);
    }

    @Override
    public CityGMLClass getCityGMLClass() {
        return CityGMLClass.ADDRESS;
    }

    @Override
    public BoundingShape calcBoundedBy(BoundingBoxOptions options) {
        BoundingShape boundedBy = super.calcBoundedBy(options);
        if (options.isUseExistingEnvelopes() && !boundedBy.isEmpty()) {
            return boundedBy;
        }
        if (this.multiPoint != null && this.multiPoint.isSetMultiPoint()) {
            boundedBy.updateEnvelope(((MultiPoint)this.getMultiPoint().getGeometry()).calcBoundingBox());
        }
        if (this.isSetGenericApplicationPropertyOfAddress()) {
            for (ADEComponent ade : this.getGenericApplicationPropertyOfAddress()) {
                if (ade.getADEClass() != ADEClass.MODEL_OBJECT) continue;
                boundedBy.updateEnvelope(ADEBoundingBoxHelper.calcBoundedBy((ADEModelObject)ade, options).getEnvelope());
            }
        }
        if (options.isAssignResultToFeatures()) {
            this.setBoundedBy(boundedBy);
        }
        return boundedBy;
    }

    @Override
    public SpatialRepresentation getSpatialRepresentation() {
        SpatialRepresentation representation = new SpatialRepresentation();
        representation.addRepresentation(this.multiPoint);
        return representation;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new Address(), copyBuilder);
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        Address copy = target == null ? new Address() : (Address)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetXalAddress()) {
            copy.setXalAddress((XalAddressProperty)copyBuilder.copy(this.xalAddress));
            if (copy.getXalAddress() == this.xalAddress) {
                this.xalAddress.setParent(this);
            }
        }
        if (this.isSetMultiPoint()) {
            copy.setMultiPoint((MultiPointProperty)copyBuilder.copy(this.multiPoint));
            if (copy.getMultiPoint() == this.multiPoint) {
                this.multiPoint.setParent(this);
            }
        }
        if (this.isSetGenericApplicationPropertyOfAddress()) {
            for (ADEComponent part : this.ade) {
                ADEComponent copyPart = (ADEComponent)copyBuilder.copy(part);
                copy.addGenericApplicationPropertyOfAddress(copyPart);
                if (part == null || copyPart != part) continue;
                part.setParent(this);
            }
        }
        return copy;
    }

    @Override
    public void accept(FeatureVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(FeatureFunctor<T> visitor) {
        return visitor.apply(this);
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

