/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.citygml.core;

import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.model.citygml.CityGML;
import org.citygml4j.model.citygml.CityGMLClass;
import org.citygml4j.model.citygml.ade.ADEClass;
import org.citygml4j.model.citygml.ade.ADEComponent;
import org.citygml4j.model.citygml.ade.binding.ADEBoundingBoxHelper;
import org.citygml4j.model.citygml.ade.binding.ADEModelObject;
import org.citygml4j.model.citygml.appearance.AppearanceMember;
import org.citygml4j.model.citygml.core.AbstractCityObject;
import org.citygml4j.model.citygml.core.CityObjectMember;
import org.citygml4j.model.citygml.core.CoreModuleComponent;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.common.visitor.FeatureFunctor;
import org.citygml4j.model.common.visitor.FeatureVisitor;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.gml.feature.AbstractFeature;
import org.citygml4j.model.gml.feature.AbstractFeatureCollection;
import org.citygml4j.model.gml.feature.BoundingShape;
import org.citygml4j.model.gml.feature.FeatureMember;
import org.citygml4j.model.module.Module;
import org.citygml4j.util.bbox.BoundingBoxOptions;

public class CityModel
extends AbstractFeatureCollection
implements CoreModuleComponent {
    private List<CityObjectMember> cityObjectMember;
    private List<AppearanceMember> appearanceMember;
    private List<ADEComponent> ade;

    public CityModel() {
    }

    public CityModel(Module module) {
        super(module);
    }

    public void addAppearanceMember(AppearanceMember appearanceMember) {
        this.getAppearanceMember().add(appearanceMember);
    }

    public void addCityObjectMember(CityObjectMember cityObjectMember) {
        this.getCityObjectMember().add(cityObjectMember);
    }

    public void addGenericApplicationPropertyOfCityModel(ADEComponent ade) {
        this.getGenericApplicationPropertyOfCityModel().add(ade);
    }

    public List<AppearanceMember> getAppearanceMember() {
        if (this.appearanceMember == null) {
            this.appearanceMember = new ChildList<AppearanceMember>(this);
        }
        return this.appearanceMember;
    }

    public List<CityObjectMember> getCityObjectMember() {
        if (this.cityObjectMember == null) {
            this.cityObjectMember = new ChildList<CityObjectMember>(this);
        }
        return this.cityObjectMember;
    }

    public List<ADEComponent> getGenericApplicationPropertyOfCityModel() {
        if (this.ade == null) {
            this.ade = new ChildList<ADEComponent>(this);
        }
        return this.ade;
    }

    public boolean isSetAppearanceMember() {
        return this.appearanceMember != null && !this.appearanceMember.isEmpty();
    }

    public boolean isSetCityObjectMember() {
        return this.cityObjectMember != null && !this.cityObjectMember.isEmpty();
    }

    public boolean isSetGenericApplicationPropertyOfCityModel() {
        return this.ade != null && !this.ade.isEmpty();
    }

    public void setAppearanceMember(List<AppearanceMember> appearanceMember) {
        this.appearanceMember = new ChildList<AppearanceMember>((ModelObject)this, appearanceMember);
    }

    public void setCityObjectMember(List<CityObjectMember> cityObjectMember) {
        this.cityObjectMember = new ChildList<CityObjectMember>((ModelObject)this, cityObjectMember);
    }

    public void setGenericApplicationPropertyOfCityModel(List<ADEComponent> ade) {
        this.ade = new ChildList<ADEComponent>((ModelObject)this, ade);
    }

    public void unsetAppearanceMember() {
        this.appearanceMember = ModelObjects.setNull(this.appearanceMember);
    }

    public boolean unsetAppearanceMember(AppearanceMember appearanceMember) {
        return this.isSetAppearanceMember() && this.appearanceMember.remove(appearanceMember);
    }

    public void unsetCityObjectMember() {
        this.cityObjectMember = ModelObjects.setNull(this.cityObjectMember);
    }

    public boolean unsetCityObjectMember(CityObjectMember cityObjectMember) {
        return this.isSetCityObjectMember() && this.cityObjectMember.remove(cityObjectMember);
    }

    public void unsetGenericApplicationPropertyOfCityModel() {
        this.ade = ModelObjects.setNull(this.ade);
    }

    public boolean unsetGenericApplicationPropertyOfCityModel(ADEComponent ade) {
        return this.isSetGenericApplicationPropertyOfCityModel() && this.ade.remove(ade);
    }

    @Override
    public CityGMLClass getCityGMLClass() {
        return CityGMLClass.CITY_MODEL;
    }

    @Override
    public BoundingShape calcBoundedBy(BoundingBoxOptions options) {
        BoundingShape boundedBy = super.calcBoundedBy(options);
        if (options.isUseExistingEnvelopes() && !boundedBy.isEmpty()) {
            return boundedBy;
        }
        if (this.isSetCityObjectMember()) {
            for (CityObjectMember cityObjectMember : this.cityObjectMember) {
                if (!cityObjectMember.isSetFeature()) continue;
                boundedBy.updateEnvelope(((AbstractCityObject)cityObjectMember.getFeature()).calcBoundedBy(options).getEnvelope());
            }
        }
        if (this.isSetFeatureMember()) {
            for (FeatureMember featureMember : this.getFeatureMember()) {
                if (!featureMember.isSetFeature()) continue;
                boundedBy.updateEnvelope(((AbstractFeature)featureMember.getFeature()).calcBoundedBy(options).getEnvelope());
            }
        }
        if (this.isSetFeatureMembers()) {
            for (AbstractFeature abstractFeature : this.getFeatureMembers().getFeature()) {
                if (abstractFeature == null) continue;
                boundedBy.updateEnvelope(abstractFeature.calcBoundedBy(options).getEnvelope());
            }
        }
        if (this.isSetGenericApplicationPropertyOfCityModel()) {
            for (ADEComponent aDEComponent : this.getGenericApplicationPropertyOfCityModel()) {
                if (aDEComponent.getADEClass() != ADEClass.MODEL_OBJECT) continue;
                boundedBy.updateEnvelope(ADEBoundingBoxHelper.calcBoundedBy((ADEModelObject)aDEComponent, options).getEnvelope());
            }
        }
        if (options.isAssignResultToFeatures()) {
            this.setBoundedBy(boundedBy);
        }
        return boundedBy;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new CityModel(), copyBuilder);
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        CityGML copyPart;
        CityModel copy = target == null ? new CityModel() : (CityModel)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetCityObjectMember()) {
            for (CityObjectMember cityObjectMember : this.cityObjectMember) {
                copyPart = (CityObjectMember)copyBuilder.copy(cityObjectMember);
                copy.addCityObjectMember((CityObjectMember)copyPart);
                if (cityObjectMember == null || copyPart != cityObjectMember) continue;
                cityObjectMember.setParent(this);
            }
        }
        if (this.isSetAppearanceMember()) {
            for (AppearanceMember appearanceMember : this.appearanceMember) {
                copyPart = (AppearanceMember)copyBuilder.copy(appearanceMember);
                copy.addAppearanceMember((AppearanceMember)copyPart);
                if (appearanceMember == null || copyPart != appearanceMember) continue;
                appearanceMember.setParent(this);
            }
        }
        if (this.isSetGenericApplicationPropertyOfCityModel()) {
            for (ADEComponent aDEComponent : this.ade) {
                copyPart = (ADEComponent)copyBuilder.copy(aDEComponent);
                copy.addGenericApplicationPropertyOfCityModel((ADEComponent)copyPart);
                if (aDEComponent == null || copyPart != aDEComponent) continue;
                aDEComponent.setParent(this);
            }
        }
        return copy;
    }

    @Override
    public void accept(FeatureVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(FeatureFunctor<T> visitor) {
        return visitor.apply(this);
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

