/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.citygml.core;

import java.util.Collections;
import java.util.List;
import org.citygml4j.model.citygml.core.ImplicitRepresentationProperty;
import org.citygml4j.model.gml.base.AbstractGML;
import org.citygml4j.model.gml.base.AssociationByRepOrRef;
import org.citygml4j.model.gml.feature.SpatialRepresentation;
import org.citygml4j.model.gml.geometry.AbstractGeometry;
import org.citygml4j.model.gml.geometry.GeometryProperty;

public class LodRepresentation
extends SpatialRepresentation {
    private static final LodRepresentation EMPTY_REPRESENTATION = new LodRepresentation();

    public static LodRepresentation emptyRepresentation() {
        return EMPTY_REPRESENTATION;
    }

    public void addRepresentation(int lod, AssociationByRepOrRef<? extends AbstractGML> property) {
        if (lod >= 0) {
            this.add(lod, property);
        }
    }

    public void addRepresentation(int lod, GeometryProperty<? extends AbstractGeometry> property) {
        if (lod >= 0) {
            this.add(lod, property);
        }
    }

    public void addRepresentation(int lod, ImplicitRepresentationProperty property) {
        if (lod >= 0) {
            this.add(lod, property);
        }
    }

    @Override
    public boolean isSetRepresentation(int lod) {
        return lod >= 0 && super.isSetRepresentation(lod);
    }

    public boolean hasLodRepresentations() {
        return !this.getLods().isEmpty();
    }

    public boolean hasNonLodRepresentation() {
        return super.isSetRepresentation(-1);
    }

    @Override
    public List<AssociationByRepOrRef<? extends AbstractGML>> getRepresentation(int lod) {
        return lod >= 0 ? super.getRepresentation(lod) : Collections.emptyList();
    }

    public List<AssociationByRepOrRef<? extends AbstractGML>> getNonLodRepresentation() {
        return super.getRepresentation(-1);
    }

    @Override
    public boolean isSetGeometry(int lod) {
        return lod >= 0 && super.isSetGeometry(lod);
    }

    public boolean hasLodGeometries() {
        return this.getLods().stream().anyMatch(this::isSetGeometry);
    }

    public boolean hasNonLodGeometry() {
        return super.isSetGeometry(-1);
    }

    @Override
    public List<GeometryProperty<? extends AbstractGeometry>> getGeometry(int lod) {
        return lod >= 0 ? super.getGeometry(lod) : Collections.emptyList();
    }

    public List<GeometryProperty<? extends AbstractGeometry>> getNonLodGeometry() {
        return super.getGeometry(-1);
    }

    @Override
    public boolean isSetImplicitGeometry(int lod) {
        return lod >= 0 && super.isSetImplicitGeometry(lod);
    }

    public boolean hasLodImplicitGeometries() {
        return this.getLods().stream().anyMatch(this::isSetImplicitGeometry);
    }

    public boolean hasNonLodImplicitGeometry() {
        return super.isSetImplicitGeometry(-1);
    }

    @Override
    public List<ImplicitRepresentationProperty> getImplicitGeometry(int lod) {
        return lod >= 0 ? super.getImplicitGeometry(lod) : Collections.emptyList();
    }

    public List<ImplicitRepresentationProperty> getNonLodImplicitGeometry() {
        return super.getImplicitGeometry(-1);
    }
}

