/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.citygml.relief;

import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.model.citygml.CityGMLClass;
import org.citygml4j.model.citygml.ade.ADEClass;
import org.citygml4j.model.citygml.ade.ADEComponent;
import org.citygml4j.model.citygml.ade.binding.ADEBoundingBoxHelper;
import org.citygml4j.model.citygml.ade.binding.ADEModelObject;
import org.citygml4j.model.citygml.core.LodRepresentation;
import org.citygml4j.model.citygml.relief.AbstractReliefComponent;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.common.visitor.FeatureFunctor;
import org.citygml4j.model.common.visitor.FeatureVisitor;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.gml.feature.BoundingShape;
import org.citygml4j.model.gml.geometry.aggregates.MultiPointProperty;
import org.citygml4j.model.module.Module;
import org.citygml4j.util.bbox.BoundingBoxOptions;

public class MassPointRelief
extends AbstractReliefComponent {
    private MultiPointProperty reliefPoints;
    private List<ADEComponent> ade;

    public MassPointRelief() {
    }

    public MassPointRelief(Module module) {
        super(module);
    }

    public void addGenericApplicationPropertyOfMassPointRelief(ADEComponent ade) {
        this.getGenericApplicationPropertyOfMassPointRelief().add(ade);
    }

    public List<ADEComponent> getGenericApplicationPropertyOfMassPointRelief() {
        if (this.ade == null) {
            this.ade = new ChildList<ADEComponent>(this);
        }
        return this.ade;
    }

    public MultiPointProperty getReliefPoints() {
        return this.reliefPoints;
    }

    public boolean isSetGenericApplicationPropertyOfMassPointRelief() {
        return this.ade != null && !this.ade.isEmpty();
    }

    public boolean isSetReliefPoints() {
        return this.reliefPoints != null;
    }

    public void setGenericApplicationPropertyOfMassPointRelief(List<ADEComponent> ade) {
        this.ade = new ChildList<ADEComponent>((ModelObject)this, ade);
    }

    public void setReliefPoints(MultiPointProperty reliefPoints) {
        this.reliefPoints = ModelObjects.setParent(reliefPoints, (ModelObject)this);
    }

    public void unsetGenericApplicationPropertyOfMassPointRelief() {
        this.ade = ModelObjects.setNull(this.ade);
    }

    public boolean unsetGenericApplicationPropertyOfMassPointRelief(ADEComponent ade) {
        return this.isSetGenericApplicationPropertyOfMassPointRelief() && this.ade.remove(ade);
    }

    public void unsetReliefPoints() {
        this.reliefPoints = ModelObjects.setNull(this.reliefPoints);
    }

    @Override
    public CityGMLClass getCityGMLClass() {
        return CityGMLClass.MASSPOINT_RELIEF;
    }

    @Override
    public BoundingShape calcBoundedBy(BoundingBoxOptions options) {
        BoundingShape boundedBy = super.calcBoundedBy(options);
        if (options.isUseExistingEnvelopes() && !boundedBy.isEmpty()) {
            return boundedBy;
        }
        if (this.isSetReliefPoints() && this.reliefPoints.isSetMultiPoint()) {
            boundedBy.updateEnvelope(this.reliefPoints.getMultiPoint().calcBoundingBox());
        }
        if (this.isSetGenericApplicationPropertyOfMassPointRelief()) {
            for (ADEComponent ade : this.getGenericApplicationPropertyOfMassPointRelief()) {
                if (ade.getADEClass() != ADEClass.MODEL_OBJECT) continue;
                boundedBy.updateEnvelope(ADEBoundingBoxHelper.calcBoundedBy((ADEModelObject)ade, options).getEnvelope());
            }
        }
        if (options.isAssignResultToFeatures()) {
            this.setBoundedBy(boundedBy);
        }
        return boundedBy;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new MassPointRelief(), copyBuilder);
    }

    @Override
    public LodRepresentation getLodRepresentation() {
        LodRepresentation lodRepresentation = new LodRepresentation();
        lodRepresentation.addRepresentation(this.getLod(), this.reliefPoints);
        return lodRepresentation;
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        MassPointRelief copy = target == null ? new MassPointRelief() : (MassPointRelief)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetReliefPoints()) {
            copy.setReliefPoints((MultiPointProperty)copyBuilder.copy(this.reliefPoints));
            if (copy.getReliefPoints() == this.reliefPoints) {
                this.reliefPoints.setParent(this);
            }
        }
        if (this.isSetGenericApplicationPropertyOfMassPointRelief()) {
            for (ADEComponent part : this.ade) {
                ADEComponent copyPart = (ADEComponent)copyBuilder.copy(part);
                copy.addGenericApplicationPropertyOfMassPointRelief(copyPart);
                if (part == null || copyPart != part) continue;
                part.setParent(this);
            }
        }
        return copy;
    }

    @Override
    public void accept(FeatureVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(FeatureFunctor<T> visitor) {
        return visitor.apply(this);
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

