/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.model.gml.geometry.aggregates;

import java.util.Arrays;
import java.util.List;
import org.citygml4j.builder.copy.CopyBuilder;
import org.citygml4j.geometry.BoundingBox;
import org.citygml4j.model.common.base.ModelObject;
import org.citygml4j.model.common.base.ModelObjects;
import org.citygml4j.model.common.child.ChildList;
import org.citygml4j.model.common.visitor.GMLFunctor;
import org.citygml4j.model.common.visitor.GMLVisitor;
import org.citygml4j.model.common.visitor.GeometryFunctor;
import org.citygml4j.model.common.visitor.GeometryVisitor;
import org.citygml4j.model.gml.GMLClass;
import org.citygml4j.model.gml.geometry.aggregates.AbstractGeometricAggregate;
import org.citygml4j.model.gml.geometry.primitives.AbstractCurve;
import org.citygml4j.model.gml.geometry.primitives.CurveArrayProperty;
import org.citygml4j.model.gml.geometry.primitives.CurveProperty;

public class MultiCurve
extends AbstractGeometricAggregate {
    private List<CurveProperty> curveMember;
    private CurveArrayProperty curveMembers;

    public MultiCurve() {
    }

    public MultiCurve(List<? extends AbstractCurve> abstractCurves) {
        for (AbstractCurve abstractCurve : abstractCurves) {
            this.addCurveMember(new CurveProperty(abstractCurve));
        }
    }

    public MultiCurve(AbstractCurve ... abstractCurves) {
        this(Arrays.asList(abstractCurves));
    }

    public void addCurveMember(CurveProperty curveMember) {
        this.getCurveMember().add(curveMember);
    }

    public List<CurveProperty> getCurveMember() {
        if (this.curveMember == null) {
            this.curveMember = new ChildList<CurveProperty>(this);
        }
        return this.curveMember;
    }

    public CurveArrayProperty getCurveMembers() {
        return this.curveMembers;
    }

    public boolean isSetCurveMember() {
        return this.curveMember != null && !this.curveMember.isEmpty();
    }

    public boolean isSetCurveMembers() {
        return this.curveMembers != null;
    }

    public void setCurveMember(List<CurveProperty> curveMember) {
        this.curveMember = new ChildList<CurveProperty>((ModelObject)this, curveMember);
    }

    public void setCurveMembers(CurveArrayProperty curveMembers) {
        this.curveMembers = ModelObjects.setParent(curveMembers, (ModelObject)this);
    }

    public void unsetCurveMember() {
        this.curveMember = ModelObjects.setNull(this.curveMember);
    }

    public boolean unsetCurveMember(CurveProperty curveMember) {
        return this.isSetCurveMember() && this.curveMember.remove(curveMember);
    }

    public void unsetCurveMembers() {
        this.curveMembers = ModelObjects.setNull(this.curveMembers);
    }

    @Override
    public BoundingBox calcBoundingBox() {
        CurveArrayProperty curveArrayProperty;
        BoundingBox bbox = new BoundingBox();
        if (this.isSetCurveMember()) {
            for (CurveProperty curveProperty : this.getCurveMember()) {
                if (!curveProperty.isSetCurve()) continue;
                bbox.update(curveProperty.getCurve().calcBoundingBox());
            }
        }
        if (this.isSetCurveMembers() && (curveArrayProperty = this.getCurveMembers()).isSetCurve()) {
            for (AbstractCurve abstractCurve : curveArrayProperty.getCurve()) {
                bbox.update(abstractCurve.calcBoundingBox());
            }
        }
        return bbox;
    }

    @Override
    public GMLClass getGMLClass() {
        return GMLClass.MULTI_CURVE;
    }

    @Override
    public Object copy(CopyBuilder copyBuilder) {
        return this.copyTo(new MultiCurve(), copyBuilder);
    }

    @Override
    public Object copyTo(Object target, CopyBuilder copyBuilder) {
        MultiCurve copy = target == null ? new MultiCurve() : (MultiCurve)target;
        super.copyTo(copy, copyBuilder);
        if (this.isSetCurveMember()) {
            for (CurveProperty part : this.curveMember) {
                CurveProperty copyPart = (CurveProperty)copyBuilder.copy(part);
                copy.addCurveMember(copyPart);
                if (part == null || copyPart != part) continue;
                part.setParent(this);
            }
        }
        if (this.isSetCurveMembers()) {
            copy.setCurveMembers((CurveArrayProperty)copyBuilder.copy(this.curveMembers));
            if (copy.getCurveMembers() == this.curveMembers) {
                this.curveMembers.setParent(this);
            }
        }
        return copy;
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GeometryFunctor<T> visitor) {
        return visitor.apply(this);
    }

    @Override
    public void accept(GMLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(GMLFunctor<T> visitor) {
        return visitor.apply(this);
    }
}

